#include "../binary_c.h"

/*
 * Angular momentum loss because of gravitational radiation
 */

void angular_momentum_loss_mechanisms_for_close_systems(
    struct stardata_t * RESTRICT const stardata)
                           
{
    //if(NEITHER_STAR_MASSLESS &&
    //   Less_or_equal(stardata->common.orbit.separation,
    //                 MIN_SEP_FOR_CLOSE_ANG_MOM_LOSS))        
    if(1)
    {
        double jdot = gravitational_radiation_jdot(stardata); 
        stardata->model.derivative[DERIVATIVE_ORBIT_ANGMOM_GRAVITATIONAL_RADIATION] = jdot;
        
        double edot = gravitational_radiation_edot(stardata);
        stardata->model.derivative[DERIVATIVE_ORBIT_ECCENTRICITY_GRAVITATIONAL_RADIATION] = edot;

        Dprint("Jdot = %30.12e (from close system losses)\n",jdot);
        Dprint("Edot = %30.12e (from close system losses)\n",edot);
    }
    else
    {
        stardata->model.derivative[DERIVATIVE_ORBIT_ANGMOM_GRAVITATIONAL_RADIATION] = 0.0;
        stardata->model.derivative[DERIVATIVE_ORBIT_ECCENTRICITY_GRAVITATIONAL_RADIATION] = 0.0;
    }
}

