
#include "../binary_c.h"

void adjust_radius_derivative(struct stardata_t * RESTRICT const stardata)
{
    unsigned int k;
  
    if(Is_not_zero(stardata->model.dtm))
    {
	Starloop(k)
        {       
	    SETstar(k);
            Dprint("adjust_radius_derivative%u: rdot=%g roche_radius=%g rol0=%g (diff=%g)  dtm=%g -> ",
                   k,
                   star->rdot,
                   star->roche_radius,
                   star->rol0,
                   star->roche_radius-star->rol0,
                   stardata->model.dtm);

            star->rdot += (star->roche_radius - star->rol0)/stardata->model.dtm;
            star->rol0 = star->roche_radius;

            Dprint("rdot=%g m=%g mc=%g r=%g l=%g RL=%g RL0=%g dtm=%g\n",
                   star->rdot,
                   star->mass,
                   star->core_mass,
                   star->radius,
                   star->luminosity,
                   star->roche_radius,
                   star->rol0,
                   stardata->model.dtm
                );
        }
    }
}
