#pragma once
#ifndef BINARY_C_TYPES_H
#define BINARY_C_TYPES_H

/*
 * The binary_c stellar population nucleosynthesis framework.
 *
 * Contact: r.izzard@surrey.ac.uk or rob.izzard@gmail.com
 *
 * http://personal.ph.surrey.ac.uk/~ri0005/binary_c.html
 * https://gitlab.eps.surrey.ac.uk/ri0005/binary_c
 * https://groups.google.com/forum/#!forum/binary_c-nucsyn-announce
 * https://groups.google.com/forum/#!forum/binary_c-nucsyn-devel
 * https://twitter.com/binary_c_code
 * https://www.facebook.com/groups/149489915089142/
 *
 * Please see the files README, LICENCE and CHANGES,
 * and the doc/ directory for documentation.
 *
 *
 *
 * This file contains the variable types, as typedefs and macros,
 * used in binary_c. 
 */


/*
 * Define a Boolean type
 *
 * If we're using _C99, which is the standard in binary_c 2.1, 
 * use the built in bool type.
 *
 * Note: if you are building binary_grid::C you should use the
 *       same setup as builds binary_c. E.g. if you use an old
 *       gcc for binary_grid::C, which has no _C99, and a new
 *       gcc for binary_c, you'll have different sizes of stardata_t
 *       which will cause problems. The lesson: be consistent. 
 */
#undef FALSE
#undef TRUE

#ifdef _C99
#include <stdbool.h>
#ifndef __USE_C99_BOOLEAN__
#define __USE_C99_BOOLEAN__
#endif // __USE_C99_BOOLEAN__
#endif

#ifdef __USE_C99_BOOLEAN__
#define Boolean bool
#define FALSE (false)
#define TRUE (true)
#else
typedef unsigned int Boolean;
#define FALSE (0)
#define TRUE (1)
#endif //_C99


/* 
 * You can choose whether to use short int types rather than int
 * 
 * Normally, short int is slower, even if its memory footprint
 * is smaller, so just leave the macro blank.
 */
//#define __short__ short
#define __short__

/*
 * Other types can be changed ... 
 * but expect many function calls to break if you do.
 */
#define __int__ int
#define __double__ double
#define __long__ long
#define __unsigned__ unsigned
#define __static__ static
#define __const__ const

/*************************************************************
 * Variable types
 */
#define Stellar_type __short__ __int__
#define Star_number __short__ __int__
#define Supernova __unsigned__ __short__ __int__
#define Abundance __double__
#define Time __double__
#define Temp_data_table __const__ __double__
#define Const_data_table __static__ __const__ __double__
#define Disc_type __short__ __int__
#define Ensemble_type __unsigned__ __short__ __int__
#define Disc_zone_counter __unsigned__ __short__ __int__
#define Event_type __short__ __int__
#define Wind_loss_algorithm __unsigned__ __short__ __int__
#define Number_density __double__
#define Isotope __unsigned__ __short__ __int__
#define Element __unsigned__ __short__ __int__
#define staticIsotope __unsigned__ __short__ __int__
#define Nuclear_mass __double__
#define Atomic_number __short__ __int__
#define Nucleon_number __short__ __int__
#define Reaction_rate __double__
#define Yield_source __short__ __int__
#define Moles __double__
#define Molecular_weight __double__ 
#define Abundance_ratio __double__
#define WR_type __short__ __int__
#define PNtrigger __unsigned__ __short__ __int__
#define Abundance_mix __unsigned__ __short__ __int__
#define Source_number __unsigned__ __short__ __int__
#define Ensemble_index __unsigned__ __short__ __int__
#define Stellar_magnitude_index __unsigned__ __short__ __int__
#define Shell_index __short__ __int__
#define Supernova_type __short__ __int__
#define Caller_id __short__ __int__
#define Stellar_structure_algorithm __short__ __int__
#define Composition __double__
#define RLOF_stability __short__ __int__
#define Reject_index __unsigned__ __short__ __int__
#define Evolution_system_type __unsigned__ __short__ __int__
#define Derivative __unsigned__ __int__
#define Lock_index __unsigned__ __int__
#define Spectral_type __int__
#define Long_spectral_type __double__
#define Nova_type __unsigned__ __int__
#define Nova_state __unsigned__ __int__
#define Reaction_network __unsigned__ __int__

#ifdef CODESTATS
#define Codestats_counter __unsigned__ __long__ __int__
#endif

#ifdef BINARY_C_USE_LOCAL_RAND48
#include "maths/binary_c_drandr_types.h"
#endif // BINARY_C_USE_LOCAL_RAND48

#ifdef USE_DRAND48_R
#define Random_seed long int
#define Random_buffer struct drand48_data
#endif // USE_DRAND48_R
#ifdef USE_MERSENNE_TWISTER
#define Random_seed unsigned long long
#define Random_buffer struct mersenne_twister_data_t
#endif // USE_MERSENNE_TWISTER

/* qsort_r function type */
typedef int (*comparison_fn_r) (const void *, const void *, void * arg);

/* brent bisector function type */
typedef double(*brent_function)(const double,void*);
#define brent_cast double (*)(const double,void*)


#endif // BINARY_C_TYPES_H
