#pragma once
#ifndef STRING_MACROS_H
#define STRING_MACROS_H

/*
 * The binary_c stellar population nucleosynthesis framework.
 *
 * Contact: r.izzard@surrey.ac.uk or rob.izzard@gmail.com
 *
 * http://personal.ph.surrey.ac.uk/~ri0005/binary_c.html
 * https://gitlab.eps.surrey.ac.uk/ri0005/binary_c
 * https://groups.google.com/forum/#!forum/binary_c-nucsyn-announce
 * https://groups.google.com/forum/#!forum/binary_c-nucsyn-devel
 * https://twitter.com/binary_c_code
 * https://www.facebook.com/groups/149489915089142/
 *
 * Please see the files README, LICENCE and CHANGES,
 * and the doc/ directory for documentation.
 *
 *
 * In this file are macros to deal with macros as strings.
 * These are used e.g. in the version() function.
 */


#define Slash() /
#define Double_slash() Slash()Slash()

/* stringize macro to output macro names */
#define Stringize(x) #x
/* macro to output value of a macro as a string */
#define Stringof(x) Stringize(x)

#define Yesno(B) ((B)==TRUE ? "Yes" : "No")
#define YESNO(B) ((B)==TRUE ? "YES" : "NO")
#define Truefalse(B) ((B)==TRUE ? "True" : "False")
#define TRUEFALSE(B) ((B)==TRUE ? "TRUE" : "FALSE")

/*
 * Macros to prevent us using strcmp and strcasecmp while 
 * associatedly forgetting the ==0
 */
#define Strings_equal(A,B)                      \
    (strcmp((A),(B))==0)
#define Strings_equal_case_insensitive(A,B)     \
    (strcasecmp((A),(B))==0)

/*
 * Macro to match a string S to true.
 *
 * An empty string is FALSE.
 */
#define String_is_true(S)                                               \
    (                                                                   \
        (                                                               \
            (S)[0] != '\0' &&                                           \
            (                                                           \
                ((S)[0]=='1' && (S)[1]=='\0')                           \
                ||                                                      \
                (                                                       \
                    ((S)[0] == 'T' ||                                   \
                     (S)[0] == 't') &&                                  \
                    (                                                   \
                        Strings_equal_case_insensitive((S),"T") ||      \
                        Strings_equal_case_insensitive((S),"TRUE")      \
                        )                                               \
                    )                                                   \
                ||                                                      \
                (                                                       \
                    ((S)[0] == 'Y' ||                                   \
                     (S)[0] == 'y') && (                                \
                         Strings_equal_case_insensitive((S),"Y") ||     \
                         Strings_equal_case_insensitive((S),"YES")      \
                         )                                              \
                    )                                                   \
                ||                                                      \
                (                                                       \
                    ((S)[0] == 'O' || (S)[0] == 'o') &&                 \
                    (                                                   \
                        Strings_equal_case_insensitive((S),"ON")        \
                        )                                               \
                    )                                                   \
                )                                                       \
            )                                                           \
        ? TRUE : FALSE)

/*
 * Macro to match a string S to FALSE.
 *
 * An empty string is FALSE.
 */
#define String_is_false(S)                                              \
    (                                                                   \
        (                                                               \
            (S)[0] == '\0'                                              \
            ||                                                          \
            (                                                           \
                ((S)[0] == '0' && (S)[1] == '\0')                       \
                ||                                                      \
                (                                                       \
                    ((S)[0] == 'F' ||                                   \
                     (S)[0] == 'f') &&                                  \
                    (                                                   \
                        Strings_equal_case_insensitive((S),"F") ||      \
                        Strings_equal_case_insensitive((S),"FALSE")     \
                        )                                               \
                    )                                                   \
                ||                                                      \
                (                                                       \
                    ((S)[0] == 'N' ||                                   \
                     (S)[0] == 'n') &&                                  \
                    (                                                   \
                        Strings_equal_case_insensitive((S),"N") ||      \
                        Strings_equal_case_insensitive((S),"NO")        \
                        )                                               \
                    )                                                   \
                ||                                                      \
                (                                                       \
                    ((S)[0] == 'O' ||                                   \
                     (S)[0] == 'o') &&                                  \
                    (                                                   \
                        Strings_equal_case_insensitive((S),"Off")       \
                        )                                               \
                    )                                                   \
                )                                                       \
            )                                                           \
        ? TRUE : FALSE)

#define String_is_boolean(S)                    \
    (                                           \
        (                                       \
            Arg_is_true(S) ||                   \
            Arg_is_false(S)                     \
            )                                   \
        ? TRUE: FALSE)

#endif // STRING_MACROS_H
