#pragma once
#ifndef BINARY_PROTOTYPES_H
#define BINARY_PROTOTYPES_H

/*
 * The binary_c stellar population nucleosynthesis framework.
 *
 * Contact: r.izzard@surrey.ac.uk or rob.izzard@gmail.com
 *
 * http://personal.ph.surrey.ac.uk/~ri0005/binary_c.html
 * https://gitlab.eps.surrey.ac.uk/ri0005/binary_c
 * https://groups.google.com/forum/#!forum/binary_c-nucsyn-announce
 * https://groups.google.com/forum/#!forum/binary_c-nucsyn-devel
 * https://twitter.com/binary_c_code
 * https://www.facebook.com/groups/149489915089142/
 *
 * Please see the files README, LICENCE and CHANGES,
 * and the doc/ directory for documentation.
 *
 *
 * This header file loads in all the binary_c function
 * prototypes.
 */


#include <stdio.h>
#include <stdlib.h>
#include "binary_c_code_options.h"
#include "binary_c_parameters.h"
#include "binary_c_macros.h"
#include "binary_c_structures.h"

#include "./binary_c_main_prototypes.h"
#include "./debug/debug_prototypes.h"
#include "./file/file_prototypes.h"
#include "./batchmode/batchmode_prototypes.h"
#include "./memory/memory_prototypes.h"
#include "./tables/tables_prototypes.h"
#include "./timers/timers_prototypes.h"
#include "./string/string_prototypes.h"
#include "./signals/signals_prototypes.h"
#include "./evolution/evolution_prototypes.h"
#include "./events/events_prototypes.h"
#include "./zfuncs/zfuncs_prototypes.h"
#include "./single_star_functions/single_star_functions_prototypes.h"
#include "./stellar_timescales/stellar_timescales_prototypes.h"
#include "./binary_star_functions/binary_star_functions_prototypes.h"
#include "./novae/novae_prototypes.h"
#include "./setup/setup_prototypes.h"
#include "./stellar_structure/stellar_structure_prototypes.h"
#include "./logging/logging_prototypes.h"
#include "./RLOF/RLOF_prototypes.h"
#include "./maths/maths_prototypes.h"
#ifdef __HAVE_LIBRINTERPOLATE__
#  include <rinterpolate_prototypes.h>
#else
#  include "librinterpolate/rinterpolate_prototypes.h"
#endif//__HAVE_LIBRINTERPOLATE__
#include "./misc/misc_prototypes.h"
#include "./wind/wind_prototypes.h"
#include "./stellar_colours/stellar_colours_prototypes.h"
#include "./buffering/buffering_prototypes.h"
#include "./disc/disc_prototypes.h"
#include "./timestep/timestep_prototypes.h"
#include "./spectra/spectra_prototypes.h"
#include "./common_envelope/common_envelope_prototypes.h"
#include "./supernovae/supernovae_prototypes.h"
#include "./opacity/opacity_prototypes.h"
#include "./equation_of_state/equation_of_state_prototypes.h"
#include "./envelope_integration/envelope_integration_prototypes.h"
#include "./breakpoints/breakpoints_prototypes.h"
#ifdef __HAVE_LIBMEMOIZE__
#  include <memoize_prototypes.h>
#else
#  include "./libmemoize/memoize_prototypes.h"
#endif
#include "binary_c_exit_prototypes.h"
#include "orbit/orbit_prototypes.h"
#ifdef BINT
#include "BINT/BINT_prototypes.h"
#endif//BINT

void reset_binary_c_timeout(void);
void disable_binary_c_timeout(void);
void hoover_and_sms(struct stardata_t * const stardata,
                    const unsigned int s) No_return;
#if ((defined LINUX)||(defined TRAP_FLOATING_POINT_ERRORS))
void tstp_handler(int sig, siginfo_t *info, ucontext_t *uc);
#endif



#ifdef RANDOM_SYSTEMS
void set_random_system(struct stardata_t * const RESTRICT stardata);
#endif

/*
 * Force _exit() to be used ONLY for temporary code.
 * Issue a stern warning otherwise.
 */
void _exit(int status) Deprecated("_exit should only be used for temporary code!");


#endif /* BINARY_PROTOTYPES_H */
