#pragma once
#ifndef BINARY_C_OBJECTS_H
#define BINARY_C_OBJECTS_H


/*
 * The binary_c stellar population nucleosynthesis framework.
 *
 * Contact: r.izzard@surrey.ac.uk or rob.izzard@gmail.com
 *
 * http://personal.ph.surrey.ac.uk/~ri0005/binary_c.html
 * https://gitlab.eps.surrey.ac.uk/ri0005/binary_c
 * https://groups.google.com/forum/#!forum/binary_c-nucsyn-announce
 * https://groups.google.com/forum/#!forum/binary_c-nucsyn-devel
 * https://twitter.com/binary_c_code
 * https://www.facebook.com/groups/149489915089142/
 *
 * Please see the files README, LICENCE and CHANGES,
 * and the doc/ directory for documentation.
 *
 *
 *
 * This file contains macros which, when defined, lead to the 
 * inclusion of a given object file in the
 * binary_c executable. These files are usually built when
 * the configure script is run, and contain data.
 *
 * The macro should be of the form:
 * 
 * OBJECT_FILENAME
 *  
 * where the filename is translated into capitals
 * with underscores (_) replacing non-alphabet characters.
 *
 * e.g. 
 *
 * src/stellar_magnitudes/Kurucz.o
 * 
 * becomes
 *
 * OBJECT_SRC_STELLAR_COLOURS_KURUCZ
 */

#ifdef STELLAR_COLOURS
#  define OBJECT_SRC_STELLAR_COLOURS_KURUCZ
#  define OBJECT_SRC_STELLAR_COLOURS_ELDRIDGE2015_OSTAR
#  define OBJECT_SRC_STELLAR_COLOURS_ELDRIDGE2015_BASEL
#endif

#if defined NUCSYN && defined NUCSYN_S_PROCESS
#  define OBJECT_SRC_NUCSYN_NUCSYN_EXTENDED_S_PROCESS
#endif

#if defined NUCSYN && defined NUCSYN_NOVAE
#  define OBJECT_NUCSYN_NUCSYN_NOVAE_JH98_CO
#  define OBJECT_NUCSYN_NUCSYN_NOVAE_JH98_ONE
#endif

#ifdef COMENV_POLYTROPES
#  define OBJECT_COMMON_ENVELOPE_COMMON_ENVELOPE_POLYTROPE_3D
#endif

#ifdef OPACITY_ALGORITHMS
#ifdef OPACITY_ENABLE_ALGORITHM_FERGUSON_OPAL
#  define OBJECT_OPACITY_FERGUSON_OPAL_16062017
#endif
#ifdef OPACITY_ENABLE_ALGORITHM_STARS
#  define OBJECT_OPACITY_STARS
#endif
#endif // OPACITY_ALGORITHMS
#endif// BINARY_C_OBJECTS_H
