#pragma once
#ifndef BINARY_C_MAIN_H
#define BINARY_C_MAIN_H

/*
 * The binary_c stellar population nucleosynthesis framework.
 *
 * Contact: r.izzard@surrey.ac.uk or rob.izzard@gmail.com
 *
 * http://personal.ph.surrey.ac.uk/~ri0005/binary_c.html
 * https://gitlab.eps.surrey.ac.uk/ri0005/binary_c
 * https://groups.google.com/forum/#!forum/binary_c-nucsyn-announce
 * https://groups.google.com/forum/#!forum/binary_c-nucsyn-devel
 * https://twitter.com/binary_c_code
 * https://www.facebook.com/groups/149489915089142/
 *
 * Please see the files README, LICENCE and CHANGES,
 * and the doc/ directory for documentation.
 *
 *
 * This header file is used by the main() function 
 * of binary_c (see main.c).
 */


#include "binary_c.h"
#ifdef FPU_PRECISION
#include <fpu_control.h>
#endif//FPU_PRECISION
#include "binary_c_main_prototypes.h"
#include "binary_c_main_macros.h"
#ifdef STACK_SIZE
#include <sys/resource.h>
#endif//STACK_SIZE
#ifdef USE_MCHECK
#include <mcheck.h>
#endif//USE_MCHECK


#ifdef CODESTATS
struct codestats_t codestats;
static void output_codestats(void);

#define Output_codestats output_codestats();
#else
#define Output_codestats /* do nothing */
#endif//CODESTATS

static int binary_c_main(int argc,
                         char ** argv,
                         struct stardata_t ** RESTRICT s);

#endif // BINARY_C_MAIN_H
