#include "binary_c_code_options.h"
/*
 * The binary_c stellar population nucleosynthesis framework.
 *
 * Contact: r.izzard@surrey.ac.uk or rob.izzard@gmail.com
 *
 * http://personal.ph.surrey.ac.uk/~ri0005/binary_c.html
 * https://gitlab.eps.surrey.ac.uk/ri0005/binary_c
 * https://groups.google.com/forum/#!forum/binary_c-nucsyn-announce
 * https://groups.google.com/forum/#!forum/binary_c-nucsyn-devel
 * https://twitter.com/binary_c_code
 * https://www.facebook.com/groups/149489915089142/
 *
 * Please see the files README, LICENCE and CHANGES,
 * and the doc/ directory for documentation.
 *
 *
 * This file contains the exit function prototypes.
 *
 * If you define __HAVE_STARDATA_T then the 
 * exit function with stardata is also included.
 * 
 * This option is provided so that you can include
 * the exit prototypes from code locations that lack 
 * stardata. If you include binary_c.h (as is recommended
 * from general code) then you'll always have __HAVE_STARDATA_T
 * defined by binary_c_structures.h
 */

#ifdef __HAVE_STARDATA_T
void No_return exit_binary_c_with_stardata(struct stardata_t * stardata,
                                           char * filename,
                                           const int fileline,
                                           const int errsv,
                                           const int binary_c_error_code,
                                           char * format,
                                           ...) Gnu_format_args(6,7);
#endif//__HAVE_STARDATA_T

#ifndef Gnu_format_args
//#define Gnu_format_args
#endif

void No_return exit_binary_c_no_stardata(char * filename,
                                         const int fileline,
                                         const int errsv,
                                         const int binary_c_error_code,
                                         char * format,
                                         ...) Gnu_format_args(5,6);



