#pragma once
#ifndef BINARY_C_EXIT_MACROS_H
#define BINARY_C_EXIT_MACROS_H
/*
 * The binary_c stellar population nucleosynthesis framework.
 *
 * Contact: r.izzard@surrey.ac.uk or rob.izzard@gmail.com
 *
 * http://personal.ph.surrey.ac.uk/~ri0005/binary_c.html
 * https://gitlab.eps.surrey.ac.uk/ri0005/binary_c
 * https://groups.google.com/forum/#!forum/binary_c-nucsyn-announce
 * https://groups.google.com/forum/#!forum/binary_c-nucsyn-devel
 * https://twitter.com/binary_c_code
 * https://www.facebook.com/groups/149489915089142/
 *
 * Please see the files README, LICENCE and CHANGES,
 * and the doc/ directory for documentation.
 *
 * This file contains the function macros used by binary_c
 * to allow it to exit safely.
 */

#include <errno.h>

#define Exit_binary_c(...) {                                            \
        int errsv=errno;                                                \
        binary_c_breakpoint(stardata);                                  \
        exit_binary_c_with_stardata(stardata,                           \
                                    __FILE__,                           \
                                    __LINE__,                           \
                                    errsv,                              \
                                    __VA_ARGS__);                       \
                                                                        \
    }


#define Exit_binary_c_no_stardata(...) {        \
        int errsv=errno;                        \
        binary_c_breakpoint(NULL);              \
        exit_binary_c_no_stardata(__FILE__,     \
                                  __LINE__,     \
                                  errsv,        \
                                  __VA_ARGS__); \
    }


#define MAX_EXIT_STATEMENT_PRINT_SIZE (KIBIBYTE*16)

#define Exit_or_return_void(...) {                                      \
        Exit_or_return((void) 0,__VA_ARGS__);                           \
    }
        
#define Exit_or_return(RETVAL,...) {                                    \
        if(stardata &&                                                  \
           stardata->preferences &&                                     \
           stardata->preferences->batchmode==BATCHMODE_LIBRARY)         \
        {                                                               \
            uncatch_timeouts();                                         \
            return (RETVAL);                                            \
        }                                                               \
        else                                                            \
        {                                                               \
            Exit_binary_c(__VA_ARGS__);                          \
        }                                                               \
    }


#endif//BINARY_C_EXIT_MACROS
