#pragma once
#ifndef BINARY_C_EVENT_STRUCTURES_H
#define BINARY_C_EVENT_STRUCTURES_H

/*
 * The binary_c stellar population nucleosynthesis framework.
 *
 * Contact: r.izzard@surrey.ac.uk or rob.izzard@gmail.com
 *
 * http://personal.ph.surrey.ac.uk/~ri0005/binary_c.html
 * https://gitlab.eps.surrey.ac.uk/ri0005/binary_c
 * https://groups.google.com/forum/#!forum/binary_c-nucsyn-announce
 * https://groups.google.com/forum/#!forum/binary_c-nucsyn-devel
 * https://twitter.com/binary_c_code
 * https://www.facebook.com/groups/149489915089142/
 *
 * Please see the files README, LICENCE and CHANGES,
 * and the doc/ directory for documentation.
 *
 * This file contains structures used by binary_c's
 * event handling API.
 */

typedef unsigned int Event_notice;

#define EVENT_HANDLER_ARGS                              \
    void * const /* event pointer */,                   \
        struct stardata_t * const ,                     \
        void * /* data */

/* event handler type */
typedef void (*Event_handler_function)(EVENT_HANDLER_ARGS);

/* new event structure */
struct binary_c_event_t {
    Event_type type;
    Event_handler_function (*func)(EVENT_HANDLER_ARGS);
    Event_handler_function (*erase_func)(EVENT_HANDLER_ARGS);
    void * data;
    char * caller;
    Boolean unique;
};

/* data structure to handle supernova events */
struct binary_c_new_supernova_event_t {
    struct star_t * oldstar;
    struct star_t * companion;
    struct star_t * newstar;
};

/* data structure to handle common envelope events */
struct binary_c_new_common_envelope_event_t {
    struct star_t * donor;
    struct star_t * accretor;
};

struct binary_c_unstable_RLOF_event_t {
    struct star_t * donor;
    struct star_t * accretor;
    int instability;
};

struct binary_c_nova_event_t {
    struct star_t * donor;
    struct star_t * accretor;
    double accretion_rate;
    double steady_burn_rate;
    double f;
};

#endif // BINARY_C_EVENT_STRUCUTRES_H
