#pragma once
#ifndef BINARY_C_ERROR_CODES_H
#define BINARY_C_ERROR_CODES_H
/*
 * The binary_c stellar population nucleosynthesis framework.
 *
 * Contact: r.izzard@surrey.ac.uk or rob.izzard@gmail.com
 *
 * http://personal.ph.surrey.ac.uk/~ri0005/binary_c.html
 * https://gitlab.eps.surrey.ac.uk/ri0005/binary_c
 * https://groups.google.com/forum/#!forum/binary_c-nucsyn-announce
 * https://groups.google.com/forum/#!forum/binary_c-nucsyn-devel
 * https://twitter.com/binary_c_code
 * https://www.facebook.com/groups/149489915089142/
 *
 * Please see the files README, LICENCE and CHANGES,
 * and the doc/ directory for documentation.
 *
 * This file contains exit codes for binary_c : 
 * these should be integers <255 with 0 the normal exit.
 */
#define BINARY_C_NORMAL_EXIT 0
#define BINARY_C_NORMAL_BATCHMODE_EXIT 1
#define BINARY_C_DELIBERATE_FAIL 2
#define BINARY_C_SETUP_UNKNOWN_ARGUMENT 3
#define BINARY_C_SETUP_FAILED_TO_LOAD_PARAMETERS 4
#define BINARY_C_NEWTON_RAPHSON_FAILURE 5
#define BINARY_C_COMENV_STELLAR_TYPE_CHANGE 6
#define BINARY_C_GIANT_AGE_MMAX_NOT_FOUND 7
#define BINARY_C_GIANT_AGE_ROOT_NOT_BRACKETED 8
#define BINARY_C_GIANT_AGE_ROOT_NOT_FOUND 9
#define BINARY_C_GIANT_AGE_FRACTIONAL_AGE_OUT_OF_BOUNDS 10
#define BINARY_C_GIANT_AGE_STAR_TOO_BIG_FOR_GB 11
#define BINARY_C_GIANT_AGE_MMIN_TOO_BIG 12
#define BINARY_C_ADAPTIVE_GRID_EXCEPTION 13
#define BINARY_C_ADAPTIVE_GRID_CAUGHT_SIGINT 14
#define BINARY_C_ADAPTIVE_GRID_CAUGHT_SIGTERM 15
#define BINARY_C_ADAPTIVE_GRID_NO_SAVE_FILE_BACKUP 16
#define BINARY_C_ADAPTIVE_GRID_BAD_DATA_ON_LOAD 17
#define BINARY_C_ADAPTIVE_GRID_OPEN_FAILED 18
#define BINARY_C_ADAPTIVE_GRID_CHECKSUM_FAILED 19
#define BINARY_C_ADAPTIVE_GRID_OUT_OF_MEMORY 20
#define BINARY_C_ADAPTIVE_GRID_ZERO_STEP_SIZE 21
#define BINARY_C_MAX_INT_OOPS 22
#define BINARY_C_ADAPTIVE_GRID_UNSURE_USER 23
#define BINARY_C_ADAPTIVE_GRID_OUT_OF_BOUNDS 24
#define BINARY_C_ADAPTIVE_GRID_INDEX_TOO_BIG 25
#define BINARY_C_MIX_MERGED_STELLAR_TYPE_NOT_CAUGHT 26
#define BINARY_C_XHBB_OR_XENV_CALLOC_FAILED 27
#define BINARY_C_MNUC_CALLOC_FAILED 28
#define BINARY_C_NUCSYN_HBB_MALLOC_FAILED 29
#define BINARY_C_CAUGHT_SEGFAULT 30
#define BINARY_C_TIMED_OUT 31
#define BINARY_C_WAS_TOLD_TO_EXIT 32
#define BINARY_C_DIST_KICK_FORK_FAILED 33
#define BINARY_C_MAX_SPLIT_DEPTH_HIT 34
#define BINARY_C_FILE_CLOSE_ERROR 35
#define BINARY_C_FILE_OPEN_ERROR 36
#define BINARY_C_PIPE_FAILURE 37
#define BINARY_C_LOG_FP_NULL_IN_ITERATE 38
#define BINARY_C_EXCEED_BIGLOG_LINES 39
#define BINARY_C_DETAILED_LOG_OPEN_FAILED 40
#define BINARY_C_ADAPTIVE_GRID_LIMITS_NOT_DEFINED 41
#define BINARY_C_LOG_HR_OPEN_FAIL 42
#define BINARY_C_NENA_CALLOC_FAILED 43
#define BINARY_C_CALLOC_FAILED_IN_INTERPOLATE 44
#define BINARY_C_HBB_MASS_FRACTION_ERROR 45
#define BINARY_C_NR_FAILED_IN_KICK 46
#define BINARY_C_RLOF_EXIT 47
#define BINARY_C_ADAPTIVE_COMENV_FAILED 48
#define BINARY_C_WRONG_ARGUMENT 49
#define BINARY_C_MALLOC_FAILED 50
#define BINARY_C_ALLOC_FAILED 50
#define BINARY_C_ACQUIRE_NEGATIVE_AGE 51
#define BINARY_C_MAX_NUM_RLOFS_REACHED 52
#define BINARY_C_CORELESS_AGB 53
#define BINARY_C_MASS_OUT_OF_RANGE 54
#define BINARY_C_TOO_MANY_ITERATIONS 55
#define BINARY_C_ALGORITHM_OUT_OF_RANGE 56
#define BINARY_C_INVALID_KICK_VELOCITY_DISTRIBUTION 57
#define BINARY_C_POINTER_FAILURE 58
#define BINARY_C_TIMESCALE_ERROR 59
#define BINARY_C_OUT_OF_RANGE 60
#define BINARY_C_ALGORITHM_BRANCH_FAILURE 61
#define BINARY_C_SINGULAR_MATRIX 62
#define BINARY_C_WRITE_FAILED 63
#define BINARY_C_MADVISE_ERROR 64
#define BINARY_C_COMENV_MALLOC_FAILED 65
#define BINARY_C_MASS_NOT_CONSERVED 66
#define BINARY_C_UPDATE_MASSES_MALLOC_FAILED 67
#define BINARY_C_EXIT_NAN 68
#define BINARY_C_UNKNOWN_DISC_TYPE 70
#define BINARY_C_NINTLIB_EXIT 71
#define BINARY_C_QUIET_EXIT 72
#define BINARY_C_NOT_ENOUGH_SHELLS 73
#define BINARY_C_SPECIAL_EXIT 74
#define BINARY_C_UNDER_OR_OVERFLOW 75
#define BINARY_C_EQUATION_OF_STATE_FAILED 76
#define BINARY_C_PRINTF_BUFFER_EXCEEDED 77
#define BINARY_C_GSL_ERROR 78
#define BINARY_C_DEBUG_STOP 79
#define BINARY_C_FILE_READ_ERROR 80
#define BINARY_C_STACK_HANDLER 81
#define BINARY_C_STACK_FAIL 82
#define BINARY_C_FLOATING_POINT_ERROR 83
#define BINARY_C_ISNAN_FAILED 84
#define BINARY_C_INTERPOLATION_ERROR 85
#define BINARY_C_DISC_NO_INITIAL_STRUCTURE 86
#define BINARY_C_BISECT_ERROR 87
#define BINARY_C_IMPORTED_CODE_ERROR 88
#define BINARY_C_SNPRINTF_FAILED 89
#define BINARY_C_ENVVAR_EMPTY 90

#define Binary_c_error_string(I)                                        \
    (                                                                   \
        (I)==BINARY_C_NORMAL_EXIT ? "Normal exit" :                     \
        (I)==BINARY_C_NORMAL_BATCHMODE_EXIT ? "Normal batchmode exit" : \
        (I)==BINARY_C_DELIBERATE_FAIL ? "Deliberate fail" :             \
        (I)==BINARY_C_SETUP_UNKNOWN_ARGUMENT ? "Setup unknown argument" : \
        (I)==BINARY_C_SETUP_FAILED_TO_LOAD_PARAMETERS ? "Setup failed to load parameters" : \
        (I)==BINARY_C_NEWTON_RAPHSON_FAILURE ? "Newton raphson failure" : \
        (I)==BINARY_C_COMENV_STELLAR_TYPE_CHANGE ? "Comenv stellar type change" : \
        (I)==BINARY_C_GIANT_AGE_MMAX_NOT_FOUND ? "Giant age mmax not found" : \
        (I)==BINARY_C_GIANT_AGE_ROOT_NOT_BRACKETED ? "Giant age root not bracketed" : \
        (I)==BINARY_C_GIANT_AGE_ROOT_NOT_FOUND ? "Giant age root not found" : \
        (I)==BINARY_C_GIANT_AGE_FRACTIONAL_AGE_OUT_OF_BOUNDS ? "Giant age fractional age out of bounds" : \
        (I)==BINARY_C_GIANT_AGE_STAR_TOO_BIG_FOR_GB ? "Giant age star too big for gb" : \
        (I)==BINARY_C_GIANT_AGE_MMIN_TOO_BIG ? "Giant age mmin too big" : \
        (I)==BINARY_C_ADAPTIVE_GRID_EXCEPTION ? "Adaptive grid exception" : \
        (I)==BINARY_C_ADAPTIVE_GRID_CAUGHT_SIGINT ? "Adaptive grid caught sigint" : \
        (I)==BINARY_C_ADAPTIVE_GRID_CAUGHT_SIGTERM ? "Adaptive grid caught sigterm" : \
        (I)==BINARY_C_ADAPTIVE_GRID_NO_SAVE_FILE_BACKUP ? "Adaptive grid no save file backup" : \
        (I)==BINARY_C_ADAPTIVE_GRID_BAD_DATA_ON_LOAD ? "Adaptive grid bad data on load" : \
        (I)==BINARY_C_ADAPTIVE_GRID_OPEN_FAILED ? "Adaptive grid open failed" : \
        (I)==BINARY_C_ADAPTIVE_GRID_CHECKSUM_FAILED ? "Adaptive grid checksum failed" : \
        (I)==BINARY_C_ADAPTIVE_GRID_OUT_OF_MEMORY ? "Adaptive grid out of memory" : \
        (I)==BINARY_C_ADAPTIVE_GRID_ZERO_STEP_SIZE ? "Adaptive grid zero step size" : \
        (I)==BINARY_C_MAX_INT_OOPS ? "Max int oops" :                   \
        (I)==BINARY_C_ADAPTIVE_GRID_UNSURE_USER ? "Adaptive grid unsure user" : \
        (I)==BINARY_C_ADAPTIVE_GRID_OUT_OF_BOUNDS ? "Adaptive grid out of bounds" : \
        (I)==BINARY_C_ADAPTIVE_GRID_INDEX_TOO_BIG ? "Adaptive grid index too big" : \
        (I)==BINARY_C_MIX_MERGED_STELLAR_TYPE_NOT_CAUGHT ? "Mix merged stellar type not caught" : \
        (I)==BINARY_C_XHBB_OR_XENV_CALLOC_FAILED ? "Xhbb or xenv calloc failed" : \
        (I)==BINARY_C_MNUC_CALLOC_FAILED ? "Mnuc calloc failed" :       \
        (I)==BINARY_C_NUCSYN_HBB_MALLOC_FAILED ? "Nucsyn hbb malloc failed" : \
        (I)==BINARY_C_CAUGHT_SEGFAULT ? "Caught segfault" :             \
        (I)==BINARY_C_TIMED_OUT ? "Timed out" :                         \
        (I)==BINARY_C_WAS_TOLD_TO_EXIT ? "Was told to exit" :           \
        (I)==BINARY_C_DIST_KICK_FORK_FAILED ? "Dist kick fork failed" : \
        (I)==BINARY_C_MAX_SPLIT_DEPTH_HIT ? "Max split depth hit" :     \
        (I)==BINARY_C_FILE_CLOSE_ERROR ? "File close error" :           \
        (I)==BINARY_C_FILE_OPEN_ERROR ? "File open error" :             \
        (I)==BINARY_C_PIPE_FAILURE ? "Pipe failure" :                   \
        (I)==BINARY_C_LOG_FP_NULL_IN_ITERATE ? "Log fp null in iterate" : \
        (I)==BINARY_C_EXCEED_BIGLOG_LINES ? "Exceed biglog lines" :     \
        (I)==BINARY_C_DETAILED_LOG_OPEN_FAILED ? "Detailed log open failed" : \
        (I)==BINARY_C_ADAPTIVE_GRID_LIMITS_NOT_DEFINED ? "Adaptive grid limits not defined" : \
        (I)==BINARY_C_LOG_HR_OPEN_FAIL ? "Log hr open fail" :           \
        (I)==BINARY_C_NENA_CALLOC_FAILED ? "Nena calloc failed" :       \
        (I)==BINARY_C_CALLOC_FAILED_IN_INTERPOLATE ? "Calloc failed in interpolate" : \
        (I)==BINARY_C_HBB_MASS_FRACTION_ERROR ? "Hbb mass fraction error" : \
        (I)==BINARY_C_NR_FAILED_IN_KICK ? "Nr failed in kick" :         \
        (I)==BINARY_C_RLOF_EXIT ? "Rlof exit" :                         \
        (I)==BINARY_C_ADAPTIVE_COMENV_FAILED ? "Adaptive comenv failed" : \
        (I)==BINARY_C_WRONG_ARGUMENT ? "Wrong argument" :               \
        (I)==BINARY_C_MALLOC_FAILED ? "Malloc failed" :                 \
        (I)==BINARY_C_ALLOC_FAILED ? "Alloc failed" :                   \
        (I)==BINARY_C_ACQUIRE_NEGATIVE_AGE ? "Acquire negative age" :   \
        (I)==BINARY_C_MAX_NUM_RLOFS_REACHED ? "Max num rlofs reached" : \
        (I)==BINARY_C_CORELESS_AGB ? "Coreless agb" :                   \
        (I)==BINARY_C_MASS_OUT_OF_RANGE ? "Mass out of range" :         \
        (I)==BINARY_C_TOO_MANY_ITERATIONS ? "Too many iterations" :     \
        (I)==BINARY_C_ALGORITHM_OUT_OF_RANGE ? "Algorithm out of range" : \
        (I)==BINARY_C_INVALID_KICK_VELOCITY_DISTRIBUTION ? "Invalid kick velocity distribution" : \
        (I)==BINARY_C_POINTER_FAILURE ? "Pointer failure" :             \
        (I)==BINARY_C_TIMESCALE_ERROR ? "Timescale error" :             \
        (I)==BINARY_C_OUT_OF_RANGE ? "Out of range" :                   \
        (I)==BINARY_C_ALGORITHM_BRANCH_FAILURE ? "Algorithm branch failure" : \
        (I)==BINARY_C_SINGULAR_MATRIX ? "Singular matrix" :             \
        (I)==BINARY_C_WRITE_FAILED ? "Write failed" :                   \
        (I)==BINARY_C_MADVISE_ERROR ? "Madvise error" :                 \
        (I)==BINARY_C_COMENV_MALLOC_FAILED ? "Comenv malloc failed" :   \
        (I)==BINARY_C_MASS_NOT_CONSERVED ? "Mass not conserved" :       \
        (I)==BINARY_C_UPDATE_MASSES_MALLOC_FAILED ? "Update masses malloc failed" : \
        (I)==BINARY_C_EXIT_NAN ? "Exit nan" :                           \
        (I)==BINARY_C_UNKNOWN_DISC_TYPE ? "Unknown disc type" :         \
        (I)==BINARY_C_NINTLIB_EXIT ? "Nintlib exit" :                   \
        (I)==BINARY_C_QUIET_EXIT ? "Quiet exit" :                       \
        (I)==BINARY_C_NOT_ENOUGH_SHELLS ? "Not enough shells" :         \
        (I)==BINARY_C_SPECIAL_EXIT ? "Special exit" :                   \
        (I)==BINARY_C_UNDER_OR_OVERFLOW ? "Under or overflow" :         \
        (I)==BINARY_C_EQUATION_OF_STATE_FAILED ? "Equation of state failed" : \
        (I)==BINARY_C_PRINTF_BUFFER_EXCEEDED ? "Printf buffer exceeded" : \
        (I)==BINARY_C_GSL_ERROR ? "Gsl error" :                         \
        (I)==BINARY_C_DEBUG_STOP ? "Debug stop" :                       \
        (I)==BINARY_C_FILE_READ_ERROR ? "File read error" :             \
        (I)==BINARY_C_STACK_HANDLER ? "Stack handler" :                 \
        (I)==BINARY_C_STACK_FAIL ? "Stack fail" :                       \
        (I)==BINARY_C_FLOATING_POINT_ERROR ? "Floating point error" :   \
        (I)==BINARY_C_ISNAN_FAILED ? "isnan failed" :                   \
        (I)==BINARY_C_INTERPOLATION_ERROR ? "Interpolation error" :     \
        (I)==BINARY_C_DISC_NO_INITIAL_STRUCTURE ? "Disc no initial structure" : \
        (I)==BINARY_C_IMPORTED_CODE_ERROR ? "Imported code error" :     \
        (I)==BINARY_C_SNPRINTF_FAILED ? "Snprintf failed" :             \
        )




/*
 * generic_bisect errors
 */
#define BINARY_C_BISECT_ERROR_NONE 0
#define BINARY_C_BISECT_ERROR_MAXED_OUT 1
#define BINARY_C_BISECT_ERROR_BRACKET_FAILED 2
#define BINARY_C_BISECT_ERROR_NON_MONOTONICALLY_INCREASING 3
#define BINARY_C_BISECT_ERROR_ALL_ZERO 4
#define BINARY_C_BISECT_ERROR_FUNCTION_FAILED 5

#define Bisect_error_string(I)                                          \
    (                                                                   \
        (I)==BINARY_C_BISECT_ERROR_NONE ? "None" :                      \
        (I)==BINARY_C_BISECT_ERROR_MAXED_OUT ? "Maxed out" :            \
        (I)==BINARY_C_BISECT_ERROR_BRACKET_FAILED ? "Bracket failed" :  \
        (I)==BINARY_C_BISECT_ERROR_NON_MONOTONICALLY_INCREASING ? "Function is not monotonic" : \
        (I)==BINARY_C_BISECT_ERROR_ALL_ZERO ? "All residuals are zero" : \
        (I)==BINARY_C_BISECT_ERROR_FUNCTION_FAILED ? "Function failed" : \
        "unknown"                                                       \
        )
        
        
#endif // BINARY_C_ERROR_CODES_H
