#pragma once
/*
 * Collision matrix.
 *
 * This matrix determines the stellar type when two stars merge.
 * It is equivalent to the "ktypes" array in BSE.
 * 
 * See Hurley et al 2002, MNRAS 329, 897, Table 2
 *
 * COLLISION_MATRIX_SIZE is defined in binary_c_macros.h
 */

#define COLLISION_MATRIX {                                              \
        { 1, 1, 102, 103, 104, 105, 106, 4, 106, 106, 3, 6, 6, 13, 14 }, \
        { 1, 1, 102, 103, 104, 105, 106, 4, 106, 106, 3, 6, 6, 13, 14 }, \
        { 102, 102, 103, 103, 104, 104, 105, 104, 104, 104, 103, 105, 105, 113, 114 }, \
        { 103, 103, 103, 103, 104, 104, 105, 104, 104, 104, 103, 105, 105, 113, 114 }, \
        { 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 113, 114 }, \
        { 105, 105, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 113, 114 }, \
        { 106, 106, 105, 105, 104, 104, 106, 104, 106, 106, 105, 106, 106, 113, 114 }, \
        { 4, 4, 104, 104, 104, 104, 104, 1, 108, 109, 7, 9, 9, 13, 14 }, \
        { 106, 106, 104, 104, 104, 104, 106, 108, 108, 109, 107, 109, 109, 113, 114 }, \
        { 106, 106, 104, 104, 104, 104, 106, 109, 109, 109, 107, 109, 109, 113, 114 }, \
        { 3, 3, 103, 103, 104, 104, 105, 7, 107, 107, 15, 9, 9, 13, 14 }, \
        { 6, 6, 105, 105, 104, 104, 106, 9, 109, 109, 9, 11, 12, 13, 14 }, \
        { 6, 6, 105, 105, 104, 104, 106, 9, 109, 109, 9, 12, 12, 13, 14 }, \
        { 13, 13, 113, 113, 113, 113, 113, 13, 113, 113, 13, 13, 13, 14, 14 }, \
        { 14, 14, 114, 114, 114, 114, 114, 14, 114, 114, 14, 14, 14, 14, 14 } \
    }
