
#ifndef BINARY_C_H
#define BINARY_C_H

/*
 * The binary_c stellar population nucleosynthesis framework.
 *
 * Contact: r.izzard@surrey.ac.uk or rob.izzard@gmail.com
 *
 * http://personal.ph.surrey.ac.uk/~ri0005/binary_c.html
 * https://gitlab.eps.surrey.ac.uk/ri0005/binary_c
 * https://groups.google.com/forum/#!forum/binary_c-nucsyn-announce
 * https://groups.google.com/forum/#!forum/binary_c-nucsyn-devel
 * https://twitter.com/binary_c_code
 * https://www.facebook.com/groups/149489915089142/
 *
 * Please see the files README, LICENCE and CHANGES,
 * and the doc/ directory for documentation.
 *
 * This Header file load in all macros, prototypes, etc.
 * for binary_c/nucsyn, and set a couple of global variables.
 *
 * It is the header file to be loaded if you are using the
 * libbinary_c API. 
 */

/* first : system headers */
#ifndef _GNU_SOURCE
#define _GNU_SOURCE
#endif
#include <search.h>
#include <stdlib.h>
#include <errno.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <strings.h>
#include <setjmp.h>
#include <ctype.h>
#include <limits.h>
#include <float.h>
#include <sys/timeb.h>
#include <sys/time.h>
#include <time.h>
#include <stdarg.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <fenv.h>
#ifdef __HAVE_LIBBSD__
#include <bsd/string.h>
#endif

/* binary_c's headers */
#include "binary_c_version_macros.h"
#include "binary_c_code_options.h"
#include "binary_c_types.h"
#include "binary_c_debug.h"
#include "binary_c_error_codes.h"
#include "misc/misc.h"
#include "binary_c_parameters.h"
#include "binary_c_macros.h"
#include "binary_c_structures.h"
#include "binary_c_prototypes.h"
#include "timestep/timestep.h"
#include "nucsyn/nucsyn.h"
#include "supernovae/sn.h"
#include "evolution/evolution_macros.h"
#include "disc/disc.h"
#include "memory/memory_function_macros.h"
#include "API/binary_c_API.h"
//#include MEMOIZE_HEADER_FILE
#ifdef __HAVE_LIBMEMOIZE__
#  include <memoize.h>
#else
#  include "libmemoize/memoize.h"
#endif
#include "binary_c_objects.h"
#ifdef __HAVE_LIBRINTERPOLATE__
#  include <rinterpolate.h>
#else
#  include "librinterpolate/rinterpolate.h"
#endif


#endif //BINARY_C_H
