#include "../binary_c.h"
#include "RLOF.h"

Boolean Pure_function RLOF_overflowing(struct stardata_t * RESTRICT const stardata,
                                       const double fac)
{
    /*
     * Return TRUE if Roche-lobe overflow will happen (R>RL)
     * in either star.
     *
     * NB in older versions of the code, ndonor was used 
     *    to identify the donor star. However, this fails 
     *    when used with discs. Instead, just test both
     *    stars and return the obvious Boolean.
     */
    Star_number k;
    Boolean overflowing = FALSE;
    Starloop(k)
    { 
        SETstar(k);
        Dprint("t=%g STAR %d type %d : R=%g RL=%g : overflowing? %d\n",
               stardata->model.time,
               k,
               star->stellar_type,
               star->radius,
               star->roche_radius,
               star->radius > star->roche_radius * fac);
                
        if(star->radius > star->roche_radius * fac)
        {
            overflowing = TRUE;
            break;
        }
    }
    return overflowing;

}
