#include "../binary_c.h"
#include "RLOF.h"
#ifdef DEPREACTED

/*
 * This is now done in non-conservative_angular_momentum_loss
 */

void RLOF_orbital_angular_momentum_loss(struct stardata_t * RESTRICT const stardata)
{
    RLOF_stars;

    /*
     * Calculate orbital angular momentum change due to 
     * mass being lost from the system because of
     * (possibly non-conservative) Roche-lobe overflow.
     *
     * This only deals with material in the accretion stream which
     * is not accreted onto the companion.
     *
     * dm_lose_dt is the rate of mass change of the system
     * because of non-conservative Roche lobe overflow.  
     *
     * d(RLOF_TRANSFER) is < 0, while d(RLOF_GAIN) > 0,
     * so we add these two. If the result is <0, this is the
     * rate of change of the system mass.
     *
     * Novae are not treated here, see limit_accretion_rates().
     */
    double dm_lose_dt = 
        /* this term is negative because the derivative is positive */
        - donor->derivative[DERIVATIVE_STELLAR_MASS_RLOF_TRANSFER] 
        +
        /* this term is positive */
        accretor->derivative[DERIVATIVE_STELLAR_MASS_RLOF_GAIN];

    if(dm_lose_dt < 0.0)
    {
        /*
         * Orbital angular momentum
         */
        double Jorb = Angular_momentum_from_stardata;

        /*
         * Specific orbital angular momentum
         */
        double Lorb = Jorb / Total_mass;

        /*
         * gamma is the factor by which dm_lose_dt is multiplied to calculate
         * the angular momentum of lost material
         */
        double gamma = non_conservative_gamma(stardata,
                                              donor,
                                              accretor);
                
        /* hence add a contribution to dJorb */
        stardata->model.derivative[DERIVATIVE_ORBIT_ANGMOM_RLOF_LOSS] =
            gamma * dm_lose_dt * Lorb;

        Dprint("DJORB += %30.20e (RLOF system loss)\n",
               stardata->model.derivative[DERIVATIVE_ORBIT_ANGMOM_RLOF_LOSS]);
    }
}
#endif // DEPRECATED
