#include "../binary_c.h"


/*
 * Event handler for RLOF mergers, which is really
 * just a wrapper to mix the stars
 */

Event_handler_function RLOF_merger_event_handler(void * eventp,
                                                 struct stardata_t * stardata,
                                                 void * data)
{
    mix_stars(stardata->star,stardata);
    stardata->star[0].epoch = stardata->model.time - stardata->star[0].age;
    stardata->model.coalesce = TRUE;
    
    Dprint("Set epoch 0 of merged star: %g\n",stardata->star[0].epoch);
    return NULL;
}
