
#include "../binary_c.h"
#include "RLOF.h"

void RLOF_merger(struct stardata_t * RESTRICT stardata,
                 struct RLOF_orbit_t * RLOF_orbit)
{
    /*
     * Two stars (dynamically) merge during RLOF, either
     * because R>10RL or because they are two 
     * main sequence stars with q>qc
     *
     * This is handled as an event when events are available.
     */
    RLOF_stars;

    double donor_mass_was = donor->mass;
    double accretor_mass_was = accretor->mass;
    mix_stars(stardata->star,stardata);
    RLOF_orbit->dM_RLOF_lose = -(donor_mass_was - donor->mass);
    RLOF_orbit->dM_RLOF_transfer = accretor->mass - accretor_mass_was;
    Dprint("RLOF merger : lose %g transfer %g\n",
           RLOF_orbit->dM_RLOF_lose,
           RLOF_orbit->dM_RLOF_transfer
        );
    stardata->star[0].epoch = stardata->model.time - stardata->star[0].age;
    Dprint("Set epoch 0 %g\n",stardata->star[0].epoch);
    stardata->model.coalesce = TRUE;
}
