/*
 * header file for macros used in RLOF_mass_transfer_rate
 * and associated functions.
 * These are *only* to make the code clearer, not provide options/parameters.
 * Also included are function prototypes.
 */



/*
 * Macro defining stars with convective envelopes
 */
#define CONVENV(A) (CONVECTIVE_ENVELOPE(A))

#define STELLAR_STRUCTURE_ARGS                                  \
    p_m0,                                                       \
        p_mc0,                                                  \
        p_aj,                                                   \
        p_mt,                                                   \
        p_tm,                                                   \
        p_tn,                                                   \
        hr_tscls,                                               \
        hr_lums,                                                \
        hr_GB,                                                  \
        p_r,                                                    \
        p_lum,                                                  \
        p_stellar_type,                                         \
        p_mc,                                                   \
        p_mcCO,                                                 \
        p_mcGB,                                                 \
        p_mcmaxMS,                                              \
        p_rc,                                                   \
        p_menv,                                                 \
        p_renv,                                                 \
        p_k2,                                                   \
        p_time_first_pulse,                                     \
        p_num_thermal_pulses,                                   \
        p_time_prev_pulse,                                      \
        p_prev_tagb,                                            \
        p_menv_1tp,                                             \
        p_mc_1tp,                                               \
        p_core_mass_no_3dup,                                    \
        p_interpulse_period,                                    \
        p_time_next_pulse,                                      \
        p_lambda_3dup,                                          \
        p_num_thermal_pulses_since_mcmin,                       \
        p_spiky_luminosity,                                     \
        &hr_SN_type,                                            \
        FALSE,                                                  \
        star,                                                   \
        stardata,                                               \
        STELLAR_STRUCTURE_CALLER_RLOF_mass_transfer_rate
		     
#define STELLAR_TIMESCALES_ARGS hr_stellar_type,hr_m0,hr_mt,p_tm,p_tn,hr_tscls,hr_lums,hr_GB,stardata,star

#define STELLAR_STRUCTURE_VARS double                                   \
    hr_m0=star->phase_start_mass;                                       \
    double hr_mc0=star->phase_start_core_mass;                          \
    double hr_mt=mass;                                                  \
    double hr_aj=star->age;                                             \
    double hr_GB[GB_ARRAY_SIZE];                                        \
    double hr_lums[LUMS_ARRAY_SIZE];                                    \
    double hr_tscls[TSCLS_ARRAY_SIZE];                                  \
    double hr_tm,hr_tn;                                                 \
    double hr_r=r;                                                      \
    double hr_lum=star->luminosity;                                     \
    double hr_mc=star->core_mass;                                       \
    double hr_mcCO=star->CO_core_mass;                                  \
    double hr_mcGB=star->GB_core_mass;                                  \
    double hr_mcmaxMS=star->max_MS_core_mass;                           \
    double hr_rc=star->core_radius;                                     \
    double hr_menv=star->menv;                                          \
    double hr_renv=star->renv;                                          \
    double hr_k2=star->k2;                                              \
    double hr_time_first_pulse=star->time_first_pulse;                  \
    double hr_num_thermal_pulses=star->num_thermal_pulses;              \
    double hr_time_prev_pulse=star->time_prev_pulse;                    \
    double hr_prev_tagb=star->prev_tagb;                                \
    double hr_menv_1tp=star->menv_1tp;                                  \
    double hr_mc_1tp=star->mc_1tp;                                      \
    double hr_core_mass_no_3dup=star->core_mass_no_3dup;                \
    double hr_interpulse_period=star->interpulse_period;                \
    double hr_time_next_pulse=star->time_next_pulse;                    \
    double hr_lambda_3dup=star->lambda_3dup;                            \
    double hr_num_thermal_pulses_since_mcmin=star->num_thermal_pulses_since_mcmin; \
    double hr_spiky_luminosity=star->spiky_luminosity;                  \
    Stellar_type hr_stellar_type=star->stellar_type;                    \
    int hr_SN_type=SN_NONE;

#define RESET_STELLAR_STRUCTURE_VARS_EXCEPT_MASS                        \
    hr_aj=star->age;                                                    \
    hr_r=r;                                                             \
    hr_lum=star->luminosity;                                            \
    hr_mc=star->core_mass;                                              \
    hr_mcCO=star->CO_core_mass;                                         \
    hr_mcGB=star->GB_core_mass;                                         \
    hr_mcmaxMS=star->max_MS_core_mass;                                  \
    hr_rc=star->core_radius;                                            \
    hr_menv=star->menv;                                                 \
    hr_renv=star->renv;                                                 \
    hr_k2=star->k2;                                                     \
    hr_stellar_type=star->stellar_type;                                 \
    hr_SN_type=SN_NONE;                                                 \
    hr_time_first_pulse=star->time_first_pulse;                         \
    hr_num_thermal_pulses=star->num_thermal_pulses;                     \
    hr_time_prev_pulse=star->time_prev_pulse;                           \
    hr_prev_tagb=star->prev_tagb;                                       \
    hr_menv_1tp=star->menv_1tp;                                         \
    hr_mc_1tp=star->mc_1tp;                                             \
    hr_core_mass_no_3dup=star->core_mass_no_3dup;                       \
    hr_interpulse_period=star->interpulse_period;                       \
    hr_time_next_pulse=star->time_next_pulse;                           \
    hr_lambda_3dup=star->lambda_3dup;                                   \
    hr_num_thermal_pulses_since_mcmin=star->num_thermal_pulses_since_mcmin; \
    hr_spiky_luminosity=star->spiky_luminosity;                  
    
#define STELLAR_STRUCTURE_SHOW_ARGS printf("STELLAR_STRUCTURE args m0=%g mt=%g age=%g mc=%g st=%d\n",hr_m0,hr_mt,hr_aj,hr_mc,hr_stellar_type);

#define STELLAR_STRUCTURE_POINTERS                                      \
    double *p_m0=&hr_m0;                                                \
    double *p_mc0=&hr_mc0;                                              \
    double *p_aj=&hr_aj;                                                \
    double *p_mt=&hr_mt;                                                \
    double *p_tm=&hr_tm;                                                \
    double *p_tn=&hr_tn;                                                \
    double *p_r=&hr_r;                                                  \
    double *p_lum=&hr_lum;                                              \
    Stellar_type *p_stellar_type=&hr_stellar_type;                      \
    double *p_mc=&hr_mc;                                                \
    double *p_mcCO=&hr_mcCO;                                            \
    double *p_mcGB=&hr_mcGB;                                            \
    double *p_mcmaxMS=&hr_mcmaxMS;                                      \
    double *p_rc=&hr_rc;                                                \
    double *p_menv=&hr_menv;                                            \
    double *p_renv=&hr_renv;                                            \
    double *p_k2=&hr_k2;                                                \
    double *p_time_first_pulse=&hr_time_first_pulse;                    \
    double *p_num_thermal_pulses=&hr_num_thermal_pulses;                \
    double *p_time_prev_pulse=&hr_time_prev_pulse;                      \
    double *p_prev_tagb=&hr_prev_tagb;                                  \
    double *p_menv_1tp=&hr_menv_1tp;                                    \
    double *p_mc_1tp=&hr_mc_1tp;                                        \
    double *p_core_mass_no_3dup=&hr_core_mass_no_3dup;                  \
    double *p_interpulse_period=&hr_interpulse_period;                  \
    double *p_time_next_pulse=&hr_time_next_pulse;                      \
    double *p_lambda_3dup=&hr_lambda_3dup;                              \
    double *p_num_thermal_pulses_since_mcmin=&hr_num_thermal_pulses_since_mcmin; \
    double *p_spiky_luminosity=&hr_spiky_luminosity;                    \

#define CAP_NONE 0
#define CAP_THERMAL 1
#define CAP_ENVELOPE 2
#define CAP_DYNAMICAL 3

#define STATUS_NONE 0
#define STATUS_CONVERGED 1 
#define STATUS_DMDR_NEGATIVE 2
#define STATUS_DR_ZERO 3
#define STATUS_WD_ENVELOPE 4
#define STATUS_MT_LT_ZERO 5

double Pure_function hurley_rate(const double r,
                                 const double roche_radius,
                                 const double mass,
                                 const struct star_t * const star,
                                 const struct stardata_t * const stardata);

double Pure_function ritter_rate(const double r,
                                 const double roche_radius,
                                 const double mass,
                                 struct star_t * const star,
                                 struct stardata_t * const stardata);

static double Pure_function Claeys_factor(const struct star_t * const loser);

double radius_mass_derivative(struct stardata_t * const stardata,
                              struct star_t * const star,
                              const double mass);

double Pure_function roche_stream_area(const struct star_t * const star,
                                       const struct stardata_t * const stardata);
double Constant_function_if_no_debug sound_speed(struct star_t * const star,
                                                 struct stardata_t * const stardata);
double Constant_function_if_no_debug surface_pressure_scale_height(struct star_t * const star,
                                                                   struct stardata_t * const stardata);
