
#include "../binary_c.h"
#include "RLOF.h"

#undef naccretor
#undef ndonor

void RLOF_dynamical_transfer_from_low_mass_MS_star(struct stardata_t * const stardata,
                                                   struct RLOF_orbit_t * const RLOF_orbit)
{
    Dprint("RLOF caught dynamical low mass MS donor event\n");
    RLOF_stars;
   
    double taum;
#ifdef BSE
    double tmsnew;
#endif
#ifdef NUCSYN
    double am,bm;
    Isotope i;
#ifdef NUCSYN_STRIP_AND_MIX
    accretor->strip_and_mix_disabled=TRUE;
    donor->strip_and_mix_disabled=TRUE;
#endif
#endif
        
    /*
     * This will be dynamical mass transfer of a similar nature to
     * common-envelope evolution.  The result is always a single
     * merged star.
     */
  
    /* 
     * Eddington limit for accretion on to the secondary in one orbit. 
     */
    double Eddington_rate =  eddington_limit_for_accretion(stardata,
                                                           accretor->radius,
                                                           Hydrogen_mass_fraction);
    /*
     * Dynamical timescale for the primary.
     */
    double tdyn = dynamical_timescale(donor);

    taum = sqrt(donor->tkh*tdyn);
    RLOF_orbit->dM_RLOF_lose = -donor->mass;

    if(ON_MAIN_SEQUENCE(accretor->stellar_type))
    {
        /*
         * Restrict accretion to thermal timescale of secondary.
         */
        Dprint("Restrict accretion to thermal timescale of secondary.");
        RLOF_orbit->dM_RLOF_transfer = -taum/accretor->tkh*RLOF_orbit->dM_RLOF_lose;
        accretor->mass +=  RLOF_orbit->dM_RLOF_transfer;

#ifdef NUCSYN
        /* Mix abundances of star 1 through star 2 */
        bm = RLOF_orbit->dM_RLOF_transfer/accretor->mass;
        am=1.0-bm;
        Isotope_loop(i)
        {
            accretor->Xenv[i]=am*accretor->Xenv[i]+bm*donor->Xenv[i];
        }
#endif

#ifdef BSE
        /*
         * Rejuvenate if the star is still on the main sequence.
         */
        accretor->phase_start_mass = accretor->mass;

        double GB[GB_ARRAY_SIZE];
        double lums[LUMS_ARRAY_SIZE];
        double tscls[TSCLS_ARRAY_SIZE];
        double tn;
        stellar_timescales(accretor->stellar_type,
                           accretor->phase_start_mass,
                           accretor->mass,
                           &tmsnew,
                           &tn,
                           tscls,
                           lums,
                           GB,
                           stardata,
                           accretor);
            
        /*
         * If the star has no convective core then the effective age decreases,
         * otherwise it will become younger still.
         */ 
        accretor->age = tmsnew/accretor->tms*accretor->age;
        if(!Convective_star(naccretor)) accretor->age *= (1.0 - RLOF_orbit->dM_RLOF_transfer/accretor->mass);
        accretor->epoch = stardata->model.time - accretor->age;
        Dprint("set epoch 1\n");
#endif // BSE
    }
    else if(accretor->stellar_type<=TPAGB)
    {
        /*
         * Add all the material to the giant's envelope.
         */
        Dprint("Add all the material to the giant's envelope.");
        RLOF_orbit->dM_RLOF_transfer = -RLOF_orbit->dM_RLOF_lose;
        accretor->mass += RLOF_orbit->dM_RLOF_transfer;
#ifdef NUCSYN
        bm=RLOF_orbit->dM_RLOF_transfer/(accretor->mass-accretor->core_mass+TINY);
        am=1.0-bm;
        Isotope_loop(i)
        {
            accretor->Xenv[i]=am*accretor->Xenv[i]+bm*donor->Xenv[i];
        }
#endif
#ifdef BSE
        if(accretor->stellar_type==HERTZSPRUNG_GAP)
        {
            accretor->phase_start_mass = accretor->mass;
            double GB[GB_ARRAY_SIZE];
            double lums[LUMS_ARRAY_SIZE];
            double tscls[TSCLS_ARRAY_SIZE];
            double tn;
            stellar_timescales(accretor->stellar_type,
                               accretor->phase_start_mass,
                               accretor->mass,
                               &tmsnew,
                               &tn,
                               tscls,
                               lums,
                               GB,
                               stardata,
                               accretor);

            accretor->age = tmsnew + tscls[T_BGB]*
                (accretor->age-accretor->tms)/accretor->tbgb;
            accretor->epoch = stardata->model.time - accretor->age;
            Dprint("set epoch 2\n");
        }
#endif//BSE

    }
    else if(accretor->stellar_type<=ONeWD)
    {
        /*
         * Form a new giant envelope.
         */
        Dprint("Form a new giant envelope.");
        RLOF_orbit->dM_RLOF_transfer = -RLOF_orbit->dM_RLOF_lose;

        Stellar_type stellar_type = stardata->store->collision_matrix[donor->stellar_type][accretor->stellar_type];
        if(stellar_type>100) stellar_type -= 100;
        Dprint("Set from collision matrix[%d][%d] = %d\n",
               donor->stellar_type,
               accretor->stellar_type,
               stellar_type);

        if(stellar_type==CHeB)
        {
            accretor->age /= accretor->tms;
            accretor->core_mass = accretor->mass;
        }

#ifdef NUCSYN
        /* New abundances are those of star 1 */
        Copy_abundances(donor->Xenv,accretor->Xenv);
#endif

        /*
         * Check for planets or low-mass WDs.
         */
        if((accretor->stellar_type==HeWD && accretor->mass<0.05)||

           /* in BSE the 0.05 was 0.5, which was presumably a typo */
           (accretor->stellar_type>=COWD && accretor->mass<0.05))
        {
            stellar_type = donor->stellar_type;
            donor->mass = accretor->mass + RLOF_orbit->dM_RLOF_transfer;
            accretor->mass=0.0;
        }
        else
        {
            accretor->mass += RLOF_orbit->dM_RLOF_transfer;
#ifdef BSE
            giant_age(&accretor->core_mass,
                      accretor->mass,
                      &stellar_type,
                      &accretor->phase_start_mass,
                      &accretor->age,
                      stardata,
                      accretor);
            Dprint("giant age gave stellar type %d\n",stellar_type);
#endif//BSE
            accretor->epoch = stardata->model.time - accretor->age;
            Dprint("set epoch 3 = %g from time=%g - age=%g\n",
                   accretor->epoch,
                   stardata->model.time,
                   accretor->age
                );
        }
        /*
         * NB any existing accretion layer will be mixed into the new envelope
         * in the update_masses() function
         */
        accretor->stellar_type = stellar_type;
        Dprint("set ac st %d\n",stellar_type);
    }
    else
    {
        /*
         * The neutron star or black hole simply accretes at the Eddington rate.
         */
        Dprint("The neutron star or black hole simply accretes at the Eddington rate.");
        RLOF_orbit->dM_RLOF_transfer = Min(Eddington_rate*taum, 
                                           -RLOF_orbit->dM_RLOF_lose);
        if(RLOF_orbit->dM_RLOF_transfer < -RLOF_orbit->dM_RLOF_lose)
            stardata->model.supedd = TRUE;
        accretor->mass += RLOF_orbit->dM_RLOF_transfer;
    }

    stardata->model.coalesce = TRUE;

    /*
     * Case where the other star cannot accept all the mass being dumped on
     * it e.g. low mass MS dumping all of its mass onto a low mass MS
     */
    if(accretor->mass > TINY)
    {
        /* Lose mass of star ndonor to environment */
#ifdef NUCSYN
        nucsyn_calc_yields(stardata,
                           donor,
                           -RLOF_orbit->dM_RLOF_lose,
                           donor->Xenv,
                           RLOF_orbit->dM_RLOF_transfer,
                           accretor->Xenv,
                           ndonor,
                           YIELD_NOT_FINAL,
                           NUCSYN_SOURCE_RLOF);
#endif
        donor->mass = 0.0;
        donor->stellar_type = MASSLESS_REMNANT;
    }
    else
    {
        /* Lose star naccretor */
#ifdef NUCSYN
        nucsyn_calc_yields(stardata,
                           accretor,
                           -RLOF_orbit->dM_RLOF_lose,
                           accretor->Xenv,
                           RLOF_orbit->dM_RLOF_transfer,
                           donor->Xenv,
                           naccretor,
                           YIELD_NOT_FINAL,
                           NUCSYN_SOURCE_RLOF);
#endif    
        donor->stellar_type = accretor->stellar_type;
        accretor->stellar_type = MASSLESS_REMNANT;
    }

    stardata->common.orbit.separation = 0.0;
    stardata->common.orbit.period = 0.0;
    stardata->common.orbit.angular_momentum = 0.0;
    stardata->common.orbit.eccentricity = 0.0;
        
    update_orbital_variables(stardata,
                             &stardata->common.orbit,
                             donor,
                             accretor);

    Dprint("post RLOF dyn st %d %d\n",
           donor->stellar_type,
           accretor->stellar_type
        );
}
