
#include "../binary_c.h"
#include "RLOF.h"

Boolean RLOF_dynamical_comenv(struct stardata_t * const RESTRICT stardata,
                              struct RLOF_orbit_t * const RLOF_orbit)
{
    /*
     * Common-envelope evolution (q>qc) during RLOF.
     *
     * Returns CONTINUE_RLOF or END_RLOF
     */
    RLOF_stars;
    int action;
    const double m1ce = donor->mass;
    const double m2ce = accretor->mass;
    Dprint("call comenv sep=%12.12e\n",stardata->common.orbit.separation);

    common_envelope_evolution( 
        donor,
        accretor,
        stardata
        );

    donor->epoch = stardata->model.time - donor->age;

    /* check for merger */
    if(stardata->model.coalesce==TRUE)
    {
        stardata->model.com = TRUE;
        action = END_RLOF;
    }
    else
    {
        /* reset epoch */
        accretor->epoch = stardata->model.time - accretor->age;
        Dprint("Set epoch %g\n",accretor->epoch);
        
        /* check for break up */
        if(stardata->common.orbit.eccentricity>1.0)
        {
#ifdef BSE
            Star_number k;
            Starloop(k)
            {
                SETstar(k);
                if(star->stellar_type>=NEUTRON_STAR)
                {
                    double rc = corerd(star->stellar_type,
                                       star->mass,
                                       star->mass,
                                       star->phase_start_core_mass,
                                       stardata->common.metallicity_parameters[ZPAR_MASS_HE_FLASH],
                                       stardata);
                    if(Is_zero(rc)) rc = star->radius;

                    star->omega = star->angular_momentum/(K3*Pow2(rc)*star->mass);
                }
            }
#endif//BSE
            action = END_RLOF;
        }
        else
        {
            /*
             * Next step should be made without changing the time.
             *
             * Note that these dM_* are not used for anything except
             * logging: they're not realisitic given that we know little 
             * about the timescale of common-envelope evolution.
             */
            RLOF_orbit->dM_RLOF_lose = -(m1ce - donor->mass);
            RLOF_orbit->dM_RLOF_transfer = accretor->mass - m2ce;
            RLOF_orbit->dM_RLOF_accrete = RLOF_orbit->dM_RLOF_transfer;
            stardata->model.dtm = 0.0;

            /*
             * Reset orbital parameters as separation may have changed.
             */

            stardata->common.orbit.period = (stardata->common.orbit.separation/AU_IN_SOLAR_RADII)*sqrt(stardata->common.orbit.separation/(AU_IN_SOLAR_RADII*Total_mass));
            stardata->common.orbit.angular_frequency = TWOPI/stardata->common.orbit.period;

            action = CONTINUE_RLOF;
        }
    }

    return action;
}
