#include "../binary_c.h"

/*
 * Donor star's maximum rate limit : envelope
 */

double Pure_function RLOF_donor_envelope_rate_limit(const struct stardata_t * const stardata,
                                                    const struct star_t * const donor)
{
    return
        stardata->preferences->donor_limit_envelope_multiplier < -TINY ?
        VERY_LARGE_MASS_TRANSFER_RATE :
        ((donor->mass - donor->core_mass) / (1e6 * stardata->model.dtm));
}
