#include "../binary_c.h"
#include "RLOF.h"

void RLOF_NSNS_NSBH_merger(struct stardata_t * const stardata,
                           struct RLOF_orbit_t * const RLOF_orbit)
{
    RLOF_stars;
  
    /*
     * NS donor: NS-NS/BH merger: Gamma ray burst ... ?
     */

#ifdef NS_BH_AIC_LOG
    if((donor->stellar_type==NEUTRON_STAR)&&
       (accretor->stellar_type==NEUTRON_STAR))
    {
        printf("NSNS p=%12.12e t=%12.12e in special cases\n",stardata->model.probability,
               stardata->model.time);
        //printf("sgl = %d\n",stardata->model.sgl);
#ifdef FILE_LOG
        char c[STRING_LENGTH];
        sprintf(c,"NSNS at time t=%12.12e\n",stardata->model.time);
        output_string_to_log(stardata,c);
#endif
    }
#endif

    /*
     * The neutron star must be the donor
     */
    if(accretor->stellar_type == NEUTRON_STAR &&
       donor->stellar_type == BLACK_HOLE)
    {
        Swap_stars(donor,accretor);
    }

    /*
     * determine "SN" type: the overflower
     * is a neutron star, so the companion
     * must be more compact, i.e. a black hole.
     */
    if((accretor->stellar_type==NEUTRON_STAR &&
        donor->stellar_type==BLACK_HOLE)
       ||
       (donor->stellar_type==NEUTRON_STAR &&
        accretor->stellar_type==BLACK_HOLE))
    {
        accretor->SN_type = SN_BH_NS;
    }
    else
    {
        accretor->SN_type = SN_NS_NS;
    }
        
    struct star_t * news =
        new_supernova(stardata,accretor,donor,accretor);

    /* 
     * Set post-SN mass
     */
    
    RLOF_orbit->dM_RLOF_lose = -donor->mass;
    RLOF_orbit->dM_RLOF_transfer = -RLOF_orbit->dM_RLOF_lose;
    
    /*
     * Post-SN structure : will be set into the accretor
     */
    
    if(news)
    {
        news->mass = RLOF_orbit->dM_RLOF_transfer + accretor->mass;
        news->phase_start_mass = news->mass;
        news->core_mass = news->mass;
        news->SN_type = accretor->SN_type;
        news->stellar_type =
            news->mass > stardata->preferences->max_neutron_star_mass ?
            BLACK_HOLE : NEUTRON_STAR;
    }
    
    /*
     * donor is evaporated
     */
    donor->mass = 0.0;
    donor->stellar_type  = MASSLESS_REMNANT;
    donor->SN_type = SN_NONE;
    
    /*
     * Set merge flag and update the orbit
     */
    stardata->model.coalesce = TRUE;
    stardata->common.orbit.separation = 0.0;
    stardata->common.orbit.period = 0.0;
    stardata->common.orbit.angular_momentum = 0.0;
    stardata->common.orbit.eccentricity = 0.0;
        
    update_orbital_variables(stardata,
                             &stardata->common.orbit,
                             donor,
                             accretor);
#ifdef NUCSYN
    // remove accretion layers for BH and MASSLESS_REMNANT
    donor->dmacc=0.0;
    accretor->dmacc=0.0;
    nucsyn_merge_NSs(stardata);
    donor->sn_last_time = accretor->SN_type;
#endif
    
}
