/*
 * Stellar evolution based on the BINT algorithm.
 */
#include "../binary_c.h"

#ifdef BINT

void BINT_stellar_structure(struct star_t *const newstar,
                            struct star_t *const oldstar,
                            struct stardata_t *const stardata,
                            const Caller_id caller_id)
{
    /*
     * Check for fuel exhaustion
     */
    if(oldstar->stellar_type < HERTZSPRUNG_GAP)
    {
        if(Is_zero(oldstar->bint.XHc))
        {
            newstar->stellar_type = HERTZSPRUNG_GAP;
        }
    }

    if(newstar->stellar_type <= MAIN_SEQUENCE)
    {
        BINT_stellar_structure_MS(newstar,
                                  stardata);
    }
    else
    {
        stardata->model.max_evolution_time = stardata->model.time;

        fprintf(stderr,
               "BINT algorithm called for post-main sequence star: not yet implemented\n");
        Exit_binary_c(0,"");
    }
    
    newstar->phase_start_mass = fabs(newstar->phase_start_mass); 
}

#endif // BINT
