#pragma once
#ifndef BINT_PROTOTYPES_H
#define BINT_PROTOTYPES_H

/*
 * Setup functions
 */
void BINT_init(struct stardata_t * const stardata);
int BINT_load_grid(struct stardata_t * const stardata);
void BINT_free_store(struct store_t * const store);


/*
 * Stellar structure
 */
void BINT_stellar_structure(struct star_t * const newstar,
                            struct star_t *const oldstar,
                            struct stardata_t *const stardata,
                            const Caller_id caller_id);
Stellar_type BINT_stellar_structure_MS(struct star_t * const newstar,
                                       struct stardata_t * RESTRICT const stardata);
double BINT_MS_lifetime(struct stardata_t * const stardata,
                        struct star_t * const star);
double BINT_initial_XHc(struct stardata_t * const stardata);



/*
 * Stellar merging
 */
void BINT_mix_stars(struct star_t * const stars,
                    struct stardata_t * const stardata);

#endif // BINT_PROTOTYPES_H
