#include "../binary_c.h"
#ifdef BINT

double BINT_MS_lifetime(struct stardata_t * const stardata,
                        struct star_t * const star)
{
    /*
     * Estimate the main sequence lifetime of star
     * based on its metallicity, mass, etc.
     */
    double params[3] = {
        log10(stardata->common.metallicity),
        star->phase_start_mass,
        0.0 // XHc = 0
    };
    double result[12];
                
    /*
     * Interpolate to find stellar structure
     */
    Interpolate(stardata->store->BINT_MS,
                params,
                result,
                FALSE);

    Dprint("MS lifetime(%g,%g,%g) = %g\n",
           params[0],
           params[1],
           params[2],
           result[0]);
    return result[0];
}
#endif // BINT
