#include "../binary_c.h"

#ifdef BINARY_C_API

void binary_c_API_function binary_c_help(struct stardata_t * RESTRICT const stardata,
                                         char * argstring)
{
    /*
     * API function to put help associated with the argument in argstring
     * into buffer.
     */
    if(stardata != NULL)
    {
        int c = 0;
        const int argc = 2;
        char ** argv = Malloc(argc * sizeof(char *));
    
        asprintf(&argv[0],"binary_c");
        argv[1] = argstring;

        struct tmpstore_t * tmpstore = stardata->tmpstore;
        if(tmpstore == NULL)
        {
            build_tmpstore_contents(tmpstore);
        }
        binary_c_help_from_arg(
            stardata->tmpstore->cmd_line_args,
            stardata,
            &c,
            0, // dummy var
            stardata->tmpstore->arg_count, // arg_count
            argv,
            -argc // argc 
            );
        Safe_free(argv[0]);
        Safe_free(argv);
    }
}
#endif//BINARY_C_API
