package Maths_Double;

# a variety of functions aimed at manipulating arrays of doubles 
# at speed
#
# These are written in C and use the Inline module

use 5.008005;
use strict;
use warnings;
use base 'Exporter';
use Time::HiRes qw(gettimeofday tv_interval);
use Config;
use Carp;

our $VERSION = '0.01';

use Inline 
    (
     C => 'DATA',
     CC => $Config{cc},
     LD => $Config{ld},
     CCFLAGS=>$Config{ccflags}.' -lm -lc ',
     NAME => 'Maths_Double',
     VERSION => '0.01',
     BUILD_NOISY => 1,
     FORCE_BUILD => 1
    );

our @ISA = qw(Exporter);
my @subs = qw( &increment_array &increment_two_arrays &add_two_arrays &add_two_arrays_and_increment &copy_array_of_doubles &sum_array_of_doubles &test_Maths_Double &simple_increment_array &binary_search );
our %EXPORT_TAGS = ( 'all' => \@subs );
our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );
our @EXPORT = @subs;

# C functions used by the yieldset loader: 
#
# or, rather, wrappers in perl for the C functions
#
#
# These are funtions which speed up operations on arrays of doubles


# add_two_arrays
#
# add_two_arrays_and_increment
#
# increment_array
#
# copy_array_of_doubles
#
# sum_array_of_doubles



sub test_Maths_Double
{
    print "Maths Double tests\n";

    my @x=(1,2,3);
    my @y=(4,5,6);
    my @z=();
    my $f1=1.0;
    my $f2=1.0;

    print "X=@x\nY=@y\n";
    
    add_two_arrays(1.0,1.0,\@z,\@x,\@y);
    print "x+y=@z\n";

    @z=(-1,-1,-1);
    add_two_arrays_and_increment(1.0,1.0,\@z,\@x,\@y);
    print "x+y-1=@z\n";

    @z=@x;
    increment_array(2.0,\@z,\@y);
    print "x+2*y=@z\n";

    @z=();
    copy_array_of_doubles(\@z,\@x);
    printf "x (copy)=@z\nsum of x=%g, of y=%g\n",
    sum_array_of_doubles(\@x),sum_array_of_doubles(\@y);
}

sub add_two_arrays
{
    #add_two_arrays_speed_test(@_);exit;
    if(0){print "ADD TWO ARRAYS: facs $_[0] $_[1] : arrays $_[2] $_[3] $_[4]\n";
    print join(',',$_[2],@{$_[2]},"\n");
    print join(',',$_[3],@{$_[3]},"\n");
	  print join(',',$_[4],@{$_[4]},"\n");}
    C_add_two_arrays(@_);
}

sub add_two_arrays_speed_test
{
    my $t0;
    my $n=100000;

    print "Spin up...";
    foreach (0..$n)
    {
	C_add_two_arrays(@_);
    }
    print "done\n";


    # original version
    print "\n\nTest slow: ... ";
    $t0=[gettimeofday];
    foreach (0..$n)
    {
	C_add_two_arrays(@_);
    }
    printf "%s s\n",tv_interval($t0);
}

sub add_two_arrays_and_increment
{
    C_add_two_arrays_and_increment(@_);
}

sub increment_array
{
    # args:
    #
    # factor
    # array1
    # array2
    #
    # then set array1 = array1 + factor * array2
    C_increment_array(@_);
}

sub increment_two_arrays
{
    # as increment array but for two arrays
    C_increment_two_arrays(@_);
}

sub simple_increment_array
{
    # set $_[0] = $_[0] + $_[1]
    C_simple_increment_array(@_);
}

sub copy_array_of_doubles
{
    # copy $_[1] into $_[0]
    $#{$_[0]}=$#{$_[1]}; # pregrow array
    C_copy_array_of_doubles(@_);
}
sub sum_array_of_doubles
{
    C_sum_array($_[0]);
}

sub binary_search
{
    # return spanning indices from a binary search
    # @_ = (value, arrayref)
    # where <value> is searched for in <arrayref> 
    my $sa = C_binary_search(@_);
    return ($sa,$sa+1);
}

1;

__DATA__

=pod
=cut

__C__
#include <stdlib.h>


// sometimes require this prototype...
void zeroarray(AV * a, int i);

void C_increment_array(double f,SV *y1,SV *y2)
{
    // y1 = y1 + f*y2

    AV *a1=(AV*)SvRV(y1),*a2=(AV*)SvRV(y2);
    int i=0,imax=av_len(a2)+1;

    // a1 may be undef, in which case build it
    if(av_len(a1)+1<imax) zeroarray(a1,imax);

    for(i=0;i<imax;i++)
    {
	av_store(a1,i,newSVnv((double)SvNV(*av_fetch(a1,i,0))+
			      f*(double)SvNV(*av_fetch(a2,i,0))));
    }
}

/* like C_increment_array for two arrays */
void C_increment_two_arrays(double f,SV *y0, SV *y1,SV *y2)
{
    // y0 = y0 + f*y2
    // y1 = y1 + f*y2

    
    AV *a0=(AV*)SvRV(y0),*a1=(AV*)SvRV(y1),*a2=(AV*)SvRV(y2);
    int i=0,imax=av_len(a2)+1;
    double tmp;

    // a0 or a1 may be undef, in which case build it
    if(av_len(a0)+1<imax) zeroarray(a0,imax);
    if(av_len(a1)+1<imax) zeroarray(a1,imax);

    for(i=0;i<imax;i++)
    {
	tmp = f*(double)SvNV(*av_fetch(a2,i,0));
	av_store(a0,i,newSVnv((double)SvNV(*av_fetch(a0,i,0))+tmp));
	av_store(a1,i,newSVnv((double)SvNV(*av_fetch(a1,i,0))+tmp));
    }
}

void C_simple_increment_array(SV *y1,SV *y2)
{
    // y1 = y1 + y2

    AV *a1=(AV*)SvRV(y1),*a2=(AV*)SvRV(y2);
    int i=0,imax=av_len(a2)+1;

    // a1 may be undef, in which case build it
    if(av_len(a1)+1<imax) zeroarray(a1,imax);

    for(i=0;i<imax;i++)
    {
	av_store(a1,i,newSVnv((double)SvNV(*av_fetch(a1,i,0))+
			      (double)SvNV(*av_fetch(a2,i,0))));
    }
}


#define MAX_MACRO(A,B) ((A)>(B)?(A):(B))

void C_add_two_arrays_and_increment(double f,double f1,
				    SV *y1, SV *y2, SV *y3)
{
  /* Interpolation function (with increment on y1) */

  // make y1 = y1+f*y2+f1*y3
    
  // y1,y2,y3 are references to (perl) arrays
  // f and f1 are the interpolation constants

  // use SvRV to convert from the reference to the actual arrays
  AV *a1=(AV*)SvRV(y1),*a2=(AV*)SvRV(y2),*a3=(AV*)SvRV(y3);

  int imax=av_len(a2)+1;
    
  // a1 may be undef, in which case build it
  if(av_len(a1)+1<imax) zeroarray(a1,imax);
    
  int i=0;
  while(i<imax)
  {
      av_store(a1,i,newSVnv((double)SvNV(*av_fetch(a1,i,0))+
			    f*(double)SvNV(*av_fetch(a2,i,0))+
			    f1*(double)SvNV(*av_fetch(a3,i,0))));
      i++;
  }
}

void C_add_two_arrays(double f,double f1,
		      SV *y1, SV *y2, SV *y3)
{
    /* Interpolation function (without increment) */
  // make y1 = f*y2+f1*f3
  
  // y1,y2,y3 are references to (perl) arrays
  // f and f1 are the interpolation constants
#ifdef DEBUG
  printf("add f=%g f1=%g y1=%p y2=%p y3=%p\n",f,f1,y1,y2,y3);
#endif
  // use SvRV to convert from the reference to the actual arrays
  AV *a1=(AV*)SvRV(y1),*a2=(AV*)SvRV(y2),*a3=(AV*)SvRV(y3);
#ifdef DEBUG
    printf("add avs %p %p %p\n",a1,a2,a3);fflush(stdout);
#endif

  int imax=av_len(a2)+1;
#ifdef DEBUG
  printf("IMAX %d\n",imax);fflush(stdout);
#endif
  // a1 may be undef, in which case build it
  if(av_len(a1)+1<imax) zeroarray(a1,imax);
#ifdef DEBUG
  printf("zeroed\n");fflush(stdout);
#endif
   
  int i=0;
  for(i=0;i<imax;i++)
  {

#ifdef DEBUG
      printf("pre-avstore %d\n",i);
      fflush(stdout);
      printf("avstore %d (%g %g)\n",i,
             (double)SvNV(*av_fetch(a2,i,0)),
             (double)SvNV(*av_fetch(a3,i,0)));
      fflush(stdout);
#endif
      av_store(a1,i,newSVnv(f*(double)SvNV(*av_fetch(a2,i,0))+
	    f1*(double)SvNV(*av_fetch(a3,i,0))));
  
  }

#ifdef DEBUG
    printf("return\n");fflush(stdout);
#endif
}



double C_sum_array(SV *y2)
{
  /* add up array */
  AV *a2=(AV*)SvRV(y2);
  double x=0.0;
  const int imax=av_len(a2)+1;
  int i=0;
  while(i<imax)
  {
      x+=(double)SvNV(*av_fetch(a2,i,0));
      i++;
  }
  return (x);
}

void C_copy_array_of_doubles( SV *y1, SV *y2)
{
  /* copy array y2 into y1 : assume both are filled with doubles */
  AV *a1=(AV*)SvRV(y1),*a2=(AV*)SvRV(y2);
  int imax=av_len(a2)+1;
  // a1 may be undef, in which case build it
  if(av_len(a1)+1<imax) zeroarray(a1,imax);

  int i=0;
  while(i<imax)
  {
      av_store(a1,i,newSVnv((double)SvNV(*av_fetch(a2,i,0))));
      i++;
  }
}
void zeroarray(AV * a, int i)
{
    // set array a to zero, up to i elements
    i -= av_len(a)+1;
    while(i-->0) av_push(a,newSVnv(0.0));
}

int C_binary_search(double value, SV * arrayref)
{
    AV *array=(AV*)SvRV(arrayref);
    int sa=0,sb=av_len(array),sc;
    while(sb>sa+1)
    {
       sc = (int)((sa+sb)/2);
       if(value > (double)SvNV(*av_fetch(array,sc,0)))
       {
           sa = sc;
       }
       else
       {
           sb = sc;
       }
    }
    return sa;
}

double C_gaussian(double x,double mean,double sigma)
{
    double r = 1.0/sigma;
    double y = (x-mean)*r;
    return 3.989422804014327028632180827117e-01 * r * exp(-0.5*y*y);
}

__END__



