
package Data::Serializer::RobJSON;
BEGIN { @Data::Serializer::RobJSON::ISA = qw(Data::Serializer) }

use warnings;
use strict;
use Cpanel::JSON::XS; # thread safe JSON module
use vars qw($VERSION @ISA);
use Histogram;

$VERSION = '0.05';

#
# Hacked verison of the Data::Serializer::JSON module
# to allow object support in JSON AND bless Histogram
# objects that arise
#
# Changes:
#
# 0.05 : use JSON::XS thread-safe module
#

sub serialize {
    my $obj = Cpanel::JSON::XS->new();
    $obj->allow_blessed(1);
    $obj->convert_blessed(1);
    $obj->utf8(1);
    my $r;
    #if(JSON->VERSION<2)
    #{#
#	$r = $obj->to_json($_[1]);
 #   }
  #  else
   # {
	$r = $obj->utf8->encode($_[1]);
    #}
 
    return $r;
}

sub deserialize {

    my $obj = Cpanel::JSON::XS->new();
#    my $obj = JSON::PP->new();

#    print "DESERIALIZER $obj\n";
    
    $obj->allow_blessed(1);
    $obj->convert_blessed(1);

    my $r;
#    if(JSON->VERSION<2)
 #   {
#	$r = $obj->jsonToObj($_[1]);
 #   }
  #  else
    # {
    #print "Call decode on $_[1]\n";
    #open(FP,'>','/tmp/poo');print FP $_[1];close FP;exit;
    $r = $obj->utf8->decode($_[1]);
    #}

 #   print "Call bless histo\n";
    # bless histogram objects
    analyse_hash_recursively($r);

  #  print "RETURN\n";
    $_[1] and return $r;
}

sub analyse_hash_recursively {
    my $hash           =   shift @_;
    foreach ( keys %{$hash} )
    {
	if($hash->{_is_histogram_object})
	{
	    # found histogram object: bless it
	    bless $hash,'Histogram';
	}
        elsif (ref $hash->{$_} eq 'HASH') 
	{
            analyse_hash_recursively($hash->{$_});
        }
    }
}

1;
__END__
