"""
File containing dictionary with the Moe & diStefano 2017 dataset. Prepared by Sophie Dykes
"""

moe_di_stefano_2017_data = {
    "Comments": "File contains data concerning properties for different log10(primary mass) for multiple star systems. Data from Moe and Di Stefano (2017): https://ui.adsabs.harvard.edu/abs/2017ApJS..230...15M/abstract . Github: https://gitlab.eps.surrey.ac.uk/sd00599/fyp",
    "log10M1": [
        {
            "-1.0": {
                "f_multi": 0.1126,
                "multi system fraction": 0.0995,
                "binary star fraction": 0.0929,
                "triple/quad star fraction": 0.0066,
                "single star fraction": 0.9005,
                "poisson_model": {
                    "single_fraction": 0.894,
                    "binary_fraction": 0.101,
                    "triple_fraction": 0.00566,
                    "quadruple_fraction": 2.13e-05,
                },
                "logP": {
                    "0.25": {
                        "periodfrac": 0.0026031,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.02617,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.423083,
                            "0.95": 0.576917,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "0.75": {
                        "periodfrac": 0.00328462,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.03302,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.423083,
                            "0.95": 0.576917,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.25": {
                        "periodfrac": 0.00426667,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.04289,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.423083,
                            "0.95": 0.576917,
                        },
                        "e": {
                            "0.05": 0.330824,
                            "0.15": 0.165642,
                            "0.25": 0.129153,
                            "0.35": 0.110009,
                            "0.45": 0.100964,
                            "0.55": 0.0990032,
                            "0.65": 0.057533,
                            "0.75": 0.00687094,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.75": {
                        "periodfrac": 0.0055291,
                        "P_bin": 0.995371,
                        "normed_bin_frac_p_dist": 0.05532,
                        "normed_tripquad_frac_p_dist": 0.001953,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.423083,
                            "0.95": 0.576917,
                        },
                        "e": {
                            "0.05": 0.14167,
                            "0.15": 0.131895,
                            "0.25": 0.12826,
                            "0.35": 0.125956,
                            "0.45": 0.12427,
                            "0.55": 0.123559,
                            "0.65": 0.12234,
                            "0.75": 0.0809714,
                            "0.85": 0.0210788,
                            "0.95": 0.0,
                        },
                    },
                    "2.25": {
                        "periodfrac": 0.00704218,
                        "P_bin": 0.981652,
                        "normed_bin_frac_p_dist": 0.06949,
                        "normed_tripquad_frac_p_dist": 0.009859,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.424963,
                            "0.95": 0.575037,
                        },
                        "e": {
                            "0.05": 0.0944499,
                            "0.15": 0.110031,
                            "0.25": 0.117032,
                            "0.35": 0.121823,
                            "0.45": 0.125515,
                            "0.55": 0.127863,
                            "0.65": 0.127994,
                            "0.75": 0.112768,
                            "0.85": 0.0563073,
                            "0.95": 0.00621564,
                        },
                    },
                    "2.75": {
                        "periodfrac": 0.0086958,
                        "P_bin": 0.963641,
                        "normed_bin_frac_p_dist": 0.08423,
                        "normed_tripquad_frac_p_dist": 0.02412,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.426869,
                            "0.95": 0.573131,
                        },
                        "e": {
                            "0.05": 0.0754871,
                            "0.15": 0.0987081,
                            "0.25": 0.110213,
                            "0.35": 0.118419,
                            "0.45": 0.12492,
                            "0.55": 0.129746,
                            "0.65": 0.13039,
                            "0.75": 0.123258,
                            "0.85": 0.0725423,
                            "0.95": 0.0163158,
                        },
                    },
                    "3.25": {
                        "periodfrac": 0.0101032,
                        "P_bin": 0.942517,
                        "normed_bin_frac_p_dist": 0.09572,
                        "normed_tripquad_frac_p_dist": 0.04431,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.429069,
                            "0.95": 0.570931,
                        },
                        "e": {
                            "0.05": 0.0657833,
                            "0.15": 0.0922986,
                            "0.25": 0.106244,
                            "0.35": 0.116451,
                            "0.45": 0.124683,
                            "0.55": 0.131158,
                            "0.65": 0.132341,
                            "0.75": 0.127869,
                            "0.85": 0.0804725,
                            "0.95": 0.0226993,
                        },
                    },
                    "3.75": {
                        "periodfrac": 0.0110051,
                        "P_bin": 0.91881,
                        "normed_bin_frac_p_dist": 0.1016,
                        "normed_tripquad_frac_p_dist": 0.06818,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.431586,
                            "0.95": 0.568414,
                        },
                        "e": {
                            "0.05": 0.0601091,
                            "0.15": 0.0884375,
                            "0.25": 0.103949,
                            "0.35": 0.115505,
                            "0.45": 0.124938,
                            "0.55": 0.132423,
                            "0.65": 0.133797,
                            "0.75": 0.13029,
                            "0.85": 0.0845054,
                            "0.95": 0.0260463,
                        },
                    },
                    "4.25": {
                        "periodfrac": 0.0113538,
                        "P_bin": 0.89282,
                        "normed_bin_frac_p_dist": 0.1019,
                        "normed_tripquad_frac_p_dist": 0.09285,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.434447,
                            "0.95": 0.565553,
                        },
                        "e": {
                            "0.05": 0.0563761,
                            "0.15": 0.085828,
                            "0.25": 0.102429,
                            "0.35": 0.114957,
                            "0.45": 0.125274,
                            "0.55": 0.133513,
                            "0.65": 0.135029,
                            "0.75": 0.131961,
                            "0.85": 0.086745,
                            "0.95": 0.0278885,
                        },
                    },
                    "4.75": {
                        "periodfrac": 0.0111577,
                        "P_bin": 0.864737,
                        "normed_bin_frac_p_dist": 0.09698,
                        "normed_tripquad_frac_p_dist": 0.1152,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.437684,
                            "0.95": 0.562316,
                        },
                        "e": {
                            "0.05": 0.0537433,
                            "0.15": 0.0839551,
                            "0.25": 0.101361,
                            "0.35": 0.114626,
                            "0.45": 0.125623,
                            "0.55": 0.134449,
                            "0.65": 0.136076,
                            "0.75": 0.133203,
                            "0.85": 0.088098,
                            "0.95": 0.0288651,
                        },
                    },
                    "5.25": {
                        "periodfrac": 0.0104133,
                        "P_bin": 0.834686,
                        "normed_bin_frac_p_dist": 0.08737,
                        "normed_tripquad_frac_p_dist": 0.1314,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.441333,
                            "0.95": 0.558667,
                        },
                        "e": {
                            "0.05": 0.0517855,
                            "0.15": 0.0825411,
                            "0.25": 0.100565,
                            "0.35": 0.114409,
                            "0.45": 0.125945,
                            "0.55": 0.135239,
                            "0.65": 0.136956,
                            "0.75": 0.134167,
                            "0.85": 0.0889851,
                            "0.95": 0.0294067,
                        },
                    },
                    "5.75": {
                        "periodfrac": 0.00887353,
                        "P_bin": 0.802745,
                        "normed_bin_frac_p_dist": 0.0716,
                        "normed_tripquad_frac_p_dist": 0.1336,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.445437,
                            "0.95": 0.554563,
                        },
                        "e": {
                            "0.05": 0.0502699,
                            "0.15": 0.0814303,
                            "0.25": 0.099944,
                            "0.35": 0.114252,
                            "0.45": 0.126226,
                            "0.55": 0.135904,
                            "0.65": 0.137694,
                            "0.75": 0.134937,
                            "0.85": 0.0896122,
                            "0.95": 0.0297304,
                        },
                    },
                    "6.25": {
                        "periodfrac": 0.00688391,
                        "P_bin": 0.76896,
                        "normed_bin_frac_p_dist": 0.05321,
                        "normed_tripquad_frac_p_dist": 0.1214,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.450046,
                            "0.95": 0.549954,
                        },
                        "e": {
                            "0.05": 0.0490604,
                            "0.15": 0.0805314,
                            "0.25": 0.0994411,
                            "0.35": 0.114131,
                            "0.45": 0.126467,
                            "0.55": 0.136463,
                            "0.65": 0.138314,
                            "0.75": 0.135567,
                            "0.85": 0.0900846,
                            "0.95": 0.0299411,
                        },
                    },
                    "6.75": {
                        "periodfrac": 0.00509626,
                        "P_bin": 0.733351,
                        "normed_bin_frac_p_dist": 0.03757,
                        "normed_tripquad_frac_p_dist": 0.1037,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.455221,
                            "0.95": 0.544779,
                        },
                        "e": {
                            "0.05": 0.0480717,
                            "0.15": 0.0797869,
                            "0.25": 0.0990233,
                            "0.35": 0.114031,
                            "0.45": 0.126672,
                            "0.55": 0.136936,
                            "0.65": 0.138838,
                            "0.75": 0.136092,
                            "0.85": 0.0904586,
                            "0.95": 0.0300905,
                        },
                    },
                    "7.25": {
                        "periodfrac": 0.00367211,
                        "P_bin": 0.69591,
                        "normed_bin_frac_p_dist": 0.02569,
                        "normed_tripquad_frac_p_dist": 0.0852,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.461031,
                            "0.95": 0.538969,
                        },
                        "e": {
                            "0.05": 0.0472479,
                            "0.15": 0.0791591,
                            "0.25": 0.0986693,
                            "0.35": 0.113946,
                            "0.45": 0.126846,
                            "0.55": 0.13734,
                            "0.65": 0.139286,
                            "0.75": 0.136535,
                            "0.85": 0.0907653,
                            "0.95": 0.0302046,
                        },
                    },
                    "7.75": {
                        "periodfrac": 0.00261088,
                        "P_bin": 0.656608,
                        "normed_bin_frac_p_dist": 0.01723,
                        "normed_tripquad_frac_p_dist": 0.06841,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.469083,
                            "0.95": 0.530917,
                        },
                        "e": {
                            "0.05": 0.0465507,
                            "0.15": 0.0786221,
                            "0.25": 0.0983648,
                            "0.35": 0.113873,
                            "0.45": 0.126996,
                            "0.55": 0.137687,
                            "0.65": 0.139672,
                            "0.75": 0.136916,
                            "0.85": 0.0910235,
                            "0.95": 0.0302959,
                        },
                    },
                },
            },
            "-0.9": {
                "f_multi": 0.1638,
                "multi system fraction": 0.1433,
                "binary star fraction": 0.1331,
                "triple/quad star fraction": 0.0102,
                "single star fraction": 0.8567,
                "poisson_model": {
                    "single_fraction": 0.849,
                    "binary_fraction": 0.139,
                    "triple_fraction": 0.0114,
                    "quadruple_fraction": 0.000622,
                },
                "logP": {
                    "0.25": {
                        "periodfrac": 0.00368278,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.02569,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0977401,
                            "0.75": 0.179682,
                            "0.85": 0.305711,
                            "0.95": 0.416867,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "0.75": {
                        "periodfrac": 0.00458848,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.03201,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0977401,
                            "0.75": 0.179682,
                            "0.85": 0.305711,
                            "0.95": 0.416867,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.25": {
                        "periodfrac": 0.00589663,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.04114,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0977401,
                            "0.75": 0.179682,
                            "0.85": 0.305711,
                            "0.95": 0.416867,
                        },
                        "e": {
                            "0.05": 0.330824,
                            "0.15": 0.165642,
                            "0.25": 0.129153,
                            "0.35": 0.110009,
                            "0.45": 0.100964,
                            "0.55": 0.0990032,
                            "0.65": 0.057533,
                            "0.75": 0.00687094,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.75": {
                        "periodfrac": 0.00759622,
                        "P_bin": 0.995252,
                        "normed_bin_frac_p_dist": 0.05275,
                        "normed_tripquad_frac_p_dist": 0.001764,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0978791,
                            "0.75": 0.179939,
                            "0.85": 0.305722,
                            "0.95": 0.416461,
                        },
                        "e": {
                            "0.05": 0.14167,
                            "0.15": 0.131895,
                            "0.25": 0.12826,
                            "0.35": 0.125956,
                            "0.45": 0.12427,
                            "0.55": 0.123559,
                            "0.65": 0.12234,
                            "0.75": 0.0809714,
                            "0.85": 0.0210788,
                            "0.95": 0.0,
                        },
                    },
                    "2.25": {
                        "periodfrac": 0.00966255,
                        "P_bin": 0.981186,
                        "normed_bin_frac_p_dist": 0.06615,
                        "normed_tripquad_frac_p_dist": 0.00889,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.098796,
                            "0.75": 0.181624,
                            "0.85": 0.305795,
                            "0.95": 0.413785,
                        },
                        "e": {
                            "0.05": 0.0944499,
                            "0.15": 0.110031,
                            "0.25": 0.117032,
                            "0.35": 0.121823,
                            "0.45": 0.125515,
                            "0.55": 0.127863,
                            "0.65": 0.127994,
                            "0.75": 0.112768,
                            "0.85": 0.0563073,
                            "0.95": 0.00621564,
                        },
                    },
                    "2.75": {
                        "periodfrac": 0.0119747,
                        "P_bin": 0.962726,
                        "normed_bin_frac_p_dist": 0.08043,
                        "normed_tripquad_frac_p_dist": 0.02183,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0998574,
                            "0.75": 0.183575,
                            "0.85": 0.30588,
                            "0.95": 0.410687,
                        },
                        "e": {
                            "0.05": 0.0754871,
                            "0.15": 0.0987081,
                            "0.25": 0.110213,
                            "0.35": 0.118419,
                            "0.45": 0.12492,
                            "0.55": 0.129746,
                            "0.65": 0.13039,
                            "0.75": 0.123258,
                            "0.85": 0.0725423,
                            "0.95": 0.0163158,
                        },
                    },
                    "3.25": {
                        "periodfrac": 0.0139985,
                        "P_bin": 0.941088,
                        "normed_bin_frac_p_dist": 0.09191,
                        "normed_tripquad_frac_p_dist": 0.04033,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.101072,
                            "0.75": 0.185808,
                            "0.85": 0.305978,
                            "0.95": 0.407142,
                        },
                        "e": {
                            "0.05": 0.0657833,
                            "0.15": 0.0922986,
                            "0.25": 0.106244,
                            "0.35": 0.116451,
                            "0.45": 0.124683,
                            "0.55": 0.131158,
                            "0.65": 0.132341,
                            "0.75": 0.127869,
                            "0.85": 0.0804725,
                            "0.95": 0.0226993,
                        },
                    },
                    "3.75": {
                        "periodfrac": 0.0153772,
                        "P_bin": 0.916817,
                        "normed_bin_frac_p_dist": 0.09836,
                        "normed_tripquad_frac_p_dist": 0.06255,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.102447,
                            "0.75": 0.188336,
                            "0.85": 0.306088,
                            "0.95": 0.403129,
                        },
                        "e": {
                            "0.05": 0.0601091,
                            "0.15": 0.0884375,
                            "0.25": 0.103949,
                            "0.35": 0.115505,
                            "0.45": 0.124938,
                            "0.55": 0.132423,
                            "0.65": 0.133797,
                            "0.75": 0.13029,
                            "0.85": 0.0845054,
                            "0.95": 0.0260463,
                        },
                    },
                    "4.25": {
                        "periodfrac": 0.0160598,
                        "P_bin": 0.890228,
                        "normed_bin_frac_p_dist": 0.09975,
                        "normed_tripquad_frac_p_dist": 0.08621,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.103992,
                            "0.75": 0.191176,
                            "0.85": 0.306212,
                            "0.95": 0.39862,
                        },
                        "e": {
                            "0.05": 0.0563761,
                            "0.15": 0.085828,
                            "0.25": 0.102429,
                            "0.35": 0.114957,
                            "0.45": 0.125274,
                            "0.55": 0.133513,
                            "0.65": 0.135029,
                            "0.75": 0.131961,
                            "0.85": 0.086745,
                            "0.95": 0.0278885,
                        },
                    },
                    "4.75": {
                        "periodfrac": 0.0160902,
                        "P_bin": 0.861521,
                        "normed_bin_frac_p_dist": 0.09672,
                        "normed_tripquad_frac_p_dist": 0.109,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.105717,
                            "0.75": 0.194347,
                            "0.85": 0.30635,
                            "0.95": 0.393585,
                        },
                        "e": {
                            "0.05": 0.0537433,
                            "0.15": 0.0839551,
                            "0.25": 0.101361,
                            "0.35": 0.114626,
                            "0.45": 0.125623,
                            "0.55": 0.134449,
                            "0.65": 0.136076,
                            "0.75": 0.133203,
                            "0.85": 0.088098,
                            "0.95": 0.0288651,
                        },
                    },
                    "5.25": {
                        "periodfrac": 0.0154216,
                        "P_bin": 0.830827,
                        "normed_bin_frac_p_dist": 0.08939,
                        "normed_tripquad_frac_p_dist": 0.1276,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.107633,
                            "0.75": 0.19787,
                            "0.85": 0.306504,
                            "0.95": 0.387993,
                        },
                        "e": {
                            "0.05": 0.0517855,
                            "0.15": 0.0825411,
                            "0.25": 0.100565,
                            "0.35": 0.114409,
                            "0.45": 0.125945,
                            "0.55": 0.135239,
                            "0.65": 0.136956,
                            "0.75": 0.134167,
                            "0.85": 0.0889851,
                            "0.95": 0.0294067,
                        },
                    },
                    "5.75": {
                        "periodfrac": 0.0135192,
                        "P_bin": 0.798235,
                        "normed_bin_frac_p_dist": 0.07529,
                        "normed_tripquad_frac_p_dist": 0.1334,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.109753,
                            "0.75": 0.201768,
                            "0.85": 0.306674,
                            "0.95": 0.381805,
                        },
                        "e": {
                            "0.05": 0.0502699,
                            "0.15": 0.0814303,
                            "0.25": 0.099944,
                            "0.35": 0.114252,
                            "0.45": 0.126226,
                            "0.55": 0.135904,
                            "0.65": 0.137694,
                            "0.75": 0.134937,
                            "0.85": 0.0896122,
                            "0.95": 0.0297304,
                        },
                    },
                    "6.25": {
                        "periodfrac": 0.0107866,
                        "P_bin": 0.763798,
                        "normed_bin_frac_p_dist": 0.05748,
                        "normed_tripquad_frac_p_dist": 0.1246,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.112091,
                            "0.75": 0.206066,
                            "0.85": 0.306861,
                            "0.95": 0.374982,
                        },
                        "e": {
                            "0.05": 0.0490604,
                            "0.15": 0.0805314,
                            "0.25": 0.0994411,
                            "0.35": 0.114131,
                            "0.45": 0.126467,
                            "0.55": 0.136463,
                            "0.65": 0.138314,
                            "0.75": 0.135567,
                            "0.85": 0.0900846,
                            "0.95": 0.0299411,
                        },
                    },
                    "6.75": {
                        "periodfrac": 0.00829838,
                        "P_bin": 0.727542,
                        "normed_bin_frac_p_dist": 0.04212,
                        "normed_tripquad_frac_p_dist": 0.1106,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.114662,
                            "0.75": 0.210792,
                            "0.85": 0.307068,
                            "0.95": 0.367479,
                        },
                        "e": {
                            "0.05": 0.0480717,
                            "0.15": 0.0797869,
                            "0.25": 0.0990233,
                            "0.35": 0.114031,
                            "0.45": 0.126672,
                            "0.55": 0.136936,
                            "0.65": 0.138838,
                            "0.75": 0.136092,
                            "0.85": 0.0904586,
                            "0.95": 0.0300905,
                        },
                    },
                    "7.25": {
                        "periodfrac": 0.00622618,
                        "P_bin": 0.689471,
                        "normed_bin_frac_p_dist": 0.02995,
                        "normed_tripquad_frac_p_dist": 0.09455,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.117484,
                            "0.75": 0.215979,
                            "0.85": 0.307294,
                            "0.95": 0.359243,
                        },
                        "e": {
                            "0.05": 0.0472479,
                            "0.15": 0.0791591,
                            "0.25": 0.0986693,
                            "0.35": 0.113946,
                            "0.45": 0.126846,
                            "0.55": 0.13734,
                            "0.65": 0.139286,
                            "0.75": 0.136535,
                            "0.85": 0.0907653,
                            "0.95": 0.0302046,
                        },
                    },
                    "7.75": {
                        "periodfrac": 0.0045977,
                        "P_bin": 0.649563,
                        "normed_bin_frac_p_dist": 0.02084,
                        "normed_tripquad_frac_p_dist": 0.07879,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.121286,
                            "0.75": 0.222969,
                            "0.85": 0.307599,
                            "0.95": 0.348146,
                        },
                        "e": {
                            "0.05": 0.0465507,
                            "0.15": 0.0786221,
                            "0.25": 0.0983648,
                            "0.35": 0.113873,
                            "0.45": 0.126996,
                            "0.55": 0.137687,
                            "0.65": 0.139672,
                            "0.75": 0.136916,
                            "0.85": 0.0910235,
                            "0.95": 0.0302959,
                        },
                    },
                },
            },
            "-0.8": {
                "f_multi": 0.2126,
                "multi system fraction": 0.1847,
                "binary star fraction": 0.1707,
                "triple/quad star fraction": 0.014,
                "single star fraction": 0.8153,
                "poisson_model": {
                    "single_fraction": 0.809,
                    "binary_fraction": 0.172,
                    "triple_fraction": 0.0183,
                    "quadruple_fraction": 0.00129,
                },
                "logP": {
                    "0.25": {
                        "periodfrac": 0.0046835,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.02536,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.111739,
                            "0.65": 0.137656,
                            "0.75": 0.149481,
                            "0.85": 0.254326,
                            "0.95": 0.346798,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "0.75": {
                        "periodfrac": 0.00581462,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.03149,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.111739,
                            "0.65": 0.137656,
                            "0.75": 0.149481,
                            "0.85": 0.254326,
                            "0.95": 0.346798,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.25": {
                        "periodfrac": 0.00743267,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.04025,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.111739,
                            "0.65": 0.137656,
                            "0.75": 0.149481,
                            "0.85": 0.254326,
                            "0.95": 0.346798,
                        },
                        "e": {
                            "0.05": 0.330824,
                            "0.15": 0.165642,
                            "0.25": 0.129153,
                            "0.35": 0.110009,
                            "0.45": 0.100964,
                            "0.55": 0.0990032,
                            "0.65": 0.057533,
                            "0.75": 0.00687094,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.75": {
                        "periodfrac": 0.00954036,
                        "P_bin": 0.995134,
                        "normed_bin_frac_p_dist": 0.05141,
                        "normed_tripquad_frac_p_dist": 0.001662,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.111871,
                            "0.65": 0.137819,
                            "0.75": 0.149658,
                            "0.85": 0.254274,
                            "0.95": 0.346378,
                        },
                        "e": {
                            "0.05": 0.14167,
                            "0.15": 0.131895,
                            "0.25": 0.12826,
                            "0.35": 0.125956,
                            "0.45": 0.12427,
                            "0.55": 0.123559,
                            "0.65": 0.12234,
                            "0.75": 0.0809714,
                            "0.85": 0.0210788,
                            "0.95": 0.0,
                        },
                    },
                    "2.25": {
                        "periodfrac": 0.0121165,
                        "P_bin": 0.98072,
                        "normed_bin_frac_p_dist": 0.06435,
                        "normed_tripquad_frac_p_dist": 0.008363,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.112741,
                            "0.65": 0.138891,
                            "0.75": 0.150822,
                            "0.85": 0.253935,
                            "0.95": 0.343611,
                        },
                        "e": {
                            "0.05": 0.0944499,
                            "0.15": 0.110031,
                            "0.25": 0.117032,
                            "0.35": 0.121823,
                            "0.45": 0.125515,
                            "0.55": 0.127863,
                            "0.65": 0.127994,
                            "0.75": 0.112768,
                            "0.85": 0.0563073,
                            "0.95": 0.00621564,
                        },
                    },
                    "2.75": {
                        "periodfrac": 0.0150299,
                        "P_bin": 0.961812,
                        "normed_bin_frac_p_dist": 0.07828,
                        "normed_tripquad_frac_p_dist": 0.02055,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.113746,
                            "0.65": 0.140128,
                            "0.75": 0.152165,
                            "0.85": 0.253544,
                            "0.95": 0.340418,
                        },
                        "e": {
                            "0.05": 0.0754871,
                            "0.15": 0.0987081,
                            "0.25": 0.110213,
                            "0.35": 0.118419,
                            "0.45": 0.12492,
                            "0.55": 0.129746,
                            "0.65": 0.13039,
                            "0.75": 0.123258,
                            "0.85": 0.0725423,
                            "0.95": 0.0163158,
                        },
                    },
                    "3.25": {
                        "periodfrac": 0.0176176,
                        "P_bin": 0.93966,
                        "normed_bin_frac_p_dist": 0.08965,
                        "normed_tripquad_frac_p_dist": 0.03806,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.11489,
                            "0.65": 0.141538,
                            "0.75": 0.153696,
                            "0.85": 0.253098,
                            "0.95": 0.336779,
                        },
                        "e": {
                            "0.05": 0.0657833,
                            "0.15": 0.0922986,
                            "0.25": 0.106244,
                            "0.35": 0.116451,
                            "0.45": 0.124683,
                            "0.55": 0.131158,
                            "0.65": 0.132341,
                            "0.75": 0.127869,
                            "0.85": 0.0804725,
                            "0.95": 0.0226993,
                        },
                    },
                    "3.75": {
                        "periodfrac": 0.0194364,
                        "P_bin": 0.914829,
                        "normed_bin_frac_p_dist": 0.09629,
                        "normed_tripquad_frac_p_dist": 0.05927,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.11618,
                            "0.65": 0.143127,
                            "0.75": 0.155422,
                            "0.85": 0.252595,
                            "0.95": 0.332677,
                        },
                        "e": {
                            "0.05": 0.0601091,
                            "0.15": 0.0884375,
                            "0.25": 0.103949,
                            "0.35": 0.115505,
                            "0.45": 0.124938,
                            "0.55": 0.132423,
                            "0.65": 0.133797,
                            "0.75": 0.13029,
                            "0.85": 0.0845054,
                            "0.95": 0.0260463,
                        },
                    },
                    "4.25": {
                        "periodfrac": 0.0204304,
                        "P_bin": 0.887644,
                        "normed_bin_frac_p_dist": 0.0982,
                        "normed_tripquad_frac_p_dist": 0.08218,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.117622,
                            "0.65": 0.144903,
                            "0.75": 0.157351,
                            "0.85": 0.252033,
                            "0.95": 0.328091,
                        },
                        "e": {
                            "0.05": 0.0563761,
                            "0.15": 0.085828,
                            "0.25": 0.102429,
                            "0.35": 0.114957,
                            "0.45": 0.125274,
                            "0.55": 0.133513,
                            "0.65": 0.135029,
                            "0.75": 0.131961,
                            "0.85": 0.086745,
                            "0.95": 0.0278885,
                        },
                    },
                    "4.75": {
                        "periodfrac": 0.0206719,
                        "P_bin": 0.858317,
                        "normed_bin_frac_p_dist": 0.09608,
                        "normed_tripquad_frac_p_dist": 0.1049,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.119223,
                            "0.65": 0.146876,
                            "0.75": 0.159493,
                            "0.85": 0.251409,
                            "0.95": 0.322999,
                        },
                        "e": {
                            "0.05": 0.0537433,
                            "0.15": 0.0839551,
                            "0.25": 0.101361,
                            "0.35": 0.114626,
                            "0.45": 0.125623,
                            "0.55": 0.134449,
                            "0.65": 0.136076,
                            "0.75": 0.133203,
                            "0.85": 0.088098,
                            "0.95": 0.0288651,
                        },
                    },
                    "5.25": {
                        "periodfrac": 0.0201144,
                        "P_bin": 0.826987,
                        "normed_bin_frac_p_dist": 0.09008,
                        "normed_tripquad_frac_p_dist": 0.1246,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.120991,
                            "0.65": 0.149054,
                            "0.75": 0.161858,
                            "0.85": 0.25072,
                            "0.95": 0.317378,
                        },
                        "e": {
                            "0.05": 0.0517855,
                            "0.15": 0.0825411,
                            "0.25": 0.100565,
                            "0.35": 0.114409,
                            "0.45": 0.125945,
                            "0.55": 0.135239,
                            "0.65": 0.136956,
                            "0.75": 0.134167,
                            "0.85": 0.0889851,
                            "0.95": 0.0294067,
                        },
                    },
                    "5.75": {
                        "periodfrac": 0.017969,
                        "P_bin": 0.793751,
                        "normed_bin_frac_p_dist": 0.07724,
                        "normed_tripquad_frac_p_dist": 0.1327,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.122933,
                            "0.65": 0.151447,
                            "0.75": 0.164456,
                            "0.85": 0.249963,
                            "0.95": 0.3112,
                        },
                        "e": {
                            "0.05": 0.0502699,
                            "0.15": 0.0814303,
                            "0.25": 0.099944,
                            "0.35": 0.114252,
                            "0.45": 0.126226,
                            "0.55": 0.135904,
                            "0.65": 0.137694,
                            "0.75": 0.134937,
                            "0.85": 0.0896122,
                            "0.95": 0.0297304,
                        },
                    },
                    "6.25": {
                        "periodfrac": 0.0146226,
                        "P_bin": 0.75867,
                        "normed_bin_frac_p_dist": 0.06007,
                        "normed_tripquad_frac_p_dist": 0.1263,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.125059,
                            "0.65": 0.154066,
                            "0.75": 0.1673,
                            "0.85": 0.249134,
                            "0.95": 0.30444,
                        },
                        "e": {
                            "0.05": 0.0490604,
                            "0.15": 0.0805314,
                            "0.25": 0.0994411,
                            "0.35": 0.114131,
                            "0.45": 0.126467,
                            "0.55": 0.136463,
                            "0.65": 0.138314,
                            "0.75": 0.135567,
                            "0.85": 0.0900846,
                            "0.95": 0.0299411,
                        },
                    },
                    "6.75": {
                        "periodfrac": 0.0115294,
                        "P_bin": 0.721779,
                        "normed_bin_frac_p_dist": 0.04506,
                        "normed_tripquad_frac_p_dist": 0.1148,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.127378,
                            "0.65": 0.156922,
                            "0.75": 0.170402,
                            "0.85": 0.248231,
                            "0.95": 0.297067,
                        },
                        "e": {
                            "0.05": 0.0480717,
                            "0.15": 0.0797869,
                            "0.25": 0.0990233,
                            "0.35": 0.114031,
                            "0.45": 0.126672,
                            "0.55": 0.136936,
                            "0.65": 0.138838,
                            "0.75": 0.136092,
                            "0.85": 0.0904586,
                            "0.95": 0.0300905,
                        },
                    },
                    "7.25": {
                        "periodfrac": 0.00887396,
                        "P_bin": 0.683091,
                        "normed_bin_frac_p_dist": 0.03283,
                        "normed_tripquad_frac_p_dist": 0.1007,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.1299,
                            "0.65": 0.160029,
                            "0.75": 0.173776,
                            "0.85": 0.247248,
                            "0.95": 0.289046,
                        },
                        "e": {
                            "0.05": 0.0472479,
                            "0.15": 0.0791591,
                            "0.25": 0.0986693,
                            "0.35": 0.113946,
                            "0.45": 0.126846,
                            "0.55": 0.13734,
                            "0.65": 0.139286,
                            "0.75": 0.136535,
                            "0.85": 0.0907653,
                            "0.95": 0.0302046,
                        },
                    },
                    "7.75": {
                        "periodfrac": 0.00671586,
                        "P_bin": 0.642594,
                        "normed_bin_frac_p_dist": 0.02337,
                        "normed_tripquad_frac_p_dist": 0.08593,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.133261,
                            "0.65": 0.164171,
                            "0.75": 0.178273,
                            "0.85": 0.245938,
                            "0.95": 0.278357,
                        },
                        "e": {
                            "0.05": 0.0465507,
                            "0.15": 0.0786221,
                            "0.25": 0.0983648,
                            "0.35": 0.113873,
                            "0.45": 0.126996,
                            "0.55": 0.137687,
                            "0.65": 0.139672,
                            "0.75": 0.136916,
                            "0.85": 0.0910235,
                            "0.95": 0.0302959,
                        },
                    },
                },
            },
            "-0.7": {
                "f_multi": 0.2539,
                "multi system fraction": 0.219,
                "binary star fraction": 0.2015,
                "triple/quad star fraction": 0.0175,
                "single star fraction": 0.781,
                "poisson_model": {
                    "single_fraction": 0.776,
                    "binary_fraction": 0.197,
                    "triple_fraction": 0.025,
                    "quadruple_fraction": 0.00212,
                },
                "logP": {
                    "0.25": {
                        "periodfrac": 0.00555792,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.02538,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.088838,
                            "0.55": 0.112203,
                            "0.65": 0.123817,
                            "0.75": 0.134453,
                            "0.85": 0.228757,
                            "0.95": 0.311933,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "0.75": {
                        "periodfrac": 0.00686457,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.03135,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.088838,
                            "0.55": 0.112203,
                            "0.65": 0.123817,
                            "0.75": 0.134453,
                            "0.85": 0.228757,
                            "0.95": 0.311933,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.25": {
                        "periodfrac": 0.00870554,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.03975,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.088838,
                            "0.55": 0.112203,
                            "0.65": 0.123817,
                            "0.75": 0.134453,
                            "0.85": 0.228757,
                            "0.95": 0.311933,
                        },
                        "e": {
                            "0.05": 0.330824,
                            "0.15": 0.165642,
                            "0.25": 0.129153,
                            "0.35": 0.110009,
                            "0.45": 0.100964,
                            "0.55": 0.0990032,
                            "0.65": 0.057533,
                            "0.75": 0.00687094,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.75": {
                        "periodfrac": 0.0111054,
                        "P_bin": 0.995016,
                        "normed_bin_frac_p_dist": 0.05046,
                        "normed_tripquad_frac_p_dist": 0.001585,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0889327,
                            "0.55": 0.112322,
                            "0.65": 0.123948,
                            "0.75": 0.134596,
                            "0.85": 0.228683,
                            "0.95": 0.311517,
                        },
                        "e": {
                            "0.05": 0.14167,
                            "0.15": 0.131895,
                            "0.25": 0.12826,
                            "0.35": 0.125956,
                            "0.45": 0.12427,
                            "0.55": 0.123559,
                            "0.65": 0.12234,
                            "0.75": 0.0809714,
                            "0.85": 0.0210788,
                            "0.95": 0.0,
                        },
                    },
                    "2.25": {
                        "periodfrac": 0.0140525,
                        "P_bin": 0.980254,
                        "normed_bin_frac_p_dist": 0.0629,
                        "normed_tripquad_frac_p_dist": 0.007946,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0895542,
                            "0.55": 0.113107,
                            "0.65": 0.124815,
                            "0.75": 0.135537,
                            "0.85": 0.2282,
                            "0.95": 0.308787,
                        },
                        "e": {
                            "0.05": 0.0944499,
                            "0.15": 0.110031,
                            "0.25": 0.117032,
                            "0.35": 0.121823,
                            "0.45": 0.125515,
                            "0.55": 0.127863,
                            "0.65": 0.127994,
                            "0.75": 0.112768,
                            "0.85": 0.0563073,
                            "0.95": 0.00621564,
                        },
                    },
                    "2.75": {
                        "periodfrac": 0.0174192,
                        "P_bin": 0.960899,
                        "normed_bin_frac_p_dist": 0.07643,
                        "normed_tripquad_frac_p_dist": 0.0195,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0902705,
                            "0.55": 0.114012,
                            "0.65": 0.125813,
                            "0.75": 0.13662,
                            "0.85": 0.227642,
                            "0.95": 0.305642,
                        },
                        "e": {
                            "0.05": 0.0754871,
                            "0.15": 0.0987081,
                            "0.25": 0.110213,
                            "0.35": 0.118419,
                            "0.45": 0.12492,
                            "0.55": 0.129746,
                            "0.65": 0.13039,
                            "0.75": 0.123258,
                            "0.85": 0.0725423,
                            "0.95": 0.0163158,
                        },
                    },
                    "3.25": {
                        "periodfrac": 0.0204421,
                        "P_bin": 0.938235,
                        "normed_bin_frac_p_dist": 0.08758,
                        "normed_tripquad_frac_p_dist": 0.03616,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0910849,
                            "0.55": 0.115041,
                            "0.65": 0.126948,
                            "0.75": 0.137853,
                            "0.85": 0.227009,
                            "0.95": 0.302064,
                        },
                        "e": {
                            "0.05": 0.0657833,
                            "0.15": 0.0922986,
                            "0.25": 0.106244,
                            "0.35": 0.116451,
                            "0.45": 0.124683,
                            "0.55": 0.131158,
                            "0.65": 0.132341,
                            "0.75": 0.127869,
                            "0.85": 0.0804725,
                            "0.95": 0.0226993,
                        },
                    },
                    "3.75": {
                        "periodfrac": 0.0226164,
                        "P_bin": 0.912845,
                        "normed_bin_frac_p_dist": 0.09427,
                        "normed_tripquad_frac_p_dist": 0.05644,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0920011,
                            "0.55": 0.116198,
                            "0.65": 0.128225,
                            "0.75": 0.13924,
                            "0.85": 0.226296,
                            "0.95": 0.29804,
                        },
                        "e": {
                            "0.05": 0.0601091,
                            "0.15": 0.0884375,
                            "0.25": 0.103949,
                            "0.35": 0.115505,
                            "0.45": 0.124938,
                            "0.55": 0.132423,
                            "0.65": 0.133797,
                            "0.75": 0.13029,
                            "0.85": 0.0845054,
                            "0.95": 0.0260463,
                        },
                    },
                    "4.25": {
                        "periodfrac": 0.0238913,
                        "P_bin": 0.885068,
                        "normed_bin_frac_p_dist": 0.09655,
                        "normed_tripquad_frac_p_dist": 0.07863,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0930229,
                            "0.55": 0.117488,
                            "0.65": 0.129649,
                            "0.75": 0.140786,
                            "0.85": 0.225501,
                            "0.95": 0.293552,
                        },
                        "e": {
                            "0.05": 0.0563761,
                            "0.15": 0.085828,
                            "0.25": 0.102429,
                            "0.35": 0.114957,
                            "0.45": 0.125274,
                            "0.55": 0.133513,
                            "0.65": 0.135029,
                            "0.75": 0.131961,
                            "0.85": 0.086745,
                            "0.95": 0.0278885,
                        },
                    },
                    "4.75": {
                        "periodfrac": 0.0243655,
                        "P_bin": 0.855124,
                        "normed_bin_frac_p_dist": 0.09514,
                        "normed_tripquad_frac_p_dist": 0.1011,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0941542,
                            "0.55": 0.118917,
                            "0.65": 0.131226,
                            "0.75": 0.142498,
                            "0.85": 0.224621,
                            "0.95": 0.288583,
                        },
                        "e": {
                            "0.05": 0.0537433,
                            "0.15": 0.0839551,
                            "0.25": 0.101361,
                            "0.35": 0.114626,
                            "0.45": 0.125623,
                            "0.55": 0.134449,
                            "0.65": 0.136076,
                            "0.75": 0.133203,
                            "0.85": 0.088098,
                            "0.95": 0.0288651,
                        },
                    },
                    "5.25": {
                        "periodfrac": 0.0240221,
                        "P_bin": 0.823164,
                        "normed_bin_frac_p_dist": 0.09029,
                        "normed_tripquad_frac_p_dist": 0.1216,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0953996,
                            "0.55": 0.12049,
                            "0.65": 0.132962,
                            "0.75": 0.144383,
                            "0.85": 0.223652,
                            "0.95": 0.283113,
                        },
                        "e": {
                            "0.05": 0.0517855,
                            "0.15": 0.0825411,
                            "0.25": 0.100565,
                            "0.35": 0.114409,
                            "0.45": 0.125945,
                            "0.55": 0.135239,
                            "0.65": 0.136956,
                            "0.75": 0.134167,
                            "0.85": 0.0889851,
                            "0.95": 0.0294067,
                        },
                    },
                    "5.75": {
                        "periodfrac": 0.0218311,
                        "P_bin": 0.789291,
                        "normed_bin_frac_p_dist": 0.07868,
                        "normed_tripquad_frac_p_dist": 0.1317,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0967636,
                            "0.55": 0.122213,
                            "0.65": 0.134863,
                            "0.75": 0.146448,
                            "0.85": 0.222591,
                            "0.95": 0.277123,
                        },
                        "e": {
                            "0.05": 0.0502699,
                            "0.15": 0.0814303,
                            "0.25": 0.099944,
                            "0.35": 0.114252,
                            "0.45": 0.126226,
                            "0.55": 0.135904,
                            "0.65": 0.137694,
                            "0.75": 0.134937,
                            "0.85": 0.0896122,
                            "0.95": 0.0297304,
                        },
                    },
                    "6.25": {
                        "periodfrac": 0.0180863,
                        "P_bin": 0.753576,
                        "normed_bin_frac_p_dist": 0.06224,
                        "normed_tripquad_frac_p_dist": 0.1276,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0982509,
                            "0.55": 0.124091,
                            "0.65": 0.136936,
                            "0.75": 0.148699,
                            "0.85": 0.221434,
                            "0.95": 0.27059,
                        },
                        "e": {
                            "0.05": 0.0490604,
                            "0.15": 0.0805314,
                            "0.25": 0.0994411,
                            "0.35": 0.114131,
                            "0.45": 0.126467,
                            "0.55": 0.136463,
                            "0.65": 0.138314,
                            "0.75": 0.135567,
                            "0.85": 0.0900846,
                            "0.95": 0.0299411,
                        },
                    },
                    "6.75": {
                        "periodfrac": 0.0145753,
                        "P_bin": 0.716063,
                        "normed_bin_frac_p_dist": 0.04766,
                        "normed_tripquad_frac_p_dist": 0.1185,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0998666,
                            "0.55": 0.126132,
                            "0.65": 0.139188,
                            "0.75": 0.151144,
                            "0.85": 0.220177,
                            "0.95": 0.263493,
                        },
                        "e": {
                            "0.05": 0.0480717,
                            "0.15": 0.0797869,
                            "0.25": 0.0990233,
                            "0.35": 0.114031,
                            "0.45": 0.126672,
                            "0.55": 0.136936,
                            "0.65": 0.138838,
                            "0.75": 0.136092,
                            "0.85": 0.0904586,
                            "0.95": 0.0300905,
                        },
                    },
                    "7.25": {
                        "periodfrac": 0.0114844,
                        "P_bin": 0.676771,
                        "normed_bin_frac_p_dist": 0.03549,
                        "normed_tripquad_frac_p_dist": 0.1063,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.101617,
                            "0.55": 0.128342,
                            "0.65": 0.141627,
                            "0.75": 0.153793,
                            "0.85": 0.218815,
                            "0.95": 0.255807,
                        },
                        "e": {
                            "0.05": 0.0472479,
                            "0.15": 0.0791591,
                            "0.25": 0.0986693,
                            "0.35": 0.113946,
                            "0.45": 0.126846,
                            "0.55": 0.13734,
                            "0.65": 0.139286,
                            "0.75": 0.136535,
                            "0.85": 0.0907653,
                            "0.95": 0.0302046,
                        },
                    },
                    "7.75": {
                        "periodfrac": 0.00890084,
                        "P_bin": 0.6357,
                        "normed_bin_frac_p_dist": 0.02584,
                        "normed_tripquad_frac_p_dist": 0.09285,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.103937,
                            "0.55": 0.131272,
                            "0.65": 0.14486,
                            "0.75": 0.157304,
                            "0.85": 0.21701,
                            "0.95": 0.245616,
                        },
                        "e": {
                            "0.05": 0.0465507,
                            "0.15": 0.0786221,
                            "0.25": 0.0983648,
                            "0.35": 0.113873,
                            "0.45": 0.126996,
                            "0.55": 0.137687,
                            "0.65": 0.139672,
                            "0.75": 0.136916,
                            "0.85": 0.0910235,
                            "0.95": 0.0302959,
                        },
                    },
                },
            },
            "-0.6": {
                "f_multi": 0.2966,
                "multi system fraction": 0.254,
                "binary star fraction": 0.2327,
                "triple/quad star fraction": 0.0213,
                "single star fraction": 0.746,
                "poisson_model": {
                    "single_fraction": 0.744,
                    "binary_fraction": 0.221,
                    "triple_fraction": 0.0327,
                    "quadruple_fraction": 0.00323,
                },
                "logP": {
                    "0.25": {
                        "periodfrac": 0.00644011,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.02535,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0618404,
                            "0.45": 0.0921846,
                            "0.55": 0.104176,
                            "0.65": 0.114958,
                            "0.75": 0.124834,
                            "0.85": 0.212391,
                            "0.95": 0.289616,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "0.75": {
                        "periodfrac": 0.0079293,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.03122,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0618404,
                            "0.45": 0.0921846,
                            "0.55": 0.104176,
                            "0.65": 0.114958,
                            "0.75": 0.124834,
                            "0.85": 0.212391,
                            "0.95": 0.289616,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.25": {
                        "periodfrac": 0.0099862,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.03931,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0618404,
                            "0.45": 0.0921846,
                            "0.55": 0.104176,
                            "0.65": 0.114958,
                            "0.75": 0.124834,
                            "0.85": 0.212391,
                            "0.95": 0.289616,
                        },
                        "e": {
                            "0.05": 0.330824,
                            "0.15": 0.165642,
                            "0.25": 0.129153,
                            "0.35": 0.110009,
                            "0.45": 0.100964,
                            "0.55": 0.0990032,
                            "0.65": 0.057533,
                            "0.75": 0.00687094,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.75": {
                        "periodfrac": 0.0126679,
                        "P_bin": 0.994897,
                        "normed_bin_frac_p_dist": 0.04962,
                        "normed_tripquad_frac_p_dist": 0.001517,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0619016,
                            "0.45": 0.0922758,
                            "0.55": 0.104278,
                            "0.65": 0.115072,
                            "0.75": 0.124957,
                            "0.85": 0.212306,
                            "0.95": 0.289208,
                        },
                        "e": {
                            "0.05": 0.14167,
                            "0.15": 0.131895,
                            "0.25": 0.12826,
                            "0.35": 0.125956,
                            "0.45": 0.12427,
                            "0.55": 0.123559,
                            "0.65": 0.12234,
                            "0.75": 0.0809714,
                            "0.85": 0.0210788,
                            "0.95": 0.0,
                        },
                    },
                    "2.25": {
                        "periodfrac": 0.015974,
                        "P_bin": 0.979789,
                        "normed_bin_frac_p_dist": 0.06162,
                        "normed_tripquad_frac_p_dist": 0.007575,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.062303,
                            "0.45": 0.0928742,
                            "0.55": 0.104955,
                            "0.65": 0.115819,
                            "0.75": 0.125767,
                            "0.85": 0.211751,
                            "0.95": 0.286531,
                        },
                        "e": {
                            "0.05": 0.0944499,
                            "0.15": 0.110031,
                            "0.25": 0.117032,
                            "0.35": 0.121823,
                            "0.45": 0.125515,
                            "0.55": 0.127863,
                            "0.65": 0.127994,
                            "0.75": 0.112768,
                            "0.85": 0.0563073,
                            "0.95": 0.00621564,
                        },
                    },
                    "2.75": {
                        "periodfrac": 0.0197824,
                        "P_bin": 0.959987,
                        "normed_bin_frac_p_dist": 0.07476,
                        "normed_tripquad_frac_p_dist": 0.01857,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0627651,
                            "0.45": 0.0935631,
                            "0.55": 0.105733,
                            "0.65": 0.116677,
                            "0.75": 0.1267,
                            "0.85": 0.211113,
                            "0.95": 0.283448,
                        },
                        "e": {
                            "0.05": 0.0754871,
                            "0.15": 0.0987081,
                            "0.25": 0.110213,
                            "0.35": 0.118419,
                            "0.45": 0.12492,
                            "0.55": 0.129746,
                            "0.65": 0.13039,
                            "0.75": 0.123258,
                            "0.85": 0.0725423,
                            "0.95": 0.0163158,
                        },
                    },
                    "3.25": {
                        "periodfrac": 0.0232327,
                        "P_bin": 0.936812,
                        "normed_bin_frac_p_dist": 0.08568,
                        "normed_tripquad_frac_p_dist": 0.03444,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.06329,
                            "0.45": 0.0943454,
                            "0.55": 0.106617,
                            "0.65": 0.117653,
                            "0.75": 0.12776,
                            "0.85": 0.210387,
                            "0.95": 0.279947,
                        },
                        "e": {
                            "0.05": 0.0657833,
                            "0.15": 0.0922986,
                            "0.25": 0.106244,
                            "0.35": 0.116451,
                            "0.45": 0.124683,
                            "0.55": 0.131158,
                            "0.65": 0.132341,
                            "0.75": 0.127869,
                            "0.85": 0.0804725,
                            "0.95": 0.0226993,
                        },
                    },
                    "3.75": {
                        "periodfrac": 0.0257603,
                        "P_bin": 0.910865,
                        "normed_bin_frac_p_dist": 0.09238,
                        "normed_tripquad_frac_p_dist": 0.05387,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0638795,
                            "0.45": 0.0952243,
                            "0.55": 0.10761,
                            "0.65": 0.118749,
                            "0.75": 0.12895,
                            "0.85": 0.209572,
                            "0.95": 0.276015,
                        },
                        "e": {
                            "0.05": 0.0601091,
                            "0.15": 0.0884375,
                            "0.25": 0.103949,
                            "0.35": 0.115505,
                            "0.45": 0.124938,
                            "0.55": 0.132423,
                            "0.65": 0.133797,
                            "0.75": 0.13029,
                            "0.85": 0.0845054,
                            "0.95": 0.0260463,
                        },
                    },
                    "4.25": {
                        "periodfrac": 0.0273216,
                        "P_bin": 0.882499,
                        "normed_bin_frac_p_dist": 0.09492,
                        "normed_tripquad_frac_p_dist": 0.07532,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.064536,
                            "0.45": 0.0962029,
                            "0.55": 0.108716,
                            "0.65": 0.119969,
                            "0.75": 0.130275,
                            "0.85": 0.208665,
                            "0.95": 0.271635,
                        },
                        "e": {
                            "0.05": 0.0563761,
                            "0.15": 0.085828,
                            "0.25": 0.102429,
                            "0.35": 0.114957,
                            "0.45": 0.125274,
                            "0.55": 0.133513,
                            "0.65": 0.135029,
                            "0.75": 0.131961,
                            "0.85": 0.086745,
                            "0.95": 0.0278885,
                        },
                    },
                    "4.75": {
                        "periodfrac": 0.0280418,
                        "P_bin": 0.851943,
                        "normed_bin_frac_p_dist": 0.09405,
                        "normed_tripquad_frac_p_dist": 0.09741,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0652616,
                            "0.45": 0.0972846,
                            "0.55": 0.109939,
                            "0.65": 0.121318,
                            "0.75": 0.13174,
                            "0.85": 0.207662,
                            "0.95": 0.266795,
                        },
                        "e": {
                            "0.05": 0.0537433,
                            "0.15": 0.0839551,
                            "0.25": 0.101361,
                            "0.35": 0.114626,
                            "0.45": 0.125623,
                            "0.55": 0.134449,
                            "0.65": 0.136076,
                            "0.75": 0.133203,
                            "0.85": 0.088098,
                            "0.95": 0.0288651,
                        },
                    },
                    "5.25": {
                        "periodfrac": 0.0279726,
                        "P_bin": 0.819359,
                        "normed_bin_frac_p_dist": 0.09023,
                        "normed_tripquad_frac_p_dist": 0.1186,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0660589,
                            "0.45": 0.098473,
                            "0.55": 0.111282,
                            "0.65": 0.1228,
                            "0.75": 0.133349,
                            "0.85": 0.20656,
                            "0.95": 0.261477,
                        },
                        "e": {
                            "0.05": 0.0517855,
                            "0.15": 0.0825411,
                            "0.25": 0.100565,
                            "0.35": 0.114409,
                            "0.45": 0.125945,
                            "0.55": 0.135239,
                            "0.65": 0.136956,
                            "0.75": 0.134167,
                            "0.85": 0.0889851,
                            "0.95": 0.0294067,
                        },
                    },
                    "5.75": {
                        "periodfrac": 0.0258458,
                        "P_bin": 0.784857,
                        "normed_bin_frac_p_dist": 0.07986,
                        "normed_tripquad_frac_p_dist": 0.1305,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0669302,
                            "0.45": 0.0997719,
                            "0.55": 0.11275,
                            "0.65": 0.12442,
                            "0.75": 0.135108,
                            "0.85": 0.205356,
                            "0.95": 0.255665,
                        },
                        "e": {
                            "0.05": 0.0502699,
                            "0.15": 0.0814303,
                            "0.25": 0.099944,
                            "0.35": 0.114252,
                            "0.45": 0.126226,
                            "0.55": 0.135904,
                            "0.65": 0.137694,
                            "0.75": 0.134937,
                            "0.85": 0.0896122,
                            "0.95": 0.0297304,
                        },
                    },
                    "6.25": {
                        "periodfrac": 0.0217923,
                        "P_bin": 0.748517,
                        "normed_bin_frac_p_dist": 0.06422,
                        "normed_tripquad_frac_p_dist": 0.1286,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0678781,
                            "0.45": 0.101185,
                            "0.55": 0.114346,
                            "0.65": 0.126182,
                            "0.75": 0.137022,
                            "0.85": 0.204045,
                            "0.95": 0.249342,
                        },
                        "e": {
                            "0.05": 0.0490604,
                            "0.15": 0.0805314,
                            "0.25": 0.0994411,
                            "0.35": 0.114131,
                            "0.45": 0.126467,
                            "0.55": 0.136463,
                            "0.65": 0.138314,
                            "0.75": 0.135567,
                            "0.85": 0.0900846,
                            "0.95": 0.0299411,
                        },
                    },
                    "6.75": {
                        "periodfrac": 0.0179368,
                        "P_bin": 0.710391,
                        "normed_bin_frac_p_dist": 0.05016,
                        "normed_tripquad_frac_p_dist": 0.1219,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0689055,
                            "0.45": 0.102716,
                            "0.55": 0.116077,
                            "0.65": 0.128092,
                            "0.75": 0.139095,
                            "0.85": 0.202625,
                            "0.95": 0.242489,
                        },
                        "e": {
                            "0.05": 0.0480717,
                            "0.15": 0.0797869,
                            "0.25": 0.0990233,
                            "0.35": 0.114031,
                            "0.45": 0.126672,
                            "0.55": 0.136936,
                            "0.65": 0.138838,
                            "0.75": 0.136092,
                            "0.85": 0.0904586,
                            "0.95": 0.0300905,
                        },
                    },
                    "7.25": {
                        "periodfrac": 0.0144622,
                        "P_bin": 0.670509,
                        "normed_bin_frac_p_dist": 0.03818,
                        "normed_tripquad_frac_p_dist": 0.1118,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0700151,
                            "0.45": 0.104371,
                            "0.55": 0.117946,
                            "0.65": 0.130155,
                            "0.75": 0.141336,
                            "0.85": 0.201091,
                            "0.95": 0.235086,
                        },
                        "e": {
                            "0.05": 0.0472479,
                            "0.15": 0.0791591,
                            "0.25": 0.0986693,
                            "0.35": 0.113946,
                            "0.45": 0.126846,
                            "0.55": 0.13734,
                            "0.65": 0.139286,
                            "0.75": 0.136535,
                            "0.85": 0.0907653,
                            "0.95": 0.0302046,
                        },
                    },
                    "7.75": {
                        "periodfrac": 0.0114827,
                        "P_bin": 0.62888,
                        "normed_bin_frac_p_dist": 0.02843,
                        "normed_tripquad_frac_p_dist": 0.09999,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0714815,
                            "0.45": 0.106556,
                            "0.55": 0.120417,
                            "0.65": 0.132881,
                            "0.75": 0.144296,
                            "0.85": 0.199064,
                            "0.95": 0.225305,
                        },
                        "e": {
                            "0.05": 0.0465507,
                            "0.15": 0.0786221,
                            "0.25": 0.0983648,
                            "0.35": 0.113873,
                            "0.45": 0.126996,
                            "0.55": 0.137687,
                            "0.65": 0.139672,
                            "0.75": 0.136916,
                            "0.85": 0.0910235,
                            "0.95": 0.0302959,
                        },
                    },
                },
            },
            "-0.5": {
                "f_multi": 0.3331,
                "multi system fraction": 0.2835,
                "binary star fraction": 0.2587,
                "triple/quad star fraction": 0.0248,
                "single star fraction": 0.7165,
                "poisson_model": {
                    "single_fraction": 0.717,
                    "binary_fraction": 0.239,
                    "triple_fraction": 0.0398,
                    "quadruple_fraction": 0.00442,
                },
                "logP": {
                    "0.25": {
                        "periodfrac": 0.00717451,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.02531,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0212556,
                            "0.35": 0.0755523,
                            "0.45": 0.0887487,
                            "0.55": 0.100293,
                            "0.65": 0.110674,
                            "0.75": 0.120181,
                            "0.85": 0.204475,
                            "0.95": 0.278822,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "0.75": {
                        "periodfrac": 0.00885455,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.03123,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0212556,
                            "0.35": 0.0755523,
                            "0.45": 0.0887487,
                            "0.55": 0.100293,
                            "0.65": 0.110674,
                            "0.75": 0.120181,
                            "0.85": 0.204475,
                            "0.95": 0.278822,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.25": {
                        "periodfrac": 0.0111089,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.03919,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0212556,
                            "0.35": 0.0755523,
                            "0.45": 0.0887487,
                            "0.55": 0.100293,
                            "0.65": 0.110674,
                            "0.75": 0.120181,
                            "0.85": 0.204475,
                            "0.95": 0.278822,
                        },
                        "e": {
                            "0.05": 0.330824,
                            "0.15": 0.165642,
                            "0.25": 0.129153,
                            "0.35": 0.110009,
                            "0.45": 0.100964,
                            "0.55": 0.0990032,
                            "0.65": 0.057533,
                            "0.75": 0.00687094,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.75": {
                        "periodfrac": 0.0140363,
                        "P_bin": 0.994779,
                        "normed_bin_frac_p_dist": 0.04925,
                        "normed_tripquad_frac_p_dist": 0.001478,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0212759,
                            "0.35": 0.0756242,
                            "0.45": 0.0888332,
                            "0.55": 0.100388,
                            "0.65": 0.110779,
                            "0.75": 0.120295,
                            "0.85": 0.204386,
                            "0.95": 0.278419,
                        },
                        "e": {
                            "0.05": 0.14167,
                            "0.15": 0.131895,
                            "0.25": 0.12826,
                            "0.35": 0.125956,
                            "0.45": 0.12427,
                            "0.55": 0.123559,
                            "0.65": 0.12234,
                            "0.75": 0.0809714,
                            "0.85": 0.0210788,
                            "0.95": 0.0,
                        },
                    },
                    "2.25": {
                        "periodfrac": 0.0176421,
                        "P_bin": 0.979324,
                        "normed_bin_frac_p_dist": 0.06095,
                        "normed_tripquad_frac_p_dist": 0.007358,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0214087,
                            "0.35": 0.0760963,
                            "0.45": 0.0893876,
                            "0.55": 0.101015,
                            "0.65": 0.111471,
                            "0.75": 0.121046,
                            "0.85": 0.203802,
                            "0.95": 0.275774,
                        },
                        "e": {
                            "0.05": 0.0944499,
                            "0.15": 0.110031,
                            "0.25": 0.117032,
                            "0.35": 0.121823,
                            "0.45": 0.125515,
                            "0.55": 0.127863,
                            "0.65": 0.127994,
                            "0.75": 0.112768,
                            "0.85": 0.0563073,
                            "0.95": 0.00621564,
                        },
                    },
                    "2.75": {
                        "periodfrac": 0.0218066,
                        "P_bin": 0.959076,
                        "normed_bin_frac_p_dist": 0.07377,
                        "normed_tripquad_frac_p_dist": 0.018,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0215615,
                            "0.35": 0.0766394,
                            "0.45": 0.0900256,
                            "0.55": 0.101736,
                            "0.65": 0.112266,
                            "0.75": 0.12191,
                            "0.85": 0.203131,
                            "0.95": 0.272732,
                        },
                        "e": {
                            "0.05": 0.0754871,
                            "0.15": 0.0987081,
                            "0.25": 0.110213,
                            "0.35": 0.118419,
                            "0.45": 0.12492,
                            "0.55": 0.129746,
                            "0.65": 0.13039,
                            "0.75": 0.123258,
                            "0.85": 0.0725423,
                            "0.95": 0.0163158,
                        },
                    },
                    "3.25": {
                        "periodfrac": 0.0255986,
                        "P_bin": 0.935391,
                        "normed_bin_frac_p_dist": 0.08446,
                        "normed_tripquad_frac_p_dist": 0.03336,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0217349,
                            "0.35": 0.0772557,
                            "0.45": 0.0907496,
                            "0.55": 0.102554,
                            "0.65": 0.113169,
                            "0.75": 0.12289,
                            "0.85": 0.202369,
                            "0.95": 0.269278,
                        },
                        "e": {
                            "0.05": 0.0657833,
                            "0.15": 0.0922986,
                            "0.25": 0.106244,
                            "0.35": 0.116451,
                            "0.45": 0.124683,
                            "0.55": 0.131158,
                            "0.65": 0.132341,
                            "0.75": 0.127869,
                            "0.85": 0.0804725,
                            "0.95": 0.0226993,
                        },
                    },
                    "3.75": {
                        "periodfrac": 0.0284096,
                        "P_bin": 0.908889,
                        "normed_bin_frac_p_dist": 0.09108,
                        "normed_tripquad_frac_p_dist": 0.05221,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0219296,
                            "0.35": 0.0779477,
                            "0.45": 0.0915625,
                            "0.55": 0.103472,
                            "0.65": 0.114183,
                            "0.75": 0.123991,
                            "0.85": 0.201513,
                            "0.95": 0.265401,
                        },
                        "e": {
                            "0.05": 0.0601091,
                            "0.15": 0.0884375,
                            "0.25": 0.103949,
                            "0.35": 0.115505,
                            "0.45": 0.124938,
                            "0.55": 0.132423,
                            "0.65": 0.133797,
                            "0.75": 0.13029,
                            "0.85": 0.0845054,
                            "0.95": 0.0260463,
                        },
                    },
                    "4.25": {
                        "periodfrac": 0.030199,
                        "P_bin": 0.879937,
                        "normed_bin_frac_p_dist": 0.09374,
                        "normed_tripquad_frac_p_dist": 0.07313,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0221462,
                            "0.35": 0.0787177,
                            "0.45": 0.0924669,
                            "0.55": 0.104495,
                            "0.65": 0.11531,
                            "0.75": 0.125216,
                            "0.85": 0.200562,
                            "0.95": 0.261087,
                        },
                        "e": {
                            "0.05": 0.0563761,
                            "0.15": 0.085828,
                            "0.25": 0.102429,
                            "0.35": 0.114957,
                            "0.45": 0.125274,
                            "0.55": 0.133513,
                            "0.65": 0.135029,
                            "0.75": 0.131961,
                            "0.85": 0.086745,
                            "0.95": 0.0278885,
                        },
                    },
                    "4.75": {
                        "periodfrac": 0.0311079,
                        "P_bin": 0.848775,
                        "normed_bin_frac_p_dist": 0.09314,
                        "normed_tripquad_frac_p_dist": 0.09489,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0223854,
                            "0.35": 0.079568,
                            "0.45": 0.0934658,
                            "0.55": 0.105623,
                            "0.65": 0.116556,
                            "0.75": 0.126568,
                            "0.85": 0.199511,
                            "0.95": 0.256322,
                        },
                        "e": {
                            "0.05": 0.0537433,
                            "0.15": 0.0839551,
                            "0.25": 0.101361,
                            "0.35": 0.114626,
                            "0.45": 0.125623,
                            "0.55": 0.134449,
                            "0.65": 0.136076,
                            "0.75": 0.133203,
                            "0.85": 0.088098,
                            "0.95": 0.0288651,
                        },
                    },
                    "5.25": {
                        "periodfrac": 0.0312564,
                        "P_bin": 0.815571,
                        "normed_bin_frac_p_dist": 0.08992,
                        "normed_tripquad_frac_p_dist": 0.1163,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.022648,
                            "0.35": 0.0805014,
                            "0.45": 0.0945623,
                            "0.55": 0.106862,
                            "0.65": 0.117923,
                            "0.75": 0.128053,
                            "0.85": 0.198357,
                            "0.95": 0.251093,
                        },
                        "e": {
                            "0.05": 0.0517855,
                            "0.15": 0.0825411,
                            "0.25": 0.100565,
                            "0.35": 0.114409,
                            "0.45": 0.125945,
                            "0.55": 0.135239,
                            "0.65": 0.136956,
                            "0.75": 0.134167,
                            "0.85": 0.0889851,
                            "0.95": 0.0294067,
                        },
                    },
                    "5.75": {
                        "periodfrac": 0.0292117,
                        "P_bin": 0.780448,
                        "normed_bin_frac_p_dist": 0.08042,
                        "normed_tripquad_frac_p_dist": 0.1294,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0229347,
                            "0.35": 0.0815205,
                            "0.45": 0.0957594,
                            "0.55": 0.108215,
                            "0.65": 0.119416,
                            "0.75": 0.129674,
                            "0.85": 0.197097,
                            "0.95": 0.245383,
                        },
                        "e": {
                            "0.05": 0.0502699,
                            "0.15": 0.0814303,
                            "0.25": 0.099944,
                            "0.35": 0.114252,
                            "0.45": 0.126226,
                            "0.55": 0.135904,
                            "0.65": 0.137694,
                            "0.75": 0.134937,
                            "0.85": 0.0896122,
                            "0.95": 0.0297304,
                        },
                    },
                    "6.25": {
                        "periodfrac": 0.0249526,
                        "P_bin": 0.743492,
                        "normed_bin_frac_p_dist": 0.06544,
                        "normed_tripquad_frac_p_dist": 0.1291,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0232463,
                            "0.35": 0.0826281,
                            "0.45": 0.0970604,
                            "0.55": 0.109685,
                            "0.65": 0.121039,
                            "0.75": 0.131436,
                            "0.85": 0.195727,
                            "0.95": 0.239178,
                        },
                        "e": {
                            "0.05": 0.0490604,
                            "0.15": 0.0805314,
                            "0.25": 0.0994411,
                            "0.35": 0.114131,
                            "0.45": 0.126467,
                            "0.55": 0.136463,
                            "0.65": 0.138314,
                            "0.75": 0.135567,
                            "0.85": 0.0900846,
                            "0.95": 0.0299411,
                        },
                    },
                    "6.75": {
                        "periodfrac": 0.0208476,
                        "P_bin": 0.704764,
                        "normed_bin_frac_p_dist": 0.05183,
                        "normed_tripquad_frac_p_dist": 0.1241,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0235836,
                            "0.35": 0.0838269,
                            "0.45": 0.0984686,
                            "0.55": 0.111277,
                            "0.65": 0.122795,
                            "0.75": 0.133343,
                            "0.85": 0.194246,
                            "0.95": 0.232461,
                        },
                        "e": {
                            "0.05": 0.0480717,
                            "0.15": 0.0797869,
                            "0.25": 0.0990233,
                            "0.35": 0.114031,
                            "0.45": 0.126672,
                            "0.55": 0.136936,
                            "0.65": 0.138838,
                            "0.75": 0.136092,
                            "0.85": 0.0904586,
                            "0.95": 0.0300905,
                        },
                    },
                    "7.25": {
                        "periodfrac": 0.0170785,
                        "P_bin": 0.664305,
                        "normed_bin_frac_p_dist": 0.04002,
                        "normed_tripquad_frac_p_dist": 0.1156,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0239474,
                            "0.35": 0.0851202,
                            "0.45": 0.0999877,
                            "0.55": 0.112994,
                            "0.65": 0.124689,
                            "0.75": 0.1354,
                            "0.85": 0.192647,
                            "0.95": 0.225214,
                        },
                        "e": {
                            "0.05": 0.0472479,
                            "0.15": 0.0791591,
                            "0.25": 0.0986693,
                            "0.35": 0.113946,
                            "0.45": 0.126846,
                            "0.55": 0.13734,
                            "0.65": 0.139286,
                            "0.75": 0.136535,
                            "0.85": 0.0907653,
                            "0.95": 0.0302046,
                        },
                    },
                    "7.75": {
                        "periodfrac": 0.0137828,
                        "P_bin": 0.622133,
                        "normed_bin_frac_p_dist": 0.03025,
                        "normed_tripquad_frac_p_dist": 0.105,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0244275,
                            "0.35": 0.0868266,
                            "0.45": 0.101992,
                            "0.55": 0.115259,
                            "0.65": 0.127189,
                            "0.75": 0.138115,
                            "0.85": 0.190537,
                            "0.95": 0.215654,
                        },
                        "e": {
                            "0.05": 0.0465507,
                            "0.15": 0.0786221,
                            "0.25": 0.0983648,
                            "0.35": 0.113873,
                            "0.45": 0.126996,
                            "0.55": 0.137687,
                            "0.65": 0.139672,
                            "0.75": 0.136916,
                            "0.85": 0.0910235,
                            "0.95": 0.0302959,
                        },
                    },
                },
            },
            "-0.4": {
                "f_multi": 0.3728,
                "multi system fraction": 0.3157,
                "binary star fraction": 0.2871,
                "triple/quad star fraction": 0.0285,
                "single star fraction": 0.6843,
                "poisson_model": {
                    "single_fraction": 0.689,
                    "binary_fraction": 0.257,
                    "triple_fraction": 0.0479,
                    "quadruple_fraction": 0.00595,
                },
                "logP": {
                    "0.25": {
                        "periodfrac": 0.00795987,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.02522,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0453168,
                            "0.35": 0.0736949,
                            "0.45": 0.0865669,
                            "0.55": 0.0978271,
                            "0.65": 0.107953,
                            "0.75": 0.117226,
                            "0.85": 0.199448,
                            "0.95": 0.271967,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "0.75": {
                        "periodfrac": 0.00989926,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.03136,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0453168,
                            "0.35": 0.0736949,
                            "0.45": 0.0865669,
                            "0.55": 0.0978271,
                            "0.65": 0.107953,
                            "0.75": 0.117226,
                            "0.85": 0.199448,
                            "0.95": 0.271967,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.25": {
                        "periodfrac": 0.0124064,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.0393,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0453168,
                            "0.35": 0.0736949,
                            "0.45": 0.0865669,
                            "0.55": 0.0978271,
                            "0.65": 0.107953,
                            "0.75": 0.117226,
                            "0.85": 0.199448,
                            "0.95": 0.271967,
                        },
                        "e": {
                            "0.05": 0.330824,
                            "0.15": 0.165642,
                            "0.25": 0.129153,
                            "0.35": 0.110009,
                            "0.45": 0.100964,
                            "0.55": 0.0990032,
                            "0.65": 0.057533,
                            "0.75": 0.00687094,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.75": {
                        "periodfrac": 0.0156363,
                        "P_bin": 0.994661,
                        "normed_bin_frac_p_dist": 0.04927,
                        "normed_tripquad_frac_p_dist": 0.001462,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0453589,
                            "0.35": 0.0737634,
                            "0.45": 0.0866473,
                            "0.55": 0.0979179,
                            "0.65": 0.108053,
                            "0.75": 0.117335,
                            "0.85": 0.199357,
                            "0.95": 0.271568,
                        },
                        "e": {
                            "0.05": 0.14167,
                            "0.15": 0.131895,
                            "0.25": 0.12826,
                            "0.35": 0.125956,
                            "0.45": 0.12427,
                            "0.55": 0.123559,
                            "0.65": 0.12234,
                            "0.75": 0.0809714,
                            "0.85": 0.0210788,
                            "0.95": 0.0,
                        },
                    },
                    "2.25": {
                        "periodfrac": 0.0195932,
                        "P_bin": 0.978859,
                        "normed_bin_frac_p_dist": 0.06076,
                        "normed_tripquad_frac_p_dist": 0.007254,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.045635,
                            "0.35": 0.0742124,
                            "0.45": 0.0871747,
                            "0.55": 0.098514,
                            "0.65": 0.108711,
                            "0.75": 0.118049,
                            "0.85": 0.198757,
                            "0.95": 0.268947,
                        },
                        "e": {
                            "0.05": 0.0944499,
                            "0.15": 0.110031,
                            "0.25": 0.117032,
                            "0.35": 0.121823,
                            "0.45": 0.125515,
                            "0.55": 0.127863,
                            "0.65": 0.127994,
                            "0.75": 0.112768,
                            "0.85": 0.0563073,
                            "0.95": 0.00621564,
                        },
                    },
                    "2.75": {
                        "periodfrac": 0.0241514,
                        "P_bin": 0.958166,
                        "normed_bin_frac_p_dist": 0.07331,
                        "normed_tripquad_frac_p_dist": 0.01769,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0459526,
                            "0.35": 0.0747288,
                            "0.45": 0.0877814,
                            "0.55": 0.0991995,
                            "0.65": 0.109467,
                            "0.75": 0.118871,
                            "0.85": 0.198067,
                            "0.95": 0.265933,
                        },
                        "e": {
                            "0.05": 0.0754871,
                            "0.15": 0.0987081,
                            "0.25": 0.110213,
                            "0.35": 0.118419,
                            "0.45": 0.12492,
                            "0.55": 0.129746,
                            "0.65": 0.13039,
                            "0.75": 0.123258,
                            "0.85": 0.0725423,
                            "0.95": 0.0163158,
                        },
                    },
                    "3.25": {
                        "periodfrac": 0.0283117,
                        "P_bin": 0.933972,
                        "normed_bin_frac_p_dist": 0.08377,
                        "normed_tripquad_frac_p_dist": 0.03274,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0463129,
                            "0.35": 0.0753148,
                            "0.45": 0.0884696,
                            "0.55": 0.0999772,
                            "0.65": 0.110326,
                            "0.75": 0.119803,
                            "0.85": 0.197285,
                            "0.95": 0.262512,
                        },
                        "e": {
                            "0.05": 0.0657833,
                            "0.15": 0.0922986,
                            "0.25": 0.106244,
                            "0.35": 0.116451,
                            "0.45": 0.124683,
                            "0.55": 0.131158,
                            "0.65": 0.132341,
                            "0.75": 0.127869,
                            "0.85": 0.0804725,
                            "0.95": 0.0226993,
                        },
                    },
                    "3.75": {
                        "periodfrac": 0.0314205,
                        "P_bin": 0.906918,
                        "normed_bin_frac_p_dist": 0.09027,
                        "normed_tripquad_frac_p_dist": 0.05122,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0467172,
                            "0.35": 0.0759722,
                            "0.45": 0.089242,
                            "0.55": 0.10085,
                            "0.65": 0.111289,
                            "0.75": 0.120849,
                            "0.85": 0.196406,
                            "0.95": 0.258675,
                        },
                        "e": {
                            "0.05": 0.0601091,
                            "0.15": 0.0884375,
                            "0.25": 0.103949,
                            "0.35": 0.115505,
                            "0.45": 0.124938,
                            "0.55": 0.132423,
                            "0.65": 0.133797,
                            "0.75": 0.13029,
                            "0.85": 0.0845054,
                            "0.95": 0.0260463,
                        },
                    },
                    "4.25": {
                        "periodfrac": 0.0334328,
                        "P_bin": 0.877383,
                        "normed_bin_frac_p_dist": 0.09292,
                        "normed_tripquad_frac_p_dist": 0.0718,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0471669,
                            "0.35": 0.0767035,
                            "0.45": 0.0901009,
                            "0.55": 0.101821,
                            "0.65": 0.11236,
                            "0.75": 0.122012,
                            "0.85": 0.19543,
                            "0.95": 0.254406,
                        },
                        "e": {
                            "0.05": 0.0563761,
                            "0.15": 0.085828,
                            "0.25": 0.102429,
                            "0.35": 0.114957,
                            "0.45": 0.125274,
                            "0.55": 0.133513,
                            "0.65": 0.135029,
                            "0.75": 0.131961,
                            "0.85": 0.086745,
                            "0.95": 0.0278885,
                        },
                    },
                    "4.75": {
                        "periodfrac": 0.0344995,
                        "P_bin": 0.845618,
                        "normed_bin_frac_p_dist": 0.09242,
                        "normed_tripquad_frac_p_dist": 0.09328,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0476632,
                            "0.35": 0.0775107,
                            "0.45": 0.0910491,
                            "0.55": 0.102892,
                            "0.65": 0.113542,
                            "0.75": 0.123296,
                            "0.85": 0.194352,
                            "0.95": 0.249695,
                        },
                        "e": {
                            "0.05": 0.0537433,
                            "0.15": 0.0839551,
                            "0.25": 0.101361,
                            "0.35": 0.114626,
                            "0.45": 0.125623,
                            "0.55": 0.134449,
                            "0.65": 0.136076,
                            "0.75": 0.133203,
                            "0.85": 0.088098,
                            "0.95": 0.0288651,
                        },
                    },
                    "5.25": {
                        "periodfrac": 0.0347989,
                        "P_bin": 0.811801,
                        "normed_bin_frac_p_dist": 0.08949,
                        "normed_tripquad_frac_p_dist": 0.1147,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0482077,
                            "0.35": 0.0783961,
                            "0.45": 0.0920893,
                            "0.55": 0.104068,
                            "0.65": 0.11484,
                            "0.75": 0.124704,
                            "0.85": 0.193169,
                            "0.95": 0.244526,
                        },
                        "e": {
                            "0.05": 0.0517855,
                            "0.15": 0.0825411,
                            "0.25": 0.100565,
                            "0.35": 0.114409,
                            "0.45": 0.125945,
                            "0.55": 0.135239,
                            "0.65": 0.136956,
                            "0.75": 0.134167,
                            "0.85": 0.0889851,
                            "0.95": 0.0294067,
                        },
                    },
                    "5.75": {
                        "periodfrac": 0.0327644,
                        "P_bin": 0.776063,
                        "normed_bin_frac_p_dist": 0.08055,
                        "normed_tripquad_frac_p_dist": 0.1285,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0488019,
                            "0.35": 0.0793623,
                            "0.45": 0.0932242,
                            "0.55": 0.10535,
                            "0.65": 0.116255,
                            "0.75": 0.126241,
                            "0.85": 0.191879,
                            "0.95": 0.238886,
                        },
                        "e": {
                            "0.05": 0.0502699,
                            "0.15": 0.0814303,
                            "0.25": 0.099944,
                            "0.35": 0.114252,
                            "0.45": 0.126226,
                            "0.55": 0.135904,
                            "0.65": 0.137694,
                            "0.75": 0.134937,
                            "0.85": 0.0896122,
                            "0.95": 0.0297304,
                        },
                    },
                    "6.25": {
                        "periodfrac": 0.0282525,
                        "P_bin": 0.7385,
                        "normed_bin_frac_p_dist": 0.0661,
                        "normed_tripquad_frac_p_dist": 0.1294,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0494471,
                            "0.35": 0.0804116,
                            "0.45": 0.0944568,
                            "0.55": 0.106743,
                            "0.65": 0.117792,
                            "0.75": 0.127911,
                            "0.85": 0.190477,
                            "0.95": 0.232762,
                        },
                        "e": {
                            "0.05": 0.0490604,
                            "0.15": 0.0805314,
                            "0.25": 0.0994411,
                            "0.35": 0.114131,
                            "0.45": 0.126467,
                            "0.55": 0.136463,
                            "0.65": 0.138314,
                            "0.75": 0.135567,
                            "0.85": 0.0900846,
                            "0.95": 0.0299411,
                        },
                    },
                    "6.75": {
                        "periodfrac": 0.0238438,
                        "P_bin": 0.699182,
                        "normed_bin_frac_p_dist": 0.05281,
                        "normed_tripquad_frac_p_dist": 0.1256,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.050145,
                            "0.35": 0.0815466,
                            "0.45": 0.0957899,
                            "0.55": 0.10825,
                            "0.65": 0.119455,
                            "0.75": 0.129716,
                            "0.85": 0.188961,
                            "0.95": 0.226137,
                        },
                        "e": {
                            "0.05": 0.0480717,
                            "0.15": 0.0797869,
                            "0.25": 0.0990233,
                            "0.35": 0.114031,
                            "0.45": 0.126672,
                            "0.55": 0.136936,
                            "0.65": 0.138838,
                            "0.75": 0.136092,
                            "0.85": 0.0904586,
                            "0.95": 0.0300905,
                        },
                    },
                    "7.25": {
                        "periodfrac": 0.0197285,
                        "P_bin": 0.658158,
                        "normed_bin_frac_p_dist": 0.04113,
                        "normed_tripquad_frac_p_dist": 0.1181,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0508973,
                            "0.35": 0.0827699,
                            "0.45": 0.0972269,
                            "0.55": 0.109874,
                            "0.65": 0.121246,
                            "0.75": 0.131662,
                            "0.85": 0.187328,
                            "0.95": 0.218996,
                        },
                        "e": {
                            "0.05": 0.0472479,
                            "0.15": 0.0791591,
                            "0.25": 0.0986693,
                            "0.35": 0.113946,
                            "0.45": 0.126846,
                            "0.55": 0.13734,
                            "0.65": 0.139286,
                            "0.75": 0.136535,
                            "0.85": 0.0907653,
                            "0.95": 0.0302046,
                        },
                    },
                    "7.75": {
                        "periodfrac": 0.0160713,
                        "P_bin": 0.615459,
                        "normed_bin_frac_p_dist": 0.03133,
                        "normed_tripquad_frac_p_dist": 0.1082,
                        "q": {
                            "0.15": 0.0,
                            "0.25": 0.0518889,
                            "0.35": 0.0843825,
                            "0.45": 0.0991212,
                            "0.55": 0.112014,
                            "0.65": 0.123609,
                            "0.75": 0.134227,
                            "0.85": 0.185174,
                            "0.95": 0.209583,
                        },
                        "e": {
                            "0.05": 0.0465507,
                            "0.15": 0.0786221,
                            "0.25": 0.0983648,
                            "0.35": 0.113873,
                            "0.45": 0.126996,
                            "0.55": 0.137687,
                            "0.65": 0.139672,
                            "0.75": 0.136916,
                            "0.85": 0.0910235,
                            "0.95": 0.0302959,
                        },
                    },
                },
            },
            "-0.3": {
                "f_multi": 0.416,
                "multi system fraction": 0.35,
                "binary star fraction": 0.317,
                "triple/quad star fraction": 0.033,
                "single star fraction": 0.65,
                "poisson_model": {
                    "single_fraction": 0.66,
                    "binary_fraction": 0.275,
                    "triple_fraction": 0.0571,
                    "quadruple_fraction": 0.00792,
                },
                "logP": {
                    "0.25": {
                        "periodfrac": 0.00876877,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.02505,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0180435,
                            "0.25": 0.068383,
                            "0.35": 0.0854537,
                            "0.45": 0.091417,
                            "0.55": 0.0972312,
                            "0.65": 0.102825,
                            "0.75": 0.10819,
                            "0.85": 0.179649,
                            "0.95": 0.248808,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "0.75": {
                        "periodfrac": 0.0110317,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.03152,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0180435,
                            "0.25": 0.068383,
                            "0.35": 0.0854537,
                            "0.45": 0.091417,
                            "0.55": 0.0972312,
                            "0.65": 0.102825,
                            "0.75": 0.10819,
                            "0.85": 0.179649,
                            "0.95": 0.248808,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.25": {
                        "periodfrac": 0.013836,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.03953,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0180435,
                            "0.25": 0.068383,
                            "0.35": 0.0854537,
                            "0.45": 0.091417,
                            "0.55": 0.0972312,
                            "0.65": 0.102825,
                            "0.75": 0.10819,
                            "0.85": 0.179649,
                            "0.95": 0.248808,
                        },
                        "e": {
                            "0.05": 0.330824,
                            "0.15": 0.165642,
                            "0.25": 0.129153,
                            "0.35": 0.110009,
                            "0.45": 0.100964,
                            "0.55": 0.0990032,
                            "0.65": 0.057533,
                            "0.75": 0.00687094,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.75": {
                        "periodfrac": 0.0174164,
                        "P_bin": 0.994483,
                        "normed_bin_frac_p_dist": 0.04948,
                        "normed_tripquad_frac_p_dist": 0.001457,
                        "q": {
                            "0.15": 0.0181069,
                            "0.25": 0.0686235,
                            "0.35": 0.0857541,
                            "0.45": 0.0917385,
                            "0.55": 0.0975729,
                            "0.65": 0.103186,
                            "0.75": 0.10857,
                            "0.85": 0.179244,
                            "0.95": 0.247203,
                        },
                        "e": {
                            "0.05": 0.14167,
                            "0.15": 0.131895,
                            "0.25": 0.12826,
                            "0.35": 0.125956,
                            "0.45": 0.12427,
                            "0.55": 0.123559,
                            "0.65": 0.12234,
                            "0.75": 0.0809714,
                            "0.85": 0.0210788,
                            "0.95": 0.0,
                        },
                    },
                    "2.25": {
                        "periodfrac": 0.0217719,
                        "P_bin": 0.978162,
                        "normed_bin_frac_p_dist": 0.06084,
                        "normed_tripquad_frac_p_dist": 0.007207,
                        "q": {
                            "0.15": 0.0182144,
                            "0.25": 0.0690307,
                            "0.35": 0.0862629,
                            "0.45": 0.0922828,
                            "0.55": 0.0981518,
                            "0.65": 0.103798,
                            "0.75": 0.109215,
                            "0.85": 0.17856,
                            "0.95": 0.244485,
                        },
                        "e": {
                            "0.05": 0.0944499,
                            "0.15": 0.110031,
                            "0.25": 0.117032,
                            "0.35": 0.121823,
                            "0.45": 0.125515,
                            "0.55": 0.127863,
                            "0.65": 0.127994,
                            "0.75": 0.112768,
                            "0.85": 0.0563073,
                            "0.95": 0.00621564,
                        },
                    },
                    "2.75": {
                        "periodfrac": 0.0267649,
                        "P_bin": 0.956802,
                        "normed_bin_frac_p_dist": 0.07316,
                        "normed_tripquad_frac_p_dist": 0.01753,
                        "q": {
                            "0.15": 0.0183588,
                            "0.25": 0.0695781,
                            "0.35": 0.086947,
                            "0.45": 0.0930146,
                            "0.55": 0.0989302,
                            "0.65": 0.104622,
                            "0.75": 0.11008,
                            "0.85": 0.177639,
                            "0.95": 0.24083,
                        },
                        "e": {
                            "0.05": 0.0754871,
                            "0.15": 0.0987081,
                            "0.25": 0.110213,
                            "0.35": 0.118419,
                            "0.45": 0.12492,
                            "0.55": 0.129746,
                            "0.65": 0.13039,
                            "0.75": 0.123258,
                            "0.85": 0.0725423,
                            "0.95": 0.0163158,
                        },
                    },
                    "3.25": {
                        "periodfrac": 0.0313318,
                        "P_bin": 0.931848,
                        "normed_bin_frac_p_dist": 0.08341,
                        "normed_tripquad_frac_p_dist": 0.03237,
                        "q": {
                            "0.15": 0.0185244,
                            "0.25": 0.0702057,
                            "0.35": 0.0877314,
                            "0.45": 0.0938537,
                            "0.55": 0.0998226,
                            "0.65": 0.105565,
                            "0.75": 0.111074,
                            "0.85": 0.176584,
                            "0.95": 0.236639,
                        },
                        "e": {
                            "0.05": 0.0657833,
                            "0.15": 0.0922986,
                            "0.25": 0.106244,
                            "0.35": 0.116451,
                            "0.45": 0.124683,
                            "0.55": 0.131158,
                            "0.65": 0.132341,
                            "0.75": 0.127869,
                            "0.85": 0.0804725,
                            "0.95": 0.0226993,
                        },
                    },
                    "3.75": {
                        "periodfrac": 0.0347721,
                        "P_bin": 0.903969,
                        "normed_bin_frac_p_dist": 0.0898,
                        "normed_tripquad_frac_p_dist": 0.05062,
                        "q": {
                            "0.15": 0.0186837,
                            "0.25": 0.0708094,
                            "0.35": 0.0884857,
                            "0.45": 0.0946607,
                            "0.55": 0.100681,
                            "0.65": 0.106473,
                            "0.75": 0.112029,
                            "0.85": 0.175569,
                            "0.95": 0.232609,
                        },
                        "e": {
                            "0.05": 0.0601091,
                            "0.15": 0.0884375,
                            "0.25": 0.103949,
                            "0.35": 0.115505,
                            "0.45": 0.124938,
                            "0.55": 0.132423,
                            "0.65": 0.133797,
                            "0.75": 0.13029,
                            "0.85": 0.0845054,
                            "0.95": 0.0260463,
                        },
                    },
                    "4.25": {
                        "periodfrac": 0.037028,
                        "P_bin": 0.873565,
                        "normed_bin_frac_p_dist": 0.09241,
                        "normed_tripquad_frac_p_dist": 0.07097,
                        "q": {
                            "0.15": 0.0188903,
                            "0.25": 0.0715925,
                            "0.35": 0.0894643,
                            "0.45": 0.0957076,
                            "0.55": 0.101794,
                            "0.65": 0.107651,
                            "0.75": 0.113268,
                            "0.85": 0.174252,
                            "0.95": 0.22738,
                        },
                        "e": {
                            "0.05": 0.0563761,
                            "0.15": 0.085828,
                            "0.25": 0.102429,
                            "0.35": 0.114957,
                            "0.45": 0.125274,
                            "0.55": 0.133513,
                            "0.65": 0.135029,
                            "0.75": 0.131961,
                            "0.85": 0.086745,
                            "0.95": 0.0278885,
                        },
                    },
                    "4.75": {
                        "periodfrac": 0.0382512,
                        "P_bin": 0.840904,
                        "normed_bin_frac_p_dist": 0.0919,
                        "normed_tripquad_frac_p_dist": 0.09225,
                        "q": {
                            "0.15": 0.0190857,
                            "0.25": 0.0723331,
                            "0.35": 0.0903898,
                            "0.45": 0.0966976,
                            "0.55": 0.102848,
                            "0.65": 0.108764,
                            "0.75": 0.114439,
                            "0.85": 0.173007,
                            "0.95": 0.222436,
                        },
                        "e": {
                            "0.05": 0.0537433,
                            "0.15": 0.0839551,
                            "0.25": 0.101361,
                            "0.35": 0.114626,
                            "0.45": 0.125623,
                            "0.55": 0.134449,
                            "0.65": 0.136076,
                            "0.75": 0.133203,
                            "0.85": 0.088098,
                            "0.95": 0.0288651,
                        },
                    },
                    "5.25": {
                        "periodfrac": 0.038664,
                        "P_bin": 0.806179,
                        "normed_bin_frac_p_dist": 0.08905,
                        "normed_tripquad_frac_p_dist": 0.1136,
                        "q": {
                            "0.15": 0.0193356,
                            "0.25": 0.0732802,
                            "0.35": 0.0915733,
                            "0.45": 0.0979637,
                            "0.55": 0.104194,
                            "0.65": 0.110188,
                            "0.75": 0.115938,
                            "0.85": 0.171414,
                            "0.95": 0.216113,
                        },
                        "e": {
                            "0.05": 0.0517855,
                            "0.15": 0.0825411,
                            "0.25": 0.100565,
                            "0.35": 0.114409,
                            "0.45": 0.125945,
                            "0.55": 0.135239,
                            "0.65": 0.136956,
                            "0.75": 0.134167,
                            "0.85": 0.0889851,
                            "0.95": 0.0294067,
                        },
                    },
                    "5.75": {
                        "periodfrac": 0.0365901,
                        "P_bin": 0.769533,
                        "normed_bin_frac_p_dist": 0.08045,
                        "normed_tripquad_frac_p_dist": 0.1278,
                        "q": {
                            "0.15": 0.0196098,
                            "0.25": 0.0743192,
                            "0.35": 0.0928716,
                            "0.45": 0.0993527,
                            "0.55": 0.105671,
                            "0.65": 0.11175,
                            "0.75": 0.117582,
                            "0.85": 0.169668,
                            "0.95": 0.209176,
                        },
                        "e": {
                            "0.05": 0.0502699,
                            "0.15": 0.0814303,
                            "0.25": 0.099944,
                            "0.35": 0.114252,
                            "0.45": 0.126226,
                            "0.55": 0.135904,
                            "0.65": 0.137694,
                            "0.75": 0.134937,
                            "0.85": 0.0896122,
                            "0.95": 0.0297304,
                        },
                    },
                    "6.25": {
                        "periodfrac": 0.0317898,
                        "P_bin": 0.731076,
                        "normed_bin_frac_p_dist": 0.0664,
                        "normed_tripquad_frac_p_dist": 0.1296,
                        "q": {
                            "0.15": 0.0198646,
                            "0.25": 0.0752848,
                            "0.35": 0.0940784,
                            "0.45": 0.100644,
                            "0.55": 0.107044,
                            "0.65": 0.113203,
                            "0.75": 0.119109,
                            "0.85": 0.168044,
                            "0.95": 0.202729,
                        },
                        "e": {
                            "0.05": 0.0490604,
                            "0.15": 0.0805314,
                            "0.25": 0.0994411,
                            "0.35": 0.114131,
                            "0.45": 0.126467,
                            "0.55": 0.136463,
                            "0.65": 0.138314,
                            "0.75": 0.135567,
                            "0.85": 0.0900846,
                            "0.95": 0.0299411,
                        },
                    },
                    "6.75": {
                        "periodfrac": 0.027027,
                        "P_bin": 0.690892,
                        "normed_bin_frac_p_dist": 0.05335,
                        "normed_tripquad_frac_p_dist": 0.1266,
                        "q": {
                            "0.15": 0.020213,
                            "0.25": 0.0766054,
                            "0.35": 0.0957287,
                            "0.45": 0.102409,
                            "0.55": 0.108922,
                            "0.65": 0.115188,
                            "0.75": 0.121199,
                            "0.85": 0.165823,
                            "0.95": 0.193911,
                        },
                        "e": {
                            "0.05": 0.0480717,
                            "0.15": 0.0797869,
                            "0.25": 0.0990233,
                            "0.35": 0.114031,
                            "0.45": 0.126672,
                            "0.55": 0.136936,
                            "0.65": 0.138838,
                            "0.75": 0.136092,
                            "0.85": 0.0904586,
                            "0.95": 0.0300905,
                        },
                    },
                    "7.25": {
                        "periodfrac": 0.0225091,
                        "P_bin": 0.649045,
                        "normed_bin_frac_p_dist": 0.04174,
                        "normed_tripquad_frac_p_dist": 0.1197,
                        "q": {
                            "0.15": 0.020579,
                            "0.25": 0.0779923,
                            "0.35": 0.0974617,
                            "0.45": 0.104263,
                            "0.55": 0.110894,
                            "0.65": 0.117274,
                            "0.75": 0.123393,
                            "0.85": 0.163491,
                            "0.95": 0.184652,
                        },
                        "e": {
                            "0.05": 0.0472479,
                            "0.15": 0.0791591,
                            "0.25": 0.0986693,
                            "0.35": 0.113946,
                            "0.45": 0.126846,
                            "0.55": 0.13734,
                            "0.65": 0.139286,
                            "0.75": 0.136535,
                            "0.85": 0.0907653,
                            "0.95": 0.0302046,
                        },
                    },
                    "7.75": {
                        "periodfrac": 0.0184345,
                        "P_bin": 0.605581,
                        "normed_bin_frac_p_dist": 0.03189,
                        "normed_tripquad_frac_p_dist": 0.1102,
                        "q": {
                            "0.15": 0.0216324,
                            "0.25": 0.0819847,
                            "0.35": 0.101775,
                            "0.45": 0.107639,
                            "0.55": 0.113449,
                            "0.65": 0.119072,
                            "0.75": 0.124478,
                            "0.85": 0.158471,
                            "0.95": 0.171498,
                        },
                        "e": {
                            "0.05": 0.0465507,
                            "0.15": 0.0786221,
                            "0.25": 0.0983648,
                            "0.35": 0.113873,
                            "0.45": 0.126996,
                            "0.55": 0.137687,
                            "0.65": 0.139672,
                            "0.75": 0.136916,
                            "0.85": 0.0910235,
                            "0.95": 0.0302959,
                        },
                    },
                },
            },
            "-0.2": {
                "f_multi": 0.4591,
                "multi system fraction": 0.3821,
                "binary star fraction": 0.3436,
                "triple/quad star fraction": 0.0385,
                "single star fraction": 0.6179,
                "poisson_model": {
                    "single_fraction": 0.632,
                    "binary_fraction": 0.29,
                    "triple_fraction": 0.0667,
                    "quadruple_fraction": 0.0102,
                },
                "logP": {
                    "0.25": {
                        "periodfrac": 0.00975898,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.02554,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0499282,
                            "0.25": 0.0913533,
                            "0.35": 0.100045,
                            "0.45": 0.0972576,
                            "0.55": 0.0961698,
                            "0.65": 0.096017,
                            "0.75": 0.0964256,
                            "0.85": 0.154054,
                            "0.95": 0.218749,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "0.75": {
                        "periodfrac": 0.0119901,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.03138,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0499282,
                            "0.25": 0.0913533,
                            "0.35": 0.100045,
                            "0.45": 0.0972576,
                            "0.55": 0.0961698,
                            "0.65": 0.096017,
                            "0.75": 0.0964256,
                            "0.85": 0.154054,
                            "0.95": 0.218749,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.25": {
                        "periodfrac": 0.0146919,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.03845,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0499282,
                            "0.25": 0.0913533,
                            "0.35": 0.100045,
                            "0.45": 0.0972576,
                            "0.55": 0.0961698,
                            "0.65": 0.096017,
                            "0.75": 0.0964256,
                            "0.85": 0.154054,
                            "0.95": 0.218749,
                        },
                        "e": {
                            "0.05": 0.330824,
                            "0.15": 0.165642,
                            "0.25": 0.129153,
                            "0.35": 0.110009,
                            "0.45": 0.100964,
                            "0.55": 0.0990032,
                            "0.65": 0.057533,
                            "0.75": 0.00687094,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.75": {
                        "periodfrac": 0.0182615,
                        "P_bin": 0.994306,
                        "normed_bin_frac_p_dist": 0.04752,
                        "normed_tripquad_frac_p_dist": 0.001351,
                        "q": {
                            "0.15": 0.0502501,
                            "0.25": 0.0919423,
                            "0.35": 0.10069,
                            "0.45": 0.0978846,
                            "0.55": 0.0967897,
                            "0.65": 0.0966361,
                            "0.75": 0.0970475,
                            "0.85": 0.153181,
                            "0.95": 0.215578,
                        },
                        "e": {
                            "0.05": 0.14167,
                            "0.15": 0.131895,
                            "0.25": 0.12826,
                            "0.35": 0.125956,
                            "0.45": 0.12427,
                            "0.55": 0.123559,
                            "0.65": 0.12234,
                            "0.75": 0.0809714,
                            "0.85": 0.0210788,
                            "0.95": 0.0,
                        },
                    },
                    "2.25": {
                        "periodfrac": 0.0227806,
                        "P_bin": 0.977466,
                        "normed_bin_frac_p_dist": 0.05827,
                        "normed_tripquad_frac_p_dist": 0.00667,
                        "q": {
                            "0.15": 0.0506354,
                            "0.25": 0.0926472,
                            "0.35": 0.101462,
                            "0.45": 0.098635,
                            "0.55": 0.0975319,
                            "0.65": 0.0973769,
                            "0.75": 0.0977912,
                            "0.85": 0.152136,
                            "0.95": 0.211784,
                        },
                        "e": {
                            "0.05": 0.0944499,
                            "0.15": 0.110031,
                            "0.25": 0.117032,
                            "0.35": 0.121823,
                            "0.45": 0.125515,
                            "0.55": 0.127863,
                            "0.65": 0.127994,
                            "0.75": 0.112768,
                            "0.85": 0.0563073,
                            "0.95": 0.00621564,
                        },
                    },
                    "2.75": {
                        "periodfrac": 0.0281898,
                        "P_bin": 0.95544,
                        "normed_bin_frac_p_dist": 0.07049,
                        "normed_tripquad_frac_p_dist": 0.01632,
                        "q": {
                            "0.15": 0.0510858,
                            "0.25": 0.0934713,
                            "0.35": 0.102365,
                            "0.45": 0.0995125,
                            "0.55": 0.0983994,
                            "0.65": 0.0982431,
                            "0.75": 0.0986613,
                            "0.85": 0.150915,
                            "0.95": 0.207347,
                        },
                        "e": {
                            "0.05": 0.0754871,
                            "0.15": 0.0987081,
                            "0.25": 0.110213,
                            "0.35": 0.118419,
                            "0.45": 0.12492,
                            "0.55": 0.129746,
                            "0.65": 0.13039,
                            "0.75": 0.123258,
                            "0.85": 0.0725423,
                            "0.95": 0.0163158,
                        },
                    },
                    "3.25": {
                        "periodfrac": 0.0332434,
                        "P_bin": 0.929728,
                        "normed_bin_frac_p_dist": 0.08089,
                        "normed_tripquad_frac_p_dist": 0.03035,
                        "q": {
                            "0.15": 0.0516032,
                            "0.25": 0.0944181,
                            "0.35": 0.103402,
                            "0.45": 0.10052,
                            "0.55": 0.099396,
                            "0.65": 0.0992382,
                            "0.75": 0.0996604,
                            "0.85": 0.149511,
                            "0.95": 0.202251,
                        },
                        "e": {
                            "0.05": 0.0657833,
                            "0.15": 0.0922986,
                            "0.25": 0.106244,
                            "0.35": 0.116451,
                            "0.45": 0.124683,
                            "0.55": 0.131158,
                            "0.65": 0.132341,
                            "0.75": 0.127869,
                            "0.85": 0.0804725,
                            "0.95": 0.0226993,
                        },
                    },
                    "3.75": {
                        "periodfrac": 0.037156,
                        "P_bin": 0.90103,
                        "normed_bin_frac_p_dist": 0.08761,
                        "normed_tripquad_frac_p_dist": 0.04778,
                        "q": {
                            "0.15": 0.0521893,
                            "0.25": 0.0954904,
                            "0.35": 0.104576,
                            "0.45": 0.101662,
                            "0.55": 0.100525,
                            "0.65": 0.100365,
                            "0.75": 0.100792,
                            "0.85": 0.147922,
                            "0.95": 0.196478,
                        },
                        "e": {
                            "0.05": 0.0601091,
                            "0.15": 0.0884375,
                            "0.25": 0.103949,
                            "0.35": 0.115505,
                            "0.45": 0.124938,
                            "0.55": 0.132423,
                            "0.65": 0.133797,
                            "0.75": 0.13029,
                            "0.85": 0.0845054,
                            "0.95": 0.0260463,
                        },
                    },
                    "4.25": {
                        "periodfrac": 0.0399386,
                        "P_bin": 0.869764,
                        "normed_bin_frac_p_dist": 0.09091,
                        "normed_tripquad_frac_p_dist": 0.06759,
                        "q": {
                            "0.15": 0.0528456,
                            "0.25": 0.0966912,
                            "0.35": 0.105891,
                            "0.45": 0.10294,
                            "0.55": 0.101789,
                            "0.65": 0.101627,
                            "0.75": 0.10206,
                            "0.85": 0.146142,
                            "0.95": 0.190014,
                        },
                        "e": {
                            "0.05": 0.0563761,
                            "0.15": 0.085828,
                            "0.25": 0.102429,
                            "0.35": 0.114957,
                            "0.45": 0.125274,
                            "0.55": 0.133513,
                            "0.65": 0.135029,
                            "0.75": 0.131961,
                            "0.85": 0.086745,
                            "0.95": 0.0278885,
                        },
                    },
                    "4.75": {
                        "periodfrac": 0.0418175,
                        "P_bin": 0.836217,
                        "normed_bin_frac_p_dist": 0.09151,
                        "normed_tripquad_frac_p_dist": 0.08899,
                        "q": {
                            "0.15": 0.0535737,
                            "0.25": 0.0980233,
                            "0.35": 0.10735,
                            "0.45": 0.104359,
                            "0.55": 0.103191,
                            "0.65": 0.103027,
                            "0.75": 0.103466,
                            "0.85": 0.144167,
                            "0.95": 0.182843,
                        },
                        "e": {
                            "0.05": 0.0537433,
                            "0.15": 0.0839551,
                            "0.25": 0.101361,
                            "0.35": 0.114626,
                            "0.45": 0.125623,
                            "0.55": 0.134449,
                            "0.65": 0.136076,
                            "0.75": 0.133203,
                            "0.85": 0.088098,
                            "0.95": 0.0288651,
                        },
                    },
                    "5.25": {
                        "periodfrac": 0.043078,
                        "P_bin": 0.800595,
                        "normed_bin_frac_p_dist": 0.09026,
                        "normed_tripquad_frac_p_dist": 0.1116,
                        "q": {
                            "0.15": 0.0543749,
                            "0.25": 0.0994894,
                            "0.35": 0.108955,
                            "0.45": 0.10592,
                            "0.55": 0.104735,
                            "0.65": 0.104568,
                            "0.75": 0.105013,
                            "0.85": 0.141994,
                            "0.95": 0.174951,
                        },
                        "e": {
                            "0.05": 0.0517855,
                            "0.15": 0.0825411,
                            "0.25": 0.100565,
                            "0.35": 0.114409,
                            "0.45": 0.125945,
                            "0.55": 0.135239,
                            "0.65": 0.136956,
                            "0.75": 0.134167,
                            "0.85": 0.0889851,
                            "0.95": 0.0294067,
                        },
                    },
                    "5.75": {
                        "periodfrac": 0.0414412,
                        "P_bin": 0.763057,
                        "normed_bin_frac_p_dist": 0.08276,
                        "normed_tripquad_frac_p_dist": 0.1276,
                        "q": {
                            "0.15": 0.0553744,
                            "0.25": 0.101318,
                            "0.35": 0.110958,
                            "0.45": 0.107867,
                            "0.55": 0.10666,
                            "0.65": 0.106491,
                            "0.75": 0.106944,
                            "0.85": 0.139283,
                            "0.95": 0.165105,
                        },
                        "e": {
                            "0.05": 0.0502699,
                            "0.15": 0.0814303,
                            "0.25": 0.099944,
                            "0.35": 0.114252,
                            "0.45": 0.126226,
                            "0.55": 0.135904,
                            "0.65": 0.137694,
                            "0.75": 0.134937,
                            "0.85": 0.0896122,
                            "0.95": 0.0297304,
                        },
                    },
                    "6.25": {
                        "periodfrac": 0.0363967,
                        "P_bin": 0.723726,
                        "normed_bin_frac_p_dist": 0.06894,
                        "normed_tripquad_frac_p_dist": 0.1307,
                        "q": {
                            "0.15": 0.0565129,
                            "0.25": 0.103401,
                            "0.35": 0.113239,
                            "0.45": 0.110084,
                            "0.55": 0.108853,
                            "0.65": 0.10868,
                            "0.75": 0.109143,
                            "0.85": 0.136195,
                            "0.95": 0.153892,
                        },
                        "e": {
                            "0.05": 0.0490604,
                            "0.15": 0.0805314,
                            "0.25": 0.0994411,
                            "0.35": 0.114131,
                            "0.45": 0.126467,
                            "0.55": 0.136463,
                            "0.65": 0.138314,
                            "0.75": 0.135567,
                            "0.85": 0.0900846,
                            "0.95": 0.0299411,
                        },
                    },
                    "6.75": {
                        "periodfrac": 0.0314149,
                        "P_bin": 0.6827,
                        "normed_bin_frac_p_dist": 0.05613,
                        "normed_tripquad_frac_p_dist": 0.1295,
                        "q": {
                            "0.15": 0.0617724,
                            "0.25": 0.113025,
                            "0.35": 0.121618,
                            "0.45": 0.114676,
                            "0.55": 0.110676,
                            "0.65": 0.108296,
                            "0.75": 0.106899,
                            "0.85": 0.126844,
                            "0.95": 0.136194,
                        },
                        "e": {
                            "0.05": 0.0480717,
                            "0.15": 0.0797869,
                            "0.25": 0.0990233,
                            "0.35": 0.114031,
                            "0.45": 0.126672,
                            "0.55": 0.136936,
                            "0.65": 0.138838,
                            "0.75": 0.136092,
                            "0.85": 0.0904586,
                            "0.95": 0.0300905,
                        },
                    },
                    "7.25": {
                        "periodfrac": 0.0266439,
                        "P_bin": 0.640057,
                        "normed_bin_frac_p_dist": 0.04463,
                        "normed_tripquad_frac_p_dist": 0.1246,
                        "q": {
                            "0.15": 0.067307,
                            "0.25": 0.123151,
                            "0.35": 0.130215,
                            "0.45": 0.119088,
                            "0.55": 0.112177,
                            "0.65": 0.107574,
                            "0.75": 0.10437,
                            "0.85": 0.117414,
                            "0.95": 0.118704,
                        },
                        "e": {
                            "0.05": 0.0472479,
                            "0.15": 0.0791591,
                            "0.25": 0.0986693,
                            "0.35": 0.113946,
                            "0.45": 0.126846,
                            "0.55": 0.13734,
                            "0.65": 0.139286,
                            "0.75": 0.136535,
                            "0.85": 0.0907653,
                            "0.95": 0.0302046,
                        },
                    },
                    "7.75": {
                        "periodfrac": 0.0222681,
                        "P_bin": 0.595862,
                        "normed_bin_frac_p_dist": 0.03472,
                        "normed_tripquad_frac_p_dist": 0.1169,
                        "q": {
                            "0.15": 0.0731034,
                            "0.25": 0.133757,
                            "0.35": 0.138989,
                            "0.45": 0.123282,
                            "0.55": 0.11334,
                            "0.65": 0.106519,
                            "0.75": 0.101579,
                            "0.85": 0.107947,
                            "0.95": 0.101483,
                        },
                        "e": {
                            "0.05": 0.0465507,
                            "0.15": 0.0786221,
                            "0.25": 0.0983648,
                            "0.35": 0.113873,
                            "0.45": 0.126996,
                            "0.55": 0.137687,
                            "0.65": 0.139672,
                            "0.75": 0.136916,
                            "0.85": 0.0910235,
                            "0.95": 0.0302959,
                        },
                    },
                },
            },
            "-0.1": {
                "f_multi": 0.4957,
                "multi system fraction": 0.4109,
                "binary star fraction": 0.3685,
                "triple/quad star fraction": 0.0424,
                "single star fraction": 0.5891,
                "poisson_model": {
                    "single_fraction": 0.61,
                    "binary_fraction": 0.302,
                    "triple_fraction": 0.075,
                    "quadruple_fraction": 0.0124,
                },
                "logP": {
                    "0.25": {
                        "periodfrac": 0.0103566,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.02521,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0791935,
                            "0.25": 0.106573,
                            "0.35": 0.109396,
                            "0.45": 0.100568,
                            "0.55": 0.0947079,
                            "0.65": 0.0905761,
                            "0.75": 0.0875482,
                            "0.85": 0.135162,
                            "0.95": 0.196275,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "0.75": {
                        "periodfrac": 0.0129562,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.03153,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0791935,
                            "0.25": 0.106573,
                            "0.35": 0.109396,
                            "0.45": 0.100568,
                            "0.55": 0.0947079,
                            "0.65": 0.0905761,
                            "0.75": 0.0875482,
                            "0.85": 0.135162,
                            "0.95": 0.196275,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.25": {
                        "periodfrac": 0.0159111,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.03872,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.079299,
                            "0.25": 0.106715,
                            "0.35": 0.109542,
                            "0.45": 0.100702,
                            "0.55": 0.0948341,
                            "0.65": 0.0906967,
                            "0.75": 0.0876651,
                            "0.85": 0.134963,
                            "0.95": 0.195583,
                        },
                        "e": {
                            "0.05": 0.330824,
                            "0.15": 0.165642,
                            "0.25": 0.129153,
                            "0.35": 0.110009,
                            "0.45": 0.100964,
                            "0.55": 0.0990032,
                            "0.65": 0.057533,
                            "0.75": 0.00687094,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.75": {
                        "periodfrac": 0.0197689,
                        "P_bin": 0.994187,
                        "normed_bin_frac_p_dist": 0.04783,
                        "normed_tripquad_frac_p_dist": 0.001355,
                        "q": {
                            "0.15": 0.0798417,
                            "0.25": 0.107446,
                            "0.35": 0.110291,
                            "0.45": 0.101391,
                            "0.55": 0.0954829,
                            "0.65": 0.0913174,
                            "0.75": 0.0882649,
                            "0.85": 0.133937,
                            "0.95": 0.192028,
                        },
                        "e": {
                            "0.05": 0.14167,
                            "0.15": 0.131895,
                            "0.25": 0.12826,
                            "0.35": 0.125956,
                            "0.45": 0.12427,
                            "0.55": 0.123559,
                            "0.65": 0.12234,
                            "0.75": 0.0809714,
                            "0.85": 0.0210788,
                            "0.95": 0.0,
                        },
                    },
                    "2.25": {
                        "periodfrac": 0.0246065,
                        "P_bin": 0.977002,
                        "normed_bin_frac_p_dist": 0.05851,
                        "normed_tripquad_frac_p_dist": 0.006671,
                        "q": {
                            "0.15": 0.0804976,
                            "0.25": 0.108328,
                            "0.35": 0.111197,
                            "0.45": 0.102224,
                            "0.55": 0.0962675,
                            "0.65": 0.0920675,
                            "0.75": 0.0889899,
                            "0.85": 0.132696,
                            "0.95": 0.187731,
                        },
                        "e": {
                            "0.05": 0.0944499,
                            "0.15": 0.110031,
                            "0.25": 0.117032,
                            "0.35": 0.121823,
                            "0.45": 0.125515,
                            "0.55": 0.127863,
                            "0.65": 0.127994,
                            "0.75": 0.112768,
                            "0.85": 0.0563073,
                            "0.95": 0.00621564,
                        },
                    },
                    "2.75": {
                        "periodfrac": 0.0303554,
                        "P_bin": 0.954533,
                        "normed_bin_frac_p_dist": 0.07052,
                        "normed_tripquad_frac_p_dist": 0.01627,
                        "q": {
                            "0.15": 0.0812698,
                            "0.25": 0.109368,
                            "0.35": 0.112264,
                            "0.45": 0.103205,
                            "0.55": 0.0971908,
                            "0.65": 0.0929508,
                            "0.75": 0.0898436,
                            "0.85": 0.131237,
                            "0.95": 0.182672,
                        },
                        "e": {
                            "0.05": 0.0754871,
                            "0.15": 0.0987081,
                            "0.25": 0.110213,
                            "0.35": 0.118419,
                            "0.45": 0.12492,
                            "0.55": 0.129746,
                            "0.65": 0.13039,
                            "0.75": 0.123258,
                            "0.85": 0.0725423,
                            "0.95": 0.0163158,
                        },
                    },
                    "3.25": {
                        "periodfrac": 0.0357358,
                        "P_bin": 0.928318,
                        "normed_bin_frac_p_dist": 0.08074,
                        "normed_tripquad_frac_p_dist": 0.03019,
                        "q": {
                            "0.15": 0.0821607,
                            "0.25": 0.110567,
                            "0.35": 0.113495,
                            "0.45": 0.104336,
                            "0.55": 0.0982563,
                            "0.65": 0.0939698,
                            "0.75": 0.0908286,
                            "0.85": 0.129552,
                            "0.95": 0.176835,
                        },
                        "e": {
                            "0.05": 0.0657833,
                            "0.15": 0.0922986,
                            "0.25": 0.106244,
                            "0.35": 0.116451,
                            "0.45": 0.124683,
                            "0.55": 0.131158,
                            "0.65": 0.132341,
                            "0.75": 0.127869,
                            "0.85": 0.0804725,
                            "0.95": 0.0226993,
                        },
                    },
                    "3.75": {
                        "periodfrac": 0.0399337,
                        "P_bin": 0.899076,
                        "normed_bin_frac_p_dist": 0.08738,
                        "normed_tripquad_frac_p_dist": 0.04751,
                        "q": {
                            "0.15": 0.0831728,
                            "0.25": 0.111929,
                            "0.35": 0.114893,
                            "0.45": 0.105621,
                            "0.55": 0.0994666,
                            "0.65": 0.0951273,
                            "0.75": 0.0919474,
                            "0.85": 0.127639,
                            "0.95": 0.170204,
                        },
                        "e": {
                            "0.05": 0.0601091,
                            "0.15": 0.0884375,
                            "0.25": 0.103949,
                            "0.35": 0.115505,
                            "0.45": 0.124938,
                            "0.55": 0.132423,
                            "0.65": 0.133797,
                            "0.75": 0.13029,
                            "0.85": 0.0845054,
                            "0.95": 0.0260463,
                        },
                    },
                    "4.25": {
                        "periodfrac": 0.0429449,
                        "P_bin": 0.86724,
                        "normed_bin_frac_p_dist": 0.09064,
                        "normed_tripquad_frac_p_dist": 0.0672,
                        "q": {
                            "0.15": 0.0843078,
                            "0.25": 0.113456,
                            "0.35": 0.116461,
                            "0.45": 0.107063,
                            "0.55": 0.100824,
                            "0.65": 0.0964254,
                            "0.75": 0.0932022,
                            "0.85": 0.125493,
                            "0.95": 0.162768,
                        },
                        "e": {
                            "0.05": 0.0563761,
                            "0.15": 0.085828,
                            "0.25": 0.102429,
                            "0.35": 0.114957,
                            "0.45": 0.125274,
                            "0.55": 0.133513,
                            "0.65": 0.135029,
                            "0.75": 0.131961,
                            "0.85": 0.086745,
                            "0.95": 0.0278885,
                        },
                    },
                    "4.75": {
                        "periodfrac": 0.0449846,
                        "P_bin": 0.833107,
                        "normed_bin_frac_p_dist": 0.09121,
                        "normed_tripquad_frac_p_dist": 0.0885,
                        "q": {
                            "0.15": 0.0855673,
                            "0.25": 0.115151,
                            "0.35": 0.118201,
                            "0.45": 0.108662,
                            "0.55": 0.10233,
                            "0.65": 0.097866,
                            "0.75": 0.0945944,
                            "0.85": 0.123112,
                            "0.95": 0.154517,
                        },
                        "e": {
                            "0.05": 0.0537433,
                            "0.15": 0.0839551,
                            "0.25": 0.101361,
                            "0.35": 0.114626,
                            "0.45": 0.125623,
                            "0.55": 0.134449,
                            "0.65": 0.136076,
                            "0.75": 0.133203,
                            "0.85": 0.088098,
                            "0.95": 0.0288651,
                        },
                    },
                    "5.25": {
                        "periodfrac": 0.0463467,
                        "P_bin": 0.796894,
                        "normed_bin_frac_p_dist": 0.08989,
                        "normed_tripquad_frac_p_dist": 0.111,
                        "q": {
                            "0.15": 0.0871982,
                            "0.25": 0.117346,
                            "0.35": 0.120453,
                            "0.45": 0.110733,
                            "0.55": 0.104281,
                            "0.65": 0.0997312,
                            "0.75": 0.0963973,
                            "0.85": 0.120029,
                            "0.95": 0.143832,
                        },
                        "e": {
                            "0.05": 0.0517855,
                            "0.15": 0.0825411,
                            "0.25": 0.100565,
                            "0.35": 0.114409,
                            "0.45": 0.125945,
                            "0.55": 0.135239,
                            "0.65": 0.136956,
                            "0.75": 0.134167,
                            "0.85": 0.0889851,
                            "0.95": 0.0294067,
                        },
                    },
                    "5.75": {
                        "periodfrac": 0.0446918,
                        "P_bin": 0.75877,
                        "normed_bin_frac_p_dist": 0.08253,
                        "normed_tripquad_frac_p_dist": 0.1271,
                        "q": {
                            "0.15": 0.0911132,
                            "0.25": 0.122614,
                            "0.35": 0.125032,
                            "0.45": 0.113635,
                            "0.55": 0.106044,
                            "0.65": 0.100655,
                            "0.75": 0.0966634,
                            "0.85": 0.114417,
                            "0.95": 0.129827,
                        },
                        "e": {
                            "0.05": 0.0502699,
                            "0.15": 0.0814303,
                            "0.25": 0.099944,
                            "0.35": 0.114252,
                            "0.45": 0.126226,
                            "0.55": 0.135904,
                            "0.65": 0.137694,
                            "0.75": 0.134937,
                            "0.85": 0.0896122,
                            "0.95": 0.0297304,
                        },
                    },
                    "6.25": {
                        "periodfrac": 0.03946,
                        "P_bin": 0.718867,
                        "normed_bin_frac_p_dist": 0.06904,
                        "normed_tripquad_frac_p_dist": 0.1308,
                        "q": {
                            "0.15": 0.0995671,
                            "0.25": 0.133991,
                            "0.35": 0.13396,
                            "0.45": 0.117639,
                            "0.55": 0.106824,
                            "0.65": 0.0991218,
                            "0.75": 0.0933625,
                            "0.85": 0.104279,
                            "0.95": 0.111257,
                        },
                        "e": {
                            "0.05": 0.0490604,
                            "0.15": 0.0805314,
                            "0.25": 0.0994411,
                            "0.35": 0.114131,
                            "0.45": 0.126467,
                            "0.55": 0.136463,
                            "0.65": 0.138314,
                            "0.75": 0.135567,
                            "0.85": 0.0900846,
                            "0.95": 0.0299411,
                        },
                    },
                    "6.75": {
                        "periodfrac": 0.0342086,
                        "P_bin": 0.677292,
                        "normed_bin_frac_p_dist": 0.05639,
                        "normed_tripquad_frac_p_dist": 0.1301,
                        "q": {
                            "0.15": 0.10834,
                            "0.25": 0.145797,
                            "0.35": 0.14293,
                            "0.45": 0.121272,
                            "0.55": 0.107155,
                            "0.65": 0.0971981,
                            "0.75": 0.0897915,
                            "0.85": 0.0942432,
                            "0.95": 0.0932743,
                        },
                        "e": {
                            "0.05": 0.0480717,
                            "0.15": 0.0797869,
                            "0.25": 0.0990233,
                            "0.35": 0.114031,
                            "0.45": 0.126672,
                            "0.55": 0.136936,
                            "0.65": 0.138838,
                            "0.75": 0.136092,
                            "0.85": 0.0904586,
                            "0.95": 0.0300905,
                        },
                    },
                    "7.25": {
                        "periodfrac": 0.0291026,
                        "P_bin": 0.634135,
                        "normed_bin_frac_p_dist": 0.04492,
                        "normed_tripquad_frac_p_dist": 0.1255,
                        "q": {
                            "0.15": 0.117386,
                            "0.25": 0.157971,
                            "0.35": 0.151873,
                            "0.45": 0.124497,
                            "0.55": 0.107036,
                            "0.65": 0.0949114,
                            "0.75": 0.0859935,
                            "0.85": 0.0843732,
                            "0.95": 0.075958,
                        },
                        "e": {
                            "0.05": 0.0472479,
                            "0.15": 0.0791591,
                            "0.25": 0.0986693,
                            "0.35": 0.113946,
                            "0.45": 0.126846,
                            "0.55": 0.13734,
                            "0.65": 0.139286,
                            "0.75": 0.136535,
                            "0.85": 0.0907653,
                            "0.95": 0.0302046,
                        },
                    },
                    "7.75": {
                        "periodfrac": 0.0243564,
                        "P_bin": 0.589469,
                        "normed_bin_frac_p_dist": 0.03494,
                        "normed_tripquad_frac_p_dist": 0.1179,
                        "q": {
                            "0.15": 0.126657,
                            "0.25": 0.170446,
                            "0.35": 0.160723,
                            "0.45": 0.127283,
                            "0.55": 0.106476,
                            "0.65": 0.0922945,
                            "0.75": 0.0820138,
                            "0.85": 0.0747305,
                            "0.95": 0.0593761,
                        },
                        "e": {
                            "0.05": 0.0465507,
                            "0.15": 0.0786221,
                            "0.25": 0.0983648,
                            "0.35": 0.113873,
                            "0.45": 0.126996,
                            "0.55": 0.137687,
                            "0.65": 0.139672,
                            "0.75": 0.136916,
                            "0.85": 0.0910235,
                            "0.95": 0.0302959,
                        },
                    },
                },
            },
            "0.0": {
                "f_multi": 0.5328,
                "multi system fraction": 0.4385,
                "binary star fraction": 0.3914,
                "triple/quad star fraction": 0.0471,
                "single star fraction": 0.5615,
                "poisson_model": {
                    "single_fraction": 0.588,
                    "binary_fraction": 0.313,
                    "triple_fraction": 0.0835,
                    "quadruple_fraction": 0.0148,
                },
                "logP": {
                    "0.25": {
                        "periodfrac": 0.0113839,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.02596,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0919084,
                            "0.25": 0.113372,
                            "0.35": 0.117173,
                            "0.45": 0.103229,
                            "0.55": 0.0933255,
                            "0.65": 0.0858212,
                            "0.75": 0.07988,
                            "0.85": 0.118919,
                            "0.95": 0.196372,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "0.75": {
                        "periodfrac": 0.0139543,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.03182,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0919084,
                            "0.25": 0.113372,
                            "0.35": 0.117173,
                            "0.45": 0.103229,
                            "0.55": 0.0933255,
                            "0.65": 0.0858212,
                            "0.75": 0.07988,
                            "0.85": 0.118919,
                            "0.95": 0.196372,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.25": {
                        "periodfrac": 0.016745,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.03818,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0921513,
                            "0.25": 0.113671,
                            "0.35": 0.117483,
                            "0.45": 0.103502,
                            "0.55": 0.0935721,
                            "0.65": 0.0860479,
                            "0.75": 0.0800912,
                            "0.85": 0.118548,
                            "0.95": 0.194933,
                        },
                        "e": {
                            "0.05": 0.330824,
                            "0.15": 0.165642,
                            "0.25": 0.129153,
                            "0.35": 0.110009,
                            "0.45": 0.100964,
                            "0.55": 0.0990032,
                            "0.65": 0.057533,
                            "0.75": 0.00687094,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.75": {
                        "periodfrac": 0.0205272,
                        "P_bin": 0.994069,
                        "normed_bin_frac_p_dist": 0.04653,
                        "normed_tripquad_frac_p_dist": 0.001291,
                        "q": {
                            "0.15": 0.0928664,
                            "0.25": 0.114553,
                            "0.35": 0.118394,
                            "0.45": 0.104305,
                            "0.55": 0.0942982,
                            "0.65": 0.0867158,
                            "0.75": 0.0807125,
                            "0.85": 0.117456,
                            "0.95": 0.190698,
                        },
                        "e": {
                            "0.05": 0.14167,
                            "0.15": 0.131895,
                            "0.25": 0.12826,
                            "0.35": 0.125956,
                            "0.45": 0.12427,
                            "0.55": 0.123559,
                            "0.65": 0.12234,
                            "0.75": 0.0809714,
                            "0.85": 0.0210788,
                            "0.95": 0.0,
                        },
                    },
                    "2.25": {
                        "periodfrac": 0.0254716,
                        "P_bin": 0.976538,
                        "normed_bin_frac_p_dist": 0.05672,
                        "normed_tripquad_frac_p_dist": 0.006339,
                        "q": {
                            "0.15": 0.0937391,
                            "0.25": 0.11563,
                            "0.35": 0.119507,
                            "0.45": 0.105286,
                            "0.55": 0.0951843,
                            "0.65": 0.0875306,
                            "0.75": 0.0814712,
                            "0.85": 0.116123,
                            "0.95": 0.185529,
                        },
                        "e": {
                            "0.05": 0.0944499,
                            "0.15": 0.110031,
                            "0.25": 0.117032,
                            "0.35": 0.121823,
                            "0.45": 0.125515,
                            "0.55": 0.127863,
                            "0.65": 0.127994,
                            "0.75": 0.112768,
                            "0.85": 0.0563073,
                            "0.95": 0.00621564,
                        },
                    },
                    "2.75": {
                        "periodfrac": 0.0315933,
                        "P_bin": 0.953627,
                        "normed_bin_frac_p_dist": 0.0687,
                        "normed_tripquad_frac_p_dist": 0.01554,
                        "q": {
                            "0.15": 0.0947737,
                            "0.25": 0.116906,
                            "0.35": 0.120826,
                            "0.45": 0.106448,
                            "0.55": 0.0962349,
                            "0.65": 0.0884966,
                            "0.75": 0.0823703,
                            "0.85": 0.114544,
                            "0.95": 0.179401,
                        },
                        "e": {
                            "0.05": 0.0754871,
                            "0.15": 0.0987081,
                            "0.25": 0.110213,
                            "0.35": 0.118419,
                            "0.45": 0.12492,
                            "0.55": 0.129746,
                            "0.65": 0.13039,
                            "0.75": 0.123258,
                            "0.85": 0.0725423,
                            "0.95": 0.0163158,
                        },
                    },
                    "3.25": {
                        "periodfrac": 0.0374044,
                        "P_bin": 0.92691,
                        "normed_bin_frac_p_dist": 0.07906,
                        "normed_tripquad_frac_p_dist": 0.029,
                        "q": {
                            "0.15": 0.0959733,
                            "0.25": 0.118386,
                            "0.35": 0.122355,
                            "0.45": 0.107795,
                            "0.55": 0.0974529,
                            "0.65": 0.0896168,
                            "0.75": 0.083413,
                            "0.85": 0.112712,
                            "0.95": 0.172296,
                        },
                        "e": {
                            "0.05": 0.0657833,
                            "0.15": 0.0922986,
                            "0.25": 0.106244,
                            "0.35": 0.116451,
                            "0.45": 0.124683,
                            "0.55": 0.131158,
                            "0.65": 0.132341,
                            "0.75": 0.127869,
                            "0.85": 0.0804725,
                            "0.95": 0.0226993,
                        },
                    },
                    "3.75": {
                        "periodfrac": 0.0420017,
                        "P_bin": 0.897126,
                        "normed_bin_frac_p_dist": 0.08592,
                        "normed_tripquad_frac_p_dist": 0.04583,
                        "q": {
                            "0.15": 0.0973406,
                            "0.25": 0.120072,
                            "0.35": 0.124099,
                            "0.45": 0.109331,
                            "0.55": 0.0988415,
                            "0.65": 0.0908936,
                            "0.75": 0.0846013,
                            "0.85": 0.110624,
                            "0.95": 0.164197,
                        },
                        "e": {
                            "0.05": 0.0601091,
                            "0.15": 0.0884375,
                            "0.25": 0.103949,
                            "0.35": 0.115505,
                            "0.45": 0.124938,
                            "0.55": 0.132423,
                            "0.65": 0.133797,
                            "0.75": 0.13029,
                            "0.85": 0.0845054,
                            "0.95": 0.0260463,
                        },
                    },
                    "4.25": {
                        "periodfrac": 0.0454674,
                        "P_bin": 0.864722,
                        "normed_bin_frac_p_dist": 0.08965,
                        "normed_tripquad_frac_p_dist": 0.06524,
                        "q": {
                            "0.15": 0.0988777,
                            "0.25": 0.121968,
                            "0.35": 0.126058,
                            "0.45": 0.111057,
                            "0.55": 0.100402,
                            "0.65": 0.0923287,
                            "0.75": 0.0859372,
                            "0.85": 0.108277,
                            "0.95": 0.155093,
                        },
                        "e": {
                            "0.05": 0.0563761,
                            "0.15": 0.085828,
                            "0.25": 0.102429,
                            "0.35": 0.114957,
                            "0.45": 0.125274,
                            "0.55": 0.133513,
                            "0.65": 0.135029,
                            "0.75": 0.131961,
                            "0.85": 0.086745,
                            "0.95": 0.0278885,
                        },
                    },
                    "4.75": {
                        "periodfrac": 0.0480946,
                        "P_bin": 0.830008,
                        "normed_bin_frac_p_dist": 0.09103,
                        "normed_tripquad_frac_p_dist": 0.08672,
                        "q": {
                            "0.15": 0.10086,
                            "0.25": 0.124413,
                            "0.35": 0.128585,
                            "0.45": 0.113283,
                            "0.55": 0.102415,
                            "0.65": 0.0941795,
                            "0.75": 0.0876597,
                            "0.85": 0.105251,
                            "0.95": 0.143354,
                        },
                        "e": {
                            "0.05": 0.0537433,
                            "0.15": 0.0839551,
                            "0.25": 0.101361,
                            "0.35": 0.114626,
                            "0.45": 0.125623,
                            "0.55": 0.134449,
                            "0.65": 0.136076,
                            "0.75": 0.133203,
                            "0.85": 0.088098,
                            "0.95": 0.0288651,
                        },
                    },
                    "5.25": {
                        "periodfrac": 0.0502072,
                        "P_bin": 0.793211,
                        "normed_bin_frac_p_dist": 0.09081,
                        "normed_tripquad_frac_p_dist": 0.1101,
                        "q": {
                            "0.15": 0.106203,
                            "0.25": 0.131004,
                            "0.35": 0.134208,
                            "0.45": 0.116448,
                            "0.55": 0.104007,
                            "0.65": 0.0946849,
                            "0.75": 0.0873739,
                            "0.85": 0.099104,
                            "0.95": 0.126969,
                        },
                        "e": {
                            "0.05": 0.0517855,
                            "0.15": 0.0825411,
                            "0.25": 0.100565,
                            "0.35": 0.114409,
                            "0.45": 0.125945,
                            "0.55": 0.135239,
                            "0.65": 0.136956,
                            "0.75": 0.134167,
                            "0.85": 0.0889851,
                            "0.95": 0.0294067,
                        },
                    },
                    "5.75": {
                        "periodfrac": 0.0488465,
                        "P_bin": 0.754507,
                        "normed_bin_frac_p_dist": 0.08404,
                        "normed_tripquad_frac_p_dist": 0.1272,
                        "q": {
                            "0.15": 0.116552,
                            "0.25": 0.14377,
                            "0.35": 0.144092,
                            "0.45": 0.120341,
                            "0.55": 0.104272,
                            "0.65": 0.0925648,
                            "0.75": 0.0835963,
                            "0.85": 0.0888351,
                            "0.95": 0.105977,
                        },
                        "e": {
                            "0.05": 0.0502699,
                            "0.15": 0.0814303,
                            "0.25": 0.099944,
                            "0.35": 0.114252,
                            "0.45": 0.126226,
                            "0.55": 0.135904,
                            "0.65": 0.137694,
                            "0.75": 0.134937,
                            "0.85": 0.0896122,
                            "0.95": 0.0297304,
                        },
                    },
                    "6.25": {
                        "periodfrac": 0.0432827,
                        "P_bin": 0.714041,
                        "normed_bin_frac_p_dist": 0.07047,
                        "normed_tripquad_frac_p_dist": 0.1313,
                        "q": {
                            "0.15": 0.127222,
                            "0.25": 0.156931,
                            "0.35": 0.153895,
                            "0.45": 0.123707,
                            "0.55": 0.103982,
                            "0.65": 0.0900093,
                            "0.75": 0.0795545,
                            "0.85": 0.0787777,
                            "0.95": 0.0859211,
                        },
                        "e": {
                            "0.05": 0.0490604,
                            "0.15": 0.0805314,
                            "0.25": 0.0994411,
                            "0.35": 0.114131,
                            "0.45": 0.126467,
                            "0.55": 0.136463,
                            "0.65": 0.138314,
                            "0.75": 0.135567,
                            "0.85": 0.0900846,
                            "0.95": 0.0299411,
                        },
                    },
                    "6.75": {
                        "periodfrac": 0.0377923,
                        "P_bin": 0.671928,
                        "normed_bin_frac_p_dist": 0.05791,
                        "normed_tripquad_frac_p_dist": 0.1315,
                        "q": {
                            "0.15": 0.138135,
                            "0.25": 0.170394,
                            "0.35": 0.163524,
                            "0.45": 0.126508,
                            "0.55": 0.103153,
                            "0.65": 0.0870662,
                            "0.75": 0.0753111,
                            "0.85": 0.0690109,
                            "0.95": 0.0668977,
                        },
                        "e": {
                            "0.05": 0.0480717,
                            "0.15": 0.0797869,
                            "0.25": 0.0990233,
                            "0.35": 0.114031,
                            "0.45": 0.126672,
                            "0.55": 0.136936,
                            "0.65": 0.138838,
                            "0.75": 0.136092,
                            "0.85": 0.0904586,
                            "0.95": 0.0300905,
                        },
                    },
                    "7.25": {
                        "periodfrac": 0.0324921,
                        "P_bin": 0.628268,
                        "normed_bin_frac_p_dist": 0.04655,
                        "normed_tripquad_frac_p_dist": 0.1281,
                        "q": {
                            "0.15": 0.148234,
                            "0.25": 0.18285,
                            "0.35": 0.171754,
                            "0.45": 0.127875,
                            "0.55": 0.101141,
                            "0.65": 0.0832402,
                            "0.75": 0.0704637,
                            "0.85": 0.0609157,
                            "0.95": 0.0535263,
                        },
                        "e": {
                            "0.05": 0.0472479,
                            "0.15": 0.0791591,
                            "0.25": 0.0986693,
                            "0.35": 0.113946,
                            "0.45": 0.126846,
                            "0.55": 0.13734,
                            "0.65": 0.139286,
                            "0.75": 0.136535,
                            "0.85": 0.0907653,
                            "0.95": 0.0302046,
                        },
                    },
                    "7.75": {
                        "periodfrac": 0.02755,
                        "P_bin": 0.583145,
                        "normed_bin_frac_p_dist": 0.03663,
                        "normed_tripquad_frac_p_dist": 0.1218,
                        "q": {
                            "0.15": 0.156884,
                            "0.25": 0.19352,
                            "0.35": 0.177947,
                            "0.45": 0.127491,
                            "0.55": 0.0978119,
                            "0.65": 0.0784915,
                            "0.75": 0.0650248,
                            "0.85": 0.0551633,
                            "0.95": 0.0476668,
                        },
                        "e": {
                            "0.05": 0.0465507,
                            "0.15": 0.0786221,
                            "0.25": 0.0983648,
                            "0.35": 0.113873,
                            "0.45": 0.126996,
                            "0.55": 0.137687,
                            "0.65": 0.139672,
                            "0.75": 0.136916,
                            "0.85": 0.0910235,
                            "0.95": 0.0302959,
                        },
                    },
                },
            },
            "0.1": {
                "f_multi": 0.5582,
                "multi system fraction": 0.4504,
                "binary star fraction": 0.3965,
                "triple/quad star fraction": 0.0539,
                "single star fraction": 0.5496,
                "poisson_model": {
                    "single_fraction": 0.574,
                    "binary_fraction": 0.32,
                    "triple_fraction": 0.0894,
                    "quadruple_fraction": 0.0166,
                },
                "logP": {
                    "0.25": {
                        "periodfrac": 0.0142215,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.03157,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0925364,
                            "0.25": 0.113883,
                            "0.35": 0.117604,
                            "0.45": 0.103609,
                            "0.55": 0.0936687,
                            "0.65": 0.0861367,
                            "0.75": 0.0801739,
                            "0.85": 0.118303,
                            "0.95": 0.194085,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "0.75": {
                        "periodfrac": 0.0169053,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.03753,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0925364,
                            "0.25": 0.113883,
                            "0.35": 0.117604,
                            "0.45": 0.103609,
                            "0.55": 0.0936687,
                            "0.65": 0.0861367,
                            "0.75": 0.0801739,
                            "0.85": 0.118303,
                            "0.95": 0.194085,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.25": {
                        "periodfrac": 0.019633,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.04359,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.092902,
                            "0.25": 0.114333,
                            "0.35": 0.118038,
                            "0.45": 0.103944,
                            "0.55": 0.0939372,
                            "0.65": 0.0863577,
                            "0.75": 0.0803588,
                            "0.85": 0.117799,
                            "0.95": 0.192331,
                        },
                        "e": {
                            "0.05": 0.330824,
                            "0.15": 0.165642,
                            "0.25": 0.129153,
                            "0.35": 0.110009,
                            "0.45": 0.100964,
                            "0.55": 0.0990032,
                            "0.65": 0.057533,
                            "0.75": 0.00687094,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.75": {
                        "periodfrac": 0.0236514,
                        "P_bin": 0.993299,
                        "normed_bin_frac_p_dist": 0.05216,
                        "normed_tripquad_frac_p_dist": 0.001471,
                        "q": {
                            "0.15": 0.0939266,
                            "0.25": 0.115594,
                            "0.35": 0.119261,
                            "0.45": 0.104901,
                            "0.55": 0.094717,
                            "0.65": 0.0870091,
                            "0.75": 0.0809129,
                            "0.85": 0.116372,
                            "0.95": 0.187306,
                        },
                        "e": {
                            "0.05": 0.14167,
                            "0.15": 0.131895,
                            "0.25": 0.12826,
                            "0.35": 0.125956,
                            "0.45": 0.12427,
                            "0.55": 0.123559,
                            "0.65": 0.12234,
                            "0.75": 0.0809714,
                            "0.85": 0.0210788,
                            "0.95": 0.0,
                        },
                    },
                    "2.25": {
                        "periodfrac": 0.0286704,
                        "P_bin": 0.973493,
                        "normed_bin_frac_p_dist": 0.06197,
                        "normed_tripquad_frac_p_dist": 0.007052,
                        "q": {
                            "0.15": 0.0951131,
                            "0.25": 0.117054,
                            "0.35": 0.120688,
                            "0.45": 0.106036,
                            "0.55": 0.0956546,
                            "0.65": 0.0878045,
                            "0.75": 0.0816001,
                            "0.85": 0.114702,
                            "0.95": 0.181348,
                        },
                        "e": {
                            "0.05": 0.0944499,
                            "0.15": 0.110031,
                            "0.25": 0.117032,
                            "0.35": 0.121823,
                            "0.45": 0.125515,
                            "0.55": 0.127863,
                            "0.65": 0.127994,
                            "0.75": 0.112768,
                            "0.85": 0.0563073,
                            "0.95": 0.00621564,
                        },
                    },
                    "2.75": {
                        "periodfrac": 0.0347509,
                        "P_bin": 0.947608,
                        "normed_bin_frac_p_dist": 0.07311,
                        "normed_tripquad_frac_p_dist": 0.01689,
                        "q": {
                            "0.15": 0.0966243,
                            "0.25": 0.118749,
                            "0.35": 0.122294,
                            "0.45": 0.107325,
                            "0.55": 0.0967299,
                            "0.65": 0.0887249,
                            "0.75": 0.0824023,
                            "0.85": 0.112756,
                            "0.95": 0.174395,
                        },
                        "e": {
                            "0.05": 0.0754871,
                            "0.15": 0.0987081,
                            "0.25": 0.110213,
                            "0.35": 0.118419,
                            "0.45": 0.12492,
                            "0.55": 0.129746,
                            "0.65": 0.13039,
                            "0.75": 0.123258,
                            "0.85": 0.0725423,
                            "0.95": 0.0163158,
                        },
                    },
                    "3.25": {
                        "periodfrac": 0.0405586,
                        "P_bin": 0.917423,
                        "normed_bin_frac_p_dist": 0.08261,
                        "normed_tripquad_frac_p_dist": 0.03108,
                        "q": {
                            "0.15": 0.0985518,
                            "0.25": 0.120699,
                            "0.35": 0.124066,
                            "0.45": 0.108756,
                            "0.55": 0.0979311,
                            "0.65": 0.089759,
                            "0.75": 0.0833092,
                            "0.85": 0.110515,
                            "0.95": 0.166413,
                        },
                        "e": {
                            "0.05": 0.0657833,
                            "0.15": 0.0922986,
                            "0.25": 0.106244,
                            "0.35": 0.116451,
                            "0.45": 0.124683,
                            "0.55": 0.131158,
                            "0.65": 0.132341,
                            "0.75": 0.127869,
                            "0.85": 0.0804725,
                            "0.95": 0.0226993,
                        },
                    },
                    "3.75": {
                        "periodfrac": 0.0443595,
                        "P_bin": 0.883773,
                        "normed_bin_frac_p_dist": 0.08704,
                        "normed_tripquad_frac_p_dist": 0.04784,
                        "q": {
                            "0.15": 0.100666,
                            "0.25": 0.122861,
                            "0.35": 0.126048,
                            "0.45": 0.110368,
                            "0.55": 0.0992929,
                            "0.65": 0.090939,
                            "0.75": 0.08435,
                            "0.85": 0.108017,
                            "0.95": 0.157457,
                        },
                        "e": {
                            "0.05": 0.0601091,
                            "0.15": 0.0884375,
                            "0.25": 0.103949,
                            "0.35": 0.115505,
                            "0.45": 0.124938,
                            "0.55": 0.132423,
                            "0.65": 0.133797,
                            "0.75": 0.13029,
                            "0.85": 0.0845054,
                            "0.95": 0.0260463,
                        },
                    },
                    "4.25": {
                        "periodfrac": 0.0467016,
                        "P_bin": 0.847164,
                        "normed_bin_frac_p_dist": 0.08784,
                        "normed_tripquad_frac_p_dist": 0.06623,
                        "q": {
                            "0.15": 0.103049,
                            "0.25": 0.125335,
                            "0.35": 0.128342,
                            "0.45": 0.112249,
                            "0.55": 0.100893,
                            "0.65": 0.0923351,
                            "0.75": 0.0855901,
                            "0.85": 0.105141,
                            "0.95": 0.147065,
                        },
                        "e": {
                            "0.05": 0.0563761,
                            "0.15": 0.085828,
                            "0.25": 0.102429,
                            "0.35": 0.114957,
                            "0.45": 0.125274,
                            "0.55": 0.133513,
                            "0.65": 0.135029,
                            "0.75": 0.131961,
                            "0.85": 0.086745,
                            "0.95": 0.0278885,
                        },
                    },
                    "4.75": {
                        "periodfrac": 0.0484531,
                        "P_bin": 0.807944,
                        "normed_bin_frac_p_dist": 0.08692,
                        "normed_tripquad_frac_p_dist": 0.08635,
                        "q": {
                            "0.15": 0.106039,
                            "0.25": 0.128524,
                            "0.35": 0.131322,
                            "0.45": 0.114673,
                            "0.55": 0.102941,
                            "0.65": 0.0941104,
                            "0.75": 0.0871572,
                            "0.85": 0.10145,
                            "0.95": 0.133783,
                        },
                        "e": {
                            "0.05": 0.0537433,
                            "0.15": 0.0839551,
                            "0.25": 0.101361,
                            "0.35": 0.114626,
                            "0.45": 0.125623,
                            "0.55": 0.134449,
                            "0.65": 0.136076,
                            "0.75": 0.133203,
                            "0.85": 0.088098,
                            "0.95": 0.0288651,
                        },
                    },
                    "5.25": {
                        "periodfrac": 0.0499774,
                        "P_bin": 0.76637,
                        "normed_bin_frac_p_dist": 0.08504,
                        "normed_tripquad_frac_p_dist": 0.1083,
                        "q": {
                            "0.15": 0.112306,
                            "0.25": 0.135649,
                            "0.35": 0.137091,
                            "0.45": 0.117709,
                            "0.55": 0.104261,
                            "0.65": 0.0942621,
                            "0.75": 0.0864707,
                            "0.85": 0.0949849,
                            "0.95": 0.117267,
                        },
                        "e": {
                            "0.05": 0.0517855,
                            "0.15": 0.0825411,
                            "0.25": 0.100565,
                            "0.35": 0.114409,
                            "0.45": 0.125945,
                            "0.55": 0.135239,
                            "0.65": 0.136956,
                            "0.75": 0.134167,
                            "0.85": 0.0889851,
                            "0.95": 0.0294067,
                        },
                    },
                    "5.75": {
                        "periodfrac": 0.0484371,
                        "P_bin": 0.722643,
                        "normed_bin_frac_p_dist": 0.07771,
                        "normed_tripquad_frac_p_dist": 0.1247,
                        "q": {
                            "0.15": 0.123512,
                            "0.25": 0.148736,
                            "0.35": 0.146856,
                            "0.45": 0.1213,
                            "0.55": 0.104183,
                            "0.65": 0.0918129,
                            "0.75": 0.0824013,
                            "0.85": 0.0846391,
                            "0.95": 0.0965601,
                        },
                        "e": {
                            "0.05": 0.0502699,
                            "0.15": 0.0814303,
                            "0.25": 0.099944,
                            "0.35": 0.114252,
                            "0.45": 0.126226,
                            "0.55": 0.135904,
                            "0.65": 0.137694,
                            "0.75": 0.134937,
                            "0.85": 0.0896122,
                            "0.95": 0.0297304,
                        },
                    },
                    "6.25": {
                        "periodfrac": 0.0430633,
                        "P_bin": 0.676924,
                        "normed_bin_frac_p_dist": 0.06472,
                        "normed_tripquad_frac_p_dist": 0.1291,
                        "q": {
                            "0.15": 0.134972,
                            "0.25": 0.162161,
                            "0.35": 0.15649,
                            "0.45": 0.124335,
                            "0.55": 0.103547,
                            "0.65": 0.0889468,
                            "0.75": 0.0781008,
                            "0.85": 0.0745634,
                            "0.95": 0.0768828,
                        },
                        "e": {
                            "0.05": 0.0490604,
                            "0.15": 0.0805314,
                            "0.25": 0.0994411,
                            "0.35": 0.114131,
                            "0.45": 0.126467,
                            "0.55": 0.136463,
                            "0.65": 0.138314,
                            "0.75": 0.135567,
                            "0.85": 0.0900846,
                            "0.95": 0.0299411,
                        },
                    },
                    "6.75": {
                        "periodfrac": 0.0378522,
                        "P_bin": 0.629345,
                        "normed_bin_frac_p_dist": 0.05289,
                        "normed_tripquad_frac_p_dist": 0.1302,
                        "q": {
                            "0.15": 0.146482,
                            "0.25": 0.175582,
                            "0.35": 0.165721,
                            "0.45": 0.126763,
                            "0.55": 0.102435,
                            "0.65": 0.0858179,
                            "0.75": 0.0737594,
                            "0.85": 0.0649722,
                            "0.95": 0.0584673,
                        },
                        "e": {
                            "0.05": 0.0480717,
                            "0.15": 0.0797869,
                            "0.25": 0.0990233,
                            "0.35": 0.114031,
                            "0.45": 0.126672,
                            "0.55": 0.136936,
                            "0.65": 0.138838,
                            "0.75": 0.136092,
                            "0.85": 0.0904586,
                            "0.95": 0.0300905,
                        },
                    },
                    "7.25": {
                        "periodfrac": 0.0327884,
                        "P_bin": 0.580018,
                        "normed_bin_frac_p_dist": 0.04222,
                        "normed_tripquad_frac_p_dist": 0.1278,
                        "q": {
                            "0.15": 0.155547,
                            "0.25": 0.186017,
                            "0.35": 0.171871,
                            "0.45": 0.126736,
                            "0.55": 0.0994775,
                            "0.65": 0.0813539,
                            "0.75": 0.0684953,
                            "0.85": 0.0589345,
                            "0.95": 0.0515685,
                        },
                        "e": {
                            "0.05": 0.0472479,
                            "0.15": 0.0791591,
                            "0.25": 0.0986693,
                            "0.35": 0.113946,
                            "0.45": 0.126846,
                            "0.55": 0.13734,
                            "0.65": 0.139286,
                            "0.75": 0.136535,
                            "0.85": 0.0907653,
                            "0.95": 0.0302046,
                        },
                    },
                    "7.75": {
                        "periodfrac": 0.0281551,
                        "P_bin": 0.529039,
                        "normed_bin_frac_p_dist": 0.03307,
                        "normed_tripquad_frac_p_dist": 0.123,
                        "q": {
                            "0.15": 0.164412,
                            "0.25": 0.196164,
                            "0.35": 0.177456,
                            "0.45": 0.126136,
                            "0.55": 0.0961663,
                            "0.65": 0.0767702,
                            "0.75": 0.0633163,
                            "0.85": 0.0535054,
                            "0.95": 0.046075,
                        },
                        "e": {
                            "0.05": 0.0465507,
                            "0.15": 0.0786221,
                            "0.25": 0.0983648,
                            "0.35": 0.113873,
                            "0.45": 0.126996,
                            "0.55": 0.137687,
                            "0.65": 0.139672,
                            "0.75": 0.136916,
                            "0.85": 0.0910235,
                            "0.95": 0.0302959,
                        },
                    },
                },
            },
            "0.2": {
                "f_multi": 0.5985,
                "multi system fraction": 0.4711,
                "binary star fraction": 0.4075,
                "triple/quad star fraction": 0.0637,
                "single star fraction": 0.5289,
                "poisson_model": {
                    "single_fraction": 0.551,
                    "binary_fraction": 0.33,
                    "triple_fraction": 0.0988,
                    "quadruple_fraction": 0.0197,
                },
                "logP": {
                    "0.25": {
                        "periodfrac": 0.0175951,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.03735,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0942033,
                            "0.25": 0.114655,
                            "0.35": 0.11793,
                            "0.45": 0.103896,
                            "0.55": 0.0939284,
                            "0.65": 0.0863754,
                            "0.75": 0.080396,
                            "0.85": 0.117429,
                            "0.95": 0.191188,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "0.75": {
                        "periodfrac": 0.0204537,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.04341,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0942033,
                            "0.25": 0.114655,
                            "0.35": 0.11793,
                            "0.45": 0.103896,
                            "0.55": 0.0939284,
                            "0.65": 0.0863754,
                            "0.75": 0.080396,
                            "0.85": 0.117429,
                            "0.95": 0.191188,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.25": {
                        "periodfrac": 0.0229392,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.04869,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0950387,
                            "0.25": 0.115671,
                            "0.35": 0.118794,
                            "0.45": 0.104381,
                            "0.55": 0.0941688,
                            "0.65": 0.0864457,
                            "0.75": 0.0803415,
                            "0.85": 0.116479,
                            "0.95": 0.188679,
                        },
                        "e": {
                            "0.05": 0.330824,
                            "0.15": 0.165642,
                            "0.25": 0.129153,
                            "0.35": 0.110009,
                            "0.45": 0.100964,
                            "0.55": 0.0990032,
                            "0.65": 0.057533,
                            "0.75": 0.00687094,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.75": {
                        "periodfrac": 0.0270067,
                        "P_bin": 0.99243,
                        "normed_bin_frac_p_dist": 0.05689,
                        "normed_tripquad_frac_p_dist": 0.001606,
                        "q": {
                            "0.15": 0.0972572,
                            "0.25": 0.118372,
                            "0.35": 0.121104,
                            "0.45": 0.10571,
                            "0.55": 0.0948679,
                            "0.65": 0.0867084,
                            "0.75": 0.0802853,
                            "0.85": 0.113932,
                            "0.95": 0.181764,
                        },
                        "e": {
                            "0.05": 0.14167,
                            "0.15": 0.131895,
                            "0.25": 0.12826,
                            "0.35": 0.125956,
                            "0.45": 0.12427,
                            "0.55": 0.123559,
                            "0.65": 0.12234,
                            "0.75": 0.0809714,
                            "0.85": 0.0210788,
                            "0.95": 0.0,
                        },
                    },
                    "2.25": {
                        "periodfrac": 0.0320537,
                        "P_bin": 0.970052,
                        "normed_bin_frac_p_dist": 0.066,
                        "normed_tripquad_frac_p_dist": 0.00754,
                        "q": {
                            "0.15": 0.0996678,
                            "0.25": 0.121305,
                            "0.35": 0.123632,
                            "0.45": 0.107207,
                            "0.55": 0.0957071,
                            "0.65": 0.0870946,
                            "0.75": 0.0803424,
                            "0.85": 0.111128,
                            "0.95": 0.173916,
                        },
                        "e": {
                            "0.05": 0.0944499,
                            "0.15": 0.110031,
                            "0.25": 0.117032,
                            "0.35": 0.121823,
                            "0.45": 0.125515,
                            "0.55": 0.127863,
                            "0.65": 0.127994,
                            "0.75": 0.112768,
                            "0.85": 0.0563073,
                            "0.95": 0.00621564,
                        },
                    },
                    "2.75": {
                        "periodfrac": 0.0382616,
                        "P_bin": 0.940807,
                        "normed_bin_frac_p_dist": 0.0764,
                        "normed_tripquad_frac_p_dist": 0.01779,
                        "q": {
                            "0.15": 0.10325,
                            "0.25": 0.124657,
                            "0.35": 0.1262,
                            "0.45": 0.108712,
                            "0.55": 0.0965425,
                            "0.65": 0.0874723,
                            "0.75": 0.08039,
                            "0.85": 0.107901,
                            "0.95": 0.164875,
                        },
                        "e": {
                            "0.05": 0.0754871,
                            "0.15": 0.0987081,
                            "0.25": 0.110213,
                            "0.35": 0.118419,
                            "0.45": 0.12492,
                            "0.55": 0.129746,
                            "0.65": 0.13039,
                            "0.75": 0.123258,
                            "0.85": 0.0725423,
                            "0.95": 0.0163158,
                        },
                    },
                    "3.25": {
                        "periodfrac": 0.0443902,
                        "P_bin": 0.906705,
                        "normed_bin_frac_p_dist": 0.08543,
                        "normed_tripquad_frac_p_dist": 0.03253,
                        "q": {
                            "0.15": 0.108615,
                            "0.25": 0.128517,
                            "0.35": 0.128677,
                            "0.45": 0.110116,
                            "0.55": 0.0972764,
                            "0.65": 0.0877535,
                            "0.75": 0.0803479,
                            "0.85": 0.104162,
                            "0.95": 0.154535,
                        },
                        "e": {
                            "0.05": 0.0657833,
                            "0.15": 0.0922986,
                            "0.25": 0.106244,
                            "0.35": 0.116451,
                            "0.45": 0.124683,
                            "0.55": 0.131158,
                            "0.65": 0.132341,
                            "0.75": 0.127869,
                            "0.85": 0.0804725,
                            "0.95": 0.0226993,
                        },
                    },
                    "3.75": {
                        "periodfrac": 0.0475738,
                        "P_bin": 0.868687,
                        "normed_bin_frac_p_dist": 0.08772,
                        "normed_tripquad_frac_p_dist": 0.04907,
                        "q": {
                            "0.15": 0.114371,
                            "0.25": 0.132622,
                            "0.35": 0.131326,
                            "0.45": 0.111642,
                            "0.55": 0.0981074,
                            "0.65": 0.0881175,
                            "0.75": 0.0803807,
                            "0.85": 0.100151,
                            "0.95": 0.143282,
                        },
                        "e": {
                            "0.05": 0.0601091,
                            "0.15": 0.0884375,
                            "0.25": 0.103949,
                            "0.35": 0.115505,
                            "0.45": 0.124938,
                            "0.55": 0.132423,
                            "0.65": 0.133797,
                            "0.75": 0.13029,
                            "0.85": 0.0845054,
                            "0.95": 0.0260463,
                        },
                    },
                    "4.25": {
                        "periodfrac": 0.0488935,
                        "P_bin": 0.827326,
                        "normed_bin_frac_p_dist": 0.08586,
                        "normed_tripquad_frac_p_dist": 0.06632,
                        "q": {
                            "0.15": 0.12093,
                            "0.25": 0.137419,
                            "0.35": 0.134576,
                            "0.45": 0.11365,
                            "0.55": 0.0993486,
                            "0.65": 0.0888436,
                            "0.75": 0.080741,
                            "0.85": 0.0953371,
                            "0.95": 0.129155,
                        },
                        "e": {
                            "0.05": 0.0563761,
                            "0.15": 0.085828,
                            "0.25": 0.102429,
                            "0.35": 0.114957,
                            "0.45": 0.125274,
                            "0.55": 0.133513,
                            "0.65": 0.135029,
                            "0.75": 0.131961,
                            "0.85": 0.086745,
                            "0.95": 0.0278885,
                        },
                    },
                    "4.75": {
                        "periodfrac": 0.0499281,
                        "P_bin": 0.783016,
                        "normed_bin_frac_p_dist": 0.08298,
                        "normed_tripquad_frac_p_dist": 0.0851,
                        "q": {
                            "0.15": 0.128459,
                            "0.25": 0.143044,
                            "0.35": 0.138328,
                            "0.45": 0.115742,
                            "0.55": 0.100435,
                            "0.65": 0.0892678,
                            "0.75": 0.0807035,
                            "0.85": 0.0899153,
                            "0.95": 0.114105,
                        },
                        "e": {
                            "0.05": 0.0537433,
                            "0.15": 0.0839551,
                            "0.25": 0.101361,
                            "0.35": 0.114626,
                            "0.45": 0.125623,
                            "0.55": 0.134449,
                            "0.65": 0.136076,
                            "0.75": 0.133203,
                            "0.85": 0.088098,
                            "0.95": 0.0288651,
                        },
                    },
                    "5.25": {
                        "periodfrac": 0.0511126,
                        "P_bin": 0.736046,
                        "normed_bin_frac_p_dist": 0.07985,
                        "normed_tripquad_frac_p_dist": 0.106,
                        "q": {
                            "0.15": 0.139958,
                            "0.25": 0.152716,
                            "0.35": 0.144562,
                            "0.45": 0.118024,
                            "0.55": 0.100437,
                            "0.65": 0.0878347,
                            "0.75": 0.0783152,
                            "0.85": 0.0818628,
                            "0.95": 0.0962899,
                        },
                        "e": {
                            "0.05": 0.0517855,
                            "0.15": 0.0825411,
                            "0.25": 0.100565,
                            "0.35": 0.114409,
                            "0.45": 0.125945,
                            "0.55": 0.135239,
                            "0.65": 0.136956,
                            "0.75": 0.134167,
                            "0.85": 0.0889851,
                            "0.95": 0.0294067,
                        },
                    },
                    "5.75": {
                        "periodfrac": 0.0496056,
                        "P_bin": 0.686644,
                        "normed_bin_frac_p_dist": 0.07229,
                        "normed_tripquad_frac_p_dist": 0.1221,
                        "q": {
                            "0.15": 0.155761,
                            "0.25": 0.166989,
                            "0.35": 0.153414,
                            "0.45": 0.120148,
                            "0.55": 0.0989227,
                            "0.65": 0.0841719,
                            "0.75": 0.0733109,
                            "0.85": 0.0711807,
                            "0.95": 0.0761018,
                        },
                        "e": {
                            "0.05": 0.0502699,
                            "0.15": 0.0814303,
                            "0.25": 0.099944,
                            "0.35": 0.114252,
                            "0.45": 0.126226,
                            "0.55": 0.135904,
                            "0.65": 0.137694,
                            "0.75": 0.134937,
                            "0.85": 0.0896122,
                            "0.95": 0.0297304,
                        },
                    },
                    "6.25": {
                        "periodfrac": 0.0445755,
                        "P_bin": 0.63499,
                        "normed_bin_frac_p_dist": 0.06008,
                        "normed_tripquad_frac_p_dist": 0.1278,
                        "q": {
                            "0.15": 0.171419,
                            "0.25": 0.181296,
                            "0.35": 0.161915,
                            "0.45": 0.121631,
                            "0.55": 0.0968869,
                            "0.65": 0.080209,
                            "0.75": 0.0682401,
                            "0.85": 0.0610367,
                            "0.95": 0.057366,
                        },
                        "e": {
                            "0.05": 0.0490604,
                            "0.15": 0.0805314,
                            "0.25": 0.0994411,
                            "0.35": 0.114131,
                            "0.45": 0.126467,
                            "0.55": 0.136463,
                            "0.65": 0.138314,
                            "0.75": 0.135567,
                            "0.85": 0.0900846,
                            "0.95": 0.0299411,
                        },
                    },
                    "6.75": {
                        "periodfrac": 0.0395022,
                        "P_bin": 0.581236,
                        "normed_bin_frac_p_dist": 0.04873,
                        "normed_tripquad_frac_p_dist": 0.1299,
                        "q": {
                            "0.15": 0.184461,
                            "0.25": 0.192453,
                            "0.35": 0.167611,
                            "0.45": 0.121408,
                            "0.55": 0.0939568,
                            "0.65": 0.0759424,
                            "0.75": 0.063301,
                            "0.85": 0.05399,
                            "0.95": 0.0468761,
                        },
                        "e": {
                            "0.05": 0.0480717,
                            "0.15": 0.0797869,
                            "0.25": 0.0990233,
                            "0.35": 0.114031,
                            "0.45": 0.126672,
                            "0.55": 0.136936,
                            "0.65": 0.138838,
                            "0.75": 0.136092,
                            "0.85": 0.0904586,
                            "0.95": 0.0300905,
                        },
                    },
                    "7.25": {
                        "periodfrac": 0.0345252,
                        "P_bin": 0.525506,
                        "normed_bin_frac_p_dist": 0.03851,
                        "normed_tripquad_frac_p_dist": 0.1287,
                        "q": {
                            "0.15": 0.194396,
                            "0.25": 0.200076,
                            "0.35": 0.170693,
                            "0.45": 0.12017,
                            "0.55": 0.0909243,
                            "0.65": 0.0721292,
                            "0.75": 0.0591689,
                            "0.85": 0.0497659,
                            "0.95": 0.0426763,
                        },
                        "e": {
                            "0.05": 0.0472479,
                            "0.15": 0.0791591,
                            "0.25": 0.0986693,
                            "0.35": 0.113946,
                            "0.45": 0.126846,
                            "0.55": 0.13734,
                            "0.65": 0.139286,
                            "0.75": 0.136535,
                            "0.85": 0.0907653,
                            "0.95": 0.0302046,
                        },
                    },
                    "7.75": {
                        "periodfrac": 0.0300381,
                        "P_bin": 0.467911,
                        "normed_bin_frac_p_dist": 0.02983,
                        "normed_tripquad_frac_p_dist": 0.1255,
                        "q": {
                            "0.15": 0.204421,
                            "0.25": 0.207544,
                            "0.35": 0.173463,
                            "0.45": 0.11869,
                            "0.55": 0.0877989,
                            "0.65": 0.0683581,
                            "0.75": 0.0551857,
                            "0.85": 0.0457719,
                            "0.95": 0.0387677,
                        },
                        "e": {
                            "0.05": 0.0465507,
                            "0.15": 0.0786221,
                            "0.25": 0.0983648,
                            "0.35": 0.113873,
                            "0.45": 0.126996,
                            "0.55": 0.137687,
                            "0.65": 0.139672,
                            "0.75": 0.136916,
                            "0.85": 0.0910235,
                            "0.95": 0.0302959,
                        },
                    },
                },
            },
            "0.3": {
                "f_multi": 0.6521,
                "multi system fraction": 0.4989,
                "binary star fraction": 0.4222,
                "triple/quad star fraction": 0.0766,
                "single star fraction": 0.5011,
                "poisson_model": {
                    "single_fraction": 0.523,
                    "binary_fraction": 0.341,
                    "triple_fraction": 0.111,
                    "quadruple_fraction": 0.0242,
                },
                "logP": {
                    "0.25": {
                        "periodfrac": 0.021405,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.04291,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.095954,
                            "0.25": 0.115495,
                            "0.35": 0.118321,
                            "0.45": 0.104241,
                            "0.55": 0.0942398,
                            "0.65": 0.0866619,
                            "0.75": 0.0806625,
                            "0.85": 0.116466,
                            "0.95": 0.187959,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "0.75": {
                        "periodfrac": 0.0249163,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.04995,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.095954,
                            "0.25": 0.115495,
                            "0.35": 0.118321,
                            "0.45": 0.104241,
                            "0.55": 0.0942398,
                            "0.65": 0.0866619,
                            "0.75": 0.0806625,
                            "0.85": 0.116466,
                            "0.95": 0.187959,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.25": {
                        "periodfrac": 0.0269927,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.05411,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0972818,
                            "0.25": 0.117093,
                            "0.35": 0.119624,
                            "0.45": 0.104881,
                            "0.55": 0.0944549,
                            "0.65": 0.0865832,
                            "0.75": 0.0803698,
                            "0.85": 0.115058,
                            "0.95": 0.184655,
                        },
                        "e": {
                            "0.05": 0.330824,
                            "0.15": 0.165642,
                            "0.25": 0.129153,
                            "0.35": 0.110009,
                            "0.45": 0.100964,
                            "0.55": 0.0990032,
                            "0.65": 0.057533,
                            "0.75": 0.00687094,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.75": {
                        "periodfrac": 0.0308698,
                        "P_bin": 0.991447,
                        "normed_bin_frac_p_dist": 0.06135,
                        "normed_tripquad_frac_p_dist": 0.001723,
                        "q": {
                            "0.15": 0.100764,
                            "0.25": 0.121284,
                            "0.35": 0.123044,
                            "0.45": 0.106584,
                            "0.55": 0.0950721,
                            "0.65": 0.0864569,
                            "0.75": 0.0797068,
                            "0.85": 0.111353,
                            "0.95": 0.175735,
                        },
                        "e": {
                            "0.05": 0.14167,
                            "0.15": 0.131895,
                            "0.25": 0.12826,
                            "0.35": 0.125956,
                            "0.45": 0.12427,
                            "0.55": 0.123559,
                            "0.65": 0.12234,
                            "0.75": 0.0809714,
                            "0.85": 0.0210788,
                            "0.95": 0.0,
                        },
                    },
                    "2.25": {
                        "periodfrac": 0.0358858,
                        "P_bin": 0.966165,
                        "normed_bin_frac_p_dist": 0.0695,
                        "normed_tripquad_frac_p_dist": 0.007922,
                        "q": {
                            "0.15": 0.104486,
                            "0.25": 0.125764,
                            "0.35": 0.126704,
                            "0.45": 0.108437,
                            "0.55": 0.0958002,
                            "0.65": 0.0864267,
                            "0.75": 0.0791374,
                            "0.85": 0.107376,
                            "0.95": 0.165869,
                        },
                        "e": {
                            "0.05": 0.0944499,
                            "0.15": 0.110031,
                            "0.25": 0.117032,
                            "0.35": 0.121823,
                            "0.45": 0.125515,
                            "0.55": 0.127863,
                            "0.65": 0.127994,
                            "0.75": 0.112768,
                            "0.85": 0.0563073,
                            "0.95": 0.00621564,
                        },
                    },
                    "2.75": {
                        "periodfrac": 0.0424106,
                        "P_bin": 0.933124,
                        "normed_bin_frac_p_dist": 0.07933,
                        "normed_tripquad_frac_p_dist": 0.0185,
                        "q": {
                            "0.15": 0.110334,
                            "0.25": 0.13086,
                            "0.35": 0.130234,
                            "0.45": 0.110119,
                            "0.55": 0.0963562,
                            "0.65": 0.0862376,
                            "0.75": 0.0784269,
                            "0.85": 0.102825,
                            "0.95": 0.154606,
                        },
                        "e": {
                            "0.05": 0.0754871,
                            "0.15": 0.0987081,
                            "0.25": 0.110213,
                            "0.35": 0.118419,
                            "0.45": 0.12492,
                            "0.55": 0.129746,
                            "0.65": 0.13039,
                            "0.75": 0.123258,
                            "0.85": 0.0725423,
                            "0.95": 0.0163158,
                        },
                    },
                    "3.25": {
                        "periodfrac": 0.0491708,
                        "P_bin": 0.894596,
                        "normed_bin_frac_p_dist": 0.08817,
                        "normed_tripquad_frac_p_dist": 0.03381,
                        "q": {
                            "0.15": 0.119605,
                            "0.25": 0.136712,
                            "0.35": 0.133334,
                            "0.45": 0.111385,
                            "0.55": 0.0965316,
                            "0.65": 0.0857078,
                            "0.75": 0.0774149,
                            "0.85": 0.0975396,
                            "0.95": 0.141769,
                        },
                        "e": {
                            "0.05": 0.0657833,
                            "0.15": 0.0922986,
                            "0.25": 0.106244,
                            "0.35": 0.116451,
                            "0.45": 0.124683,
                            "0.55": 0.131158,
                            "0.65": 0.132341,
                            "0.75": 0.127869,
                            "0.85": 0.0804725,
                            "0.95": 0.0226993,
                        },
                    },
                    "3.75": {
                        "periodfrac": 0.0519035,
                        "P_bin": 0.851644,
                        "normed_bin_frac_p_dist": 0.08861,
                        "normed_tripquad_frac_p_dist": 0.05024,
                        "q": {
                            "0.15": 0.129954,
                            "0.25": 0.143137,
                            "0.35": 0.136798,
                            "0.45": 0.112904,
                            "0.55": 0.0969118,
                            "0.65": 0.0853612,
                            "0.75": 0.0765775,
                            "0.85": 0.0916029,
                            "0.95": 0.126754,
                        },
                        "e": {
                            "0.05": 0.0601091,
                            "0.15": 0.0884375,
                            "0.25": 0.103949,
                            "0.35": 0.115505,
                            "0.45": 0.124938,
                            "0.55": 0.132423,
                            "0.65": 0.133797,
                            "0.75": 0.13029,
                            "0.85": 0.0845054,
                            "0.95": 0.0260463,
                        },
                    },
                    "4.25": {
                        "periodfrac": 0.0521696,
                        "P_bin": 0.804914,
                        "normed_bin_frac_p_dist": 0.08417,
                        "normed_tripquad_frac_p_dist": 0.0664,
                        "q": {
                            "0.15": 0.14127,
                            "0.25": 0.14992,
                            "0.35": 0.140397,
                            "0.45": 0.11448,
                            "0.55": 0.0973244,
                            "0.65": 0.0850431,
                            "0.75": 0.0757728,
                            "0.85": 0.0852653,
                            "0.95": 0.110526,
                        },
                        "e": {
                            "0.05": 0.0563761,
                            "0.15": 0.085828,
                            "0.25": 0.102429,
                            "0.35": 0.114957,
                            "0.45": 0.125274,
                            "0.55": 0.133513,
                            "0.65": 0.135029,
                            "0.75": 0.131961,
                            "0.85": 0.086745,
                            "0.95": 0.0278885,
                        },
                    },
                    "4.75": {
                        "periodfrac": 0.0524794,
                        "P_bin": 0.754852,
                        "normed_bin_frac_p_dist": 0.07941,
                        "normed_tripquad_frac_p_dist": 0.08394,
                        "q": {
                            "0.15": 0.15446,
                            "0.25": 0.157913,
                            "0.35": 0.144501,
                            "0.45": 0.115845,
                            "0.55": 0.0971668,
                            "0.65": 0.0839614,
                            "0.75": 0.0740972,
                            "0.85": 0.0781842,
                            "0.95": 0.0938714,
                        },
                        "e": {
                            "0.05": 0.0537433,
                            "0.15": 0.0839551,
                            "0.25": 0.101361,
                            "0.35": 0.114626,
                            "0.45": 0.125623,
                            "0.55": 0.134449,
                            "0.65": 0.136076,
                            "0.75": 0.133203,
                            "0.85": 0.088098,
                            "0.95": 0.0288651,
                        },
                    },
                    "5.25": {
                        "periodfrac": 0.0533019,
                        "P_bin": 0.701786,
                        "normed_bin_frac_p_dist": 0.07498,
                        "normed_tripquad_frac_p_dist": 0.1037,
                        "q": {
                            "0.15": 0.172477,
                            "0.25": 0.169853,
                            "0.35": 0.150561,
                            "0.45": 0.116867,
                            "0.55": 0.0955427,
                            "0.65": 0.08082,
                            "0.75": 0.0700388,
                            "0.85": 0.0687338,
                            "0.95": 0.0751081,
                        },
                        "e": {
                            "0.05": 0.0517855,
                            "0.15": 0.0825411,
                            "0.25": 0.100565,
                            "0.35": 0.114409,
                            "0.45": 0.125945,
                            "0.55": 0.135239,
                            "0.65": 0.136956,
                            "0.75": 0.134167,
                            "0.85": 0.0889851,
                            "0.95": 0.0294067,
                        },
                    },
                    "5.75": {
                        "periodfrac": 0.0518321,
                        "P_bin": 0.645971,
                        "normed_bin_frac_p_dist": 0.06712,
                        "normed_tripquad_frac_p_dist": 0.1197,
                        "q": {
                            "0.15": 0.193799,
                            "0.25": 0.184737,
                            "0.35": 0.157858,
                            "0.45": 0.117206,
                            "0.55": 0.0925005,
                            "0.65": 0.0759913,
                            "0.75": 0.0642281,
                            "0.85": 0.0579301,
                            "0.95": 0.0557507,
                        },
                        "e": {
                            "0.05": 0.0502699,
                            "0.15": 0.0814303,
                            "0.25": 0.099944,
                            "0.35": 0.114252,
                            "0.45": 0.126226,
                            "0.55": 0.135904,
                            "0.65": 0.137694,
                            "0.75": 0.134937,
                            "0.85": 0.0896122,
                            "0.95": 0.0297304,
                        },
                    },
                    "6.25": {
                        "periodfrac": 0.0470627,
                        "P_bin": 0.587614,
                        "normed_bin_frac_p_dist": 0.05543,
                        "normed_tripquad_frac_p_dist": 0.1266,
                        "q": {
                            "0.15": 0.213099,
                            "0.25": 0.198098,
                            "0.35": 0.163653,
                            "0.45": 0.116218,
                            "0.55": 0.0885402,
                            "0.65": 0.0706393,
                            "0.75": 0.0582298,
                            "0.85": 0.0491846,
                            "0.95": 0.0423374,
                        },
                        "e": {
                            "0.05": 0.0490604,
                            "0.15": 0.0805314,
                            "0.25": 0.0994411,
                            "0.35": 0.114131,
                            "0.45": 0.126467,
                            "0.55": 0.136463,
                            "0.65": 0.138314,
                            "0.75": 0.135567,
                            "0.85": 0.0900846,
                            "0.95": 0.0299411,
                        },
                    },
                    "6.75": {
                        "periodfrac": 0.0420557,
                        "P_bin": 0.526882,
                        "normed_bin_frac_p_dist": 0.04442,
                        "normed_tripquad_frac_p_dist": 0.1298,
                        "q": {
                            "0.15": 0.228128,
                            "0.25": 0.206799,
                            "0.35": 0.16608,
                            "0.45": 0.113903,
                            "0.55": 0.0844139,
                            "0.65": 0.0658233,
                            "0.75": 0.053209,
                            "0.85": 0.0441829,
                            "0.95": 0.0374598,
                        },
                        "e": {
                            "0.05": 0.0480717,
                            "0.15": 0.0797869,
                            "0.25": 0.0990233,
                            "0.35": 0.114031,
                            "0.45": 0.126672,
                            "0.55": 0.136936,
                            "0.65": 0.138838,
                            "0.75": 0.136092,
                            "0.85": 0.0904586,
                            "0.95": 0.0300905,
                        },
                    },
                    "7.25": {
                        "periodfrac": 0.0370681,
                        "P_bin": 0.463919,
                        "normed_bin_frac_p_dist": 0.03447,
                        "normed_tripquad_frac_p_dist": 0.1296,
                        "q": {
                            "0.15": 0.239372,
                            "0.25": 0.211588,
                            "0.35": 0.166525,
                            "0.45": 0.11192,
                            "0.55": 0.0816259,
                            "0.65": 0.0628095,
                            "0.75": 0.0501995,
                            "0.85": 0.0412731,
                            "0.95": 0.0346863,
                        },
                        "e": {
                            "0.05": 0.0472479,
                            "0.15": 0.0791591,
                            "0.25": 0.0986693,
                            "0.35": 0.113946,
                            "0.45": 0.126846,
                            "0.55": 0.13734,
                            "0.65": 0.139286,
                            "0.75": 0.136535,
                            "0.85": 0.0907653,
                            "0.95": 0.0302046,
                        },
                    },
                    "7.75": {
                        "periodfrac": 0.0326202,
                        "P_bin": 0.398848,
                        "normed_bin_frac_p_dist": 0.02608,
                        "normed_tripquad_frac_p_dist": 0.1279,
                        "q": {
                            "0.15": 0.250807,
                            "0.25": 0.216161,
                            "0.35": 0.166722,
                            "0.45": 0.109806,
                            "0.55": 0.0788098,
                            "0.65": 0.0598419,
                            "0.75": 0.0472881,
                            "0.85": 0.0384958,
                            "0.95": 0.0320687,
                        },
                        "e": {
                            "0.05": 0.0465507,
                            "0.15": 0.0786221,
                            "0.25": 0.0983648,
                            "0.35": 0.113873,
                            "0.45": 0.126996,
                            "0.55": 0.137687,
                            "0.65": 0.139672,
                            "0.75": 0.136916,
                            "0.85": 0.0910235,
                            "0.95": 0.0302959,
                        },
                    },
                },
            },
            "0.4": {
                "f_multi": 0.725,
                "multi system fraction": 0.5355,
                "binary star fraction": 0.4408,
                "triple/quad star fraction": 0.0947,
                "single star fraction": 0.4645,
                "poisson_model": {
                    "single_fraction": 0.487,
                    "binary_fraction": 0.353,
                    "triple_fraction": 0.128,
                    "quadruple_fraction": 0.031,
                },
                "logP": {
                    "0.25": {
                        "periodfrac": 0.0253057,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.04725,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0977916,
                            "0.25": 0.116405,
                            "0.35": 0.118777,
                            "0.45": 0.104643,
                            "0.55": 0.0946032,
                            "0.65": 0.0869962,
                            "0.75": 0.0809738,
                            "0.85": 0.115414,
                            "0.95": 0.184396,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "0.75": {
                        "periodfrac": 0.0305325,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.05701,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0977916,
                            "0.25": 0.116405,
                            "0.35": 0.118777,
                            "0.45": 0.104643,
                            "0.55": 0.0946032,
                            "0.65": 0.0869962,
                            "0.75": 0.0809738,
                            "0.85": 0.115414,
                            "0.95": 0.184396,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.25": {
                        "periodfrac": 0.0320159,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.05978,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0996424,
                            "0.25": 0.118608,
                            "0.35": 0.120535,
                            "0.45": 0.105449,
                            "0.55": 0.0948017,
                            "0.65": 0.0867758,
                            "0.75": 0.0804489,
                            "0.85": 0.113524,
                            "0.95": 0.180216,
                        },
                        "e": {
                            "0.05": 0.330824,
                            "0.15": 0.165642,
                            "0.25": 0.129153,
                            "0.35": 0.110009,
                            "0.45": 0.100964,
                            "0.55": 0.0990032,
                            "0.65": 0.057533,
                            "0.75": 0.00687094,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.75": {
                        "periodfrac": 0.0353915,
                        "P_bin": 0.990337,
                        "normed_bin_frac_p_dist": 0.06545,
                        "normed_tripquad_frac_p_dist": 0.001805,
                        "q": {
                            "0.15": 0.104481,
                            "0.25": 0.124368,
                            "0.35": 0.125115,
                            "0.45": 0.107552,
                            "0.55": 0.0953528,
                            "0.65": 0.0862747,
                            "0.75": 0.0791956,
                            "0.85": 0.108593,
                            "0.95": 0.169067,
                        },
                        "e": {
                            "0.05": 0.14167,
                            "0.15": 0.131895,
                            "0.25": 0.12826,
                            "0.35": 0.125956,
                            "0.45": 0.12427,
                            "0.55": 0.123559,
                            "0.65": 0.12234,
                            "0.75": 0.0809714,
                            "0.85": 0.0210788,
                            "0.95": 0.0,
                        },
                    },
                    "2.25": {
                        "periodfrac": 0.040297,
                        "P_bin": 0.961773,
                        "normed_bin_frac_p_dist": 0.07237,
                        "normed_tripquad_frac_p_dist": 0.00813,
                        "q": {
                            "0.15": 0.109633,
                            "0.25": 0.1305,
                            "0.35": 0.129966,
                            "0.45": 0.109777,
                            "0.55": 0.0959768,
                            "0.65": 0.0858384,
                            "0.75": 0.0780177,
                            "0.85": 0.103368,
                            "0.95": 0.156923,
                        },
                        "e": {
                            "0.05": 0.0944499,
                            "0.15": 0.110031,
                            "0.25": 0.117032,
                            "0.35": 0.121823,
                            "0.45": 0.125515,
                            "0.55": 0.127863,
                            "0.65": 0.127994,
                            "0.75": 0.112768,
                            "0.85": 0.0563073,
                            "0.95": 0.00621564,
                        },
                    },
                    "2.75": {
                        "periodfrac": 0.047394,
                        "P_bin": 0.924444,
                        "normed_bin_frac_p_dist": 0.08181,
                        "normed_tripquad_frac_p_dist": 0.0189,
                        "q": {
                            "0.15": 0.117986,
                            "0.25": 0.137464,
                            "0.35": 0.13449,
                            "0.45": 0.111619,
                            "0.55": 0.0962338,
                            "0.65": 0.0850762,
                            "0.75": 0.076562,
                            "0.85": 0.0974101,
                            "0.95": 0.143159,
                        },
                        "e": {
                            "0.05": 0.0754871,
                            "0.15": 0.0987081,
                            "0.25": 0.110213,
                            "0.35": 0.118419,
                            "0.45": 0.12492,
                            "0.55": 0.129746,
                            "0.65": 0.13039,
                            "0.75": 0.123258,
                            "0.85": 0.0725423,
                            "0.95": 0.0163158,
                        },
                    },
                    "3.25": {
                        "periodfrac": 0.0552371,
                        "P_bin": 0.880915,
                        "normed_bin_frac_p_dist": 0.09086,
                        "normed_tripquad_frac_p_dist": 0.03472,
                        "q": {
                            "0.15": 0.131886,
                            "0.25": 0.145611,
                            "0.35": 0.138332,
                            "0.45": 0.112806,
                            "0.55": 0.095908,
                            "0.65": 0.0838105,
                            "0.75": 0.0746782,
                            "0.85": 0.0902578,
                            "0.95": 0.12671,
                        },
                        "e": {
                            "0.05": 0.0657833,
                            "0.15": 0.0922986,
                            "0.25": 0.106244,
                            "0.35": 0.116451,
                            "0.45": 0.124683,
                            "0.55": 0.131158,
                            "0.65": 0.132341,
                            "0.75": 0.127869,
                            "0.85": 0.0804725,
                            "0.95": 0.0226993,
                        },
                    },
                    "3.75": {
                        "periodfrac": 0.0577673,
                        "P_bin": 0.832388,
                        "normed_bin_frac_p_dist": 0.08979,
                        "normed_tripquad_frac_p_dist": 0.0511,
                        "q": {
                            "0.15": 0.147519,
                            "0.25": 0.154299,
                            "0.35": 0.142321,
                            "0.45": 0.114034,
                            "0.55": 0.0956063,
                            "0.65": 0.0825831,
                            "0.75": 0.0728582,
                            "0.85": 0.0824719,
                            "0.95": 0.108308,
                        },
                        "e": {
                            "0.05": 0.0601091,
                            "0.15": 0.0884375,
                            "0.25": 0.103949,
                            "0.35": 0.115505,
                            "0.45": 0.124938,
                            "0.55": 0.132423,
                            "0.65": 0.133797,
                            "0.75": 0.13029,
                            "0.85": 0.0845054,
                            "0.95": 0.0260463,
                        },
                    },
                    "4.25": {
                        "periodfrac": 0.0570371,
                        "P_bin": 0.779593,
                        "normed_bin_frac_p_dist": 0.08303,
                        "normed_tripquad_frac_p_dist": 0.06635,
                        "q": {
                            "0.15": 0.164373,
                            "0.25": 0.162836,
                            "0.35": 0.145808,
                            "0.45": 0.114789,
                            "0.55": 0.0949023,
                            "0.65": 0.0810291,
                            "0.75": 0.0707813,
                            "0.85": 0.0748087,
                            "0.95": 0.0906729,
                        },
                        "e": {
                            "0.05": 0.0563761,
                            "0.15": 0.085828,
                            "0.25": 0.102429,
                            "0.35": 0.114957,
                            "0.45": 0.125274,
                            "0.55": 0.133513,
                            "0.65": 0.135029,
                            "0.75": 0.131961,
                            "0.85": 0.086745,
                            "0.95": 0.0278885,
                        },
                    },
                    "4.75": {
                        "periodfrac": 0.0567247,
                        "P_bin": 0.723033,
                        "normed_bin_frac_p_dist": 0.07658,
                        "normed_tripquad_frac_p_dist": 0.08292,
                        "q": {
                            "0.15": 0.184393,
                            "0.25": 0.172963,
                            "0.35": 0.149741,
                            "0.45": 0.115011,
                            "0.55": 0.0932415,
                            "0.65": 0.0783273,
                            "0.75": 0.0674768,
                            "0.85": 0.0661952,
                            "0.95": 0.0726518,
                        },
                        "e": {
                            "0.05": 0.0537433,
                            "0.15": 0.0839551,
                            "0.25": 0.101361,
                            "0.35": 0.114626,
                            "0.45": 0.125623,
                            "0.55": 0.134449,
                            "0.65": 0.136076,
                            "0.75": 0.133203,
                            "0.85": 0.088098,
                            "0.95": 0.0288651,
                        },
                    },
                    "5.25": {
                        "periodfrac": 0.0572643,
                        "P_bin": 0.663079,
                        "normed_bin_frac_p_dist": 0.0709,
                        "normed_tripquad_frac_p_dist": 0.1018,
                        "q": {
                            "0.15": 0.210174,
                            "0.25": 0.18662,
                            "0.35": 0.154866,
                            "0.45": 0.114276,
                            "0.55": 0.089747,
                            "0.65": 0.0734297,
                            "0.75": 0.0618479,
                            "0.85": 0.0556217,
                            "0.95": 0.0534182,
                        },
                        "e": {
                            "0.05": 0.0517855,
                            "0.15": 0.0825411,
                            "0.25": 0.100565,
                            "0.35": 0.114409,
                            "0.45": 0.125945,
                            "0.55": 0.135239,
                            "0.65": 0.136956,
                            "0.75": 0.134167,
                            "0.85": 0.0889851,
                            "0.95": 0.0294067,
                        },
                    },
                    "5.75": {
                        "periodfrac": 0.0555714,
                        "P_bin": 0.60002,
                        "normed_bin_frac_p_dist": 0.06226,
                        "normed_tripquad_frac_p_dist": 0.1173,
                        "q": {
                            "0.15": 0.23634,
                            "0.25": 0.200064,
                            "0.35": 0.158944,
                            "0.45": 0.111868,
                            "0.55": 0.0846236,
                            "0.65": 0.0671185,
                            "0.75": 0.0550501,
                            "0.85": 0.0462953,
                            "0.95": 0.0396953,
                        },
                        "e": {
                            "0.05": 0.0502699,
                            "0.15": 0.0814303,
                            "0.25": 0.099944,
                            "0.35": 0.114252,
                            "0.45": 0.126226,
                            "0.55": 0.135904,
                            "0.65": 0.137694,
                            "0.75": 0.134937,
                            "0.85": 0.0896122,
                            "0.95": 0.0297304,
                        },
                    },
                    "6.25": {
                        "periodfrac": 0.0509858,
                        "P_bin": 0.534088,
                        "normed_bin_frac_p_dist": 0.05085,
                        "normed_tripquad_frac_p_dist": 0.1254,
                        "q": {
                            "0.15": 0.258639,
                            "0.25": 0.211011,
                            "0.35": 0.161168,
                            "0.45": 0.108184,
                            "0.55": 0.0788216,
                            "0.65": 0.0606017,
                            "0.75": 0.0484006,
                            "0.85": 0.0397695,
                            "0.95": 0.0334042,
                        },
                        "e": {
                            "0.05": 0.0490604,
                            "0.15": 0.0805314,
                            "0.25": 0.0994411,
                            "0.35": 0.114131,
                            "0.45": 0.126467,
                            "0.55": 0.136463,
                            "0.65": 0.138314,
                            "0.75": 0.135567,
                            "0.85": 0.0900846,
                            "0.95": 0.0299411,
                        },
                    },
                    "6.75": {
                        "periodfrac": 0.0461401,
                        "P_bin": 0.465473,
                        "normed_bin_frac_p_dist": 0.0401,
                        "normed_tripquad_frac_p_dist": 0.1302,
                        "q": {
                            "0.15": 0.277213,
                            "0.25": 0.217949,
                            "0.35": 0.161296,
                            "0.45": 0.104727,
                            "0.55": 0.0743199,
                            "0.65": 0.0559071,
                            "0.75": 0.0438268,
                            "0.85": 0.0354298,
                            "0.95": 0.0293322,
                        },
                        "e": {
                            "0.05": 0.0480717,
                            "0.15": 0.0797869,
                            "0.25": 0.0990233,
                            "0.35": 0.114031,
                            "0.45": 0.126672,
                            "0.55": 0.136936,
                            "0.65": 0.138838,
                            "0.75": 0.136092,
                            "0.85": 0.0904586,
                            "0.95": 0.0300905,
                        },
                    },
                    "7.25": {
                        "periodfrac": 0.0409612,
                        "P_bin": 0.394338,
                        "normed_bin_frac_p_dist": 0.03016,
                        "normed_tripquad_frac_p_dist": 0.1309,
                        "q": {
                            "0.15": 0.290065,
                            "0.25": 0.219741,
                            "0.35": 0.159391,
                            "0.45": 0.102259,
                            "0.55": 0.0718843,
                            "0.65": 0.0536523,
                            "0.75": 0.041778,
                            "0.85": 0.0335766,
                            "0.95": 0.0276539,
                        },
                        "e": {
                            "0.05": 0.0472479,
                            "0.15": 0.0791591,
                            "0.25": 0.0986693,
                            "0.35": 0.113946,
                            "0.45": 0.126846,
                            "0.55": 0.13734,
                            "0.65": 0.139286,
                            "0.75": 0.136535,
                            "0.85": 0.0907653,
                            "0.95": 0.0302046,
                        },
                    },
                    "7.75": {
                        "periodfrac": 0.0363996,
                        "P_bin": 0.32082,
                        "normed_bin_frac_p_dist": 0.02181,
                        "normed_tripquad_frac_p_dist": 0.1305,
                        "q": {
                            "0.15": 0.303197,
                            "0.25": 0.221291,
                            "0.35": 0.157318,
                            "0.45": 0.0997275,
                            "0.55": 0.0694438,
                            "0.65": 0.0514252,
                            "0.75": 0.0397764,
                            "0.85": 0.0317814,
                            "0.95": 0.0260398,
                        },
                        "e": {
                            "0.05": 0.0465507,
                            "0.15": 0.0786221,
                            "0.25": 0.0983648,
                            "0.35": 0.113873,
                            "0.45": 0.126996,
                            "0.55": 0.137687,
                            "0.65": 0.139672,
                            "0.75": 0.136916,
                            "0.85": 0.0910235,
                            "0.95": 0.0302959,
                        },
                    },
                },
            },
            "0.5": {
                "f_multi": 0.8224,
                "multi system fraction": 0.5833,
                "binary star fraction": 0.4638,
                "triple/quad star fraction": 0.1195,
                "single star fraction": 0.4167,
                "poisson_model": {
                    "single_fraction": 0.444,
                    "binary_fraction": 0.365,
                    "triple_fraction": 0.15,
                    "quadruple_fraction": 0.0411,
                },
                "logP": {
                    "0.25": {
                        "periodfrac": 0.029079,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.04985,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0997195,
                            "0.25": 0.117385,
                            "0.35": 0.119299,
                            "0.45": 0.105102,
                            "0.55": 0.0950189,
                            "0.65": 0.0873785,
                            "0.75": 0.0813294,
                            "0.85": 0.114273,
                            "0.95": 0.180494,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "0.75": {
                        "periodfrac": 0.0373435,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.06402,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.0997195,
                            "0.25": 0.117385,
                            "0.35": 0.119299,
                            "0.45": 0.105102,
                            "0.55": 0.0950189,
                            "0.65": 0.0873785,
                            "0.75": 0.0813294,
                            "0.85": 0.114273,
                            "0.95": 0.180494,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.25": {
                        "periodfrac": 0.0385956,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.06617,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.10214,
                            "0.25": 0.120235,
                            "0.35": 0.121546,
                            "0.45": 0.106101,
                            "0.55": 0.0952224,
                            "0.65": 0.0870351,
                            "0.75": 0.0805897,
                            "0.85": 0.111853,
                            "0.95": 0.175278,
                        },
                        "e": {
                            "0.05": 0.29981,
                            "0.15": 0.166109,
                            "0.25": 0.13396,
                            "0.35": 0.116596,
                            "0.45": 0.108259,
                            "0.55": 0.106189,
                            "0.65": 0.0617086,
                            "0.75": 0.00736965,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.75": {
                        "periodfrac": 0.0414758,
                        "P_bin": 0.989083,
                        "normed_bin_frac_p_dist": 0.07033,
                        "normed_tripquad_frac_p_dist": 0.001894,
                        "q": {
                            "0.15": 0.108483,
                            "0.25": 0.127701,
                            "0.35": 0.127392,
                            "0.45": 0.108674,
                            "0.55": 0.0957623,
                            "0.65": 0.0862081,
                            "0.75": 0.0787926,
                            "0.85": 0.105562,
                            "0.95": 0.161426,
                        },
                        "e": {
                            "0.05": 0.13011,
                            "0.15": 0.128604,
                            "0.25": 0.128014,
                            "0.35": 0.127633,
                            "0.45": 0.127351,
                            "0.55": 0.127231,
                            "0.65": 0.125975,
                            "0.75": 0.0833774,
                            "0.85": 0.0217052,
                            "0.95": 0.0,
                        },
                    },
                    "2.25": {
                        "periodfrac": 0.0463118,
                        "P_bin": 0.956812,
                        "normed_bin_frac_p_dist": 0.07597,
                        "normed_tripquad_frac_p_dist": 0.008366,
                        "q": {
                            "0.15": 0.115251,
                            "0.25": 0.135668,
                            "0.35": 0.133564,
                            "0.45": 0.111343,
                            "0.55": 0.0963338,
                            "0.65": 0.0854137,
                            "0.75": 0.0770579,
                            "0.85": 0.098926,
                            "0.95": 0.146443,
                        },
                        "e": {
                            "0.05": 0.0877384,
                            "0.15": 0.107039,
                            "0.25": 0.116056,
                            "0.35": 0.122329,
                            "0.45": 0.127215,
                            "0.55": 0.130347,
                            "0.65": 0.130522,
                            "0.75": 0.114996,
                            "0.85": 0.0574194,
                            "0.95": 0.00633846,
                        },
                    },
                    "2.75": {
                        "periodfrac": 0.0540945,
                        "P_bin": 0.914638,
                        "normed_bin_frac_p_dist": 0.08482,
                        "normed_tripquad_frac_p_dist": 0.01931,
                        "q": {
                            "0.15": 0.126554,
                            "0.25": 0.144836,
                            "0.35": 0.139308,
                            "0.45": 0.113483,
                            "0.55": 0.0964025,
                            "0.65": 0.0841839,
                            "0.75": 0.0749667,
                            "0.85": 0.0912341,
                            "0.95": 0.129032,
                        },
                        "e": {
                            "0.05": 0.0706234,
                            "0.15": 0.0960604,
                            "0.25": 0.109091,
                            "0.35": 0.11852,
                            "0.45": 0.126065,
                            "0.55": 0.131703,
                            "0.65": 0.132457,
                            "0.75": 0.125213,
                            "0.85": 0.0736927,
                            "0.95": 0.0165746,
                        },
                    },
                    "3.25": {
                        "periodfrac": 0.063103,
                        "P_bin": 0.865458,
                        "normed_bin_frac_p_dist": 0.09363,
                        "normed_tripquad_frac_p_dist": 0.03551,
                        "q": {
                            "0.15": 0.145965,
                            "0.25": 0.155644,
                            "0.35": 0.144031,
                            "0.45": 0.114652,
                            "0.55": 0.0956262,
                            "0.65": 0.0822447,
                            "0.75": 0.0722927,
                            "0.85": 0.0818333,
                            "0.95": 0.107711,
                        },
                        "e": {
                            "0.05": 0.0618441,
                            "0.15": 0.0899006,
                            "0.25": 0.105107,
                            "0.35": 0.116385,
                            "0.45": 0.125561,
                            "0.55": 0.132828,
                            "0.65": 0.13416,
                            "0.75": 0.129626,
                            "0.85": 0.081578,
                            "0.95": 0.0230111,
                        },
                    },
                    "3.75": {
                        "periodfrac": 0.0657271,
                        "P_bin": 0.810632,
                        "normed_bin_frac_p_dist": 0.09134,
                        "normed_tripquad_frac_p_dist": 0.05206,
                        "q": {
                            "0.15": 0.167375,
                            "0.25": 0.166209,
                            "0.35": 0.147951,
                            "0.45": 0.115082,
                            "0.55": 0.0942394,
                            "0.65": 0.0798273,
                            "0.75": 0.0692602,
                            "0.85": 0.0726072,
                            "0.95": 0.0874496,
                        },
                        "e": {
                            "0.05": 0.0567146,
                            "0.15": 0.0862249,
                            "0.25": 0.102839,
                            "0.35": 0.115372,
                            "0.45": 0.125687,
                            "0.55": 0.133924,
                            "0.65": 0.135439,
                            "0.75": 0.131889,
                            "0.85": 0.085543,
                            "0.95": 0.0263662,
                        },
                    },
                    "4.25": {
                        "periodfrac": 0.0643689,
                        "P_bin": 0.750985,
                        "normed_bin_frac_p_dist": 0.08287,
                        "normed_tripquad_frac_p_dist": 0.06704,
                        "q": {
                            "0.15": 0.190772,
                            "0.25": 0.176343,
                            "0.35": 0.150965,
                            "0.45": 0.114741,
                            "0.55": 0.092251,
                            "0.65": 0.0769613,
                            "0.75": 0.06591,
                            "0.85": 0.063642,
                            "0.95": 0.0684138,
                        },
                        "e": {
                            "0.05": 0.0533352,
                            "0.15": 0.0837482,
                            "0.25": 0.101347,
                            "0.35": 0.114786,
                            "0.45": 0.125941,
                            "0.55": 0.134903,
                            "0.65": 0.136556,
                            "0.75": 0.133453,
                            "0.85": 0.087726,
                            "0.95": 0.0282039,
                        },
                    },
                    "4.75": {
                        "periodfrac": 0.0635839,
                        "P_bin": 0.687083,
                        "normed_bin_frac_p_dist": 0.0749,
                        "normed_tripquad_frac_p_dist": 0.08322,
                        "q": {
                            "0.15": 0.218815,
                            "0.25": 0.18819,
                            "0.35": 0.154116,
                            "0.45": 0.113397,
                            "0.55": 0.0888555,
                            "0.65": 0.0725638,
                            "0.75": 0.0610203,
                            "0.85": 0.0536777,
                            "0.95": 0.0493644,
                        },
                        "e": {
                            "0.05": 0.0509493,
                            "0.15": 0.0819752,
                            "0.25": 0.100304,
                            "0.35": 0.114432,
                            "0.45": 0.126234,
                            "0.55": 0.135761,
                            "0.65": 0.137521,
                            "0.75": 0.134618,
                            "0.85": 0.0890338,
                            "0.95": 0.0291719,
                        },
                    },
                    "5.25": {
                        "periodfrac": 0.0630798,
                        "P_bin": 0.619348,
                        "normed_bin_frac_p_dist": 0.06698,
                        "normed_tripquad_frac_p_dist": 0.1004,
                        "q": {
                            "0.15": 0.250604,
                            "0.25": 0.20044,
                            "0.35": 0.155677,
                            "0.45": 0.109193,
                            "0.55": 0.0823751,
                            "0.65": 0.065188,
                            "0.75": 0.0533636,
                            "0.85": 0.0448015,
                            "0.95": 0.038357,
                        },
                        "e": {
                            "0.05": 0.0491732,
                            "0.15": 0.0806386,
                            "0.25": 0.0995295,
                            "0.35": 0.114199,
                            "0.45": 0.126515,
                            "0.55": 0.136493,
                            "0.65": 0.13834,
                            "0.75": 0.135523,
                            "0.85": 0.0898844,
                            "0.95": 0.0297036,
                        },
                    },
                    "5.75": {
                        "periodfrac": 0.0606909,
                        "P_bin": 0.548104,
                        "normed_bin_frac_p_dist": 0.05703,
                        "normed_tripquad_frac_p_dist": 0.1147,
                        "q": {
                            "0.15": 0.281081,
                            "0.25": 0.211029,
                            "0.35": 0.155816,
                            "0.45": 0.103943,
                            "0.55": 0.0753608,
                            "0.65": 0.0577051,
                            "0.75": 0.0459271,
                            "0.85": 0.0376226,
                            "0.95": 0.0315159,
                        },
                        "e": {
                            "0.05": 0.0477971,
                            "0.15": 0.0795898,
                            "0.25": 0.0989266,
                            "0.35": 0.114032,
                            "0.45": 0.126766,
                            "0.55": 0.137112,
                            "0.65": 0.13903,
                            "0.75": 0.136247,
                            "0.85": 0.0904819,
                            "0.95": 0.0300187,
                        },
                    },
                    "6.25": {
                        "periodfrac": 0.0565316,
                        "P_bin": 0.473614,
                        "normed_bin_frac_p_dist": 0.0459,
                        "normed_tripquad_frac_p_dist": 0.1245,
                        "q": {
                            "0.15": 0.308474,
                            "0.25": 0.220538,
                            "0.35": 0.155657,
                            "0.45": 0.0987468,
                            "0.55": 0.068801,
                            "0.65": 0.0509741,
                            "0.75": 0.0394434,
                            "0.85": 0.0315267,
                            "0.95": 0.0258395,
                        },
                        "e": {
                            "0.05": 0.046698,
                            "0.15": 0.0787415,
                            "0.25": 0.0984396,
                            "0.35": 0.113902,
                            "0.45": 0.126982,
                            "0.55": 0.137635,
                            "0.65": 0.139611,
                            "0.75": 0.136839,
                            "0.85": 0.0909299,
                            "0.95": 0.0302221,
                        },
                    },
                    "6.75": {
                        "periodfrac": 0.051636,
                        "P_bin": 0.396094,
                        "normed_bin_frac_p_dist": 0.03506,
                        "normed_tripquad_frac_p_dist": 0.1304,
                        "q": {
                            "0.15": 0.330806,
                            "0.25": 0.225165,
                            "0.35": 0.153453,
                            "0.45": 0.0943134,
                            "0.55": 0.0640861,
                            "0.65": 0.0465054,
                            "0.75": 0.0353537,
                            "0.85": 0.0278238,
                            "0.95": 0.0224935,
                        },
                        "e": {
                            "0.05": 0.0457988,
                            "0.15": 0.0780392,
                            "0.25": 0.0980355,
                            "0.35": 0.113797,
                            "0.45": 0.127167,
                            "0.55": 0.138078,
                            "0.65": 0.140104,
                            "0.75": 0.137333,
                            "0.85": 0.0912834,
                            "0.95": 0.0303651,
                        },
                    },
                    "7.25": {
                        "periodfrac": 0.0459092,
                        "P_bin": 0.315726,
                        "normed_bin_frac_p_dist": 0.02485,
                        "normed_tripquad_frac_p_dist": 0.1314,
                        "q": {
                            "0.15": 0.34558,
                            "0.25": 0.223897,
                            "0.35": 0.149542,
                            "0.45": 0.0915727,
                            "0.55": 0.0620436,
                            "0.65": 0.0449151,
                            "0.75": 0.0340746,
                            "0.85": 0.0267693,
                            "0.95": 0.0216066,
                        },
                        "e": {
                            "0.05": 0.045049,
                            "0.15": 0.077447,
                            "0.25": 0.0976935,
                            "0.35": 0.113708,
                            "0.45": 0.127324,
                            "0.55": 0.138456,
                            "0.65": 0.140525,
                            "0.75": 0.137751,
                            "0.85": 0.0915728,
                            "0.95": 0.0304732,
                        },
                    },
                    "7.75": {
                        "periodfrac": 0.0408678,
                        "P_bin": 0.232666,
                        "normed_bin_frac_p_dist": 0.0163,
                        "normed_tripquad_frac_p_dist": 0.1312,
                        "q": {
                            "0.15": 0.360686,
                            "0.25": 0.222389,
                            "0.35": 0.145551,
                            "0.45": 0.0888024,
                            "0.55": 0.0599922,
                            "0.65": 0.043326,
                            "0.75": 0.0328018,
                            "0.85": 0.0257231,
                            "0.95": 0.0207291,
                        },
                        "e": {
                            "0.05": 0.0444139,
                            "0.15": 0.0769404,
                            "0.25": 0.0973993,
                            "0.35": 0.11363,
                            "0.45": 0.12746,
                            "0.55": 0.138783,
                            "0.65": 0.140889,
                            "0.75": 0.138109,
                            "0.85": 0.0918165,
                            "0.95": 0.0305598,
                        },
                    },
                },
            },
            "0.6": {
                "f_multi": 0.9511,
                "multi system fraction": 0.6461,
                "binary star fraction": 0.4936,
                "triple/quad star fraction": 0.1525,
                "single star fraction": 0.3539,
                "poisson_model": {
                    "single_fraction": 0.393,
                    "binary_fraction": 0.373,
                    "triple_fraction": 0.178,
                    "quadruple_fraction": 0.0563,
                },
                "logP": {
                    "0.25": {
                        "periodfrac": 0.0330097,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.05109,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.102481,
                            "0.25": 0.118567,
                            "0.35": 0.119752,
                            "0.45": 0.105502,
                            "0.55": 0.0953799,
                            "0.65": 0.0877103,
                            "0.75": 0.0816384,
                            "0.85": 0.112913,
                            "0.95": 0.176056,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "0.75": {
                        "periodfrac": 0.0451863,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.06994,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.102481,
                            "0.25": 0.118567,
                            "0.35": 0.119752,
                            "0.45": 0.105502,
                            "0.55": 0.0953799,
                            "0.65": 0.0877103,
                            "0.75": 0.0816384,
                            "0.85": 0.112913,
                            "0.95": 0.176056,
                        },
                        "e": {
                            "0.05": 0.968968,
                            "0.15": 0.0192899,
                            "0.25": 0.00587085,
                            "0.35": 0.00559125,
                            "0.45": 0.000279623,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.25": {
                        "periodfrac": 0.046362,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.07176,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.107584,
                            "0.25": 0.12401,
                            "0.35": 0.123739,
                            "0.45": 0.106998,
                            "0.55": 0.0953067,
                            "0.65": 0.086569,
                            "0.75": 0.0797305,
                            "0.85": 0.108487,
                            "0.95": 0.167576,
                        },
                        "e": {
                            "0.05": 0.189656,
                            "0.15": 0.15856,
                            "0.25": 0.147999,
                            "0.35": 0.141534,
                            "0.45": 0.138203,
                            "0.55": 0.135744,
                            "0.65": 0.0788834,
                            "0.75": 0.00942081,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.75": {
                        "periodfrac": 0.0491935,
                        "P_bin": 0.987666,
                        "normed_bin_frac_p_dist": 0.0752,
                        "normed_tripquad_frac_p_dist": 0.001989,
                        "q": {
                            "0.15": 0.121132,
                            "0.25": 0.138332,
                            "0.35": 0.13393,
                            "0.45": 0.110521,
                            "0.55": 0.0948551,
                            "0.65": 0.0835415,
                            "0.75": 0.0749386,
                            "0.85": 0.0971765,
                            "0.95": 0.145573,
                        },
                        "e": {
                            "0.05": 0.089404,
                            "0.15": 0.113288,
                            "0.25": 0.124811,
                            "0.35": 0.132936,
                            "0.45": 0.139325,
                            "0.55": 0.142126,
                            "0.65": 0.140724,
                            "0.75": 0.0931392,
                            "0.85": 0.0242464,
                            "0.95": 0.0,
                        },
                    },
                    "2.25": {
                        "periodfrac": 0.0545914,
                        "P_bin": 0.951206,
                        "normed_bin_frac_p_dist": 0.08037,
                        "normed_tripquad_frac_p_dist": 0.008732,
                        "q": {
                            "0.15": 0.13418,
                            "0.25": 0.151814,
                            "0.35": 0.14324,
                            "0.45": 0.113623,
                            "0.55": 0.0945046,
                            "0.65": 0.0810924,
                            "0.75": 0.0711391,
                            "0.85": 0.0866876,
                            "0.95": 0.123718,
                        },
                        "e": {
                            "0.05": 0.0635493,
                            "0.15": 0.094085,
                            "0.25": 0.110894,
                            "0.35": 0.123446,
                            "0.45": 0.133708,
                            "0.55": 0.140497,
                            "0.65": 0.140881,
                            "0.75": 0.124122,
                            "0.85": 0.0619764,
                            "0.95": 0.0068415,
                        },
                    },
                    "2.75": {
                        "periodfrac": 0.0637868,
                        "P_bin": 0.903558,
                        "normed_bin_frac_p_dist": 0.08921,
                        "normed_tripquad_frac_p_dist": 0.02017,
                        "q": {
                            "0.15": 0.149985,
                            "0.25": 0.164171,
                            "0.35": 0.150615,
                            "0.45": 0.116106,
                            "0.55": 0.0944025,
                            "0.65": 0.0794936,
                            "0.75": 0.0686224,
                            "0.85": 0.0765297,
                            "0.95": 0.100074,
                        },
                        "e": {
                            "0.05": 0.052797,
                            "0.15": 0.0848049,
                            "0.25": 0.103686,
                            "0.35": 0.118231,
                            "0.45": 0.130377,
                            "0.55": 0.139731,
                            "0.65": 0.140998,
                            "0.75": 0.133287,
                            "0.85": 0.0784447,
                            "0.95": 0.0176434,
                        },
                    },
                    "3.25": {
                        "periodfrac": 0.074814,
                        "P_bin": 0.847995,
                        "normed_bin_frac_p_dist": 0.09819,
                        "normed_tripquad_frac_p_dist": 0.03728,
                        "q": {
                            "0.15": 0.174804,
                            "0.25": 0.177005,
                            "0.35": 0.155371,
                            "0.45": 0.116392,
                            "0.55": 0.0925099,
                            "0.65": 0.0764456,
                            "0.75": 0.0649369,
                            "0.85": 0.0658012,
                            "0.95": 0.0767343,
                        },
                        "e": {
                            "0.05": 0.0472325,
                            "0.15": 0.0797719,
                            "0.25": 0.0998024,
                            "0.35": 0.115536,
                            "0.45": 0.12885,
                            "0.55": 0.139698,
                            "0.65": 0.141711,
                            "0.75": 0.136922,
                            "0.85": 0.0861699,
                            "0.95": 0.0243064,
                        },
                    },
                    "3.75": {
                        "periodfrac": 0.0785307,
                        "P_bin": 0.786053,
                        "normed_bin_frac_p_dist": 0.09554,
                        "normed_tripquad_frac_p_dist": 0.05508,
                        "q": {
                            "0.15": 0.2048,
                            "0.25": 0.189209,
                            "0.35": 0.158106,
                            "0.45": 0.115094,
                            "0.55": 0.0894221,
                            "0.65": 0.072514,
                            "0.75": 0.0606123,
                            "0.85": 0.0552786,
                            "0.95": 0.0549647,
                        },
                        "e": {
                            "0.05": 0.0440096,
                            "0.15": 0.0769008,
                            "0.25": 0.0977412,
                            "0.35": 0.114331,
                            "0.45": 0.128499,
                            "0.55": 0.140119,
                            "0.65": 0.142282,
                            "0.75": 0.138553,
                            "0.85": 0.0898649,
                            "0.95": 0.0276982,
                        },
                    },
                    "4.25": {
                        "periodfrac": 0.0765463,
                        "P_bin": 0.718664,
                        "normed_bin_frac_p_dist": 0.08514,
                        "normed_tripquad_frac_p_dist": 0.07059,
                        "q": {
                            "0.15": 0.234964,
                            "0.25": 0.197906,
                            "0.35": 0.157695,
                            "0.45": 0.111958,
                            "0.55": 0.0852778,
                            "0.65": 0.0680251,
                            "0.75": 0.0560665,
                            "0.85": 0.0473518,
                            "0.95": 0.0407552,
                        },
                        "e": {
                            "0.05": 0.0418763,
                            "0.15": 0.0749941,
                            "0.25": 0.0964207,
                            "0.35": 0.113644,
                            "0.45": 0.128452,
                            "0.55": 0.140655,
                            "0.65": 0.142931,
                            "0.75": 0.139684,
                            "0.85": 0.0918217,
                            "0.95": 0.0295207,
                        },
                    },
                    "4.75": {
                        "periodfrac": 0.0739631,
                        "P_bin": 0.646468,
                        "normed_bin_frac_p_dist": 0.07401,
                        "normed_tripquad_frac_p_dist": 0.08572,
                        "q": {
                            "0.15": 0.265211,
                            "0.25": 0.2035,
                            "0.35": 0.154375,
                            "0.45": 0.106645,
                            "0.55": 0.0794898,
                            "0.65": 0.0622794,
                            "0.75": 0.0505491,
                            "0.85": 0.0421235,
                            "0.95": 0.0358264,
                        },
                        "e": {
                            "0.05": 0.0403651,
                            "0.15": 0.0736445,
                            "0.25": 0.0955183,
                            "0.35": 0.113232,
                            "0.45": 0.128539,
                            "0.55": 0.1412,
                            "0.65": 0.143566,
                            "0.75": 0.140535,
                            "0.85": 0.0929468,
                            "0.95": 0.0304539,
                        },
                    },
                    "5.25": {
                        "periodfrac": 0.0718829,
                        "P_bin": 0.569941,
                        "normed_bin_frac_p_dist": 0.06341,
                        "normed_tripquad_frac_p_dist": 0.1013,
                        "q": {
                            "0.15": 0.301072,
                            "0.25": 0.210293,
                            "0.35": 0.150861,
                            "0.45": 0.100219,
                            "0.55": 0.0724218,
                            "0.65": 0.0553033,
                            "0.75": 0.0439129,
                            "0.85": 0.0358992,
                            "0.95": 0.0300177,
                        },
                        "e": {
                            "0.05": 0.0392364,
                            "0.15": 0.072635,
                            "0.25": 0.0948601,
                            "0.35": 0.112963,
                            "0.45": 0.128669,
                            "0.55": 0.141699,
                            "0.65": 0.144137,
                            "0.75": 0.141201,
                            "0.85": 0.0936503,
                            "0.95": 0.0309481,
                        },
                    },
                    "5.75": {
                        "periodfrac": 0.0682327,
                        "P_bin": 0.48945,
                        "normed_bin_frac_p_dist": 0.05169,
                        "normed_tripquad_frac_p_dist": 0.1142,
                        "q": {
                            "0.15": 0.334579,
                            "0.25": 0.215751,
                            "0.35": 0.147135,
                            "0.45": 0.0939886,
                            "0.55": 0.0658452,
                            "0.65": 0.0490058,
                            "0.75": 0.0380678,
                            "0.85": 0.0305299,
                            "0.95": 0.0250978,
                        },
                        "e": {
                            "0.05": 0.0383588,
                            "0.15": 0.0718466,
                            "0.25": 0.0943537,
                            "0.35": 0.112773,
                            "0.45": 0.128805,
                            "0.55": 0.142136,
                            "0.65": 0.144632,
                            "0.75": 0.141737,
                            "0.85": 0.0941283,
                            "0.95": 0.0312285,
                        },
                    },
                    "6.25": {
                        "periodfrac": 0.0629732,
                        "P_bin": 0.405291,
                        "normed_bin_frac_p_dist": 0.0395,
                        "normed_tripquad_frac_p_dist": 0.1228,
                        "q": {
                            "0.15": 0.357855,
                            "0.25": 0.221346,
                            "0.35": 0.145556,
                            "0.45": 0.0894015,
                            "0.55": 0.0607171,
                            "0.65": 0.0440421,
                            "0.75": 0.0334687,
                            "0.85": 0.0263321,
                            "0.95": 0.0212816,
                        },
                        "e": {
                            "0.05": 0.0376554,
                            "0.15": 0.0712107,
                            "0.25": 0.0939481,
                            "0.35": 0.112628,
                            "0.45": 0.12893,
                            "0.55": 0.142513,
                            "0.65": 0.145058,
                            "0.75": 0.142178,
                            "0.85": 0.0944774,
                            "0.95": 0.0314012,
                        },
                    },
                    "6.75": {
                        "periodfrac": 0.0570407,
                        "P_bin": 0.317709,
                        "normed_bin_frac_p_dist": 0.02805,
                        "normed_tripquad_frac_p_dist": 0.1276,
                        "q": {
                            "0.15": 0.37663,
                            "0.25": 0.223421,
                            "0.35": 0.142863,
                            "0.45": 0.0857029,
                            "0.55": 0.0571304,
                            "0.65": 0.0408055,
                            "0.75": 0.0306032,
                            "0.85": 0.0238021,
                            "0.95": 0.0190414,
                        },
                        "e": {
                            "0.05": 0.0370779,
                            "0.15": 0.070685,
                            "0.25": 0.0936136,
                            "0.35": 0.112512,
                            "0.45": 0.129041,
                            "0.55": 0.142836,
                            "0.65": 0.145423,
                            "0.75": 0.142546,
                            "0.85": 0.0947484,
                            "0.95": 0.0315176,
                        },
                    },
                    "7.25": {
                        "periodfrac": 0.0504244,
                        "P_bin": 0.22691,
                        "normed_bin_frac_p_dist": 0.01771,
                        "normed_tripquad_frac_p_dist": 0.1278,
                        "q": {
                            "0.15": 0.388895,
                            "0.25": 0.22122,
                            "0.35": 0.139268,
                            "0.45": 0.0835465,
                            "0.55": 0.055693,
                            "0.65": 0.0397788,
                            "0.75": 0.0298331,
                            "0.85": 0.0232032,
                            "0.95": 0.0185622,
                        },
                        "e": {
                            "0.05": 0.036595,
                            "0.15": 0.0702422,
                            "0.25": 0.0933316,
                            "0.35": 0.112415,
                            "0.45": 0.129138,
                            "0.55": 0.143113,
                            "0.65": 0.145736,
                            "0.75": 0.142858,
                            "0.85": 0.0949681,
                            "0.95": 0.0316031,
                        },
                    },
                    "7.75": {
                        "periodfrac": 0.0446112,
                        "P_bin": 0.133069,
                        "normed_bin_frac_p_dist": 0.009188,
                        "normed_tripquad_frac_p_dist": 0.1268,
                        "q": {
                            "0.15": 0.401336,
                            "0.25": 0.218886,
                            "0.35": 0.135658,
                            "0.45": 0.0813807,
                            "0.55": 0.054249,
                            "0.65": 0.0387475,
                            "0.75": 0.0290598,
                            "0.85": 0.0226016,
                            "0.95": 0.0180811,
                        },
                        "e": {
                            "0.05": 0.0361847,
                            "0.15": 0.0698635,
                            "0.25": 0.0930898,
                            "0.35": 0.112332,
                            "0.45": 0.129222,
                            "0.55": 0.143353,
                            "0.65": 0.146007,
                            "0.75": 0.143126,
                            "0.85": 0.0951519,
                            "0.95": 0.03167,
                        },
                    },
                },
            },
            "0.7": {
                "f_multi": 1.125,
                "multi system fraction": 0.73,
                "binary star fraction": 0.5326,
                "triple/quad star fraction": 0.1975,
                "single star fraction": 0.27,
                "poisson_model": {
                    "single_fraction": 0.334,
                    "binary_fraction": 0.376,
                    "triple_fraction": 0.211,
                    "quadruple_fraction": 0.0792,
                },
                "logP": {
                    "0.25": {
                        "periodfrac": 0.0367634,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.05036,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.105975,
                            "0.25": 0.119919,
                            "0.35": 0.120154,
                            "0.45": 0.105856,
                            "0.55": 0.0956998,
                            "0.65": 0.0880047,
                            "0.75": 0.0819123,
                            "0.85": 0.111358,
                            "0.95": 0.171121,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "0.75": {
                        "periodfrac": 0.0541015,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.07411,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.105975,
                            "0.25": 0.119919,
                            "0.35": 0.120154,
                            "0.45": 0.105856,
                            "0.55": 0.0956998,
                            "0.65": 0.0880047,
                            "0.75": 0.0819123,
                            "0.85": 0.111358,
                            "0.95": 0.171121,
                        },
                        "e": {
                            "0.05": 0.819461,
                            "0.15": 0.0897422,
                            "0.25": 0.0465648,
                            "0.35": 0.0375135,
                            "0.45": 0.00671838,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.25": {
                        "periodfrac": 0.0555348,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.07607,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.115858,
                            "0.25": 0.129748,
                            "0.35": 0.127009,
                            "0.45": 0.108166,
                            "0.55": 0.0951894,
                            "0.65": 0.0855984,
                            "0.75": 0.0781623,
                            "0.85": 0.103512,
                            "0.95": 0.156757,
                        },
                        "e": {
                            "0.05": 0.11718,
                            "0.15": 0.141046,
                            "0.25": 0.15207,
                            "0.35": 0.159702,
                            "0.45": 0.163916,
                            "0.55": 0.161214,
                            "0.65": 0.0936844,
                            "0.75": 0.0111885,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.75": {
                        "periodfrac": 0.0593772,
                        "P_bin": 0.986065,
                        "normed_bin_frac_p_dist": 0.0802,
                        "normed_tripquad_frac_p_dist": 0.002095,
                        "q": {
                            "0.15": 0.14306,
                            "0.25": 0.156095,
                            "0.35": 0.144232,
                            "0.45": 0.112832,
                            "0.55": 0.0928181,
                            "0.65": 0.0789201,
                            "0.75": 0.0686942,
                            "0.85": 0.0836281,
                            "0.95": 0.11972,
                        },
                        "e": {
                            "0.05": 0.0613499,
                            "0.15": 0.0977503,
                            "0.25": 0.119076,
                            "0.35": 0.135453,
                            "0.45": 0.149099,
                            "0.55": 0.155278,
                            "0.65": 0.153746,
                            "0.75": 0.101758,
                            "0.85": 0.0264899,
                            "0.95": 0.0,
                        },
                    },
                    "2.25": {
                        "periodfrac": 0.0667909,
                        "P_bin": 0.944873,
                        "normed_bin_frac_p_dist": 0.08645,
                        "normed_tripquad_frac_p_dist": 0.009323,
                        "q": {
                            "0.15": 0.168931,
                            "0.25": 0.179578,
                            "0.35": 0.158528,
                            "0.45": 0.11624,
                            "0.55": 0.0908323,
                            "0.65": 0.0740089,
                            "0.75": 0.0621141,
                            "0.85": 0.0662466,
                            "0.95": 0.0835209,
                        },
                        "e": {
                            "0.05": 0.0460648,
                            "0.15": 0.0817766,
                            "0.25": 0.10471,
                            "0.35": 0.123082,
                            "0.45": 0.138839,
                            "0.55": 0.149596,
                            "0.65": 0.150212,
                            "0.75": 0.132344,
                            "0.85": 0.0660814,
                            "0.95": 0.00729461,
                        },
                    },
                    "2.75": {
                        "periodfrac": 0.0786553,
                        "P_bin": 0.89104,
                        "normed_bin_frac_p_dist": 0.096,
                        "normed_tripquad_frac_p_dist": 0.0217,
                        "q": {
                            "0.15": 0.190257,
                            "0.25": 0.19497,
                            "0.35": 0.166671,
                            "0.45": 0.118106,
                            "0.55": 0.0898243,
                            "0.65": 0.0715621,
                            "0.75": 0.0589184,
                            "0.85": 0.0541796,
                            "0.95": 0.0555113,
                        },
                        "e": {
                            "0.05": 0.0395114,
                            "0.15": 0.0742838,
                            "0.25": 0.0977291,
                            "0.35": 0.116945,
                            "0.45": 0.133688,
                            "0.55": 0.146977,
                            "0.65": 0.1488,
                            "0.75": 0.140662,
                            "0.85": 0.082785,
                            "0.95": 0.0186195,
                        },
                    },
                    "3.25": {
                        "periodfrac": 0.0925768,
                        "P_bin": 0.828266,
                        "normed_bin_frac_p_dist": 0.105,
                        "normed_tripquad_frac_p_dist": 0.04025,
                        "q": {
                            "0.15": 0.218562,
                            "0.25": 0.207334,
                            "0.35": 0.169143,
                            "0.45": 0.115825,
                            "0.55": 0.0857339,
                            "0.65": 0.0667854,
                            "0.75": 0.0539398,
                            "0.85": 0.0447563,
                            "0.95": 0.0379204,
                        },
                        "e": {
                            "0.05": 0.0361113,
                            "0.15": 0.0703497,
                            "0.25": 0.0941424,
                            "0.35": 0.113926,
                            "0.45": 0.131334,
                            "0.55": 0.145926,
                            "0.65": 0.148668,
                            "0.75": 0.143643,
                            "0.85": 0.0904,
                            "0.95": 0.0254995,
                        },
                    },
                    "3.75": {
                        "periodfrac": 0.0971763,
                        "P_bin": 0.758284,
                        "normed_bin_frac_p_dist": 0.1009,
                        "normed_tripquad_frac_p_dist": 0.05947,
                        "q": {
                            "0.15": 0.254059,
                            "0.25": 0.214823,
                            "0.35": 0.164956,
                            "0.45": 0.109153,
                            "0.55": 0.078632,
                            "0.65": 0.059891,
                            "0.75": 0.0474509,
                            "0.85": 0.0387171,
                            "0.95": 0.0323187,
                        },
                        "e": {
                            "0.05": 0.0341872,
                            "0.15": 0.0682335,
                            "0.25": 0.0923841,
                            "0.35": 0.112664,
                            "0.45": 0.130632,
                            "0.55": 0.145766,
                            "0.65": 0.148616,
                            "0.75": 0.144721,
                            "0.85": 0.0938653,
                            "0.95": 0.0289313,
                        },
                    },
                    "4.25": {
                        "periodfrac": 0.0943052,
                        "P_bin": 0.682147,
                        "normed_bin_frac_p_dist": 0.08812,
                        "normed_tripquad_frac_p_dist": 0.0759,
                        "q": {
                            "0.15": 0.289723,
                            "0.25": 0.218105,
                            "0.35": 0.158426,
                            "0.45": 0.102344,
                            "0.55": 0.0723385,
                            "0.65": 0.054236,
                            "0.75": 0.0423963,
                            "0.85": 0.0341886,
                            "0.95": 0.0282425,
                        },
                        "e": {
                            "0.05": 0.0329135,
                            "0.15": 0.0668544,
                            "0.25": 0.0912915,
                            "0.35": 0.11196,
                            "0.45": 0.130363,
                            "0.55": 0.14592,
                            "0.65": 0.148854,
                            "0.75": 0.145472,
                            "0.85": 0.0956265,
                            "0.95": 0.0307439,
                        },
                    },
                    "4.75": {
                        "periodfrac": 0.0900012,
                        "P_bin": 0.600581,
                        "normed_bin_frac_p_dist": 0.07404,
                        "normed_tripquad_frac_p_dist": 0.09102,
                        "q": {
                            "0.15": 0.324488,
                            "0.25": 0.21722,
                            "0.35": 0.150133,
                            "0.45": 0.0958258,
                            "0.55": 0.067089,
                            "0.65": 0.0499049,
                            "0.75": 0.0387485,
                            "0.85": 0.0310636,
                            "0.95": 0.0255275,
                        },
                        "e": {
                            "0.05": 0.0320119,
                            "0.15": 0.065894,
                            "0.25": 0.0905656,
                            "0.35": 0.111548,
                            "0.45": 0.130299,
                            "0.55": 0.146195,
                            "0.65": 0.149197,
                            "0.75": 0.146047,
                            "0.85": 0.0965928,
                            "0.95": 0.0316487,
                        },
                    },
                    "5.25": {
                        "periodfrac": 0.0855309,
                        "P_bin": 0.514121,
                        "normed_bin_frac_p_dist": 0.06024,
                        "normed_tripquad_frac_p_dist": 0.1052,
                        "q": {
                            "0.15": 0.362957,
                            "0.25": 0.215805,
                            "0.35": 0.14144,
                            "0.45": 0.0887369,
                            "0.55": 0.061286,
                            "0.65": 0.0450769,
                            "0.75": 0.0346643,
                            "0.85": 0.0275568,
                            "0.95": 0.0224772,
                        },
                        "e": {
                            "0.05": 0.0313381,
                            "0.15": 0.0651836,
                            "0.25": 0.0900478,
                            "0.35": 0.111285,
                            "0.45": 0.130321,
                            "0.55": 0.146493,
                            "0.65": 0.14955,
                            "0.75": 0.146504,
                            "0.85": 0.0971677,
                            "0.95": 0.0321107,
                        },
                    },
                    "5.75": {
                        "periodfrac": 0.0793281,
                        "P_bin": 0.423183,
                        "normed_bin_frac_p_dist": 0.04599,
                        "normed_tripquad_frac_p_dist": 0.1159,
                        "q": {
                            "0.15": 0.396639,
                            "0.25": 0.21391,
                            "0.35": 0.133967,
                            "0.45": 0.0826136,
                            "0.55": 0.056285,
                            "0.65": 0.0409344,
                            "0.75": 0.0311766,
                            "0.85": 0.0245769,
                            "0.95": 0.0198972,
                        },
                        "e": {
                            "0.05": 0.0308133,
                            "0.15": 0.0646329,
                            "0.25": 0.0896557,
                            "0.35": 0.111103,
                            "0.45": 0.130373,
                            "0.55": 0.146773,
                            "0.65": 0.149875,
                            "0.75": 0.146875,
                            "0.85": 0.0975399,
                            "0.95": 0.0323602,
                        },
                    },
                    "6.25": {
                        "periodfrac": 0.0707152,
                        "P_bin": 0.328101,
                        "normed_bin_frac_p_dist": 0.03178,
                        "normed_tripquad_frac_p_dist": 0.1203,
                        "q": {
                            "0.15": 0.407218,
                            "0.25": 0.215584,
                            "0.35": 0.132864,
                            "0.45": 0.0805336,
                            "0.55": 0.0541251,
                            "0.65": 0.0389218,
                            "0.75": 0.0293599,
                            "0.85": 0.0229506,
                            "0.95": 0.0184426,
                        },
                        "e": {
                            "0.05": 0.0303916,
                            "0.15": 0.0641905,
                            "0.25": 0.089345,
                            "0.35": 0.110967,
                            "0.45": 0.130433,
                            "0.55": 0.147022,
                            "0.65": 0.150162,
                            "0.75": 0.147181,
                            "0.85": 0.0978021,
                            "0.95": 0.0325061,
                        },
                    },
                    "6.75": {
                        "periodfrac": 0.0623626,
                        "P_bin": 0.229151,
                        "normed_bin_frac_p_dist": 0.01958,
                        "normed_tripquad_frac_p_dist": 0.1217,
                        "q": {
                            "0.15": 0.415759,
                            "0.25": 0.216059,
                            "0.35": 0.131516,
                            "0.45": 0.0788959,
                            "0.55": 0.0525927,
                            "0.65": 0.0375646,
                            "0.75": 0.0281725,
                            "0.85": 0.0219116,
                            "0.95": 0.017529,
                        },
                        "e": {
                            "0.05": 0.0300446,
                            "0.15": 0.0638256,
                            "0.25": 0.0890905,
                            "0.35": 0.110859,
                            "0.45": 0.13049,
                            "0.55": 0.147241,
                            "0.65": 0.150413,
                            "0.75": 0.147437,
                            "0.85": 0.0979999,
                            "0.95": 0.0325993,
                        },
                    },
                    "7.25": {
                        "periodfrac": 0.0543633,
                        "P_bin": 0.126566,
                        "normed_bin_frac_p_dist": 0.009425,
                        "normed_tripquad_frac_p_dist": 0.1202,
                        "q": {
                            "0.15": 0.421344,
                            "0.25": 0.21493,
                            "0.35": 0.129924,
                            "0.45": 0.0779411,
                            "0.55": 0.0519562,
                            "0.65": 0.0371099,
                            "0.75": 0.0278315,
                            "0.85": 0.0216463,
                            "0.95": 0.0173169,
                        },
                        "e": {
                            "0.05": 0.0297534,
                            "0.15": 0.0635184,
                            "0.25": 0.0888767,
                            "0.35": 0.110771,
                            "0.45": 0.130542,
                            "0.55": 0.147431,
                            "0.65": 0.15063,
                            "0.75": 0.147656,
                            "0.85": 0.0981575,
                            "0.95": 0.0326643,
                        },
                    },
                    "7.75": {
                        "periodfrac": 0.0473976,
                        "P_bin": 0.0257108,
                        "normed_bin_frac_p_dist": 0.001669,
                        "normed_tripquad_frac_p_dist": 0.1169,
                        "q": {
                            "0.15": 0.426955,
                            "0.25": 0.213777,
                            "0.35": 0.128332,
                            "0.45": 0.0769858,
                            "0.55": 0.0513192,
                            "0.65": 0.036655,
                            "0.75": 0.0274903,
                            "0.85": 0.0213811,
                            "0.95": 0.0171046,
                        },
                        "e": {
                            "0.05": 0.0295055,
                            "0.15": 0.0632558,
                            "0.25": 0.0886941,
                            "0.35": 0.110696,
                            "0.45": 0.130589,
                            "0.55": 0.147596,
                            "0.65": 0.150819,
                            "0.75": 0.147843,
                            "0.85": 0.098288,
                            "0.95": 0.0327138,
                        },
                    },
                },
            },
            "0.8": {
                "f_multi": 1.3159,
                "multi system fraction": 0.813,
                "binary star fraction": 0.5616,
                "triple/quad star fraction": 0.2514,
                "single star fraction": 0.187,
                "poisson_model": {
                    "single_fraction": 0.281,
                    "binary_fraction": 0.389,
                    "triple_fraction": 0.243,
                    "quadruple_fraction": 0.107,
                },
                "logP": {
                    "0.25": {
                        "periodfrac": 0.0401803,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.04942,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.109018,
                            "0.25": 0.121239,
                            "0.35": 0.120718,
                            "0.45": 0.106352,
                            "0.55": 0.0961489,
                            "0.65": 0.0884176,
                            "0.75": 0.0822966,
                            "0.85": 0.109808,
                            "0.95": 0.166002,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "0.75": {
                        "periodfrac": 0.0640203,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.07874,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.109018,
                            "0.25": 0.121239,
                            "0.35": 0.120718,
                            "0.45": 0.106352,
                            "0.55": 0.0961489,
                            "0.65": 0.0884176,
                            "0.75": 0.0822966,
                            "0.85": 0.109808,
                            "0.95": 0.166002,
                        },
                        "e": {
                            "0.05": 0.456345,
                            "0.15": 0.21286,
                            "0.25": 0.164486,
                            "0.35": 0.141047,
                            "0.45": 0.0252609,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.25": {
                        "periodfrac": 0.0663314,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.08158,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.125178,
                            "0.25": 0.137052,
                            "0.35": 0.132163,
                            "0.45": 0.111225,
                            "0.55": 0.0969602,
                            "0.65": 0.0865087,
                            "0.75": 0.0784647,
                            "0.85": 0.0963177,
                            "0.95": 0.136131,
                        },
                        "e": {
                            "0.05": 0.0720781,
                            "0.15": 0.120016,
                            "0.25": 0.149172,
                            "0.35": 0.171947,
                            "0.45": 0.185409,
                            "0.55": 0.182595,
                            "0.65": 0.106109,
                            "0.75": 0.0126722,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.75": {
                        "periodfrac": 0.0729304,
                        "P_bin": 0.984256,
                        "normed_bin_frac_p_dist": 0.08829,
                        "normed_tripquad_frac_p_dist": 0.002283,
                        "q": {
                            "0.15": 0.173767,
                            "0.25": 0.182941,
                            "0.35": 0.163,
                            "0.45": 0.122293,
                            "0.55": 0.0973169,
                            "0.65": 0.0804982,
                            "0.75": 0.0684377,
                            "0.85": 0.0593877,
                            "0.95": 0.0523587,
                        },
                        "e": {
                            "0.05": 0.0421728,
                            "0.15": 0.0831082,
                            "0.25": 0.111834,
                            "0.35": 0.135831,
                            "0.45": 0.157015,
                            "0.55": 0.166914,
                            "0.65": 0.165267,
                            "0.75": 0.109383,
                            "0.85": 0.0284751,
                            "0.95": 0.0,
                        },
                    },
                    "2.25": {
                        "periodfrac": 0.0814014,
                        "P_bin": 0.937717,
                        "normed_bin_frac_p_dist": 0.09388,
                        "normed_tripquad_frac_p_dist": 0.01008,
                        "q": {
                            "0.15": 0.203124,
                            "0.25": 0.205604,
                            "0.35": 0.172362,
                            "0.45": 0.118827,
                            "0.55": 0.0884266,
                            "0.65": 0.0691883,
                            "0.75": 0.0560923,
                            "0.85": 0.046696,
                            "0.95": 0.03968,
                        },
                        "e": {
                            "0.05": 0.033454,
                            "0.15": 0.0704774,
                            "0.25": 0.0979719,
                            "0.35": 0.12158,
                            "0.45": 0.142818,
                            "0.55": 0.15778,
                            "0.65": 0.158647,
                            "0.75": 0.139775,
                            "0.85": 0.0697923,
                            "0.95": 0.00770424,
                        },
                    },
                    "2.75": {
                        "periodfrac": 0.0939716,
                        "P_bin": 0.876897,
                        "normed_bin_frac_p_dist": 0.1014,
                        "normed_tripquad_frac_p_dist": 0.02301,
                        "q": {
                            "0.15": 0.221344,
                            "0.25": 0.21538,
                            "0.35": 0.174296,
                            "0.45": 0.115617,
                            "0.55": 0.0834503,
                            "0.65": 0.0636632,
                            "0.75": 0.050509,
                            "0.85": 0.0412618,
                            "0.95": 0.0344798,
                        },
                        "e": {
                            "0.05": 0.0296171,
                            "0.15": 0.0646695,
                            "0.25": 0.091503,
                            "0.35": 0.11489,
                            "0.45": 0.136147,
                            "0.55": 0.153532,
                            "0.65": 0.155947,
                            "0.75": 0.147418,
                            "0.85": 0.0867615,
                            "0.95": 0.0195137,
                        },
                    },
                    "3.25": {
                        "periodfrac": 0.109772,
                        "P_bin": 0.805975,
                        "normed_bin_frac_p_dist": 0.1088,
                        "normed_tripquad_frac_p_dist": 0.04236,
                        "q": {
                            "0.15": 0.248672,
                            "0.25": 0.22411,
                            "0.35": 0.172737,
                            "0.45": 0.110243,
                            "0.55": 0.0771766,
                            "0.65": 0.0574048,
                            "0.75": 0.0445694,
                            "0.85": 0.0357285,
                            "0.95": 0.0293595,
                        },
                        "e": {
                            "0.05": 0.0276483,
                            "0.15": 0.0617348,
                            "0.25": 0.0883279,
                            "0.35": 0.111724,
                            "0.45": 0.133127,
                            "0.55": 0.151583,
                            "0.65": 0.155094,
                            "0.75": 0.149852,
                            "0.85": 0.0943075,
                            "0.95": 0.0266017,
                        },
                    },
                    "3.75": {
                        "periodfrac": 0.116658,
                        "P_bin": 0.72691,
                        "normed_bin_frac_p_dist": 0.1043,
                        "normed_tripquad_frac_p_dist": 0.06335,
                        "q": {
                            "0.15": 0.291778,
                            "0.25": 0.230106,
                            "0.35": 0.16546,
                            "0.45": 0.101592,
                            "0.55": 0.0689779,
                            "0.65": 0.0500228,
                            "0.75": 0.0380064,
                            "0.85": 0.0298971,
                            "0.95": 0.0241592,
                        },
                        "e": {
                            "0.05": 0.0265923,
                            "0.15": 0.0602908,
                            "0.25": 0.0869235,
                            "0.35": 0.110506,
                            "0.45": 0.132176,
                            "0.55": 0.150922,
                            "0.65": 0.154493,
                            "0.75": 0.150444,
                            "0.85": 0.0975773,
                            "0.95": 0.0300756,
                        },
                    },
                    "4.25": {
                        "periodfrac": 0.113885,
                        "P_bin": 0.640891,
                        "normed_bin_frac_p_dist": 0.08977,
                        "normed_tripquad_frac_p_dist": 0.08133,
                        "q": {
                            "0.15": 0.33415,
                            "0.25": 0.230234,
                            "0.35": 0.155604,
                            "0.45": 0.0933459,
                            "0.55": 0.0622253,
                            "0.65": 0.0444447,
                            "0.75": 0.0333324,
                            "0.85": 0.0259249,
                            "0.95": 0.0207394,
                        },
                        "e": {
                            "0.05": 0.0259011,
                            "0.15": 0.0593791,
                            "0.25": 0.0860876,
                            "0.35": 0.109848,
                            "0.45": 0.131753,
                            "0.55": 0.150747,
                            "0.65": 0.154369,
                            "0.75": 0.150862,
                            "0.85": 0.0991696,
                            "0.95": 0.031883,
                        },
                    },
                    "4.75": {
                        "periodfrac": 0.107834,
                        "P_bin": 0.548738,
                        "normed_bin_frac_p_dist": 0.07278,
                        "normed_tripquad_frac_p_dist": 0.09677,
                        "q": {
                            "0.15": 0.372832,
                            "0.25": 0.224083,
                            "0.35": 0.143984,
                            "0.45": 0.0863753,
                            "0.55": 0.0575785,
                            "0.65": 0.0411255,
                            "0.75": 0.0308433,
                            "0.85": 0.0239887,
                            "0.95": 0.0191907,
                        },
                        "e": {
                            "0.05": 0.025417,
                            "0.15": 0.0587624,
                            "0.25": 0.0855558,
                            "0.35": 0.109477,
                            "0.45": 0.131586,
                            "0.55": 0.15079,
                            "0.65": 0.154455,
                            "0.75": 0.151195,
                            "0.85": 0.0999972,
                            "0.95": 0.0327642,
                        },
                    },
                    "5.25": {
                        "periodfrac": 0.100769,
                        "P_bin": 0.451056,
                        "normed_bin_frac_p_dist": 0.0559,
                        "normed_tripquad_frac_p_dist": 0.11,
                        "q": {
                            "0.15": 0.413585,
                            "0.25": 0.216494,
                            "0.35": 0.132137,
                            "0.45": 0.0792686,
                            "0.55": 0.0528411,
                            "0.65": 0.037742,
                            "0.75": 0.0283054,
                            "0.85": 0.0220151,
                            "0.95": 0.0176119,
                        },
                        "e": {
                            "0.05": 0.0250575,
                            "0.15": 0.0583163,
                            "0.25": 0.0851904,
                            "0.35": 0.109251,
                            "0.45": 0.131532,
                            "0.55": 0.150914,
                            "0.65": 0.154615,
                            "0.75": 0.151467,
                            "0.85": 0.100459,
                            "0.95": 0.0331982,
                        },
                    },
                    "5.75": {
                        "periodfrac": 0.0916901,
                        "P_bin": 0.348314,
                        "normed_bin_frac_p_dist": 0.03928,
                        "normed_tripquad_frac_p_dist": 0.1188,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0247784,
                            "0.15": 0.0579754,
                            "0.25": 0.084921,
                            "0.35": 0.109101,
                            "0.45": 0.131527,
                            "0.55": 0.151058,
                            "0.65": 0.154789,
                            "0.75": 0.151691,
                            "0.85": 0.100738,
                            "0.95": 0.0334216,
                        },
                    },
                    "6.25": {
                        "periodfrac": 0.0791704,
                        "P_bin": 0.240891,
                        "normed_bin_frac_p_dist": 0.02346,
                        "normed_tripquad_frac_p_dist": 0.1195,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0245542,
                            "0.15": 0.0577039,
                            "0.25": 0.0847115,
                            "0.35": 0.108992,
                            "0.45": 0.131541,
                            "0.55": 0.151198,
                            "0.65": 0.154955,
                            "0.75": 0.151878,
                            "0.85": 0.100923,
                            "0.95": 0.0335437,
                        },
                    },
                    "6.75": {
                        "periodfrac": 0.0681426,
                        "P_bin": 0.129098,
                        "normed_bin_frac_p_dist": 0.01082,
                        "normed_tripquad_frac_p_dist": 0.118,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0243695,
                            "0.15": 0.057481,
                            "0.25": 0.0845418,
                            "0.35": 0.108909,
                            "0.45": 0.131562,
                            "0.55": 0.151325,
                            "0.65": 0.155104,
                            "0.75": 0.152036,
                            "0.85": 0.101056,
                            "0.95": 0.0336158,
                        },
                    },
                    "7.25": {
                        "periodfrac": 0.0586509,
                        "P_bin": 0.0220797,
                        "normed_bin_frac_p_dist": 0.001593,
                        "normed_tripquad_frac_p_dist": 0.1141,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0242143,
                            "0.15": 0.057294,
                            "0.25": 0.0844004,
                            "0.35": 0.108841,
                            "0.45": 0.131584,
                            "0.55": 0.151438,
                            "0.65": 0.155236,
                            "0.75": 0.15217,
                            "0.85": 0.101159,
                            "0.95": 0.0336631,
                        },
                    },
                    "7.75": {
                        "periodfrac": 0.0504813,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.1004,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0240818,
                            "0.15": 0.0571342,
                            "0.25": 0.0842799,
                            "0.35": 0.108784,
                            "0.45": 0.131605,
                            "0.55": 0.151538,
                            "0.65": 0.155352,
                            "0.75": 0.152286,
                            "0.85": 0.101242,
                            "0.95": 0.033697,
                        },
                    },
                },
            },
            "0.9": {
                "f_multi": 1.4101,
                "multi system fraction": 0.832,
                "binary star fraction": 0.5429,
                "triple/quad star fraction": 0.2891,
                "single star fraction": 0.168,
                "poisson_model": {
                    "single_fraction": 0.258,
                    "binary_fraction": 0.364,
                    "triple_fraction": 0.257,
                    "quadruple_fraction": 0.121,
                },
                "logP": {
                    "0.25": {
                        "periodfrac": 0.044844,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.0539,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.10995,
                            "0.25": 0.122275,
                            "0.35": 0.12175,
                            "0.45": 0.107261,
                            "0.55": 0.0969706,
                            "0.65": 0.0891732,
                            "0.75": 0.083,
                            "0.85": 0.10853,
                            "0.95": 0.16109,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "0.75": {
                        "periodfrac": 0.07474,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.08983,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.10995,
                            "0.25": 0.122275,
                            "0.35": 0.12175,
                            "0.45": 0.107261,
                            "0.55": 0.0969706,
                            "0.65": 0.0891732,
                            "0.75": 0.083,
                            "0.85": 0.10853,
                            "0.95": 0.16109,
                        },
                        "e": {
                            "0.05": 0.30542,
                            "0.15": 0.241728,
                            "0.25": 0.222153,
                            "0.35": 0.195657,
                            "0.45": 0.0350411,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.25": {
                        "periodfrac": 0.0769996,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.09255,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.128184,
                            "0.25": 0.140343,
                            "0.35": 0.135337,
                            "0.45": 0.113896,
                            "0.55": 0.0992885,
                            "0.65": 0.0885861,
                            "0.75": 0.0803489,
                            "0.85": 0.092405,
                            "0.95": 0.121612,
                        },
                        "e": {
                            "0.05": 0.0579589,
                            "0.15": 0.110502,
                            "0.25": 0.146352,
                            "0.35": 0.175902,
                            "0.45": 0.193908,
                            "0.55": 0.191078,
                            "0.65": 0.111039,
                            "0.75": 0.013261,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.75": {
                        "periodfrac": 0.0818065,
                        "P_bin": 0.982213,
                        "normed_bin_frac_p_dist": 0.09658,
                        "normed_tripquad_frac_p_dist": 0.002517,
                        "q": {
                            "0.15": 0.173767,
                            "0.25": 0.182941,
                            "0.35": 0.163,
                            "0.45": 0.122293,
                            "0.55": 0.0973169,
                            "0.65": 0.0804982,
                            "0.75": 0.0684377,
                            "0.85": 0.0593877,
                            "0.95": 0.0523587,
                        },
                        "e": {
                            "0.05": 0.0356491,
                            "0.15": 0.07696,
                            "0.25": 0.108281,
                            "0.35": 0.135449,
                            "0.45": 0.160063,
                            "0.55": 0.171728,
                            "0.65": 0.170034,
                            "0.75": 0.112538,
                            "0.85": 0.0292965,
                            "0.95": 0.0,
                        },
                    },
                    "2.25": {
                        "periodfrac": 0.0890256,
                        "P_bin": 0.929633,
                        "normed_bin_frac_p_dist": 0.09948,
                        "normed_tripquad_frac_p_dist": 0.01084,
                        "q": {
                            "0.15": 0.203124,
                            "0.25": 0.205604,
                            "0.35": 0.172362,
                            "0.45": 0.118827,
                            "0.55": 0.0884266,
                            "0.65": 0.0691883,
                            "0.75": 0.0560923,
                            "0.85": 0.046696,
                            "0.95": 0.03968,
                        },
                        "e": {
                            "0.05": 0.0289821,
                            "0.15": 0.0657598,
                            "0.25": 0.0948453,
                            "0.35": 0.120607,
                            "0.45": 0.144287,
                            "0.55": 0.161204,
                            "0.65": 0.16219,
                            "0.75": 0.142897,
                            "0.85": 0.0713511,
                            "0.95": 0.00787633,
                        },
                    },
                    "2.75": {
                        "periodfrac": 0.101996,
                        "P_bin": 0.860919,
                        "normed_bin_frac_p_dist": 0.1055,
                        "normed_tripquad_frac_p_dist": 0.02454,
                        "q": {
                            "0.15": 0.221344,
                            "0.25": 0.21538,
                            "0.35": 0.174296,
                            "0.45": 0.115617,
                            "0.55": 0.0834503,
                            "0.65": 0.0636632,
                            "0.75": 0.050509,
                            "0.85": 0.0412618,
                            "0.95": 0.0344798,
                        },
                        "e": {
                            "0.05": 0.0260227,
                            "0.15": 0.0606504,
                            "0.25": 0.0886649,
                            "0.35": 0.113762,
                            "0.45": 0.137013,
                            "0.55": 0.156286,
                            "0.65": 0.158978,
                            "0.75": 0.150283,
                            "0.85": 0.0884474,
                            "0.95": 0.0198931,
                        },
                    },
                    "3.25": {
                        "periodfrac": 0.118382,
                        "P_bin": 0.780792,
                        "normed_bin_frac_p_dist": 0.1111,
                        "normed_tripquad_frac_p_dist": 0.04489,
                        "q": {
                            "0.15": 0.248672,
                            "0.25": 0.22411,
                            "0.35": 0.172737,
                            "0.45": 0.110243,
                            "0.55": 0.0771766,
                            "0.65": 0.0574048,
                            "0.75": 0.0445694,
                            "0.85": 0.0357285,
                            "0.95": 0.0293595,
                        },
                        "e": {
                            "0.05": 0.024524,
                            "0.15": 0.0581243,
                            "0.25": 0.0856965,
                            "0.35": 0.110575,
                            "0.45": 0.133737,
                            "0.55": 0.153964,
                            "0.65": 0.157834,
                            "0.75": 0.1525,
                            "0.85": 0.0959736,
                            "0.95": 0.0270717,
                        },
                    },
                    "3.75": {
                        "periodfrac": 0.125034,
                        "P_bin": 0.691464,
                        "normed_bin_frac_p_dist": 0.1039,
                        "normed_tripquad_frac_p_dist": 0.06673,
                        "q": {
                            "0.15": 0.291778,
                            "0.25": 0.230106,
                            "0.35": 0.16546,
                            "0.45": 0.101592,
                            "0.55": 0.0689779,
                            "0.65": 0.0500228,
                            "0.75": 0.0380064,
                            "0.85": 0.0298971,
                            "0.95": 0.0241592,
                        },
                        "e": {
                            "0.05": 0.023755,
                            "0.15": 0.056952,
                            "0.25": 0.0844594,
                            "0.35": 0.109402,
                            "0.45": 0.132702,
                            "0.55": 0.153101,
                            "0.65": 0.157007,
                            "0.75": 0.152892,
                            "0.85": 0.0991651,
                            "0.95": 0.0305648,
                        },
                    },
                    "4.25": {
                        "periodfrac": 0.121119,
                        "P_bin": 0.59428,
                        "normed_bin_frac_p_dist": 0.08652,
                        "normed_tripquad_frac_p_dist": 0.085,
                        "q": {
                            "0.15": 0.33415,
                            "0.25": 0.230234,
                            "0.35": 0.155604,
                            "0.45": 0.0933459,
                            "0.55": 0.0622253,
                            "0.65": 0.0444447,
                            "0.75": 0.0333324,
                            "0.85": 0.0259249,
                            "0.95": 0.0207394,
                        },
                        "e": {
                            "0.05": 0.0232584,
                            "0.15": 0.0562293,
                            "0.25": 0.0837431,
                            "0.35": 0.108781,
                            "0.45": 0.132228,
                            "0.55": 0.152793,
                            "0.65": 0.156734,
                            "0.75": 0.153173,
                            "0.85": 0.100689,
                            "0.95": 0.0323712,
                        },
                    },
                    "4.75": {
                        "periodfrac": 0.113527,
                        "P_bin": 0.490166,
                        "normed_bin_frac_p_dist": 0.06689,
                        "normed_tripquad_frac_p_dist": 0.1001,
                        "q": {
                            "0.15": 0.372832,
                            "0.25": 0.224083,
                            "0.35": 0.143984,
                            "0.45": 0.0863753,
                            "0.55": 0.0575785,
                            "0.65": 0.0411255,
                            "0.75": 0.0308433,
                            "0.85": 0.0239887,
                            "0.95": 0.0191907,
                        },
                        "e": {
                            "0.05": 0.0229148,
                            "0.15": 0.0557516,
                            "0.25": 0.0833013,
                            "0.35": 0.10844,
                            "0.45": 0.132027,
                            "0.55": 0.152742,
                            "0.65": 0.156715,
                            "0.75": 0.153406,
                            "0.85": 0.10146,
                            "0.95": 0.0332431,
                        },
                    },
                    "5.25": {
                        "periodfrac": 0.104636,
                        "P_bin": 0.379805,
                        "normed_bin_frac_p_dist": 0.04777,
                        "normed_tripquad_frac_p_dist": 0.1123,
                        "q": {
                            "0.15": 0.413585,
                            "0.25": 0.216494,
                            "0.35": 0.132137,
                            "0.45": 0.0792686,
                            "0.55": 0.0528411,
                            "0.65": 0.037742,
                            "0.75": 0.0283054,
                            "0.85": 0.0220151,
                            "0.95": 0.0176119,
                        },
                        "e": {
                            "0.05": 0.022662,
                            "0.15": 0.0554124,
                            "0.25": 0.0830058,
                            "0.35": 0.108238,
                            "0.45": 0.131949,
                            "0.55": 0.152795,
                            "0.65": 0.156795,
                            "0.75": 0.153602,
                            "0.85": 0.101875,
                            "0.95": 0.0336661,
                        },
                    },
                    "5.75": {
                        "periodfrac": 0.0942851,
                        "P_bin": 0.263728,
                        "normed_bin_frac_p_dist": 0.02989,
                        "normed_tripquad_frac_p_dist": 0.1201,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0224666,
                            "0.15": 0.0551564,
                            "0.25": 0.0827927,
                            "0.35": 0.108108,
                            "0.45": 0.131925,
                            "0.55": 0.152884,
                            "0.65": 0.156906,
                            "0.75": 0.153766,
                            "0.85": 0.102116,
                            "0.95": 0.0338787,
                        },
                    },
                    "6.25": {
                        "periodfrac": 0.0814111,
                        "P_bin": 0.142361,
                        "normed_bin_frac_p_dist": 0.01393,
                        "normed_tripquad_frac_p_dist": 0.1208,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0223102,
                            "0.15": 0.0549542,
                            "0.25": 0.0826294,
                            "0.35": 0.108017,
                            "0.45": 0.131925,
                            "0.55": 0.152979,
                            "0.65": 0.157021,
                            "0.75": 0.153903,
                            "0.85": 0.102269,
                            "0.95": 0.0339908,
                        },
                    },
                    "6.75": {
                        "periodfrac": 0.0700712,
                        "P_bin": 0.0250943,
                        "normed_bin_frac_p_dist": 0.002114,
                        "normed_tripquad_frac_p_dist": 0.1182,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0221814,
                            "0.15": 0.0547891,
                            "0.25": 0.0824984,
                            "0.35": 0.107948,
                            "0.45": 0.131934,
                            "0.55": 0.15307,
                            "0.65": 0.157129,
                            "0.75": 0.15402,
                            "0.85": 0.102375,
                            "0.95": 0.0340549,
                        },
                    },
                    "7.25": {
                        "periodfrac": 0.0603108,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.1043,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0220732,
                            "0.15": 0.0546507,
                            "0.25": 0.0823898,
                            "0.35": 0.107893,
                            "0.45": 0.131946,
                            "0.55": 0.153152,
                            "0.65": 0.157225,
                            "0.75": 0.15412,
                            "0.85": 0.102455,
                            "0.95": 0.0340945,
                        },
                    },
                    "7.75": {
                        "periodfrac": 0.05191,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.08979,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0219808,
                            "0.15": 0.0545327,
                            "0.25": 0.0822977,
                            "0.35": 0.107847,
                            "0.45": 0.131958,
                            "0.55": 0.153225,
                            "0.65": 0.157311,
                            "0.75": 0.154207,
                            "0.85": 0.102519,
                            "0.95": 0.0341218,
                        },
                    },
                },
            },
            "1.0": {
                "f_multi": 1.5158,
                "multi system fraction": 0.8532,
                "binary star fraction": 0.5219,
                "triple/quad star fraction": 0.3313,
                "single star fraction": 0.1468,
                "poisson_model": {
                    "single_fraction": 0.236,
                    "binary_fraction": 0.357,
                    "triple_fraction": 0.271,
                    "quadruple_fraction": 0.137,
                },
                "logP": {
                    "0.25": {
                        "periodfrac": 0.05188,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.06081,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.110949,
                            "0.25": 0.123386,
                            "0.35": 0.122856,
                            "0.45": 0.108236,
                            "0.55": 0.0978518,
                            "0.65": 0.0899837,
                            "0.75": 0.0837542,
                            "0.85": 0.107161,
                            "0.95": 0.155822,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "0.75": {
                        "periodfrac": 0.0864667,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.1013,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.110949,
                            "0.25": 0.123386,
                            "0.35": 0.122856,
                            "0.45": 0.108236,
                            "0.55": 0.0978518,
                            "0.65": 0.0899837,
                            "0.75": 0.0837542,
                            "0.85": 0.107161,
                            "0.95": 0.155822,
                        },
                        "e": {
                            "0.05": 0.30542,
                            "0.15": 0.241728,
                            "0.25": 0.222153,
                            "0.35": 0.195657,
                            "0.45": 0.0350411,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.25": {
                        "periodfrac": 0.088031,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.1032,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.12911,
                            "0.25": 0.141357,
                            "0.35": 0.136315,
                            "0.45": 0.114719,
                            "0.55": 0.100006,
                            "0.65": 0.0892265,
                            "0.75": 0.0809296,
                            "0.85": 0.0911988,
                            "0.95": 0.117137,
                        },
                        "e": {
                            "0.05": 0.0579589,
                            "0.15": 0.110502,
                            "0.25": 0.146352,
                            "0.35": 0.175902,
                            "0.45": 0.193908,
                            "0.55": 0.191078,
                            "0.65": 0.111039,
                            "0.75": 0.013261,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.75": {
                        "periodfrac": 0.0908005,
                        "P_bin": 0.979904,
                        "normed_bin_frac_p_dist": 0.1043,
                        "normed_tripquad_frac_p_dist": 0.002754,
                        "q": {
                            "0.15": 0.173767,
                            "0.25": 0.182941,
                            "0.35": 0.163,
                            "0.45": 0.122293,
                            "0.55": 0.0973169,
                            "0.65": 0.0804982,
                            "0.75": 0.0684377,
                            "0.85": 0.0593877,
                            "0.95": 0.0523587,
                        },
                        "e": {
                            "0.05": 0.0356491,
                            "0.15": 0.07696,
                            "0.25": 0.108281,
                            "0.35": 0.135449,
                            "0.45": 0.160063,
                            "0.55": 0.171728,
                            "0.65": 0.170034,
                            "0.75": 0.112538,
                            "0.85": 0.0292965,
                            "0.95": 0.0,
                        },
                    },
                    "2.25": {
                        "periodfrac": 0.0968251,
                        "P_bin": 0.9205,
                        "normed_bin_frac_p_dist": 0.1045,
                        "normed_tripquad_frac_p_dist": 0.01162,
                        "q": {
                            "0.15": 0.203124,
                            "0.25": 0.205604,
                            "0.35": 0.172362,
                            "0.45": 0.118827,
                            "0.55": 0.0884266,
                            "0.65": 0.0691883,
                            "0.75": 0.0560923,
                            "0.85": 0.046696,
                            "0.95": 0.03968,
                        },
                        "e": {
                            "0.05": 0.0289821,
                            "0.15": 0.0657598,
                            "0.25": 0.0948453,
                            "0.35": 0.120607,
                            "0.45": 0.144287,
                            "0.55": 0.161204,
                            "0.65": 0.16219,
                            "0.75": 0.142897,
                            "0.85": 0.0713511,
                            "0.95": 0.00787633,
                        },
                    },
                    "2.75": {
                        "periodfrac": 0.110204,
                        "P_bin": 0.842867,
                        "normed_bin_frac_p_dist": 0.1089,
                        "normed_tripquad_frac_p_dist": 0.02614,
                        "q": {
                            "0.15": 0.221344,
                            "0.25": 0.21538,
                            "0.35": 0.174296,
                            "0.45": 0.115617,
                            "0.55": 0.0834503,
                            "0.65": 0.0636632,
                            "0.75": 0.050509,
                            "0.85": 0.0412618,
                            "0.95": 0.0344798,
                        },
                        "e": {
                            "0.05": 0.0260227,
                            "0.15": 0.0606504,
                            "0.25": 0.0886649,
                            "0.35": 0.113762,
                            "0.45": 0.137013,
                            "0.55": 0.156286,
                            "0.65": 0.158978,
                            "0.75": 0.150283,
                            "0.85": 0.0884474,
                            "0.95": 0.0198931,
                        },
                    },
                    "3.25": {
                        "periodfrac": 0.127192,
                        "P_bin": 0.752339,
                        "normed_bin_frac_p_dist": 0.1122,
                        "normed_tripquad_frac_p_dist": 0.04754,
                        "q": {
                            "0.15": 0.248672,
                            "0.25": 0.22411,
                            "0.35": 0.172737,
                            "0.45": 0.110243,
                            "0.55": 0.0771766,
                            "0.65": 0.0574048,
                            "0.75": 0.0445694,
                            "0.85": 0.0357285,
                            "0.95": 0.0293595,
                        },
                        "e": {
                            "0.05": 0.024524,
                            "0.15": 0.0581243,
                            "0.25": 0.0856965,
                            "0.35": 0.110575,
                            "0.45": 0.133737,
                            "0.55": 0.153964,
                            "0.65": 0.157834,
                            "0.75": 0.1525,
                            "0.85": 0.0959736,
                            "0.95": 0.0270717,
                        },
                    },
                    "3.75": {
                        "periodfrac": 0.133733,
                        "P_bin": 0.651417,
                        "normed_bin_frac_p_dist": 0.1021,
                        "normed_tripquad_frac_p_dist": 0.07036,
                        "q": {
                            "0.15": 0.291778,
                            "0.25": 0.230106,
                            "0.35": 0.16546,
                            "0.45": 0.101592,
                            "0.55": 0.0689779,
                            "0.65": 0.0500228,
                            "0.75": 0.0380064,
                            "0.85": 0.0298971,
                            "0.95": 0.0241592,
                        },
                        "e": {
                            "0.05": 0.023755,
                            "0.15": 0.056952,
                            "0.25": 0.0844594,
                            "0.35": 0.109402,
                            "0.45": 0.132702,
                            "0.55": 0.153101,
                            "0.65": 0.157007,
                            "0.75": 0.152892,
                            "0.85": 0.0991651,
                            "0.95": 0.0305648,
                        },
                    },
                    "4.25": {
                        "periodfrac": 0.128881,
                        "P_bin": 0.54162,
                        "normed_bin_frac_p_dist": 0.08181,
                        "normed_tripquad_frac_p_dist": 0.08917,
                        "q": {
                            "0.15": 0.33415,
                            "0.25": 0.230234,
                            "0.35": 0.155604,
                            "0.45": 0.0933459,
                            "0.55": 0.0622253,
                            "0.65": 0.0444447,
                            "0.75": 0.0333324,
                            "0.85": 0.0259249,
                            "0.95": 0.0207394,
                        },
                        "e": {
                            "0.05": 0.0232584,
                            "0.15": 0.0562293,
                            "0.25": 0.0837431,
                            "0.35": 0.108781,
                            "0.45": 0.132228,
                            "0.55": 0.152793,
                            "0.65": 0.156734,
                            "0.75": 0.153173,
                            "0.85": 0.100689,
                            "0.95": 0.0323712,
                        },
                    },
                    "4.75": {
                        "periodfrac": 0.119981,
                        "P_bin": 0.423992,
                        "normed_bin_frac_p_dist": 0.05962,
                        "normed_tripquad_frac_p_dist": 0.1043,
                        "q": {
                            "0.15": 0.372832,
                            "0.25": 0.224083,
                            "0.35": 0.143984,
                            "0.45": 0.0863753,
                            "0.55": 0.0575785,
                            "0.65": 0.0411255,
                            "0.75": 0.0308433,
                            "0.85": 0.0239887,
                            "0.95": 0.0191907,
                        },
                        "e": {
                            "0.05": 0.0229148,
                            "0.15": 0.0557516,
                            "0.25": 0.0833013,
                            "0.35": 0.10844,
                            "0.45": 0.132027,
                            "0.55": 0.152742,
                            "0.65": 0.156715,
                            "0.75": 0.153406,
                            "0.85": 0.10146,
                            "0.95": 0.0332431,
                        },
                    },
                    "5.25": {
                        "periodfrac": 0.109542,
                        "P_bin": 0.299306,
                        "normed_bin_frac_p_dist": 0.03843,
                        "normed_tripquad_frac_p_dist": 0.1158,
                        "q": {
                            "0.15": 0.413585,
                            "0.25": 0.216494,
                            "0.35": 0.132137,
                            "0.45": 0.0792686,
                            "0.55": 0.0528411,
                            "0.65": 0.037742,
                            "0.75": 0.0283054,
                            "0.85": 0.0220151,
                            "0.95": 0.0176119,
                        },
                        "e": {
                            "0.05": 0.022662,
                            "0.15": 0.0554124,
                            "0.25": 0.0830058,
                            "0.35": 0.108238,
                            "0.45": 0.131949,
                            "0.55": 0.152795,
                            "0.65": 0.156795,
                            "0.75": 0.153602,
                            "0.85": 0.101875,
                            "0.95": 0.0336661,
                        },
                    },
                    "5.75": {
                        "periodfrac": 0.0980335,
                        "P_bin": 0.168163,
                        "normed_bin_frac_p_dist": 0.01932,
                        "normed_tripquad_frac_p_dist": 0.1231,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0224666,
                            "0.15": 0.0551564,
                            "0.25": 0.0827927,
                            "0.35": 0.108108,
                            "0.45": 0.131925,
                            "0.55": 0.152884,
                            "0.65": 0.156906,
                            "0.75": 0.153766,
                            "0.85": 0.102116,
                            "0.95": 0.0338787,
                        },
                    },
                    "6.25": {
                        "periodfrac": 0.0846476,
                        "P_bin": 0.0364668,
                        "normed_bin_frac_p_dist": 0.003618,
                        "normed_tripquad_frac_p_dist": 0.1231,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0223102,
                            "0.15": 0.0549542,
                            "0.25": 0.0826294,
                            "0.35": 0.108017,
                            "0.45": 0.131925,
                            "0.55": 0.152979,
                            "0.65": 0.157021,
                            "0.75": 0.153903,
                            "0.85": 0.102269,
                            "0.95": 0.0339908,
                        },
                    },
                    "6.75": {
                        "periodfrac": 0.0728569,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.11,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0221814,
                            "0.15": 0.0547891,
                            "0.25": 0.0824984,
                            "0.35": 0.107948,
                            "0.45": 0.131934,
                            "0.55": 0.15307,
                            "0.65": 0.157129,
                            "0.75": 0.15402,
                            "0.85": 0.102375,
                            "0.95": 0.0340549,
                        },
                    },
                    "7.25": {
                        "periodfrac": 0.0627085,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.09465,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0220732,
                            "0.15": 0.0546507,
                            "0.25": 0.0823898,
                            "0.35": 0.107893,
                            "0.45": 0.131946,
                            "0.55": 0.153152,
                            "0.65": 0.157225,
                            "0.75": 0.15412,
                            "0.85": 0.102455,
                            "0.95": 0.0340945,
                        },
                    },
                    "7.75": {
                        "periodfrac": 0.0539737,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.08146,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0219808,
                            "0.15": 0.0545327,
                            "0.25": 0.0822977,
                            "0.35": 0.107847,
                            "0.45": 0.131958,
                            "0.55": 0.153225,
                            "0.65": 0.157311,
                            "0.75": 0.154207,
                            "0.85": 0.102519,
                            "0.95": 0.0341218,
                        },
                    },
                },
            },
            "1.1": {
                "f_multi": 1.6319,
                "multi system fraction": 0.8751,
                "binary star fraction": 0.4966,
                "triple/quad star fraction": 0.3784,
                "single star fraction": 0.1249,
                "poisson_model": {
                    "single_fraction": 0.213,
                    "binary_fraction": 0.348,
                    "triple_fraction": 0.284,
                    "quadruple_fraction": 0.155,
                },
                "logP": {
                    "0.25": {
                        "periodfrac": 0.0595297,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.06803,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.112015,
                            "0.25": 0.124573,
                            "0.35": 0.124037,
                            "0.45": 0.109277,
                            "0.55": 0.0987928,
                            "0.65": 0.0908489,
                            "0.75": 0.0845596,
                            "0.85": 0.105698,
                            "0.95": 0.150198,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "0.75": {
                        "periodfrac": 0.0992162,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.1134,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.112015,
                            "0.25": 0.124573,
                            "0.35": 0.124037,
                            "0.45": 0.109277,
                            "0.55": 0.0987928,
                            "0.65": 0.0908489,
                            "0.75": 0.0845596,
                            "0.85": 0.105698,
                            "0.95": 0.150198,
                        },
                        "e": {
                            "0.05": 0.30542,
                            "0.15": 0.241728,
                            "0.25": 0.222153,
                            "0.35": 0.195657,
                            "0.45": 0.0350411,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.25": {
                        "periodfrac": 0.0999189,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.1142,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.130032,
                            "0.25": 0.142366,
                            "0.35": 0.137288,
                            "0.45": 0.115538,
                            "0.55": 0.10072,
                            "0.65": 0.0898632,
                            "0.75": 0.0815074,
                            "0.85": 0.0899993,
                            "0.95": 0.112686,
                        },
                        "e": {
                            "0.05": 0.0579589,
                            "0.15": 0.110502,
                            "0.25": 0.146352,
                            "0.35": 0.175902,
                            "0.45": 0.193908,
                            "0.55": 0.191078,
                            "0.65": 0.111039,
                            "0.75": 0.013261,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.75": {
                        "periodfrac": 0.100217,
                        "P_bin": 0.977295,
                        "normed_bin_frac_p_dist": 0.1119,
                        "normed_tripquad_frac_p_dist": 0.003006,
                        "q": {
                            "0.15": 0.173767,
                            "0.25": 0.182941,
                            "0.35": 0.163,
                            "0.45": 0.122293,
                            "0.55": 0.0973169,
                            "0.65": 0.0804982,
                            "0.75": 0.0684377,
                            "0.85": 0.0593877,
                            "0.95": 0.0523587,
                        },
                        "e": {
                            "0.05": 0.0356491,
                            "0.15": 0.07696,
                            "0.25": 0.108281,
                            "0.35": 0.135449,
                            "0.45": 0.160063,
                            "0.55": 0.171728,
                            "0.65": 0.170034,
                            "0.75": 0.112538,
                            "0.85": 0.0292965,
                            "0.95": 0.0,
                        },
                    },
                    "2.25": {
                        "periodfrac": 0.1048,
                        "P_bin": 0.910181,
                        "normed_bin_frac_p_dist": 0.109,
                        "normed_tripquad_frac_p_dist": 0.01244,
                        "q": {
                            "0.15": 0.203124,
                            "0.25": 0.205604,
                            "0.35": 0.172362,
                            "0.45": 0.118827,
                            "0.55": 0.0884266,
                            "0.65": 0.0691883,
                            "0.75": 0.0560923,
                            "0.85": 0.046696,
                            "0.95": 0.03968,
                        },
                        "e": {
                            "0.05": 0.0289821,
                            "0.15": 0.0657598,
                            "0.25": 0.0948453,
                            "0.35": 0.120607,
                            "0.45": 0.144287,
                            "0.55": 0.161204,
                            "0.65": 0.16219,
                            "0.75": 0.142897,
                            "0.85": 0.0713511,
                            "0.95": 0.00787633,
                        },
                    },
                    "2.75": {
                        "periodfrac": 0.118597,
                        "P_bin": 0.822472,
                        "normed_bin_frac_p_dist": 0.1115,
                        "normed_tripquad_frac_p_dist": 0.02782,
                        "q": {
                            "0.15": 0.221344,
                            "0.25": 0.21538,
                            "0.35": 0.174296,
                            "0.45": 0.115617,
                            "0.55": 0.0834503,
                            "0.65": 0.0636632,
                            "0.75": 0.050509,
                            "0.85": 0.0412618,
                            "0.95": 0.0344798,
                        },
                        "e": {
                            "0.05": 0.0260227,
                            "0.15": 0.0606504,
                            "0.25": 0.0886649,
                            "0.35": 0.113762,
                            "0.45": 0.137013,
                            "0.55": 0.156286,
                            "0.65": 0.158978,
                            "0.75": 0.150283,
                            "0.85": 0.0884474,
                            "0.95": 0.0198931,
                        },
                    },
                    "3.25": {
                        "periodfrac": 0.136201,
                        "P_bin": 0.720194,
                        "normed_bin_frac_p_dist": 0.1121,
                        "normed_tripquad_frac_p_dist": 0.05035,
                        "q": {
                            "0.15": 0.248672,
                            "0.25": 0.22411,
                            "0.35": 0.172737,
                            "0.45": 0.110243,
                            "0.55": 0.0771766,
                            "0.65": 0.0574048,
                            "0.75": 0.0445694,
                            "0.85": 0.0357285,
                            "0.95": 0.0293595,
                        },
                        "e": {
                            "0.05": 0.024524,
                            "0.15": 0.0581243,
                            "0.25": 0.0856965,
                            "0.35": 0.110575,
                            "0.45": 0.133737,
                            "0.55": 0.153964,
                            "0.65": 0.157834,
                            "0.75": 0.1525,
                            "0.85": 0.0959736,
                            "0.95": 0.0270717,
                        },
                    },
                    "3.75": {
                        "periodfrac": 0.142756,
                        "P_bin": 0.606172,
                        "normed_bin_frac_p_dist": 0.09889,
                        "normed_tripquad_frac_p_dist": 0.07428,
                        "q": {
                            "0.15": 0.291778,
                            "0.25": 0.230106,
                            "0.35": 0.16546,
                            "0.45": 0.101592,
                            "0.55": 0.0689779,
                            "0.65": 0.0500228,
                            "0.75": 0.0380064,
                            "0.85": 0.0298971,
                            "0.95": 0.0241592,
                        },
                        "e": {
                            "0.05": 0.023755,
                            "0.15": 0.056952,
                            "0.25": 0.0844594,
                            "0.35": 0.109402,
                            "0.45": 0.132702,
                            "0.55": 0.153101,
                            "0.65": 0.157007,
                            "0.75": 0.152892,
                            "0.85": 0.0991651,
                            "0.95": 0.0305648,
                        },
                    },
                    "4.25": {
                        "periodfrac": 0.137171,
                        "P_bin": 0.482124,
                        "normed_bin_frac_p_dist": 0.07558,
                        "normed_tripquad_frac_p_dist": 0.09386,
                        "q": {
                            "0.15": 0.33415,
                            "0.25": 0.230234,
                            "0.35": 0.155604,
                            "0.45": 0.0933459,
                            "0.55": 0.0622253,
                            "0.65": 0.0444447,
                            "0.75": 0.0333324,
                            "0.85": 0.0259249,
                            "0.95": 0.0207394,
                        },
                        "e": {
                            "0.05": 0.0232584,
                            "0.15": 0.0562293,
                            "0.25": 0.0837431,
                            "0.35": 0.108781,
                            "0.45": 0.132228,
                            "0.55": 0.152793,
                            "0.65": 0.156734,
                            "0.75": 0.153173,
                            "0.85": 0.100689,
                            "0.95": 0.0323712,
                        },
                    },
                    "4.75": {
                        "periodfrac": 0.127195,
                        "P_bin": 0.349228,
                        "normed_bin_frac_p_dist": 0.05076,
                        "normed_tripquad_frac_p_dist": 0.1094,
                        "q": {
                            "0.15": 0.372832,
                            "0.25": 0.224083,
                            "0.35": 0.143984,
                            "0.45": 0.0863753,
                            "0.55": 0.0575785,
                            "0.65": 0.0411255,
                            "0.75": 0.0308433,
                            "0.85": 0.0239887,
                            "0.95": 0.0191907,
                        },
                        "e": {
                            "0.05": 0.0229148,
                            "0.15": 0.0557516,
                            "0.25": 0.0833013,
                            "0.35": 0.10844,
                            "0.45": 0.132027,
                            "0.55": 0.152742,
                            "0.65": 0.156715,
                            "0.75": 0.153406,
                            "0.85": 0.10146,
                            "0.95": 0.0332431,
                        },
                    },
                    "5.25": {
                        "periodfrac": 0.115487,
                        "P_bin": 0.208359,
                        "normed_bin_frac_p_dist": 0.0275,
                        "normed_tripquad_frac_p_dist": 0.1208,
                        "q": {
                            "0.15": 0.413585,
                            "0.25": 0.216494,
                            "0.35": 0.132137,
                            "0.45": 0.0792686,
                            "0.55": 0.0528411,
                            "0.65": 0.037742,
                            "0.75": 0.0283054,
                            "0.85": 0.0220151,
                            "0.95": 0.0176119,
                        },
                        "e": {
                            "0.05": 0.022662,
                            "0.15": 0.0554124,
                            "0.25": 0.0830058,
                            "0.35": 0.108238,
                            "0.45": 0.131949,
                            "0.55": 0.152795,
                            "0.65": 0.156795,
                            "0.75": 0.153602,
                            "0.85": 0.101875,
                            "0.95": 0.0336661,
                        },
                    },
                    "5.75": {
                        "periodfrac": 0.102935,
                        "P_bin": 0.0610379,
                        "normed_bin_frac_p_dist": 0.00718,
                        "normed_tripquad_frac_p_dist": 0.1277,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0224666,
                            "0.15": 0.0551564,
                            "0.25": 0.0827927,
                            "0.35": 0.108108,
                            "0.45": 0.131925,
                            "0.55": 0.152884,
                            "0.65": 0.156906,
                            "0.75": 0.153766,
                            "0.85": 0.102116,
                            "0.95": 0.0338787,
                        },
                    },
                    "6.25": {
                        "periodfrac": 0.08888,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.1174,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0223102,
                            "0.15": 0.0549542,
                            "0.25": 0.0826294,
                            "0.35": 0.108017,
                            "0.45": 0.131925,
                            "0.55": 0.152979,
                            "0.65": 0.157021,
                            "0.75": 0.153903,
                            "0.85": 0.102269,
                            "0.95": 0.0339908,
                        },
                    },
                    "6.75": {
                        "periodfrac": 0.0764997,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.1011,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0221814,
                            "0.15": 0.0547891,
                            "0.25": 0.0824984,
                            "0.35": 0.107948,
                            "0.45": 0.131934,
                            "0.55": 0.15307,
                            "0.65": 0.157129,
                            "0.75": 0.15402,
                            "0.85": 0.102375,
                            "0.95": 0.0340549,
                        },
                    },
                    "7.25": {
                        "periodfrac": 0.0658439,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.087,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0220732,
                            "0.15": 0.0546507,
                            "0.25": 0.0823898,
                            "0.35": 0.107893,
                            "0.45": 0.131946,
                            "0.55": 0.153152,
                            "0.65": 0.157225,
                            "0.75": 0.15412,
                            "0.85": 0.102455,
                            "0.95": 0.0340945,
                        },
                    },
                    "7.75": {
                        "periodfrac": 0.0566724,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.07488,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0219808,
                            "0.15": 0.0545327,
                            "0.25": 0.0822977,
                            "0.35": 0.107847,
                            "0.45": 0.131958,
                            "0.55": 0.153225,
                            "0.65": 0.157311,
                            "0.75": 0.154207,
                            "0.85": 0.102519,
                            "0.95": 0.0341218,
                        },
                    },
                },
            },
            "1.2": {
                "f_multi": 1.7587,
                "multi system fraction": 0.8973,
                "binary star fraction": 0.4666,
                "triple/quad star fraction": 0.4307,
                "single star fraction": 0.1027,
                "poisson_model": {
                    "single_fraction": 0.192,
                    "binary_fraction": 0.337,
                    "triple_fraction": 0.297,
                    "quadruple_fraction": 0.174,
                },
                "logP": {
                    "0.25": {
                        "periodfrac": 0.067846,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.07561,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.113361,
                            "0.25": 0.126069,
                            "0.35": 0.125527,
                            "0.45": 0.110589,
                            "0.55": 0.0999794,
                            "0.65": 0.0919401,
                            "0.75": 0.0855755,
                            "0.85": 0.103854,
                            "0.95": 0.143104,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "0.75": {
                        "periodfrac": 0.113077,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.126,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.113361,
                            "0.25": 0.126069,
                            "0.35": 0.125527,
                            "0.45": 0.110589,
                            "0.55": 0.0999794,
                            "0.65": 0.0919401,
                            "0.75": 0.0855755,
                            "0.85": 0.103854,
                            "0.95": 0.143104,
                        },
                        "e": {
                            "0.05": 0.30542,
                            "0.15": 0.241728,
                            "0.25": 0.222153,
                            "0.35": 0.195657,
                            "0.45": 0.0350411,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.25": {
                        "periodfrac": 0.112675,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.1256,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.130948,
                            "0.25": 0.14337,
                            "0.35": 0.138256,
                            "0.45": 0.116353,
                            "0.55": 0.10143,
                            "0.65": 0.0904968,
                            "0.75": 0.0820819,
                            "0.85": 0.0888061,
                            "0.95": 0.108258,
                        },
                        "e": {
                            "0.05": 0.0579589,
                            "0.15": 0.110502,
                            "0.25": 0.146352,
                            "0.35": 0.175902,
                            "0.45": 0.193908,
                            "0.55": 0.191078,
                            "0.65": 0.111039,
                            "0.75": 0.013261,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.75": {
                        "periodfrac": 0.110055,
                        "P_bin": 0.974348,
                        "normed_bin_frac_p_dist": 0.1195,
                        "normed_tripquad_frac_p_dist": 0.003277,
                        "q": {
                            "0.15": 0.173767,
                            "0.25": 0.182941,
                            "0.35": 0.163,
                            "0.45": 0.122293,
                            "0.55": 0.0973169,
                            "0.65": 0.0804982,
                            "0.75": 0.0684377,
                            "0.85": 0.0593877,
                            "0.95": 0.0523587,
                        },
                        "e": {
                            "0.05": 0.0356491,
                            "0.15": 0.07696,
                            "0.25": 0.108281,
                            "0.35": 0.135449,
                            "0.45": 0.160063,
                            "0.55": 0.171728,
                            "0.65": 0.170034,
                            "0.75": 0.112538,
                            "0.85": 0.0292965,
                            "0.95": 0.0,
                        },
                    },
                    "2.25": {
                        "periodfrac": 0.11295,
                        "P_bin": 0.898523,
                        "normed_bin_frac_p_dist": 0.1131,
                        "normed_tripquad_frac_p_dist": 0.01331,
                        "q": {
                            "0.15": 0.203124,
                            "0.25": 0.205604,
                            "0.35": 0.172362,
                            "0.45": 0.118827,
                            "0.55": 0.0884266,
                            "0.65": 0.0691883,
                            "0.75": 0.0560923,
                            "0.85": 0.046696,
                            "0.95": 0.03968,
                        },
                        "e": {
                            "0.05": 0.0289821,
                            "0.15": 0.0657598,
                            "0.25": 0.0948453,
                            "0.35": 0.120607,
                            "0.45": 0.144287,
                            "0.55": 0.161204,
                            "0.65": 0.16219,
                            "0.75": 0.142897,
                            "0.85": 0.0713511,
                            "0.95": 0.00787633,
                        },
                    },
                    "2.75": {
                        "periodfrac": 0.127174,
                        "P_bin": 0.799429,
                        "normed_bin_frac_p_dist": 0.1133,
                        "normed_tripquad_frac_p_dist": 0.02961,
                        "q": {
                            "0.15": 0.221344,
                            "0.25": 0.21538,
                            "0.35": 0.174296,
                            "0.45": 0.115617,
                            "0.55": 0.0834503,
                            "0.65": 0.0636632,
                            "0.75": 0.050509,
                            "0.85": 0.0412618,
                            "0.95": 0.0344798,
                        },
                        "e": {
                            "0.05": 0.0260227,
                            "0.15": 0.0606504,
                            "0.25": 0.0886649,
                            "0.35": 0.113762,
                            "0.45": 0.137013,
                            "0.55": 0.156286,
                            "0.65": 0.158978,
                            "0.75": 0.150283,
                            "0.85": 0.0884474,
                            "0.95": 0.0198931,
                        },
                    },
                    "3.25": {
                        "periodfrac": 0.14541,
                        "P_bin": 0.683876,
                        "normed_bin_frac_p_dist": 0.1108,
                        "normed_tripquad_frac_p_dist": 0.05336,
                        "q": {
                            "0.15": 0.248672,
                            "0.25": 0.22411,
                            "0.35": 0.172737,
                            "0.45": 0.110243,
                            "0.55": 0.0771766,
                            "0.65": 0.0574048,
                            "0.75": 0.0445694,
                            "0.85": 0.0357285,
                            "0.95": 0.0293595,
                        },
                        "e": {
                            "0.05": 0.024524,
                            "0.15": 0.0581243,
                            "0.25": 0.0856965,
                            "0.35": 0.110575,
                            "0.45": 0.133737,
                            "0.55": 0.153964,
                            "0.65": 0.157834,
                            "0.75": 0.1525,
                            "0.85": 0.0959736,
                            "0.95": 0.0270717,
                        },
                    },
                    "3.75": {
                        "periodfrac": 0.152103,
                        "P_bin": 0.555055,
                        "normed_bin_frac_p_dist": 0.09409,
                        "normed_tripquad_frac_p_dist": 0.07856,
                        "q": {
                            "0.15": 0.291778,
                            "0.25": 0.230106,
                            "0.35": 0.16546,
                            "0.45": 0.101592,
                            "0.55": 0.0689779,
                            "0.65": 0.0500228,
                            "0.75": 0.0380064,
                            "0.85": 0.0298971,
                            "0.95": 0.0241592,
                        },
                        "e": {
                            "0.05": 0.023755,
                            "0.15": 0.056952,
                            "0.25": 0.0844594,
                            "0.35": 0.109402,
                            "0.45": 0.132702,
                            "0.55": 0.153101,
                            "0.65": 0.157007,
                            "0.75": 0.152892,
                            "0.85": 0.0991651,
                            "0.95": 0.0305648,
                        },
                    },
                    "4.25": {
                        "periodfrac": 0.14599,
                        "P_bin": 0.414906,
                        "normed_bin_frac_p_dist": 0.0675,
                        "normed_tripquad_frac_p_dist": 0.09916,
                        "q": {
                            "0.15": 0.33415,
                            "0.25": 0.230234,
                            "0.35": 0.155604,
                            "0.45": 0.0933459,
                            "0.55": 0.0622253,
                            "0.65": 0.0444447,
                            "0.75": 0.0333324,
                            "0.85": 0.0259249,
                            "0.95": 0.0207394,
                        },
                        "e": {
                            "0.05": 0.0232584,
                            "0.15": 0.0562293,
                            "0.25": 0.0837431,
                            "0.35": 0.108781,
                            "0.45": 0.132228,
                            "0.55": 0.152793,
                            "0.65": 0.156734,
                            "0.75": 0.153173,
                            "0.85": 0.100689,
                            "0.95": 0.0323712,
                        },
                    },
                    "4.75": {
                        "periodfrac": 0.135171,
                        "P_bin": 0.264761,
                        "normed_bin_frac_p_dist": 0.03988,
                        "normed_tripquad_frac_p_dist": 0.1154,
                        "q": {
                            "0.15": 0.372832,
                            "0.25": 0.224083,
                            "0.35": 0.143984,
                            "0.45": 0.0863753,
                            "0.55": 0.0575785,
                            "0.65": 0.0411255,
                            "0.75": 0.0308433,
                            "0.85": 0.0239887,
                            "0.95": 0.0191907,
                        },
                        "e": {
                            "0.05": 0.0229148,
                            "0.15": 0.0557516,
                            "0.25": 0.0833013,
                            "0.35": 0.10844,
                            "0.45": 0.132027,
                            "0.55": 0.152742,
                            "0.65": 0.156715,
                            "0.75": 0.153406,
                            "0.85": 0.10146,
                            "0.95": 0.0332431,
                        },
                    },
                    "5.25": {
                        "periodfrac": 0.12247,
                        "P_bin": 0.105607,
                        "normed_bin_frac_p_dist": 0.01441,
                        "normed_tripquad_frac_p_dist": 0.1272,
                        "q": {
                            "0.15": 0.413585,
                            "0.25": 0.216494,
                            "0.35": 0.132137,
                            "0.45": 0.0792686,
                            "0.55": 0.0528411,
                            "0.65": 0.037742,
                            "0.75": 0.0283054,
                            "0.85": 0.0220151,
                            "0.95": 0.0176119,
                        },
                        "e": {
                            "0.05": 0.022662,
                            "0.15": 0.0554124,
                            "0.25": 0.0830058,
                            "0.35": 0.108238,
                            "0.45": 0.131949,
                            "0.55": 0.152795,
                            "0.65": 0.156795,
                            "0.75": 0.153602,
                            "0.85": 0.101875,
                            "0.95": 0.0336661,
                        },
                    },
                    "5.75": {
                        "periodfrac": 0.10899,
                        "P_bin": 0.00148418,
                        "normed_bin_frac_p_dist": 0.0001803,
                        "normed_tripquad_frac_p_dist": 0.1263,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0224666,
                            "0.15": 0.0551564,
                            "0.25": 0.0827927,
                            "0.35": 0.108108,
                            "0.45": 0.131925,
                            "0.55": 0.152884,
                            "0.65": 0.156906,
                            "0.75": 0.153766,
                            "0.85": 0.102116,
                            "0.95": 0.0338787,
                        },
                    },
                    "6.25": {
                        "periodfrac": 0.0941082,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.1092,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0223102,
                            "0.15": 0.0549542,
                            "0.25": 0.0826294,
                            "0.35": 0.108017,
                            "0.45": 0.131925,
                            "0.55": 0.152979,
                            "0.65": 0.157021,
                            "0.75": 0.153903,
                            "0.85": 0.102269,
                            "0.95": 0.0339908,
                        },
                    },
                    "6.75": {
                        "periodfrac": 0.0809997,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.09403,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0221814,
                            "0.15": 0.0547891,
                            "0.25": 0.0824984,
                            "0.35": 0.107948,
                            "0.45": 0.131934,
                            "0.55": 0.15307,
                            "0.65": 0.157129,
                            "0.75": 0.15402,
                            "0.85": 0.102375,
                            "0.95": 0.0340549,
                        },
                    },
                    "7.25": {
                        "periodfrac": 0.0697171,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.08093,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0220732,
                            "0.15": 0.0546507,
                            "0.25": 0.0823898,
                            "0.35": 0.107893,
                            "0.45": 0.131946,
                            "0.55": 0.153152,
                            "0.65": 0.157225,
                            "0.75": 0.15412,
                            "0.85": 0.102455,
                            "0.95": 0.0340945,
                        },
                    },
                    "7.75": {
                        "periodfrac": 0.0600061,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.06966,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0219808,
                            "0.15": 0.0545327,
                            "0.25": 0.0822977,
                            "0.35": 0.107847,
                            "0.45": 0.131958,
                            "0.55": 0.153225,
                            "0.65": 0.157311,
                            "0.75": 0.154207,
                            "0.85": 0.102519,
                            "0.95": 0.0341218,
                        },
                    },
                },
            },
            "1.3": {
                "f_multi": 1.8962,
                "multi system fraction": 0.9198,
                "binary star fraction": 0.4316,
                "triple/quad star fraction": 0.4882,
                "single star fraction": 0.0802,
                "poisson_model": {
                    "single_fraction": 0.172,
                    "binary_fraction": 0.2325,
                    "triple_fraction": 0.308,
                    "quadruple_fraction": 0.195,
                },
                "logP": {
                    "0.25": {
                        "periodfrac": 0.0768182,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.08351,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.114813,
                            "0.25": 0.127684,
                            "0.35": 0.127136,
                            "0.45": 0.112006,
                            "0.55": 0.10126,
                            "0.65": 0.0931179,
                            "0.75": 0.0866718,
                            "0.85": 0.101863,
                            "0.95": 0.135448,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "0.75": {
                        "periodfrac": 0.12803,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.1392,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.114813,
                            "0.25": 0.127684,
                            "0.35": 0.127136,
                            "0.45": 0.112006,
                            "0.55": 0.10126,
                            "0.65": 0.0931179,
                            "0.75": 0.0866718,
                            "0.85": 0.101863,
                            "0.95": 0.135448,
                        },
                        "e": {
                            "0.05": 0.30542,
                            "0.15": 0.241728,
                            "0.25": 0.222153,
                            "0.35": 0.195657,
                            "0.45": 0.0350411,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.25": {
                        "periodfrac": 0.126299,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.1373,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.13186,
                            "0.25": 0.144368,
                            "0.35": 0.139218,
                            "0.45": 0.117162,
                            "0.55": 0.102136,
                            "0.65": 0.0911267,
                            "0.75": 0.0826534,
                            "0.85": 0.0876195,
                            "0.95": 0.103856,
                        },
                        "e": {
                            "0.05": 0.0579589,
                            "0.15": 0.110502,
                            "0.25": 0.146352,
                            "0.35": 0.175902,
                            "0.45": 0.193908,
                            "0.55": 0.191078,
                            "0.65": 0.111039,
                            "0.75": 0.013261,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.75": {
                        "periodfrac": 0.120316,
                        "P_bin": 0.971019,
                        "normed_bin_frac_p_dist": 0.127,
                        "normed_tripquad_frac_p_dist": 0.003571,
                        "q": {
                            "0.15": 0.173767,
                            "0.25": 0.182941,
                            "0.35": 0.163,
                            "0.45": 0.122293,
                            "0.55": 0.0973169,
                            "0.65": 0.0804982,
                            "0.75": 0.0684377,
                            "0.85": 0.0593877,
                            "0.95": 0.0523587,
                        },
                        "e": {
                            "0.05": 0.0356491,
                            "0.15": 0.07696,
                            "0.25": 0.108281,
                            "0.35": 0.135449,
                            "0.45": 0.160063,
                            "0.55": 0.171728,
                            "0.65": 0.170034,
                            "0.75": 0.112538,
                            "0.85": 0.0292965,
                            "0.95": 0.0,
                        },
                    },
                    "2.25": {
                        "periodfrac": 0.121275,
                        "P_bin": 0.885352,
                        "normed_bin_frac_p_dist": 0.1167,
                        "normed_tripquad_frac_p_dist": 0.01424,
                        "q": {
                            "0.15": 0.203124,
                            "0.25": 0.205604,
                            "0.35": 0.172362,
                            "0.45": 0.118827,
                            "0.55": 0.0884266,
                            "0.65": 0.0691883,
                            "0.75": 0.0560923,
                            "0.85": 0.046696,
                            "0.95": 0.03968,
                        },
                        "e": {
                            "0.05": 0.0289821,
                            "0.15": 0.0657598,
                            "0.25": 0.0948453,
                            "0.35": 0.120607,
                            "0.45": 0.144287,
                            "0.55": 0.161204,
                            "0.65": 0.16219,
                            "0.75": 0.142897,
                            "0.85": 0.0713511,
                            "0.95": 0.00787633,
                        },
                    },
                    "2.75": {
                        "periodfrac": 0.135936,
                        "P_bin": 0.773396,
                        "normed_bin_frac_p_dist": 0.1143,
                        "normed_tripquad_frac_p_dist": 0.03155,
                        "q": {
                            "0.15": 0.221344,
                            "0.25": 0.21538,
                            "0.35": 0.174296,
                            "0.45": 0.115617,
                            "0.55": 0.0834503,
                            "0.65": 0.0636632,
                            "0.75": 0.050509,
                            "0.85": 0.0412618,
                            "0.95": 0.0344798,
                        },
                        "e": {
                            "0.05": 0.0260227,
                            "0.15": 0.0606504,
                            "0.25": 0.0886649,
                            "0.35": 0.113762,
                            "0.45": 0.137013,
                            "0.55": 0.156286,
                            "0.65": 0.158978,
                            "0.75": 0.150283,
                            "0.85": 0.0884474,
                            "0.95": 0.0198931,
                        },
                    },
                    "3.25": {
                        "periodfrac": 0.154819,
                        "P_bin": 0.642845,
                        "normed_bin_frac_p_dist": 0.1082,
                        "normed_tripquad_frac_p_dist": 0.05663,
                        "q": {
                            "0.15": 0.248672,
                            "0.25": 0.22411,
                            "0.35": 0.172737,
                            "0.45": 0.110243,
                            "0.55": 0.0771766,
                            "0.65": 0.0574048,
                            "0.75": 0.0445694,
                            "0.85": 0.0357285,
                            "0.95": 0.0293595,
                        },
                        "e": {
                            "0.05": 0.024524,
                            "0.15": 0.0581243,
                            "0.25": 0.0856965,
                            "0.35": 0.110575,
                            "0.45": 0.133737,
                            "0.55": 0.153964,
                            "0.65": 0.157834,
                            "0.75": 0.1525,
                            "0.85": 0.0959736,
                            "0.95": 0.0270717,
                        },
                    },
                    "3.75": {
                        "periodfrac": 0.161772,
                        "P_bin": 0.497303,
                        "normed_bin_frac_p_dist": 0.08746,
                        "normed_tripquad_frac_p_dist": 0.08329,
                        "q": {
                            "0.15": 0.291778,
                            "0.25": 0.230106,
                            "0.35": 0.16546,
                            "0.45": 0.101592,
                            "0.55": 0.0689779,
                            "0.65": 0.0500228,
                            "0.75": 0.0380064,
                            "0.85": 0.0298971,
                            "0.95": 0.0241592,
                        },
                        "e": {
                            "0.05": 0.023755,
                            "0.15": 0.056952,
                            "0.25": 0.0844594,
                            "0.35": 0.109402,
                            "0.45": 0.132702,
                            "0.55": 0.153101,
                            "0.65": 0.157007,
                            "0.75": 0.152892,
                            "0.85": 0.0991651,
                            "0.95": 0.0305648,
                        },
                    },
                    "4.25": {
                        "periodfrac": 0.155338,
                        "P_bin": 0.338963,
                        "normed_bin_frac_p_dist": 0.05724,
                        "normed_tripquad_frac_p_dist": 0.1052,
                        "q": {
                            "0.15": 0.33415,
                            "0.25": 0.230234,
                            "0.35": 0.155604,
                            "0.45": 0.0933459,
                            "0.55": 0.0622253,
                            "0.65": 0.0444447,
                            "0.75": 0.0333324,
                            "0.85": 0.0259249,
                            "0.95": 0.0207394,
                        },
                        "e": {
                            "0.05": 0.0232584,
                            "0.15": 0.0562293,
                            "0.25": 0.0837431,
                            "0.35": 0.108781,
                            "0.45": 0.132228,
                            "0.55": 0.152793,
                            "0.65": 0.156734,
                            "0.75": 0.153173,
                            "0.85": 0.100689,
                            "0.95": 0.0323712,
                        },
                    },
                    "4.75": {
                        "periodfrac": 0.143908,
                        "P_bin": 0.16933,
                        "normed_bin_frac_p_dist": 0.02649,
                        "normed_tripquad_frac_p_dist": 0.1224,
                        "q": {
                            "0.15": 0.372832,
                            "0.25": 0.224083,
                            "0.35": 0.143984,
                            "0.45": 0.0863753,
                            "0.55": 0.0575785,
                            "0.65": 0.0411255,
                            "0.75": 0.0308433,
                            "0.85": 0.0239887,
                            "0.95": 0.0191907,
                        },
                        "e": {
                            "0.05": 0.0229148,
                            "0.15": 0.0557516,
                            "0.25": 0.0833013,
                            "0.35": 0.10844,
                            "0.45": 0.132027,
                            "0.55": 0.152742,
                            "0.65": 0.156715,
                            "0.75": 0.153406,
                            "0.85": 0.10146,
                            "0.95": 0.0332431,
                        },
                    },
                    "5.25": {
                        "periodfrac": 0.130492,
                        "P_bin": 0.0179237,
                        "normed_bin_frac_p_dist": 0.002543,
                        "normed_tripquad_frac_p_dist": 0.1313,
                        "q": {
                            "0.15": 0.413585,
                            "0.25": 0.216494,
                            "0.35": 0.132137,
                            "0.45": 0.0792686,
                            "0.55": 0.0528411,
                            "0.65": 0.037742,
                            "0.75": 0.0283054,
                            "0.85": 0.0220151,
                            "0.95": 0.0176119,
                        },
                        "e": {
                            "0.05": 0.022662,
                            "0.15": 0.0554124,
                            "0.25": 0.0830058,
                            "0.35": 0.108238,
                            "0.45": 0.131949,
                            "0.55": 0.152795,
                            "0.65": 0.156795,
                            "0.75": 0.153602,
                            "0.85": 0.101875,
                            "0.95": 0.0336661,
                        },
                    },
                    "5.75": {
                        "periodfrac": 0.116198,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.119,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0224666,
                            "0.15": 0.0551564,
                            "0.25": 0.0827927,
                            "0.35": 0.108108,
                            "0.45": 0.131925,
                            "0.55": 0.152884,
                            "0.65": 0.156906,
                            "0.75": 0.153766,
                            "0.85": 0.102116,
                            "0.95": 0.0338787,
                        },
                    },
                    "6.25": {
                        "periodfrac": 0.100332,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.1028,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0223102,
                            "0.15": 0.0549542,
                            "0.25": 0.0826294,
                            "0.35": 0.108017,
                            "0.45": 0.131925,
                            "0.55": 0.152979,
                            "0.65": 0.157021,
                            "0.75": 0.153903,
                            "0.85": 0.102269,
                            "0.95": 0.0339908,
                        },
                    },
                    "6.75": {
                        "periodfrac": 0.0863568,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.08845,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0221814,
                            "0.15": 0.0547891,
                            "0.25": 0.0824984,
                            "0.35": 0.107948,
                            "0.45": 0.131934,
                            "0.55": 0.15307,
                            "0.65": 0.157129,
                            "0.75": 0.15402,
                            "0.85": 0.102375,
                            "0.95": 0.0340549,
                        },
                    },
                    "7.25": {
                        "periodfrac": 0.074328,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.07613,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0220732,
                            "0.15": 0.0546507,
                            "0.25": 0.0823898,
                            "0.35": 0.107893,
                            "0.45": 0.131946,
                            "0.55": 0.153152,
                            "0.65": 0.157225,
                            "0.75": 0.15412,
                            "0.85": 0.102455,
                            "0.95": 0.0340945,
                        },
                    },
                    "7.75": {
                        "periodfrac": 0.0639747,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.06552,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0219808,
                            "0.15": 0.0545327,
                            "0.25": 0.0822977,
                            "0.35": 0.107847,
                            "0.45": 0.131958,
                            "0.55": 0.153225,
                            "0.65": 0.157311,
                            "0.75": 0.154207,
                            "0.85": 0.102519,
                            "0.95": 0.0341218,
                        },
                    },
                },
            },
            "1.4": {
                "f_multi": 2.0442,
                "multi system fraction": 0.9429,
                "binary star fraction": 0.3922,
                "triple/quad star fraction": 0.5507,
                "single star fraction": 0.0571,
                "poisson_model": {
                    "single_fraction": 0.152,
                    "binary_fraction": 0.312,
                    "triple_fraction": 0.319,
                    "quadruple_fraction": 0.217,
                },
                "logP": {
                    "0.25": {
                        "periodfrac": 0.0864326,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.09167,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.116254,
                            "0.25": 0.129286,
                            "0.35": 0.12873,
                            "0.45": 0.113411,
                            "0.55": 0.10253,
                            "0.65": 0.094286,
                            "0.75": 0.087759,
                            "0.85": 0.0998883,
                            "0.95": 0.127855,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "0.75": {
                        "periodfrac": 0.144054,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.1528,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.116254,
                            "0.25": 0.129286,
                            "0.35": 0.12873,
                            "0.45": 0.113411,
                            "0.55": 0.10253,
                            "0.65": 0.094286,
                            "0.75": 0.087759,
                            "0.85": 0.0998883,
                            "0.95": 0.127855,
                        },
                        "e": {
                            "0.05": 0.30542,
                            "0.15": 0.241728,
                            "0.25": 0.222153,
                            "0.35": 0.195657,
                            "0.45": 0.0350411,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.25": {
                        "periodfrac": 0.140794,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.1493,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.132767,
                            "0.25": 0.145361,
                            "0.35": 0.140176,
                            "0.45": 0.117968,
                            "0.55": 0.102838,
                            "0.65": 0.0917534,
                            "0.75": 0.0832216,
                            "0.85": 0.0864391,
                            "0.95": 0.0994763,
                        },
                        "e": {
                            "0.05": 0.0579589,
                            "0.15": 0.110502,
                            "0.25": 0.146352,
                            "0.35": 0.175902,
                            "0.45": 0.193908,
                            "0.55": 0.191078,
                            "0.65": 0.111039,
                            "0.75": 0.013261,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.75": {
                        "periodfrac": 0.130999,
                        "P_bin": 0.967257,
                        "normed_bin_frac_p_dist": 0.1344,
                        "normed_tripquad_frac_p_dist": 0.003894,
                        "q": {
                            "0.15": 0.173767,
                            "0.25": 0.182941,
                            "0.35": 0.163,
                            "0.45": 0.122293,
                            "0.55": 0.0973169,
                            "0.65": 0.0804982,
                            "0.75": 0.0684377,
                            "0.85": 0.0593877,
                            "0.95": 0.0523587,
                        },
                        "e": {
                            "0.05": 0.0356491,
                            "0.15": 0.07696,
                            "0.25": 0.108281,
                            "0.35": 0.135449,
                            "0.45": 0.160063,
                            "0.55": 0.171728,
                            "0.65": 0.170034,
                            "0.75": 0.112538,
                            "0.85": 0.0292965,
                            "0.95": 0.0,
                        },
                    },
                    "2.25": {
                        "periodfrac": 0.129776,
                        "P_bin": 0.870471,
                        "normed_bin_frac_p_dist": 0.1198,
                        "normed_tripquad_frac_p_dist": 0.01526,
                        "q": {
                            "0.15": 0.203124,
                            "0.25": 0.205604,
                            "0.35": 0.172362,
                            "0.45": 0.118827,
                            "0.55": 0.0884266,
                            "0.65": 0.0691883,
                            "0.75": 0.0560923,
                            "0.85": 0.046696,
                            "0.95": 0.03968,
                        },
                        "e": {
                            "0.05": 0.0289821,
                            "0.15": 0.0657598,
                            "0.25": 0.0948453,
                            "0.35": 0.120607,
                            "0.45": 0.144287,
                            "0.55": 0.161204,
                            "0.65": 0.16219,
                            "0.75": 0.142897,
                            "0.85": 0.0713511,
                            "0.95": 0.00787633,
                        },
                    },
                    "2.75": {
                        "periodfrac": 0.144882,
                        "P_bin": 0.743984,
                        "normed_bin_frac_p_dist": 0.1143,
                        "normed_tripquad_frac_p_dist": 0.03368,
                        "q": {
                            "0.15": 0.221344,
                            "0.25": 0.21538,
                            "0.35": 0.174296,
                            "0.45": 0.115617,
                            "0.55": 0.0834503,
                            "0.65": 0.0636632,
                            "0.75": 0.050509,
                            "0.85": 0.0412618,
                            "0.95": 0.0344798,
                        },
                        "e": {
                            "0.05": 0.0260227,
                            "0.15": 0.0606504,
                            "0.25": 0.0886649,
                            "0.35": 0.113762,
                            "0.45": 0.137013,
                            "0.55": 0.156286,
                            "0.65": 0.158978,
                            "0.75": 0.150283,
                            "0.85": 0.0884474,
                            "0.95": 0.0198931,
                        },
                    },
                    "3.25": {
                        "periodfrac": 0.164428,
                        "P_bin": 0.596487,
                        "normed_bin_frac_p_dist": 0.104,
                        "normed_tripquad_frac_p_dist": 0.06024,
                        "q": {
                            "0.15": 0.248672,
                            "0.25": 0.22411,
                            "0.35": 0.172737,
                            "0.45": 0.110243,
                            "0.55": 0.0771766,
                            "0.65": 0.0574048,
                            "0.75": 0.0445694,
                            "0.85": 0.0357285,
                            "0.95": 0.0293595,
                        },
                        "e": {
                            "0.05": 0.024524,
                            "0.15": 0.0581243,
                            "0.25": 0.0856965,
                            "0.35": 0.110575,
                            "0.45": 0.133737,
                            "0.55": 0.153964,
                            "0.65": 0.157834,
                            "0.75": 0.1525,
                            "0.85": 0.0959736,
                            "0.95": 0.0270717,
                        },
                    },
                    "3.75": {
                        "periodfrac": 0.171766,
                        "P_bin": 0.432055,
                        "normed_bin_frac_p_dist": 0.07871,
                        "normed_tripquad_frac_p_dist": 0.08857,
                        "q": {
                            "0.15": 0.291778,
                            "0.25": 0.230106,
                            "0.35": 0.16546,
                            "0.45": 0.101592,
                            "0.55": 0.0689779,
                            "0.65": 0.0500228,
                            "0.75": 0.0380064,
                            "0.85": 0.0298971,
                            "0.95": 0.0241592,
                        },
                        "e": {
                            "0.05": 0.023755,
                            "0.15": 0.056952,
                            "0.25": 0.0844594,
                            "0.35": 0.109402,
                            "0.45": 0.132702,
                            "0.55": 0.153101,
                            "0.65": 0.157007,
                            "0.75": 0.152892,
                            "0.85": 0.0991651,
                            "0.95": 0.0305648,
                        },
                    },
                    "4.25": {
                        "periodfrac": 0.165213,
                        "P_bin": 0.253163,
                        "normed_bin_frac_p_dist": 0.04436,
                        "normed_tripquad_frac_p_dist": 0.112,
                        "q": {
                            "0.15": 0.33415,
                            "0.25": 0.230234,
                            "0.35": 0.155604,
                            "0.45": 0.0933459,
                            "0.55": 0.0622253,
                            "0.65": 0.0444447,
                            "0.75": 0.0333324,
                            "0.85": 0.0259249,
                            "0.95": 0.0207394,
                        },
                        "e": {
                            "0.05": 0.0232584,
                            "0.15": 0.0562293,
                            "0.25": 0.0837431,
                            "0.35": 0.108781,
                            "0.45": 0.132228,
                            "0.55": 0.152793,
                            "0.65": 0.156734,
                            "0.75": 0.153173,
                            "0.85": 0.100689,
                            "0.95": 0.0323712,
                        },
                    },
                    "4.75": {
                        "periodfrac": 0.153406,
                        "P_bin": 0.0651094,
                        "normed_bin_frac_p_dist": 0.01059,
                        "normed_tripquad_frac_p_dist": 0.1302,
                        "q": {
                            "0.15": 0.372832,
                            "0.25": 0.224083,
                            "0.35": 0.143984,
                            "0.45": 0.0863753,
                            "0.55": 0.0575785,
                            "0.65": 0.0411255,
                            "0.75": 0.0308433,
                            "0.85": 0.0239887,
                            "0.95": 0.0191907,
                        },
                        "e": {
                            "0.05": 0.0229148,
                            "0.15": 0.0557516,
                            "0.25": 0.0833013,
                            "0.35": 0.10844,
                            "0.45": 0.132027,
                            "0.55": 0.152742,
                            "0.65": 0.156715,
                            "0.75": 0.153406,
                            "0.85": 0.10146,
                            "0.95": 0.0332431,
                        },
                    },
                    "5.25": {
                        "periodfrac": 0.139553,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.1267,
                        "q": {
                            "0.15": 0.413585,
                            "0.25": 0.216494,
                            "0.35": 0.132137,
                            "0.45": 0.0792686,
                            "0.55": 0.0528411,
                            "0.65": 0.037742,
                            "0.75": 0.0283054,
                            "0.85": 0.0220151,
                            "0.95": 0.0176119,
                        },
                        "e": {
                            "0.05": 0.022662,
                            "0.15": 0.0554124,
                            "0.25": 0.0830058,
                            "0.35": 0.108238,
                            "0.45": 0.131949,
                            "0.55": 0.152795,
                            "0.65": 0.156795,
                            "0.75": 0.153602,
                            "0.85": 0.101875,
                            "0.95": 0.0336661,
                        },
                    },
                    "5.75": {
                        "periodfrac": 0.12456,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.1131,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0224666,
                            "0.15": 0.0551564,
                            "0.25": 0.0827927,
                            "0.35": 0.108108,
                            "0.45": 0.131925,
                            "0.55": 0.152884,
                            "0.65": 0.156906,
                            "0.75": 0.153766,
                            "0.85": 0.102116,
                            "0.95": 0.0338787,
                        },
                    },
                    "6.25": {
                        "periodfrac": 0.107552,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.09765,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0223102,
                            "0.15": 0.0549542,
                            "0.25": 0.0826294,
                            "0.35": 0.108017,
                            "0.45": 0.131925,
                            "0.55": 0.152979,
                            "0.65": 0.157021,
                            "0.75": 0.153903,
                            "0.85": 0.102269,
                            "0.95": 0.0339908,
                        },
                    },
                    "6.75": {
                        "periodfrac": 0.0925711,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.08405,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0221814,
                            "0.15": 0.0547891,
                            "0.25": 0.0824984,
                            "0.35": 0.107948,
                            "0.45": 0.131934,
                            "0.55": 0.15307,
                            "0.65": 0.157129,
                            "0.75": 0.15402,
                            "0.85": 0.102375,
                            "0.95": 0.0340549,
                        },
                    },
                    "7.25": {
                        "periodfrac": 0.0796767,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.07234,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0220732,
                            "0.15": 0.0546507,
                            "0.25": 0.0823898,
                            "0.35": 0.107893,
                            "0.45": 0.131946,
                            "0.55": 0.153152,
                            "0.65": 0.157225,
                            "0.75": 0.15412,
                            "0.85": 0.102455,
                            "0.95": 0.0340945,
                        },
                    },
                    "7.75": {
                        "periodfrac": 0.0685783,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.06227,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0219808,
                            "0.15": 0.0545327,
                            "0.25": 0.0822977,
                            "0.35": 0.107847,
                            "0.45": 0.131958,
                            "0.55": 0.153225,
                            "0.65": 0.157311,
                            "0.75": 0.154207,
                            "0.85": 0.102519,
                            "0.95": 0.0341218,
                        },
                    },
                },
            },
            "1.5": {
                "f_multi": 2.2029,
                "multi system fraction": 0.9669,
                "binary star fraction": 0.349,
                "triple/quad star fraction": 0.618,
                "single star fraction": 0.0331,
                "poisson_model": {
                    "single_fraction": 0.135,
                    "binary_fraction": 0.297,
                    "triple_fraction": 0.327,
                    "quadruple_fraction": 0.24,
                },
                "logP": {
                    "0.25": {
                        "periodfrac": 0.0966967,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.1,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.117682,
                            "0.25": 0.130874,
                            "0.35": 0.130312,
                            "0.45": 0.114805,
                            "0.55": 0.10379,
                            "0.65": 0.0954445,
                            "0.75": 0.0888371,
                            "0.85": 0.0979304,
                            "0.95": 0.120325,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "0.75": {
                        "periodfrac": 0.161161,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.1667,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.117682,
                            "0.25": 0.130874,
                            "0.35": 0.130312,
                            "0.45": 0.114805,
                            "0.55": 0.10379,
                            "0.65": 0.0954445,
                            "0.75": 0.0888371,
                            "0.85": 0.0979304,
                            "0.95": 0.120325,
                        },
                        "e": {
                            "0.05": 0.30542,
                            "0.15": 0.241728,
                            "0.25": 0.222153,
                            "0.35": 0.195657,
                            "0.45": 0.0350411,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.25": {
                        "periodfrac": 0.156167,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.1615,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.133669,
                            "0.25": 0.146348,
                            "0.35": 0.141128,
                            "0.45": 0.118769,
                            "0.55": 0.103537,
                            "0.65": 0.0923766,
                            "0.75": 0.083787,
                            "0.85": 0.0852654,
                            "0.95": 0.0951205,
                        },
                        "e": {
                            "0.05": 0.0579589,
                            "0.15": 0.110502,
                            "0.25": 0.146352,
                            "0.35": 0.175902,
                            "0.45": 0.193908,
                            "0.55": 0.191078,
                            "0.65": 0.111039,
                            "0.75": 0.013261,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.75": {
                        "periodfrac": 0.142104,
                        "P_bin": 0.963007,
                        "normed_bin_frac_p_dist": 0.1415,
                        "normed_tripquad_frac_p_dist": 0.004253,
                        "q": {
                            "0.15": 0.173767,
                            "0.25": 0.182941,
                            "0.35": 0.163,
                            "0.45": 0.122293,
                            "0.55": 0.0973169,
                            "0.65": 0.0804982,
                            "0.75": 0.0684377,
                            "0.85": 0.0593877,
                            "0.95": 0.0523587,
                        },
                        "e": {
                            "0.05": 0.0356491,
                            "0.15": 0.07696,
                            "0.25": 0.108281,
                            "0.35": 0.135449,
                            "0.45": 0.160063,
                            "0.55": 0.171728,
                            "0.65": 0.170034,
                            "0.75": 0.112538,
                            "0.85": 0.0292965,
                            "0.95": 0.0,
                        },
                    },
                    "2.25": {
                        "periodfrac": 0.138452,
                        "P_bin": 0.853659,
                        "normed_bin_frac_p_dist": 0.1222,
                        "normed_tripquad_frac_p_dist": 0.01639,
                        "q": {
                            "0.15": 0.203124,
                            "0.25": 0.205604,
                            "0.35": 0.172362,
                            "0.45": 0.118827,
                            "0.55": 0.0884266,
                            "0.65": 0.0691883,
                            "0.75": 0.0560923,
                            "0.85": 0.046696,
                            "0.95": 0.03968,
                        },
                        "e": {
                            "0.05": 0.0289821,
                            "0.15": 0.0657598,
                            "0.25": 0.0948453,
                            "0.35": 0.120607,
                            "0.45": 0.144287,
                            "0.55": 0.161204,
                            "0.65": 0.16219,
                            "0.75": 0.142897,
                            "0.85": 0.0713511,
                            "0.95": 0.00787633,
                        },
                    },
                    "2.75": {
                        "periodfrac": 0.154013,
                        "P_bin": 0.710754,
                        "normed_bin_frac_p_dist": 0.1132,
                        "normed_tripquad_frac_p_dist": 0.03604,
                        "q": {
                            "0.15": 0.221344,
                            "0.25": 0.21538,
                            "0.35": 0.174296,
                            "0.45": 0.115617,
                            "0.55": 0.0834503,
                            "0.65": 0.0636632,
                            "0.75": 0.050509,
                            "0.85": 0.0412618,
                            "0.95": 0.0344798,
                        },
                        "e": {
                            "0.05": 0.0260227,
                            "0.15": 0.0606504,
                            "0.25": 0.0886649,
                            "0.35": 0.113762,
                            "0.45": 0.137013,
                            "0.55": 0.156286,
                            "0.65": 0.158978,
                            "0.75": 0.150283,
                            "0.85": 0.0884474,
                            "0.95": 0.0198931,
                        },
                    },
                    "3.25": {
                        "periodfrac": 0.174237,
                        "P_bin": 0.544113,
                        "normed_bin_frac_p_dist": 0.09805,
                        "normed_tripquad_frac_p_dist": 0.06427,
                        "q": {
                            "0.15": 0.248672,
                            "0.25": 0.22411,
                            "0.35": 0.172737,
                            "0.45": 0.110243,
                            "0.55": 0.0771766,
                            "0.65": 0.0574048,
                            "0.75": 0.0445694,
                            "0.85": 0.0357285,
                            "0.95": 0.0293595,
                        },
                        "e": {
                            "0.05": 0.024524,
                            "0.15": 0.0581243,
                            "0.25": 0.0856965,
                            "0.35": 0.110575,
                            "0.45": 0.133737,
                            "0.55": 0.153964,
                            "0.65": 0.157834,
                            "0.75": 0.1525,
                            "0.85": 0.0959736,
                            "0.95": 0.0270717,
                        },
                    },
                    "3.75": {
                        "periodfrac": 0.182082,
                        "P_bin": 0.358338,
                        "normed_bin_frac_p_dist": 0.06748,
                        "normed_tripquad_frac_p_dist": 0.09453,
                        "q": {
                            "0.15": 0.291778,
                            "0.25": 0.230106,
                            "0.35": 0.16546,
                            "0.45": 0.101592,
                            "0.55": 0.0689779,
                            "0.65": 0.0500228,
                            "0.75": 0.0380064,
                            "0.85": 0.0298971,
                            "0.95": 0.0241592,
                        },
                        "e": {
                            "0.05": 0.023755,
                            "0.15": 0.056952,
                            "0.25": 0.0844594,
                            "0.35": 0.109402,
                            "0.45": 0.132702,
                            "0.55": 0.153101,
                            "0.65": 0.157007,
                            "0.75": 0.152892,
                            "0.85": 0.0991651,
                            "0.95": 0.0305648,
                        },
                    },
                    "4.25": {
                        "periodfrac": 0.175617,
                        "P_bin": 0.156226,
                        "normed_bin_frac_p_dist": 0.02837,
                        "normed_tripquad_frac_p_dist": 0.1199,
                        "q": {
                            "0.15": 0.33415,
                            "0.25": 0.230234,
                            "0.35": 0.155604,
                            "0.45": 0.0933459,
                            "0.55": 0.0622253,
                            "0.65": 0.0444447,
                            "0.75": 0.0333324,
                            "0.85": 0.0259249,
                            "0.95": 0.0207394,
                        },
                        "e": {
                            "0.05": 0.0232584,
                            "0.15": 0.0562293,
                            "0.25": 0.0837431,
                            "0.35": 0.108781,
                            "0.45": 0.132228,
                            "0.55": 0.152793,
                            "0.65": 0.156734,
                            "0.75": 0.153173,
                            "0.85": 0.100689,
                            "0.95": 0.0323712,
                        },
                    },
                    "4.75": {
                        "periodfrac": 0.163665,
                        "P_bin": 0.00569596,
                        "normed_bin_frac_p_dist": 0.0009641,
                        "normed_tripquad_frac_p_dist": 0.1317,
                        "q": {
                            "0.15": 0.372832,
                            "0.25": 0.224083,
                            "0.35": 0.143984,
                            "0.45": 0.0863753,
                            "0.55": 0.0575785,
                            "0.65": 0.0411255,
                            "0.75": 0.0308433,
                            "0.85": 0.0239887,
                            "0.95": 0.0191907,
                        },
                        "e": {
                            "0.05": 0.0229148,
                            "0.15": 0.0557516,
                            "0.25": 0.0833013,
                            "0.35": 0.10844,
                            "0.45": 0.132027,
                            "0.55": 0.152742,
                            "0.65": 0.156715,
                            "0.75": 0.153406,
                            "0.85": 0.10146,
                            "0.95": 0.0332431,
                        },
                    },
                    "5.25": {
                        "periodfrac": 0.149652,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.1211,
                        "q": {
                            "0.15": 0.413585,
                            "0.25": 0.216494,
                            "0.35": 0.132137,
                            "0.45": 0.0792686,
                            "0.55": 0.0528411,
                            "0.65": 0.037742,
                            "0.75": 0.0283054,
                            "0.85": 0.0220151,
                            "0.95": 0.0176119,
                        },
                        "e": {
                            "0.05": 0.022662,
                            "0.15": 0.0554124,
                            "0.25": 0.0830058,
                            "0.35": 0.108238,
                            "0.45": 0.131949,
                            "0.55": 0.152795,
                            "0.65": 0.156795,
                            "0.75": 0.153602,
                            "0.85": 0.101875,
                            "0.95": 0.0336661,
                        },
                    },
                    "5.75": {
                        "periodfrac": 0.134075,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.1085,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0224666,
                            "0.15": 0.0551564,
                            "0.25": 0.0827927,
                            "0.35": 0.108108,
                            "0.45": 0.131925,
                            "0.55": 0.152884,
                            "0.65": 0.156906,
                            "0.75": 0.153766,
                            "0.85": 0.102116,
                            "0.95": 0.0338787,
                        },
                    },
                    "6.25": {
                        "periodfrac": 0.115768,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.09367,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0223102,
                            "0.15": 0.0549542,
                            "0.25": 0.0826294,
                            "0.35": 0.108017,
                            "0.45": 0.131925,
                            "0.55": 0.152979,
                            "0.65": 0.157021,
                            "0.75": 0.153903,
                            "0.85": 0.102269,
                            "0.95": 0.0339908,
                        },
                    },
                    "6.75": {
                        "periodfrac": 0.0996425,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.08062,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0221814,
                            "0.15": 0.0547891,
                            "0.25": 0.0824984,
                            "0.35": 0.107948,
                            "0.45": 0.131934,
                            "0.55": 0.15307,
                            "0.65": 0.157129,
                            "0.75": 0.15402,
                            "0.85": 0.102375,
                            "0.95": 0.0340549,
                        },
                    },
                    "7.25": {
                        "periodfrac": 0.0857631,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.06939,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0220732,
                            "0.15": 0.0546507,
                            "0.25": 0.0823898,
                            "0.35": 0.107893,
                            "0.45": 0.131946,
                            "0.55": 0.153152,
                            "0.65": 0.157225,
                            "0.75": 0.15412,
                            "0.85": 0.102455,
                            "0.95": 0.0340945,
                        },
                    },
                    "7.75": {
                        "periodfrac": 0.073817,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.05972,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0219808,
                            "0.15": 0.0545327,
                            "0.25": 0.0822977,
                            "0.35": 0.107847,
                            "0.45": 0.131958,
                            "0.55": 0.153225,
                            "0.65": 0.157311,
                            "0.75": 0.154207,
                            "0.85": 0.102519,
                            "0.95": 0.0341218,
                        },
                    },
                },
            },
            "1.6": {
                "f_multi": 2.3722,
                "multi system fraction": 0.9926,
                "binary star fraction": 0.3028,
                "triple/quad star fraction": 0.6898,
                "single star fraction": 0.0074,
                "poisson_model": {
                    "single_fraction": 0.119,
                    "binary_fraction": 0.282,
                    "triple_fraction": 0.335,
                    "quadruple_fraction": 0.265,
                },
                "logP": {
                    "0.25": {
                        "periodfrac": 0.107618,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.1084,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.119098,
                            "0.25": 0.13245,
                            "0.35": 0.13188,
                            "0.45": 0.116187,
                            "0.55": 0.10504,
                            "0.65": 0.0965932,
                            "0.75": 0.0899064,
                            "0.85": 0.0959885,
                            "0.95": 0.112858,
                        },
                        "e": {
                            "0.05": 1.0,
                            "0.15": 0.0,
                            "0.25": 0.0,
                            "0.35": 0.0,
                            "0.45": 0.0,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "0.75": {
                        "periodfrac": 0.179363,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.1807,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.119098,
                            "0.25": 0.13245,
                            "0.35": 0.13188,
                            "0.45": 0.116187,
                            "0.55": 0.10504,
                            "0.65": 0.0965932,
                            "0.75": 0.0899064,
                            "0.85": 0.0959885,
                            "0.95": 0.112858,
                        },
                        "e": {
                            "0.05": 0.30542,
                            "0.15": 0.241728,
                            "0.25": 0.222153,
                            "0.35": 0.195657,
                            "0.45": 0.0350411,
                            "0.55": 0.0,
                            "0.65": 0.0,
                            "0.75": 0.0,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.25": {
                        "periodfrac": 0.172423,
                        "P_bin": 1.0,
                        "normed_bin_frac_p_dist": 0.1737,
                        "normed_tripquad_frac_p_dist": 0.0,
                        "q": {
                            "0.15": 0.134565,
                            "0.25": 0.14733,
                            "0.35": 0.142075,
                            "0.45": 0.119566,
                            "0.55": 0.104232,
                            "0.65": 0.0929965,
                            "0.75": 0.0843491,
                            "0.85": 0.0840978,
                            "0.95": 0.0907882,
                        },
                        "e": {
                            "0.05": 0.0579589,
                            "0.15": 0.110502,
                            "0.25": 0.146352,
                            "0.35": 0.175902,
                            "0.45": 0.193908,
                            "0.55": 0.191078,
                            "0.65": 0.111039,
                            "0.75": 0.013261,
                            "0.85": 0.0,
                            "0.95": 0.0,
                        },
                    },
                    "1.75": {
                        "periodfrac": 0.153631,
                        "P_bin": 0.958206,
                        "normed_bin_frac_p_dist": 0.1483,
                        "normed_tripquad_frac_p_dist": 0.004654,
                        "q": {
                            "0.15": 0.173767,
                            "0.25": 0.182941,
                            "0.35": 0.163,
                            "0.45": 0.122293,
                            "0.55": 0.0973169,
                            "0.65": 0.0804982,
                            "0.75": 0.0684377,
                            "0.85": 0.0593877,
                            "0.95": 0.0523587,
                        },
                        "e": {
                            "0.05": 0.0356491,
                            "0.15": 0.07696,
                            "0.25": 0.108281,
                            "0.35": 0.135449,
                            "0.45": 0.160063,
                            "0.55": 0.171728,
                            "0.65": 0.170034,
                            "0.75": 0.112538,
                            "0.85": 0.0292965,
                            "0.95": 0.0,
                        },
                    },
                    "2.25": {
                        "periodfrac": 0.147303,
                        "P_bin": 0.834664,
                        "normed_bin_frac_p_dist": 0.1239,
                        "normed_tripquad_frac_p_dist": 0.01765,
                        "q": {
                            "0.15": 0.203124,
                            "0.25": 0.205604,
                            "0.35": 0.172362,
                            "0.45": 0.118827,
                            "0.55": 0.0884266,
                            "0.65": 0.0691883,
                            "0.75": 0.0560923,
                            "0.85": 0.046696,
                            "0.95": 0.03968,
                        },
                        "e": {
                            "0.05": 0.0289821,
                            "0.15": 0.0657598,
                            "0.25": 0.0948453,
                            "0.35": 0.120607,
                            "0.45": 0.144287,
                            "0.55": 0.161204,
                            "0.65": 0.16219,
                            "0.75": 0.142897,
                            "0.85": 0.0713511,
                            "0.95": 0.00787633,
                        },
                    },
                    "2.75": {
                        "periodfrac": 0.163328,
                        "P_bin": 0.673211,
                        "normed_bin_frac_p_dist": 0.1108,
                        "normed_tripquad_frac_p_dist": 0.03869,
                        "q": {
                            "0.15": 0.221344,
                            "0.25": 0.21538,
                            "0.35": 0.174296,
                            "0.45": 0.115617,
                            "0.55": 0.0834503,
                            "0.65": 0.0636632,
                            "0.75": 0.050509,
                            "0.85": 0.0412618,
                            "0.95": 0.0344798,
                        },
                        "e": {
                            "0.05": 0.0260227,
                            "0.15": 0.0606504,
                            "0.25": 0.0886649,
                            "0.35": 0.113762,
                            "0.45": 0.137013,
                            "0.55": 0.156286,
                            "0.65": 0.158978,
                            "0.75": 0.150283,
                            "0.85": 0.0884474,
                            "0.95": 0.0198931,
                        },
                    },
                    "3.25": {
                        "periodfrac": 0.184245,
                        "P_bin": 0.484941,
                        "normed_bin_frac_p_dist": 0.09001,
                        "normed_tripquad_frac_p_dist": 0.06879,
                        "q": {
                            "0.15": 0.248672,
                            "0.25": 0.22411,
                            "0.35": 0.172737,
                            "0.45": 0.110243,
                            "0.55": 0.0771766,
                            "0.65": 0.0574048,
                            "0.75": 0.0445694,
                            "0.85": 0.0357285,
                            "0.95": 0.0293595,
                        },
                        "e": {
                            "0.05": 0.024524,
                            "0.15": 0.0581243,
                            "0.25": 0.0856965,
                            "0.35": 0.110575,
                            "0.45": 0.133737,
                            "0.55": 0.153964,
                            "0.65": 0.157834,
                            "0.75": 0.1525,
                            "0.85": 0.0959736,
                            "0.95": 0.0270717,
                        },
                    },
                    "3.75": {
                        "periodfrac": 0.192722,
                        "P_bin": 0.275053,
                        "normed_bin_frac_p_dist": 0.0534,
                        "normed_tripquad_frac_p_dist": 0.1013,
                        "q": {
                            "0.15": 0.291778,
                            "0.25": 0.230106,
                            "0.35": 0.16546,
                            "0.45": 0.101592,
                            "0.55": 0.0689779,
                            "0.65": 0.0500228,
                            "0.75": 0.0380064,
                            "0.85": 0.0298971,
                            "0.95": 0.0241592,
                        },
                        "e": {
                            "0.05": 0.023755,
                            "0.15": 0.056952,
                            "0.25": 0.0844594,
                            "0.35": 0.109402,
                            "0.45": 0.132702,
                            "0.55": 0.153101,
                            "0.65": 0.157007,
                            "0.75": 0.152892,
                            "0.85": 0.0991651,
                            "0.95": 0.0305648,
                        },
                    },
                    "4.25": {
                        "periodfrac": 0.186549,
                        "P_bin": 0.0576758,
                        "normed_bin_frac_p_dist": 0.01084,
                        "normed_tripquad_frac_p_dist": 0.1274,
                        "q": {
                            "0.15": 0.33415,
                            "0.25": 0.230234,
                            "0.35": 0.155604,
                            "0.45": 0.0933459,
                            "0.55": 0.0622253,
                            "0.65": 0.0444447,
                            "0.75": 0.0333324,
                            "0.85": 0.0259249,
                            "0.95": 0.0207394,
                        },
                        "e": {
                            "0.05": 0.0232584,
                            "0.15": 0.0562293,
                            "0.25": 0.0837431,
                            "0.35": 0.108781,
                            "0.45": 0.132228,
                            "0.55": 0.152793,
                            "0.65": 0.156734,
                            "0.75": 0.153173,
                            "0.85": 0.100689,
                            "0.95": 0.0323712,
                        },
                    },
                    "4.75": {
                        "periodfrac": 0.174686,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.1266,
                        "q": {
                            "0.15": 0.372832,
                            "0.25": 0.224083,
                            "0.35": 0.143984,
                            "0.45": 0.0863753,
                            "0.55": 0.0575785,
                            "0.65": 0.0411255,
                            "0.75": 0.0308433,
                            "0.85": 0.0239887,
                            "0.95": 0.0191907,
                        },
                        "e": {
                            "0.05": 0.0229148,
                            "0.15": 0.0557516,
                            "0.25": 0.0833013,
                            "0.35": 0.10844,
                            "0.45": 0.132027,
                            "0.55": 0.152742,
                            "0.65": 0.156715,
                            "0.75": 0.153406,
                            "0.85": 0.10146,
                            "0.95": 0.0332431,
                        },
                    },
                    "5.25": {
                        "periodfrac": 0.160789,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.1165,
                        "q": {
                            "0.15": 0.413585,
                            "0.25": 0.216494,
                            "0.35": 0.132137,
                            "0.45": 0.0792686,
                            "0.55": 0.0528411,
                            "0.65": 0.037742,
                            "0.75": 0.0283054,
                            "0.85": 0.0220151,
                            "0.95": 0.0176119,
                        },
                        "e": {
                            "0.05": 0.022662,
                            "0.15": 0.0554124,
                            "0.25": 0.0830058,
                            "0.35": 0.108238,
                            "0.45": 0.131949,
                            "0.55": 0.152795,
                            "0.65": 0.156795,
                            "0.75": 0.153602,
                            "0.85": 0.101875,
                            "0.95": 0.0336661,
                        },
                    },
                    "5.75": {
                        "periodfrac": 0.144744,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.1049,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0224666,
                            "0.15": 0.0551564,
                            "0.25": 0.0827927,
                            "0.35": 0.108108,
                            "0.45": 0.131925,
                            "0.55": 0.152884,
                            "0.65": 0.156906,
                            "0.75": 0.153766,
                            "0.85": 0.102116,
                            "0.95": 0.0338787,
                        },
                    },
                    "6.25": {
                        "periodfrac": 0.12498,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.09059,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0223102,
                            "0.15": 0.0549542,
                            "0.25": 0.0826294,
                            "0.35": 0.108017,
                            "0.45": 0.131925,
                            "0.55": 0.152979,
                            "0.65": 0.157021,
                            "0.75": 0.153903,
                            "0.85": 0.102269,
                            "0.95": 0.0339908,
                        },
                    },
                    "6.75": {
                        "periodfrac": 0.107571,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.07797,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0221814,
                            "0.15": 0.0547891,
                            "0.25": 0.0824984,
                            "0.35": 0.107948,
                            "0.45": 0.131934,
                            "0.55": 0.15307,
                            "0.65": 0.157129,
                            "0.75": 0.15402,
                            "0.85": 0.102375,
                            "0.95": 0.0340549,
                        },
                    },
                    "7.25": {
                        "periodfrac": 0.0925872,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.06711,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0220732,
                            "0.15": 0.0546507,
                            "0.25": 0.0823898,
                            "0.35": 0.107893,
                            "0.45": 0.131946,
                            "0.55": 0.153152,
                            "0.65": 0.157225,
                            "0.75": 0.15412,
                            "0.85": 0.102455,
                            "0.95": 0.0340945,
                        },
                    },
                    "7.75": {
                        "periodfrac": 0.0796906,
                        "P_bin": 0.0,
                        "normed_bin_frac_p_dist": 0.0,
                        "normed_tripquad_frac_p_dist": 0.05776,
                        "q": {
                            "0.15": 0.447357,
                            "0.25": 0.209428,
                            "0.35": 0.122598,
                            "0.45": 0.0735457,
                            "0.55": 0.0490263,
                            "0.65": 0.0350173,
                            "0.75": 0.026262,
                            "0.85": 0.0204257,
                            "0.95": 0.0163404,
                        },
                        "e": {
                            "0.05": 0.0219808,
                            "0.15": 0.0545327,
                            "0.25": 0.0822977,
                            "0.35": 0.107847,
                            "0.45": 0.131958,
                            "0.55": 0.153225,
                            "0.65": 0.157311,
                            "0.75": 0.154207,
                            "0.85": 0.102519,
                            "0.95": 0.0341218,
                        },
                    },
                },
            },
        }
    ],
}
