"""
Configuration file for the Sphinx documentation builder.

This file only contains a selection of the most common options. For a full
list see the documentation:
https://www.sphinx-doc.org/en/master/usage/configuration.html
https://brendanhasz.github.io/2019/01/05/sphinx.html
"""

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.

import os
import sys

import sphinx_rtd_theme

# https://www.sphinx-doc.org/en/1.5/ext/example_google.html

# Include paths for python code
sys.path.insert(0, os.path.abspath("."))
sys.path.insert(0, os.path.join(os.getenv("BINARY_C"), "src/API/"))

# include paths for c code
cautodoc_root = os.path.abspath("../../")

# -- Project information -----------------------------------------------------

project = "binary_c-python"
copyright = "2021, David Hendriks, Robert Izzard"
author = "David Hendriks, Robert Izzard"


# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    "sphinx.ext.autodoc",
    "sphinx.ext.doctest",
    "sphinx.ext.todo",
    "sphinx.ext.coverage",
    "sphinx.ext.viewcode",
    "sphinx.ext.napoleon",
    "hawkmoth",
    "m2r2",
    "sphinx_rtd_theme",
    "sphinx_autodoc_typehints",  # https://mypy.readthedocs.io/en/stable/cheat_sheet_py3.html
    "nbsphinx",
]


# Napoleon settings
napoleon_google_docstring = (
    True  # https://sphinxcontrib-napoleon.readthedocs.io/en/latest/example_google.html
)
napoleon_numpy_docstring = False
napoleon_include_init_with_doc = False
napoleon_include_private_with_doc = False
napoleon_include_special_with_doc = True
napoleon_use_admonition_for_examples = False
napoleon_use_admonition_for_notes = False
napoleon_use_admonition_for_references = False
napoleon_use_ivar = False
napoleon_use_param = True
napoleon_use_rtype = True

source_suffix = [".rst", ".md"]

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = []


# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.

# html_theme = "alabaster"
html_theme = "sphinx_rtd_theme"

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ["_static"]


"""Patching m2r2"""
import m2r2

current_m2r2_setup = m2r2.setup


def patched_m2r2_setup(app):

    try:
        return current_m2r2_setup(app)
    except (AttributeError):
        app.add_source_suffix(".md", "markdown")
        app.add_source_parser(m2r2.M2RParser)
    return dict(
        version=m2r2.__version__,
        parallel_read_safe=True,
        parallel_write_safe=True,
    )


m2r2.setup = patched_m2r2_setup

# Generate some custom documentations for this version of binarycpython and binary_c
from binarycpython.utils.functions import (
    write_binary_c_parameter_descriptions_to_rst_file,
)
from binarycpython.utils.grid_options_defaults import write_grid_options_to_rst_file

print("Generating binary_c_parameters.rst")
write_binary_c_parameter_descriptions_to_rst_file("binary_c_parameters.rst")
print("Done")

print("Generating grid_options_descriptions.rst")
write_grid_options_to_rst_file("grid_options_descriptions.rst")
print("Done")

# Generate a custom footer
from functions import write_custom_footer

print("Generating custom footer")
write_custom_footer()
print("Done")
